package cz.vse.keg.patomat.detection;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;
//import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;

//import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
//import org.mindswap.pellet.query.impl.*;
//import com.clarkparsia.sparqlowl.*;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;

//import com.clarkparsia.sparqlowl.parser.arq.ARQTerpParser;
//import com.clarkparsia.sparqlowl.parser.arq.TerpSyntax;

import cz.vse.keg.patomat.naming.NamingConstraints;
import cz.vse.keg.patomat.naming.NamingConstraintsImpl;
import cz.vse.keg.patomat.naming.NamingFunctionException;
import cz.vse.keg.patomat.transformation.pattern.NameDetectionPattern;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformation;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern.EntityType;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformation.Type;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;

//NOTE,16-02-10,we use Pellet API because they will come with Manchester kind of syntax for SPARQL query
//Jena is needed because pellet works with OWL-API only for SPARQL-DL queries, queries of SPARQL type are executed using Jena ARQ

/**
 * OntologyPatternDetectionImpl provides implementation of structure-based and/or naming-based ontology pattern detection.
 * @author Ondrej Zamazal
 * 
 */

public class OntologyPatternDetectionImpl implements OntologyPatternDetection {

	/**
	 * @param args
	 */	
	//22-04-11
	class SubClassOfPair {
		//subsumed subClassOf subsumer
		String subsumerPlaceholder="";
		String subsumedPlaceholder="";
		
		SubClassOfPair(String subsumer, String subsumed) {
			this.subsumerPlaceholder=subsumer;
			this.subsumedPlaceholder=subsumed;
		}
		
		public String toString() {
			return this.subsumedPlaceholder+" subClassOf "+this.subsumerPlaceholder;
		}
	}
	
	private String patternURI="";
	private String ontologyURI="";
	private String query="";
	private ArrayList<SubClassOfPair> subClassOfs=null;
	private String ontologyNamespace="";
	private String dictionaryPath, modelsPath;
	private int numberGeneratedPlaceholders=1;
	private boolean debuggingOutput=false;
	
	/**
	 * Initialize OntologyPatternDetectionImpl class.
	 * @param dictionaryPath	the path to WordNet-3.0 installation folder, e.g. /usr/share/WordNet-3.0/
	 * @param modelsPath	the path to Stanford POS-tagger left3words-wsj-0-18.tagger model, e.g. /usr/share/models/left3words-wsj-0-18.tagger
	 */
	public OntologyPatternDetectionImpl(String dictionaryPath, String modelsPath) {
		this.dictionaryPath=dictionaryPath;
		this.modelsPath=modelsPath;
	}
	
	//07-06-11, implementation for OWL-API queryPatternNamingAspect()
	private String getBaseURI(OWLOntologyManager manager, OWLOntology ontology, String namespace) {
	  	Map<String, String> nsMap = null;
	    OWLOntologyFormat format = manager.getOntologyFormat(ontology);
		if(format instanceof PrefixOWLOntologyFormat) {
			PrefixOWLOntologyFormat nsFormat =
			(PrefixOWLOntologyFormat) format;
			nsMap =
				nsFormat.getPrefixName2PrefixMap();
			//nsFormat.getNamespacesByPrefixMap(); owl-api 2
			//System.out.println(nsMap.keySet());
			//return nsFormat.getPrefix("");
			return nsMap.get(namespace);
		}
		else return "";										
	}
	
	/**
	 * Returns namespace of an ontology.
	 * @return namespace of an ontology
	 */
	public String getOntologyNamespace() {
		return this.ontologyNamespace;
	}
	
	/**
	 * Gets binding (assignments) of all placeholders within given OP1. 
	 * not implemented yet
	 * @Override 
	 */	
	public ArrayList<HashMap<String, String>> getPlaceholdersBinding() {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * Gets pattern instances based on ontology pattern detection. 
	 * not implemented yet
	 * @Override 
	 */	
	public ArrayList<String> queryPattern(String patternURI, String ontologyURI, boolean xmlSerialization, boolean reasoner) {
		// TODO Auto-generated method stub
		return null;
	}
	
	//TODO:17-02-10,ziskani z query_results postupne jednotlive pattern_instances
	//nejsnazsi asi bude, kdyz to OntologyPatternDetectionImpl vrati ArrayList of XML bindings
	//a ten se muze prochazet v iteraci a postupne pripadne aplikovat patricne zmeny
	
	/**
	 * This method initializes basic shape of query in the case of recursion should be applied.
	 * @param tp	transformation pattern to be applied
	 * @param ontologyURI	link to ontology on which this should be applied
	 */
	public void initBasicQueryForRecursion(TransformationPattern tp, String ontologyURI) {		
		//08-03-11
		OntologyPattern pattern=tp.getOP1();
		//09-03-10
		//NOTE: now input ontology can be directly String or referring url		
		//init model using Jena
		//OntModel m = ModelFactory.createOntologyModel(PelletReasonerFactory.THE_SPEC); //for SPARQL-DL		
		this.ontologyURI=ontologyURI;
		this.patternURI=tp.getLocation();
		OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);		
		if ((ontologyURI.matches("^http.*"))||(ontologyURI.matches("^file.*")))
			m.read(ontologyURI);
		else {
			InputStream in = new ByteArrayInputStream(ontologyURI.getBytes());			
			m.read(in,"");
			try {
				in.close();
			}
			catch (IOException e) {
				e.printStackTrace();
			}	
		}
		//init query
		StringBuilder query = new StringBuilder();
		String queryBegin = 
            "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n" + 
            "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n" + 
            "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
		for(String s : pattern.getNamespaces().keySet()) {
			queryBegin+="PREFIX "+pattern.getNamespaces().get(s)+": <"+s+">\n";			
		}
		queryBegin+="\n" + 
            "SELECT * \n" + 
            "WHERE {\n";
        String queryEnd = "}";
        //22-04-10, FILTER part
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> individuals = new ArrayList<String>();
        query.append(queryBegin);
        for (String p : pattern.getPlaceholders().keySet()) {
        	if (pattern.getPlaceholders().get(p).equals(EntityType.Class)) {
        		query.append(p+" rdf:type owl:Class.\n");
        		classes.add(p);
        	}
        	else if (pattern.getPlaceholders().get(p).equals(EntityType.ObjectProperty)) {
        		query.append(p+" rdf:type owl:ObjectProperty.\n");
        		properties.add(p);
        	}
        	else if (pattern.getPlaceholders().get(p).equals(EntityType.DatatypeProperty)) {
        		query.append(p+" rdf:type owl:DataProperty.\n");
        		properties.add(p);
        	}
        	else if (pattern.getPlaceholders().get(p).equals(EntityType.Individual)) {
        		query.append(p+" rdf:type owl:Individual.\n");
        		individuals.add(p);
        	}
        }
        //22-04-10, FILTER part, cont.
        String filter="";
        if (classes.size()>=2||properties.size()>=2||individuals.size()>=2) { 
        	filter="FILTER (";
        	if (classes.size()>=2) {
        		for (int i=0; i < classes.size(); i++) {
	        		for (int j=i+1; j < classes.size(); j++) {
	        			if (i!=j) {		        			
	        				filter+=classes.get(i);
		        			filter+=" != "+classes.get(j);
		        			//System.out.println(i + " "+j+" "+classes.size());
		        			if ((i+2!=classes.size())||j+1!=classes.size())
		        			//if ((i+j)!=classes.size()+(classes.size()%2))
		        				filter+=" && ";		    
	        			}
	        		}
        		}
        	}
        	if (properties.size()>=2) {
        		if (classes.size()>=2) filter+=" && ";
        		for (int i=0; i < properties.size(); i++) {
        			for (int j=i+1; j < properties.size(); j++) {
	        			//System.out.println(i + " "+j+" "+properties.size());
        				if (i!=j) {
	        				filter+=properties.get(i);
		        			filter+=" != "+properties.get(j);
		        			if ((i+2!=properties.size())||j+1!=properties.size())
		        				filter+=" && ";
	        			}
        			}
        		}
        	}
        	if (individuals.size()>=2) {
        		if (classes.size()>=2||properties.size()>=2) filter+=" && ";
        		for (int i=0; i < individuals.size(); i++) {
        			for (int j=1+1; j < individuals.size(); j++) {
	        			filter+=individuals.get(i);
	        			filter+=" != "+individuals.get(j);
	        			if ((i+2!=individuals.size())||j+1!=individuals.size())
	        				filter+=" && ";
        			}
        		}
        	}
        	filter+=")\n";
        }
        Pattern pat;
        Matcher matcher;
        String[] placeholders = new String[4]; //20-04-10, up to 3 placeholders for now
        for (String axiom : pattern.getAxioms()) {        	
        	//07-09-11, implementace pro oneOf i.e. {..,..,..} in Manchester syntax
        	if (axiom.matches(".*\\{.*\\}")) {        		
        		String originalAxiom = axiom;
        		//axiom=axiom.replaceAll("\\{.*\\}", "");
        		originalAxiom = originalAxiom.replaceAll("\\{", "(");
        		originalAxiom = originalAxiom.replaceAll("\\}", ")");
        		originalAxiom = originalAxiom.replaceAll(",", " ");
        		originalAxiom = originalAxiom.replaceAll(" $", "");
        		originalAxiom = originalAxiom.substring(originalAxiom.indexOf("("));
        		if(axiom.matches(".*equivalentTo.*")) {
        			axiom=axiom.replaceAll("\\{.*\\}", "");
        			axiom=axiom.replaceAll("equivalentTo", "owl:equivalentClass");
        			axiom=axiom+" _:oneOf1.\n_:oneOf1 owl:oneOf "+originalAxiom+".\n";
        		}
        		else if(axiom.matches(".*subClassOf.*")) {
        			axiom=axiom.replaceAll("\\{.*\\}", "");
        			axiom=axiom.replaceAll("subClassOf", "rdfs:subClassOf");
        			axiom=axiom+" _:oneOf1.\n_:oneOf1 owl:oneOf "+originalAxiom+".\n";
        		}
        		query.append(axiom);
        	}
        	//20-04-10, docasna neohrabana implementace predtim nez to bude plne mozne pomoci Terp syntaxe
        	else if (axiom.matches(".*value.*")||axiom.matches(".*some.*")||axiom.matches(".*only.*")||axiom.matches(".*min.*")||axiom.matches(".*max.*")||axiom.matches(".*exactly.*")) {
        		String originalAxiom = axiom;
        		//pat = Pattern.compile("\\?.");
        		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        		
        		matcher = pat.matcher(axiom);
        		int p=0;
        		while(matcher.find()) {        			
        			placeholders[p]=matcher.group();
        			p++;
        		}
        		        	
        		if (originalAxiom.matches(".*subClassOf.*")) {
        			axiom=placeholders[0]+" rdfs:subClassOf _:restriction1.\n_:restriction1 rdf:type owl:Restriction.\n";
        		}
        		else if (originalAxiom.matches(".*equivalentTo.*")) {
        			axiom=placeholders[0]+" owl:equivalentClass _:restriction1.\n_:restriction1	rdf:type owl:Restriction.\n";
        		}
        		
        		axiom=axiom+"_:restriction1 owl:onProperty "+ placeholders[1]+ ".\n";
        		
        		if (originalAxiom.matches(".*value.*")) {
        			axiom=axiom+"_:restriction1 owl:hasValue "+ placeholders[2]+ ".\n";        			        		
        		} 
        		else if (originalAxiom.matches(".*some.*")) {
        			axiom=axiom+"_:restriction1 owl:someValuesFrom "+ placeholders[2]+ ".\n";
        		}
        		else if (originalAxiom.matches(".*only.*")) {
        			axiom=axiom+"_:restriction1 owl:allValuesFrom "+ placeholders[2]+ ".\n";
        		}
        		else if (originalAxiom.matches(".*min.*")) {
        			if (!placeholders[3].isEmpty()) {//qualified in OWL2
        				axiom=axiom+"_:restriction1 owl:minQualifiedCardinality "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction1 owl:onClass "+ placeholders[3]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        			else {//OWL1
        				axiom=axiom+"_:restriction1 owl:minCardinality "+ placeholders[2]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        		}
        		else if (originalAxiom.matches(".*max.*")) {
        			if (!placeholders[3].isEmpty()) {//qualified in OWL2
        				axiom=axiom+"_:restriction1 owl:maxQualifiedCardinality "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction1 owl:onClass "+ placeholders[3]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        			else {//OWL1
        				axiom=axiom+"_:restriction1 owl:maxCardinality "+ placeholders[2]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[2]+" rdf:type owl:ObjectProperty";
        			}
        		}
        		else if (originalAxiom.matches(".*exactly.*")) {
        			if (!placeholders[3].isEmpty()) {//qualified in OWL2
        				axiom=axiom+"_:restriction1 owl:qualifiedCardinality "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction1 owl:onClass "+ placeholders[3]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        			else {//OWL1
        				axiom=axiom+"_:restriction1 owl:cardinality "+ placeholders[2]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        		}
        		//axiom=axiom.replaceAll("\\(", "");
        		//axiom=axiom.replaceAll("\\)", "");
        		query.append(axiom);
        		
        	}
        	else if (axiom.matches(".*annotation.*")) {
        		//20-04-10, for now ignore annotation for detection
        	}        	
        	else {
	        	//17-12-10, replace urls with namespaces
        		for(String s : pattern.getNamespaces().keySet()) {
        			axiom=axiom.replaceAll(s, pattern.getNamespaces().get(s)+":");
        		}        		
        		//end of prefixes
        		//start for predicates
        		if (axiom.matches(".*subClassOf.*")) {
            		String originalAxiom = axiom;
            		//pat = Pattern.compile("\\?.");
            		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            		
            		matcher = pat.matcher(axiom);
            		int p=0;
            		//pair SubClassOf = new SubClassOfPair();
            		String subsumed = "";
            		String subsumer = "";
            		if (matcher.find()) subsumed=matcher.group();
            		//System.out.println("sub "+subsumed);
            		if (matcher.find()) subsumer=matcher.group();
            		//System.out.println("sub "+subsumer);
            		if (!subsumer.equals("")&&!subsumed.equals(""))
            			this.subClassOfs.add(new SubClassOfPair(subsumer,subsumed));
        		}
        		axiom=axiom.replace("domain", "rdfs:domain");
	        	axiom=axiom.replace("range", "rdfs:range");
	        	axiom=axiom.replace("subClassOf", "rdfs:subClassOf");
	        	axiom=axiom.replace("equivalentTo", "owl:equivalentClass");
	        	axiom=axiom.replace("disjointWith", "owl:disjointWith");
	        	axiom=axiom.replace("propertyDisjointWith", "owl:propertyDisjointWith");
	        	//axiom=axiom.replace("not", "owl:complementOf");
	        	//end of predicates
	        	//end of line:
	        	query.append(axiom+".\n");
        	}
        }
        //query.append("?x rdfs:subClassOf ?y.");
        query.append(filter);
        query.append(queryEnd);
        //querying using Pellet (in the case of SPARQL-DL) + Jena (in the case of SPARQL)
        //16-02-10,zvlastni pokud SPARQL neni SPARQL-DL nespadne to rovnou do Jena ale nevrati se nic!
        //solution->nepouzivam pellet reasoner PelletReasonerFactory.THE_SPEC ale PelletReasonerFactory.THE_SPEC        
        if (this.debuggingOutput) System.out.println(query);
        this.query=query.toString();
        
        //21-11-11, avoiding problem "too many open files"
        m.close();
	}
	
	/**
	 * Returns list of detected pattern instances. In this case structural detection goes first and then naming aspect is considered. However, it is more common that naming pattern will reduce search space larger and thus increase performance (see, queryPatternNamingAspect). Or just structural detection is used (see, queryPatternStructuralAspect).   
	 * @param tp	transformation pattern to be applied
	 * @param ontologyURI	link to ontology on which detection is to be applied
	 * @param xmlSerialization true/false should these results be serialized in XML (true) or in plain text (false)
	 * @param reasoner true/false should be reasoner be employed for detection?
	 * @Override 
	 * @see queryPatternNamingAspect 
	 * @see queryPatternStructuralAspect
	 */	
	public ArrayList<String> queryPattern(TransformationPattern tp, String ontologyURI, boolean xmlSerialization, boolean reasoner) {		
		//06-01-12
		boolean sparqlDL=false;
		//22-04-11
		this.subClassOfs=new ArrayList<SubClassOfPair>();
		//08-03-11
		OntologyPattern pattern=tp.getOP1();
		//09-03-10
		//NOTE: now input ontology can be directly String or referring url		
		//init model using Jena
		//OntModel m = ModelFactory.createOntologyModel(PelletReasonerFactory.THE_SPEC); //for SPARQL-DL		
		this.ontologyURI=ontologyURI;
		this.patternURI=tp.getLocation();
		OntModel m;
		if (reasoner)
			m = ModelFactory.createOntologyModel(PelletReasonerFactory.THE_SPEC);//for sparql-dl
		else
			m = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
		if ((ontologyURI.matches("^http.*"))||(ontologyURI.matches("^file.*")))
			m.read(ontologyURI);
		else {
			InputStream in = new ByteArrayInputStream(ontologyURI.getBytes());			
			m.read(in,"");
			try {
				in.close();
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
		//init query
		StringBuilder query = new StringBuilder();
		String queryBegin = 
            "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n" + 
            "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n" + 
            "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n" +
			"PREFIX sparqldl: <http://pellet.owldl.com/ns/sdle#>\n";
		for(String s : pattern.getNamespaces().keySet()) {
			queryBegin+="PREFIX "+pattern.getNamespaces().get(s)+": <"+s+">\n";			
		}
		queryBegin+="\n" + 
            "SELECT * \n" + 
            "WHERE {\n";
        String queryEnd = "}";
        //22-04-10, FILTER part
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> individuals = new ArrayList<String>();
        query.append(queryBegin);
        for (String p : pattern.getPlaceholders().keySet()) {
        	if (pattern.getPlaceholders().get(p).equals(EntityType.Class)) {
        		query.append(p+" rdf:type owl:Class.\n");
        		classes.add(p);
        	}
        	else if (pattern.getPlaceholders().get(p).equals(EntityType.ObjectProperty)) {
        		query.append(p+" rdf:type owl:ObjectProperty.\n");
        		properties.add(p);
        	}
        	else if (pattern.getPlaceholders().get(p).equals(EntityType.DatatypeProperty)) {
        		query.append(p+" rdf:type owl:DataProperty.\n");
        		properties.add(p);
        	}
        	else if (pattern.getPlaceholders().get(p).equals(EntityType.Individual)) {
        		query.append(p+" rdf:type owl:Individual.\n");
        		individuals.add(p);
        	}
        }
        //22-04-10, FILTER part, cont.
        String filter="";
        if (classes.size()>=2||properties.size()>=2||individuals.size()>=2) { 
        	filter="FILTER (";
        	if (classes.size()>=2) {
        		for (int i=0; i < classes.size(); i++) {
	        		for (int j=i+1; j < classes.size(); j++) {
	        			if (i!=j) {		        			
	        				filter+=classes.get(i);
		        			filter+=" != "+classes.get(j);
		        			//if (this.debuggingOutput) System.out.println(i + " "+j+" "+classes.size());
		        			if ((i+2!=classes.size())||j+1!=classes.size())
		        			//if ((i+j)!=classes.size()+(classes.size()%2))
		        				filter+=" && ";		    
	        			}
	        		}
        		}
        	}
        	if (properties.size()>=2) {
        		if (classes.size()>=2) filter+=" && ";
        		for (int i=0; i < properties.size(); i++) {
        			for (int j=i+1; j < properties.size(); j++) {
	        			//if (this.debuggingOutput) System.out.println(i + " "+j+" "+properties.size());
        				if (i!=j) {
	        				filter+=properties.get(i);
		        			filter+=" != "+properties.get(j);
		        			if ((i+2!=properties.size())||j+1!=properties.size())
		        				filter+=" && ";
	        			}
        			}
        		}
        	}
        	if (individuals.size()>=2) {
        		if (classes.size()>=2||properties.size()>=2) filter+=" && ";
        		for (int i=0; i < individuals.size(); i++) {
        			for (int j=1+1; j < individuals.size(); j++) {
	        			filter+=individuals.get(i);
	        			filter+=" != "+individuals.get(j);
	        			if ((i+2!=individuals.size())||j+1!=individuals.size())
	        				filter+=" && ";
        			}
        		}
        	}
        	filter+=")\n";
        }
        Pattern pat;
        Matcher matcher;
        String[] placeholders = new String[3]; //20-04-10, up to 3 placeholders for now
        for (String axiom : pattern.getAxioms()) {
        	//27-09-11, constructor expansion operator @
        	if (axiom.matches(".*@.*")) {
        		if (axiom.matches(".*@{\\?[0-9a-zA-Z_]*}")) {
        			if (this.debuggingOutput) System.out.println("constructor expansion operator @ applied on oneOf");
        		}
        		else if (axiom.matches(".*@unionOf(\\?[0-9a-zA-Z_]*)")) {
        			//TODO
        		} 
        	}
        	//21-09-11, complementOf - specific dealing with complementOf because there is different number of placeholders
        	else if (axiom.matches(".*not.*")) {
        		String originalAxiom = axiom;
        		//pat = Pattern.compile("\\?.");
        		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        		
        		matcher = pat.matcher(axiom);
        		int p=0;
        		while(matcher.find()) {        			
        			placeholders[p]=matcher.group();
        			p++;
        		}
        		
        		if (placeholders[2]!=null) {//some restriction as complementOf
        			if (originalAxiom.matches(".*subClassOf.*")) {
            			axiom=placeholders[0]+" rdfs:subClassOf _:complement1.\n_:complement1 owl:complementOf _:restriction1.\n_:restriction1 rdf:type owl:Restriction.\n";
            		}
            		else if (originalAxiom.matches(".*equivalentTo.*")) {
            			axiom=placeholders[0]+" owl:equivalentClass _:complement1.\n_:complement1 owl:complementOf _:restriction1.\n_:restriction1	rdf:type owl:Restriction.\n";
            		}
        			
        			axiom=axiom+"_:restriction1 owl:onProperty "+ placeholders[1]+ ".\n";
        			
        			if (originalAxiom.matches(".*min.*")) {
            			if (placeholders[3]!=null) {//qualified in OWL2
            				axiom=axiom+"_:restriction1 owl:minQualifiedCardinality "+ placeholders[2]+ ".\n";
            				axiom=axiom+"_:restriction1 owl:onClass "+ placeholders[3]+ ".\n";
            				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
            				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
            			}
            			else {//OWL1
            				axiom=axiom+"_:restriction1 owl:minCardinality "+ placeholders[2]+ ".\n";
            				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
            				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
            			}
        			}
        			//22-09-11,TODO:else if max atd.
            			
        		}
        		else {
	        		if (originalAxiom.matches(".*subClassOf.*")) {
	        			axiom=placeholders[0]+" rdfs:subClassOf _:complement1.\n_:complement1 owl:complementOf "+placeholders[1]+".\n";
	        		}
	        		else if (originalAxiom.matches(".*equivalentTo.*")) {
	        			axiom=placeholders[0]+" owl:equivalentClass _:complement1.\n_:complement1 owl:complementOf "+placeholders[1]+".\n";
	        		}
        		}
        		query.append(axiom);
        	}
        	//20-04-10, docasna neohrabana implementace predtim nez to bude plne mozne pomoci Terp syntaxe
        	else if (axiom.matches(".*value.*")||axiom.matches(".*some.*")||axiom.matches(".*only.*")) {
        		String originalAxiom = axiom;
        		//pat = Pattern.compile("\\?.");
        		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        		
        		matcher = pat.matcher(axiom);
        		int p=0;
        		while(matcher.find()) {        			
        			placeholders[p]=matcher.group();
        			p++;
        		}
        		        	
        		if (originalAxiom.matches("subClassOf")) {
        			axiom=placeholders[0]+" rdfs:subClassOfs _:restriction1.\n_:restriction1 rdf:type owl:Restriction.\n";
        		}
        		else if (originalAxiom.matches(".*equivalentTo.*")) {
        			axiom=placeholders[0]+" owl:equivalentClass _:restriction1.\n_:restriction1	rdf:type owl:Restriction.\n";
        		}
        		
        		axiom=axiom+"_:restriction1 owl:onProperty "+ placeholders[1]+ ".\n";
        		
        		if (originalAxiom.matches(".*value.*")) {
        			axiom=axiom+"_:restriction1 owl:hasValue "+ placeholders[2]+ ".\n";        			        		
        		} 
        		else if (originalAxiom.matches(".*some.*")) {
        			axiom=axiom+"_:restriction1 owl:someValuesFrom "+ placeholders[2]+ ".\n";
        		}
        		else if (originalAxiom.matches(".*only.*")) {
        			axiom=axiom+"_:restriction1 owl:allValuesFrom "+ placeholders[2]+ ".\n";
        		}        		
        		//axiom=axiom.replaceAll("\\(", "");
        		//axiom=axiom.replaceAll("\\)", "");
        		query.append(axiom);
        		
        	}
        	else if (axiom.matches(".*annotation.*")) {
        		//20-04-10, for now ignore annotation for detection
        	}        	
        	else {
	        	//17-12-10, replace urls with namespaces
        		for(String s : pattern.getNamespaces().keySet()) {
        			axiom=axiom.replaceAll(s, pattern.getNamespaces().get(s)+":");
        		}        		
        		//end of prefixes
        		//06-01-12, for sparql-dl implementation
            	if (axiom.matches(".*directSubClassOf.*")) {
            		sparqlDL=true;
            	}
        		//start for predicates
            	else if (axiom.matches(".*subClassOf.*")) {
            		String originalAxiom = axiom;
            		//pat = Pattern.compile("\\?.");
            		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            		
            		matcher = pat.matcher(axiom);
            		int p=0;
            		//pair SubClassOf = new SubClassOfPair();
            		String subsumed = "";
            		String subsumer = "";
            		if (matcher.find()) subsumed=matcher.group();
            		//if (this.debuggingOutput) System.out.println("sub "+subsumed);
            		if (matcher.find()) subsumer=matcher.group();
            		//if (this.debuggingOutput) System.out.println("sub "+subsumer);
            		if (!subsumer.equals("")&&!subsumed.equals(""))
            			this.subClassOfs.add(new SubClassOfPair(subsumer,subsumed));
        		}
        		axiom=axiom.replace("domain", "rdfs:domain");
	        	axiom=axiom.replace("range", "rdfs:range");
	        	axiom=axiom.replace("subClassOf", "rdfs:subClassOf");
	        	axiom=axiom.replace("equivalentTo", "owl:equivalentClass");
	        	axiom=axiom.replace("disjointWith", "owl:disjointWith");
	        	axiom=axiom.replace("propertyDisjointWith", "owl:propertyDisjointWith");
	        	axiom=axiom.replace("directSubClassOf", "sparqldl:directSubClassOf");
	        	//end of predicates
	        	//end of line:
	        	query.append(axiom+".\n");
        	}
        }
        //query.append("?x rdfs:subClassOf ?y.");
        query.append(filter);
        query.append(queryEnd);
        //querying using Pellet (in the case of SPARQL-DL) + Jena (in the case of SPARQL)
        //16-02-10,zvlastni pokud SPARQL neni SPARQL-DL nespadne to rovnou do Jena ale nevrati se nic!
        //solution->nepouzivam pellet reasoner PelletReasonerFactory.THE_SPEC ale PelletReasonerFactory.THE_SPEC        
        if (this.debuggingOutput) System.out.println(query);
        this.query=query.toString();
        //13-04-10, how to use Terp syntax?
        //ARQTerpParser terpParser = new ARQTerpParser();
        //terpParser.registerFactory();
        //ARQTerpParser.getFactory();
        //ARQTerpParser.registerFactory();
        
        //terpParser.parse(arg0, arg1)
        
        //ARQTerpParser.registerFactory();
        
        //20-04-10, Terp:Query q = QueryFactory.create(query.toString(), TerpSyntax.getInstance());
        Query q = QueryFactory.create(query.toString());        
        QueryExecution qe;
        //06-01-12, sparql-dl implementation
        if (sparqlDL)
        	qe = SparqlDLExecutionFactory.create(q,m);
        else
        	qe = QueryExecutionFactory.create(q,m);        
        //QueryExecution qe = QueryExecutionFactory.create(q,m);
        if (this.debuggingOutput) System.out.println("setting: anonymous/Thing/Nothing checking on, naming aspect off (nextOne=true)");
        //06-06-11, for query time analysis
        long currentTime=0;
        long time=0;
        
        currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right before the SPARQL query execution:"+currentTime);
        time=currentTime;
        
        //ResultSet rs = qe.execSelect();
        Iterator<QuerySolution> rs = qe.execSelect();
        
        currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right after the SPARQL query execution (delta):"+(currentTime-time));
        time=currentTime;
        
        //ResultSetFormatter.out(rs);
        //checking naming constraints
        //17-02-10,ArrayList of XML bindings
        ArrayList<String> query_results = new ArrayList<String>();
        //deprecated:StringBuilder xmlBinding = new StringBuilder("<query_results>\n");
        HashMap<String,String> sparqlBinding = new HashMap<String,String>();
        String value="";
        RDFNode node=null;
        boolean nextOne=false;
        NamingConstraintsImpl nsc = new NamingConstraintsImpl(true,this.dictionaryPath,this.modelsPath);
        //06-06-11, how many different combinations are there?
        int combinations=0;               
        
        currentTime=System.currentTimeMillis();        
        if (this.debuggingOutput) System.out.println("Right before the xxx SPARQL results processing (delta):"+(currentTime-time));
        time=currentTime;
        //Set<String> placeholdersOP1 = pattern.getPlaceholders().keySet(); //06-06-11,optimalizace
        //if (this.debuggingOutput) System.out.println(placeholdersOP1);
        ArrayList<String> placeholdersOP1inNDPs = new ArrayList<String>(); //06-06-11,optimalizace
        ArrayList<String> placeholdersOP1NOTinNDPs = new ArrayList<String>(); //06-06-11,optimalizace
        for (NameDetectionPattern ndp : pattern.getNameDetectionPatterns()) {
        	//if (this.debuggingOutput) System.out.println("entity2:"+ndp.getEntity2());
        	placeholdersOP1inNDPs.addAll(ndp.getInvolvedPlaceholders());
        }
        for (String s : pattern.getPlaceholders().keySet()) {
        	if (!placeholdersOP1inNDPs.contains(s)) placeholdersOP1NOTinNDPs.add(s);
        }
        //if (this.debuggingOutput) System.out.println(placeholdersOP1inNDPs);
        //if (this.debuggingOutput) System.out.println(placeholdersOP1NOTinNDPs);
        for ( ; rs.hasNext() ; )	{          
          //if (this.debuggingOutput) System.out.println(rs.getRowNumber()+" row...");
          combinations++;
          nextOne=false;
          //sparqlBinding = new HashMap<String,String>();
          sparqlBinding.clear();          
          //QuerySolution solution = rs.nextSolution() ;
          QuerySolution solution = rs.next() ;
	      for (String p : placeholdersOP1inNDPs) {
	    	  //if (this.debuggingOutput) System.out.println("p:"+p);
	    	  //node=(RDFNode)(solution.get(p));
	    	  node=solution.get(p);
	    	  if (node.isAnon()) {
	    		  nextOne=true;
	    		  //if (this.debuggingOutput) System.out.println("break anonymous"+node.toString());
	    		  break;	    		  
	    	  }
	    	  else {
	    		  value=node.toString();
	    		  if (this.ontologyNamespace.equals("")) this.ontologyNamespace=value.substring(0,value.indexOf("#")+1);
	    		  value=value.substring(value.indexOf("#")+1);
	    		  if (value.equals("Thing")||value.equals("Nothing")) {
	    			  nextOne=true;
	    			  //if (this.debuggingOutput) System.out.println("break Thing");
	    			  break;
	    		  }
	    		  //if (this.debuggingOutput) System.out.println("OK p:"+p+" value:"+value);
	    	  }
	    	
	    	  //if (this.debuggingOutput) System.out.print(p+"="+value);
	    	  sparqlBinding.put(p, value);	    	  
	      }
	      //TODO: add if namingConstraints are OK then print it into XML as binding
	      if (this.debuggingOutput) System.out.println(pattern.getNameDetectionPatterns()+" "+nextOne);
	      //nextOne=true;//06-06-11, artificially naming aspect on/off nextOne=true-off;
    	  if (!nextOne) {    		  
    		  if (nsc.checkNamingConstraints(sparqlBinding, pattern.getNameDetectionPatterns(),true)) {
    			  //if (this.debuggingOutput) System.out.println("Huray");
    			  //deprecated:xmlBinding.append(outputXML(sparqlBinding));
    			  //if (this.debuggingOutput) System.out.println(sparqlBinding);
    			  //06-06-11, get now also bingind for complement of placeholders than for naming aspect
				  for (String p : placeholdersOP1NOTinNDPs) {
			    	  //if (this.debuggingOutput) System.out.println("p:"+p);
			    	  //node=(RDFNode)(solution.get(p));
					  node=solution.get(p);
			    	  if (node.isAnon()) {
			    		  nextOne=true;
			    		  //if (this.debuggingOutput) System.out.println("break anonymous"+node.toString());
			    		  break;	    		  
			    	  }
			    	  else {
			    		  value=node.toString();
			    		  if (this.ontologyNamespace.equals("")) this.ontologyNamespace=value.substring(0,value.indexOf("#")+1);
			    		  value=value.substring(value.indexOf("#")+1);
			    		  if (value.equals("Thing")||value.equals("Nothing")) {
			    			  nextOne=true;
			    			  //if (this.debuggingOutput) System.out.println("break Thing");
			    			  break;
			    		  }
			    		  //if (this.debuggingOutput) System.out.println("OK p:"+p+" value:"+value);
			    	  }			    	
			    	  //if (this.debuggingOutput) System.out.print(p+"="+value);
			    	  sparqlBinding.put(p, value);
				  }
    			  if (xmlSerialization) {    				  
    			      query_results.add(outputXML(sparqlBinding));
    			  }
    			  else {
    				  //01-04-11, plain output instead of XML output
    				  query_results.add(outputPlain(sparqlBinding));
    			  }
    		  }
    	  }
    	  //if (this.debuggingOutput) System.out.println("----------");
	      //if (this.debuggingOutput) System.out.println(sparqlBinding);
	    }    
        
        currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right after the SPARQL results processing (delta):"+(currentTime-time));
        time=currentTime;
        
        //deprecated:xmlBinding.append("</query_results>\n");
		//deprecated:return xmlBinding.toString();
        if (this.debuggingOutput) System.out.println(combinations+" different combinations");
        //21-11-11, in order to close open files - there was a problem of "too many open files"
        nsc.finish();
        m.close();
        
        return query_results;
	}
	
	//07-06-11, naming aspect goes first
	//reasoner flag is for propagating to queryPatternStructuralAspect()
	/**
	 * Returns detected ontology patterns using first naming aspect and then structural aspect specified within OP1 of transformation pattern. Preferred detection method. But in some cases we just have to use structural aspect, i.e. method queryPatternStructuralAspect() 
	 * 
	 * @see queryPatternStructuralAspect()
	 * @param pattern	transformation pattern to be applied
	 * @param ontologyURI	link to ontology in which detection should be applied
	 * @param xmlSerialization true/false should these results be serialized in XML (true) or in plain text (false)
	 * @param reasoner true/false should be reasoner be employed for detection?
	 */
	public ArrayList<String> queryPatternNamingAspect(TransformationPattern pattern, String ontologyURI, boolean xmlSerialization, boolean reasoner) {
		long currentTime=0;
        long time=0;
        
        currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right before the detection:"+currentTime);
        time=currentTime;
        
		//1. init op, ontology and take entities
		OntologyPattern op = pattern.getOP1();
		OWLOntology ontology = null;	
		OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
		OWLDataFactory factory = manager.getOWLDataFactory();
		try {
			//ontology:
			//this.ontology = manager.loadOntologyFromPhysicalURI(URI.create(url));			
			//09-03-10,ontology can be directly file as String or referring URL
			if ((ontologyURI.matches("^http.*"))||(ontologyURI.matches("^file.*"))) {
				ontology = manager.loadOntologyFromOntologyDocument(IRI.create(ontologyURI));
				//this.url=url;
			}
			else {
				//InputStream in = new ByteArrayInputStream(url.getBytes()); for owl-api 3.0.0
				//setOntology(this.manager.loadOntologyFromOntologyDocument(new StringInputSource(url))); for owl-api 2
				InputStream in = new ByteArrayInputStream(ontologyURI.getBytes()); //for owl-api 3.0.0
				ontology=manager.loadOntologyFromOntologyDocument(in);
			}							
			//if (this.debuggingOutput) System.out.println("base="+this.base);
			this.ontologyNamespace = getBaseURI(manager, ontology, ":");
		}
		catch (Exception e) {
			e.printStackTrace();
		}				
		
		//test
		//if (this.debuggingOutput) System.out.println(ontology.toString());
		
		ArrayList<String> classes = new ArrayList<String>();
		for (OWLClass cls : ontology.getClassesInSignature()) {
			if (cls instanceof OWLNamedObject) {
				classes.add(cls.toStringID().substring(cls.toStringID().indexOf("#")+1));
				//if (this.debuggingOutput) System.out.println(cls.toStringID().substring(cls.toStringID().indexOf("#")+1));
			}
		}
		ArrayList<String> properties = new ArrayList<String>();
		for (OWLObjectProperty oprp : ontology.getObjectPropertiesInSignature()) {
			if (oprp instanceof OWLNamedObject) {
				properties.add(oprp.toStringID().substring(oprp.toStringID().indexOf("#")+1));
				//if (this.debuggingOutput) System.out.println(oprp.toStringID().substring(oprp.toStringID().indexOf("#")+1));
			}
		}
		for (OWLDataProperty dprp : ontology.getDataPropertiesInSignature()) {
			if (dprp instanceof OWLNamedObject) {
				properties.add(dprp.toStringID().substring(dprp.toStringID().indexOf("#")+1));
				//if (this.debuggingOutput) System.out.println(dprp.toStringID().substring(dprp.toStringID().indexOf("#")+1));
			}
		}
		ArrayList<String> individuals = new ArrayList<String>();
		for (OWLNamedIndividual ind : ontology.getIndividualsInSignature()) {
			individuals.add(ind.toStringID().substring(ind.toStringID().indexOf("#")+1));
			//if (this.debuggingOutput) System.out.println(ind.toStringID().substring(ind.toStringID().indexOf("#")+1));			
		}
				
		//2. check COMPARISON NDP
		NamingConstraintsImpl nsc = new NamingConstraintsImpl(true,this.dictionaryPath,this.modelsPath);
		//09-06-11, newly ArrayList<HashMap<String,List<String>>> i.e. array where one item for each COMPARISON
		ArrayList<HashMap<String,List<String>>> placeholdersBinding = nsc.checkNamingConstraints(op, classes, properties, individuals, op.getNameDetectionPatterns());
		if (this.debuggingOutput) System.out.println("placeholdersBinding "+placeholdersBinding);	
		//3. check structural aspect using SPARQL and then check EXIST NDP aspect and return ArrayList<String>
		//if (this.debuggingOutput) System.out.println(ontologyURI);
		ArrayList<String> results = queryPatternStructuralAspect(pattern, ontologyURI, placeholdersBinding, xmlSerialization, reasoner);
		
		if (this.debuggingOutput) System.out.println("results "+results);
		
		currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right after the detection (delta):"+(currentTime-time));
        time=currentTime;
		
        nsc.finish();
        
		return results;				
	}
	
	private void addPlaceholdersMapping(HashMap<String, ArrayList<String>> mappingsPlaceholders, String currentPlaceholder, int u) {
		if (mappingsPlaceholders.containsKey(currentPlaceholder)) {
				ArrayList<String> pls = mappingsPlaceholders.get(currentPlaceholder);
				pls.add(currentPlaceholder+(u+1));
		}
		else {
			ArrayList<String> pls = new ArrayList<String>(); 
			pls.add(currentPlaceholder+(u+1));
			mappingsPlaceholders.put(currentPlaceholder, pls);
		}
	}
	
	//07-06-11, 2nd step after COMPARISON naming aspect and before EXIST naming aspect
	//now it is also possible to choose reasoner pellet
	/**
	 * Returns detected ontology patterns merely using structural aspect specified within OP1 of transformation pattern. Preferred detection method for merely structural aspect. In some cases it is much more better to use first naming aspect and then structural aspect, see method queryPatternNamingAspect() 
	 * 
	 * @see queryPatternNamingAspect()
	 * @param pattern	transformation pattern to be applied
	 * @param ontologyURI	link to ontology in which detection should be applied
	 * @param xmlSerialization true/false should these results be serialized in XML (true) or in plain text (false)
	 * @param reasoner true/false should be reasoner be employed for detection?
	 */
	public ArrayList<String> queryPatternStructuralAspect(TransformationPattern tp, String ontologyURI, ArrayList<HashMap<String,List<String>>> placeholdersBinding, boolean xmlSerialization, boolean reasoner) {		
		//22-04-11
		this.subClassOfs=new ArrayList<SubClassOfPair>();
		//08-03-11
		OntologyPattern patternOP1=tp.getOP1();
		//09-03-10
		//NOTE: now input ontology can be directly String or referring url		
		//init model using Jena
		OntModel m;
		if (reasoner)
			m = ModelFactory.createOntologyModel(PelletReasonerFactory.THE_SPEC); //for SPARQL-DL
		else 
			m = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
		this.ontologyURI=ontologyURI;
		this.patternURI=tp.getLocation();			
		if ((ontologyURI.matches("^http.*"))||(ontologyURI.matches("^file.*")))
			m.read(ontologyURI);
		else {
			InputStream in = new ByteArrayInputStream(ontologyURI.getBytes());			
			m.read(in,"");
			try {
				in.close();
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
		//init query
		StringBuilder query = new StringBuilder();
		String queryBegin = 
            "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n" + 
            "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n" + 
            "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
		for(String s : patternOP1.getNamespaces().keySet()) {
			queryBegin+="PREFIX "+patternOP1.getNamespaces().get(s)+": <"+s+">\n";			
		}
		queryBegin+="\n" + 
            "SELECT * \n" + 
            "WHERE {\n";
        String queryEnd = "}";
        //04-11-11, finally I leave FILTER part here because if all generated/multiplied placeholders are in FILTER part then it takes much longer time        
        
        //22-04-10, FILTER part
          ArrayList<String> classes = new ArrayList<String>();
          ArrayList<String> properties = new ArrayList<String>();
          ArrayList<String> individuals = new ArrayList<String>();
          query.append(queryBegin);
          //04-11-11, also "declarations" of entities are left here and not updated because this SPARQL query is faster
          // NOTE, 10-11-11, bez declarations je to rychlejsi! 
          // FILTER muze byt velmi restriktivni -> heuristika pridat FILTER jen kdyz tam neni soucasne OPTIONAL
          // FILTER urcite potrebujeme v pripade detection naming aspectu - TODO nejak FILTER pro naming aspect, napr. tp_participation dynamicky zapnout
          //10-11-11, now declaration and filter only if there is some input from naming aspect:
          if (!placeholdersBinding.isEmpty()) {
	          for (String p : patternOP1.getPlaceholders().keySet()) {
	          	if (patternOP1.getPlaceholders().get(p).equals(EntityType.Class)) {
	          		//query.append(p+" rdf:type owl:Class.\n");
	          		classes.add(p);
	          	}
	          	else if (patternOP1.getPlaceholders().get(p).equals(EntityType.ObjectProperty)) {
	          		//query.append(p+" rdf:type owl:ObjectProperty.\n");
	          		properties.add(p);
	          	}
	          	else if (patternOP1.getPlaceholders().get(p).equals(EntityType.DatatypeProperty)) {
	          		//query.append(p+" rdf:type owl:DataProperty.\n");
	          		properties.add(p);
	          	}
	          	else if (patternOP1.getPlaceholders().get(p).equals(EntityType.Individual)) {
	          		//query.append(p+" rdf:type owl:NamedIndividual.\n");
	          		individuals.add(p);
	          	}
	          }
          }
          //22-04-10, FILTER part, cont.
          String filter="";
          //10-06-11, control listing
          //for(HashMap<String,List<String>> map : placeholdersBinding) {
      	//	if (this.debuggingOutput) System.out.println(map);        
          //}        
          //09-06-11
          /*
          if (!placeholdersBinding.isEmpty()) {
          	filter="FILTER (";
          	for(HashMap<String,List<String>> placeholdersBindingOne : placeholdersBinding) {
  		    	ArrayList<ArrayList<String>> lists = new ArrayList<ArrayList<String>>(placeholdersBindingOne.size()); 
  		    	ArrayList<String> placeholders = new ArrayList<String>();  
  		    	int max=0;
  		    	for(String s : placeholdersBindingOne.keySet()) {       		
  		    		ArrayList<String> list = (ArrayList<String>)placeholdersBindingOne.get(s);
  		    		lists.add(list);
  		    		if (list.size() > max) max=list.size();        		
  		    		placeholders.add(s);
  		    	}
  		    	for(int i=0; i<max; i++) {
  		    		filter+=" ( ";
  		    		int j=0;        		
  		    		for(ArrayList<String> li : lists) {
  		    			//if (li.size()<max-1) continue;
  		    			//if (this.debuggingOutput) System.out.println("i "+i+" j "+j+" max "+max);
  		    			//if (li.size()-1<i) continue;
  		    			if ((li.size()-1)>=i) {
  		        			if (j==0) filter+=placeholders.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		        			else filter+=" && "+placeholders.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		    			}
  		    			
  		    			//if (j!=placeholdersBindingOne.size()-1) {        				
  		    			//	filter+=" && ";
  		    			//}
  		    			j++;
  		    		}
  		    		//if (this.debuggingOutput) System.out.println("i "+i+" max "+max);
  		    		//if (i!=max-1)
  		    		filter+=" ) || "; //zde je chyba!
  		    	}        		        		        	
  		        filter+=" ) "; 
          	}
          	filter+=" ) && ";
          }*/
          //if (this.debuggingOutput) System.out.println("empty? "+placeholdersBinding.isEmpty());
          //10-06-11, variant for COMPARISON inner && and outside || - this is not completely correct
          //almost comparison variant
          /*if (!placeholdersBinding.isEmpty()) {
          	filter="FILTER (";
          	//10-06-11, in the case of non empty placeholdersBinding no additional conditions like B!=A etc.
          	//filter="FILTER ";
          	int c= 0;
          	for(HashMap<String,List<String>> placeholdersBindingOne : placeholdersBinding) {
          		//if (c!=0) filter+=" || ";        		
  		    	ArrayList<ArrayList<String>> lists = new ArrayList<ArrayList<String>>(placeholdersBindingOne.size()); 
  		    	ArrayList<String> placeholders = new ArrayList<String>();  
  		    	int max=0;
  		    	for(String s : placeholdersBindingOne.keySet()) {       		
  		    		ArrayList<String> list = (ArrayList<String>)placeholdersBindingOne.get(s);
  		    		lists.add(list);
  		    		//if (list.size() > max) max=list.size();        		
  		    		placeholders.add(s);
  		    		max=list.size();
  		    	}
  		    	for(int i=0; i<max; i++) {
  		    		filter+=" ( ";
  		    		int j=0;        		
  		    		for(ArrayList<String> li : lists) {
  		    			//if (li.size()<max-1) continue;
  		    			//if (this.debuggingOutput) System.out.println("i "+i+" j "+j+" max "+max);
  		    			//if (li.size()-1<i) continue;
  		    			if ((li.size()-1)>=i) {
  		        			if (j==0) filter+=placeholders.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		        			else filter+=" && "+placeholders.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		    			}
  		    			
  		    			//if (j!=placeholdersBindingOne.size()-1) {        				
  		    			//	filter+=" && ";
  		    			//}
  		    			j++;
  		    		}
  		    		//if (this.debuggingOutput) System.out.println("i "+i+" max "+max);
  		    		//if (i!=max-1)
  		    		//if (c!=(placeholdersBinding.size()-1)&&(i!=max-1)) 
  		    		if (i!=max-1)
  		    			filter+=" ) || ";
  		    		//else if ((i==max-1)&&(c!=(placeholdersBinding.size()-1)));
  		    		//	filter+=" || ";
  		    	}        		        		        	
  		        if (c!=(placeholdersBinding.size()-1))
  		        	filter+=" ) || ";
  		        c++;
          	}        	
          	//filter+=" ) && ";
          	//10-06-11, no additional conditions B!=A etc.
          	filter+=" ))\n ";
          }*/
          //10-06-11, right variant is all combination for one COMPARISON && and for others ||                
          //two comparison variant
          //13-06-11, now there is general comparison variant
          if (!placeholdersBinding.isEmpty()) {
          	//generate all combinations for each COMPARISON first placeholdersBindingOne:
          	ArrayList<ArrayList<String>> andCombinationsAll = new ArrayList<ArrayList<String>>(); //all comparison each one item array of array
          	String combination="";
          	for(HashMap<String,List<String>> placeholdersBindingOne : placeholdersBinding) {
          		ArrayList<String> andCombinations = new ArrayList<String>();
  		    	ArrayList<ArrayList<String>> lists = new ArrayList<ArrayList<String>>(placeholdersBindingOne.size()); 
  		    	ArrayList<String> placeholders1 = new ArrayList<String>();  
  		    	int max=0;
  		    	for(String s : placeholdersBindingOne.keySet()) {       		
  		    		ArrayList<String> list = (ArrayList<String>)placeholdersBindingOne.get(s);
  		    		lists.add(list);
  		    		placeholders1.add(s);
  		    		max=list.size();
  		    	}
  		    	for(int i=0; i<max; i++) {
  		    		int j=0;        		
  		    		for(ArrayList<String> li : lists) {
  		    			if ((li.size()-1)>=i) {
  		        			if (j==0) combination+=placeholders1.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		        			else combination+=" && "+placeholders1.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		    			}
  		    			j++;
  		    		}
  		    		andCombinations.add(combination);
  		    		combination="";
  		    	} 
  		    	andCombinationsAll.add(andCombinations);
          	}
          	//if (this.debuggingOutput) System.out.println(andCombinationsAll);
          	//combine it for filter:
          	//DONE zobecnit to i pro vice nez jen dve ci jedno COMPARISONs - po dvojicich
          	//10-06-11, 2:52pm, general comparison variant, DONE 13-06-11
          	//recursive combination of COMPARISON placeholders binding
          	int numberOfComparisons = andCombinationsAll.size();
          	//13-06-11,printing test
          	/*
          	for (int i=0; i<numberOfComparisons; i++) {
          		if (this.debuggingOutput) System.out.println(andCombinationsAll.get(i));
          	}*/
          	ArrayList<String> combined = new ArrayList<String>();
          	if (numberOfComparisons>1) {
          		combined = this.combineTwoComparisons(andCombinationsAll.get(0),andCombinationsAll.get(1));        	
  	        	for (int i=2; i<numberOfComparisons; i++) {
  	        		combined = this.combineTwoComparisons(combined, andCombinationsAll.get(i));
  	        		//if (this.debuggingOutput) System.out.println(i + ","+combined);
  	        		//if (this.debuggingOutput) System.out.println(this.combineTwoComparisons(this.combineTwoComparisons(andCombinationsAll.get(i), andCombinationsAll.get(i-1)), andCombinationsAll.get(i-1)));
  	        		//this.combineTwoComparisons(andCombinationsAll.get(i), andCombinationsAll.get(i-1));
  	        		//if (this.debuggingOutput) System.out.println(this.combineTwoComparisons(andCombinationsAll.get(i), andCombinationsAll.get(i+1)));
  	        	}
  	        	if (this.debuggingOutput) System.out.println("final combined:"+combined);	        	
          	}
          	else {
          		//just only one COMPARISON ndp
          		if (this.debuggingOutput) System.out.println("just only one COMPARSION in TP");
          		if (andCombinationsAll.get(0).size()>1) {
  	        		for (int j=0; j<andCombinationsAll.get(0).size()-1;j++) {
  						combined.add(""+andCombinationsAll.get(0).get(j)+" || "+andCombinationsAll.get(0).get(j+1)+"");
  					}
          		}
          		else if (andCombinationsAll.get(0).size()>0) 
          			combined.add(andCombinationsAll.get(0).get(0));
          	}
          	//if (this.debuggingOutput) System.out.println("(");
          	//13-06-11, completing FILTER part general comparison variant
          	if (!combined.isEmpty()) {
  	        	filter="FILTER (";
  	        	for(int i=0; i<combined.size();i++) {
  	        		//if (this.debuggingOutput) System.out.println(combined.get(i));
  	        		filter+=combined.get(i)+"\n";
  	        		if (i!=combined.size()-1)
  	        			//if (this.debuggingOutput) System.out.print(" || ");
  	        			filter+=" || ";
  	        	}
  	        	filter+=") \n";
          	}
          	//end of general comparison variant
          	//System.exit(1);
          	        	
          	//two comparison variant, combine it for the filter the case for two COMPARISONs a one COMPARISON
          	/*
          	if (andCombinationsAll.size()==2) {
          		filter="FILTER (";
          		ArrayList<String> comparison1 = andCombinationsAll.get(0);
          		//comparison1.add("?B");
          		//for testing
          		//comparison1.clear();
          		//comparison1.add("a1");
          		//comparison1.add("a2");
          		//comparison1.add("a3");
          		        		
          		ArrayList<String> comparison2 = andCombinationsAll.get(1);
          		//for testing
          		//comparison2.clear();        		 
          		//comparison2.add("b1");
          		//comparison2.add("b2");
          		
          		for(int i=0; i<comparison1.size();i++) {
          			for (int j=0; j<comparison2.size();j++) {
          				//if (this.debuggingOutput) System.out.println("("+comparison1.get(i)+" && "+comparison2.get(j)+")");
          				filter+="("+comparison1.get(i)+" && "+comparison2.get(j)+")";
          				if (j!=(comparison2.size()-1)) {        				
              				filter+=" || ";
              			}        				
          			}
          			if (i!=(comparison1.size()-1)) {        				
          				filter+=" || ";
          			}
          		}
          		filter+=" )\n ";
          	}
          	else {//just only one COMPARISON ndp
          		filter="FILTER (";
          		ArrayList<String> comparison1 = andCombinationsAll.get(0);
          		for(int i=0; i<comparison1.size();i++) {
          			//if (this.debuggingOutput) System.out.println(comparison1.get(i));
          			filter+="("+comparison1.get(i)+")";
          			if (i!=(comparison1.size()-1)) {
          				//if (this.debuggingOutput) System.out.println(" || ");
          				filter+=" || ";
          			}
          		}
          		filter+=" )\n ";       	        	        		
          	}
          	//if (this.debuggingOutput) System.out.println(filter);
          	//System.exit(1);
          	//filter="";
          }   */          
          	/*
          	filter="FILTER (";
          	//10-06-11, in the case of non empty placeholdersBinding no additional conditions like B!=A etc.
          	//filter="FILTER ";
          	int c= 0;
          	for(HashMap<String,List<String>> placeholdersBindingOne : placeholdersBinding) {
          		//if (c!=0) filter+=" || ";        		
  		    	ArrayList<ArrayList<String>> lists = new ArrayList<ArrayList<String>>(placeholdersBindingOne.size()); 
  		    	ArrayList<String> placeholders = new ArrayList<String>();  
  		    	int max=0;
  		    	for(String s : placeholdersBindingOne.keySet()) {       		
  		    		ArrayList<String> list = (ArrayList<String>)placeholdersBindingOne.get(s);
  		    		lists.add(list);
  		    		//if (list.size() > max) max=list.size();        		
  		    		placeholders.add(s);
  		    		max=list.size();
  		    	}
  		    	for(int i=0; i<max; i++) {
  		    		filter+=" ( ";
  		    		int j=0;        		
  		    		for(ArrayList<String> li : lists) {
  		    			//if (li.size()<max-1) continue;
  		    			//if (this.debuggingOutput) System.out.println("i "+i+" j "+j+" max "+max);
  		    			//if (li.size()-1<i) continue;
  		    			if ((li.size()-1)>=i) {
  		        			if (j==0) filter+=placeholders.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		        			else filter+=" && "+placeholders.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
  		    			}
  		    			
  		    			//if (j!=placeholdersBindingOne.size()-1) {        				
  		    			//	filter+=" && ";
  		    			//}
  		    			j++;
  		    		}
  		    		//if (this.debuggingOutput) System.out.println("i "+i+" max "+max);
  		    		//if (i!=max-1)
  		    		//if (c!=(placeholdersBinding.size()-1)&&(i!=max-1)) 
  		    		if (i!=max-1)
  		    			filter+=" ) || ";
  		    		//else if ((i==max-1)&&(c!=(placeholdersBinding.size()-1)));
  		    		//	filter+=" || ";
  		    	}        		        		        	
  		        if (c!=(placeholdersBinding.size()-1))
  		        	filter+=" ) || ";
  		        c++;
          	}        	
          	//filter+=" ) && ";
          	//10-06-11, no additional conditions B!=A etc.
          	filter+=" ))\n ";
          }*/
          
          //07-06-11,entities got from COMPARISON naming aspect
          //relax varianta
          /*if (!placeholdersBinding.isEmpty()) {
          	filter="FILTER (";
          	//08-06-11 this variant is: (?p= || ?p= ||...) && (?A= || ?A= || ) && ..        	
          	for(String s : placeholdersBinding.keySet()) {
          		List<String> list = placeholdersBinding.get(s);
          		filter+=" ( ";
          		int len=list.size();        		
          		for(String r : list) {
          			len--;
          			filter+=" "+s+"=<"+this.ontologyNamespace+r+">";
                  	if (len!=0)
                  		filter+=" || ";
          		}            	
              	filter+=" ) && ";
              }
          }*/
          	//08-06-11 better variant is: ((?p= && ?A=) || (?p= && ?A=) || ...) && ..
          	//relax all combinations variant
          	/*
          	ArrayList<ArrayList<String>> lists = new ArrayList<ArrayList<String>>(placeholdersBinding.size()); 
          	ArrayList<String> placeholders = new ArrayList<String>();  
          	int max=0;
          	for(String s : placeholdersBinding.keySet()) {       		
          		ArrayList<String> list = (ArrayList<String>)placeholdersBinding.get(s);
          		lists.add(list);
          		if (list.size() > max) max=list.size();        		
          		placeholders.add(s);
          	}
          	for(int i=0; i<max; i++) {
          		filter+=" ( ";
          		int j=0;        		
          		for(ArrayList<String> li : lists) {
          			//if (li.size()<max-1) continue;
          			//if (this.debuggingOutput) System.out.println("i "+i+" j "+j+" max "+max);
          			//if (li.size()-1<i) continue;
          			if ((li.size()-1)>=i) {
  	        			if (j==0) filter+=placeholders.get(j)+"= "+this.ontologyNamespace+li.get(i)+">";
  	        			else filter+=" && "+placeholders.get(j)+"=<"+this.ontologyNamespace+li.get(i)+">";
          			}
          			
          			//if (j!=placeholdersBinding.size()-1) {        				
          			//	filter+=" && ";
          			//}
          			j++;
          		}
          		//if (this.debuggingOutput) System.out.println("i "+i+" max "+max);
          		if (i!=max-1)
          			filter+=" ) || ";
          	}        		        		        	
              filter+=" ) && ";*/           
          }       
          else {        	//10-06-11, in the case empty placeholdersBinding = conditions like B!=A etc.
  	        if (classes.size()>=2||properties.size()>=2||individuals.size()>=2) { 
  	        	if (placeholdersBinding.isEmpty())
  	        		filter="FILTER (";
  	        	if (classes.size()>=2) {
  	        		for (int i=0; i < classes.size(); i++) {
  		        		for (int j=i+1; j < classes.size(); j++) {
  		        			if (i!=j) {		        			
  		        				filter+=classes.get(i);
  			        			filter+=" != "+classes.get(j);
  			        			//if (this.debuggingOutput) System.out.println(i + " "+j+" "+classes.size());
  			        			if ((i+2!=classes.size())||j+1!=classes.size())
  			        			//if ((i+j)!=classes.size()+(classes.size()%2))
  			        				filter+=" && ";		    
  		        			}
  		        		}
  	        		}
  	        	}
  	        	if (properties.size()>=2) {
  	        		if (classes.size()>=2) filter+=" && ";
  	        		for (int i=0; i < properties.size(); i++) {
  	        			for (int j=i+1; j < properties.size(); j++) {
  		        			//if (this.debuggingOutput) System.out.println(i + " "+j+" "+properties.size());
  	        				if (i!=j) {
  		        				filter+=properties.get(i);
  			        			filter+=" != "+properties.get(j);
  			        			if ((i+2!=properties.size())||j+1!=properties.size())
  			        				filter+=" && ";
  		        			}
  	        			}
  	        		}
  	        	}
  	        	if (individuals.size()>=2) {
  	        		if (classes.size()>=2||properties.size()>=2) filter+=" && ";
  	        		for (int i=0; i < individuals.size(); i++) {
  	        			for (int j=i+1; j < individuals.size(); j++) {
  		        			filter+=individuals.get(i);
  		        			filter+=" != "+individuals.get(j);
  		        			if ((i+2!=individuals.size())||j+1!=individuals.size())
  		        				filter+=" && ";
  	        			}
  	        		}
  	        	}
  	        	filter+=")\n";
  	        } 
          }
          //end of preparting FILTER component of SPARQL query
        
        Pattern pat;
        Matcher matcher;
        String[] placeholders = new String[4]; //20-04-10, up to 3 placeholders for now
        //29-09-11, first try if there is constructor expansion operator @ in any axiom
        //such an axiom must be replaced by generated ones in tp.OP1 and tp.OP2
        //it must be carefully propagated to tp.OP1 (here called pattern), tp.OP2 and tp.PT
        //prepare axioms maybe some new will be generated due to presence of expansion operator @
        HashMap<String,String[]> toReplaceOP1Axioms = new HashMap<String,String[]>();
        HashMap<String,String[]> toReplaceOP2Axioms = new HashMap<String,String[]>();
        OntologyPattern patternOP2 = tp.getOP2();
        ArrayList<String> oldOP2placeholders = new ArrayList<String>();
        //ArrayList<String> mappingsOP1Placeholders = new ArrayList<String>();
        HashMap<String, ArrayList<String>> mappingsOP1Placeholders = new HashMap<String, ArrayList<String>>(); 
        HashMap<String, ArrayList<String>> mappingsOP2Placeholders = new HashMap<String, ArrayList<String>>();
        //04-10-11, number of multiplication depending on expansion construct and its detection in an ontology
        int numberOfMultiplication = 0;
        //04-10-11, it can happen that some axioms contain only placeholders which are multipled as a result of being in other axioms, e.g. ?U subclassOf ?Y and ?U equivalentTo (unionOf(?B)) and ?B is multiplied then those axioms must be inspected and changed appropriately afterwards
        ArrayList<String> OP2axiomsToInspect = new ArrayList<String>();
        //03-11-11, placeholders which should not be multiplied e.g. A equivalentTo oneOf{...a} => A should not be multiplied
        ArrayList<String> notMultipliedPlaceholdersOP1 = new ArrayList<String>();
        ArrayList<String> notMultipliedPlaceholdersOP2 = new ArrayList<String>();
        //ArrayList<String> mappingsOP2Placeholders = new ArrayList<String>();
        for (String axiom : patternOP1.getAxioms()) {
        	//27-09-11, first try if there is constructor expansion operator @
        	if (axiom.matches(".*\\.\\.\\..*")) {
        		if (this.debuggingOutput) System.out.println("constructor expansion operator @ applied on oneOf");        		
        		//if (axiom.matches(".*@\\{\\?[0-9a-zA-Z_]* \\} ")) {
        		if (axiom.matches(".*\\{\\.\\.\\.\\?[0-9a-zA-Z_]* \\} ")) {
        			pat = Pattern.compile("\\?[0-9a-zA-Z_]*");        			
            		
            		matcher = pat.matcher(axiom);
            		int p=0;
            		while(matcher.find()) {        			
            			placeholders[p]=matcher.group();
            			p++;
            		}
        			
            		//03-11-11,placeholders which should not be multiplied:
            		notMultipliedPlaceholdersOP1.add(placeholders[0]);
            		//if (this.debuggingOutput) System.out.println("constructor expansion operator @ applied on oneOf "+placeholders[1]);
            		//17-10-11, new one according to varargs in java, here "an arbitrary number of placeholders"
            		if (this.debuggingOutput) System.out.println("constructor expansion operator ... applied on oneOf "+placeholders[1]);
        			//29-09-11,add new axioms according to expansion:
        			//1st detetect this axiom using OWL-API, i.e. equivalentTo or subClassOf and generate entities placeholders
        			//currently just for one expansion construct in TP:
        			mappingsOP1Placeholders.put(placeholders[1], this.getEntitiesFromExpansionConstruct(ontologyURI,axiom,"oneOf"));
        			numberOfMultiplication = mappingsOP1Placeholders.get(placeholders[1]).size();
        			String oneOfAxiom = mappingsOP1Placeholders.get(placeholders[1]).toString().replaceAll("\\[|\\]", "");
        			oneOfAxiom = oneOfAxiom.replaceAll(",", " ,");
        			patternOP1.replaceAxiom(axiom, axiom.substring(0, axiom.indexOf(".")-1)+"{"+oneOfAxiom+" } ");
        			//2nd (add new axioms to pattern OP1 which are multiplied if there is placeholder from oneOf)
        			//remove (or replace) the old one placeholder and add new placeholders to pattern.placeholders DONE
        			//get all axioms which have placeholders[1] inside (this could be somehow prepared before) DONE below        			
        			for (String axiom1 : patternOP1.getAxioms()) {
        				
        				if (axiom1.matches(".*\\"+placeholders[1]+".*")) {
        					String originalAxiom=axiom1;
        					String[] axiomMultiplied = new String[numberOfMultiplication];
        					for(int u=0;u<numberOfMultiplication;u++) {        						
        						axiomMultiplied[u]=axiom1.replaceAll("\\"+placeholders[1], mappingsOP1Placeholders.get(placeholders[1]).get(u));
        						
        						pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            	        		
            	        		matcher = pat.matcher(axiom1);
            	        		String currentPlaceholder="";
            	        		while(matcher.find()) {        			
            	        			currentPlaceholder=matcher.group();
            	        			if (!currentPlaceholder.equals(placeholders[1])) {
            	        				axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+currentPlaceholder, "?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
            	        				if (mappingsOP1Placeholders.containsKey(currentPlaceholder)) {
            	        					ArrayList<String> pls = mappingsOP1Placeholders.get(currentPlaceholder);
            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
            	        				}
            	        				else {
            	        					ArrayList<String> pls = new ArrayList<String>(); 
            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
            	        					mappingsOP1Placeholders.put(currentPlaceholder, pls);
            	        				}
            	        			}
            	        		}
            	        		//if (this.debuggingOutput) System.out.println(axiomMultiplied[u]);            	        		
        					}
        					toReplaceOP1Axioms.put(originalAxiom, axiomMultiplied);
        				}        				
        			}
        			//NOTE: adding new axioms can be done out of iteration over the same structure, see below in toReplaceOP1Axioms DONE        			
        			//and replace it by multiple appropriate number of axioms DONE  
        			//3rd (add new axioms to pattern OP2 which are multiplied if there is placeholder in link with placeholder from oneOf)        			
        			//get equivalent entities to placeholders[1] and store them as toReplaceEntities
        			//remove (or replace) the old one placeholder and add new placeholders to pattern.placeholders        			
        			
        			//problem that getLinks(Type.any) vraci HashMap takze tam nemuze byt jeden placeholder namapovan vicekrat. Zatim vsak ocekavam, ze max. dva jsou dost (v eq a v eqHet)
        			if (tp.getPT().getLinks(Type.eq).get(placeholders[1])!=null)        				
        				oldOP2placeholders.add(tp.getPT().getLinks(Type.eq).get(placeholders[1]));
        			if (tp.getPT().getLinks(Type.eqHet).get(placeholders[1])!=null) 
        				oldOP2placeholders.add(tp.getPT().getLinks(Type.eqHet).get(placeholders[1]));        			        			
        			for (String s : oldOP2placeholders) {        				
        				if (this.debuggingOutput) System.out.println(s); //s is one of old placeholder
        				mappingsOP2Placeholders.put(s, this.generateEntitiesPlaceholders(numberOfMultiplication, s));
        			}
        			//03-11-11, for ignoring some placeholders which should not be multiplied
        			if (tp.getPT().getLinks(Type.eq).get(placeholders[0])!=null)
        				notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(Type.eq).get(placeholders[0]));
        			if (tp.getPT().getLinks(Type.eqHet).get(placeholders[0])!=null) 
        				notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(Type.eqHet).get(placeholders[0]));        			        			        			
        			
        			if (this.debuggingOutput) System.out.println("no multiply "+notMultipliedPlaceholdersOP2);
        			
        			ArrayList<String> placholdersInUnionOfAxiom = new ArrayList<String>();
        			//get all axioms which have oldOP2placeholders (iterate with s) inside
        			//and replace it by multiple appropriate number of axioms, using the same as above for OP1 but now for OP2:
        			for (String axiom1 : patternOP2.getAxioms()) {
        				if (axiom1.matches(".*unionOf.*")) {
        					pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        					matcher = pat.matcher(axiom1);
        					matcher.find();
        					placholdersInUnionOfAxiom.add(matcher.group());        					
        				}
    					String originalAxiom=axiom1;
    					String[] axiomMultiplied = new String[numberOfMultiplication];
    					
    					String newAxiom="";
    					newAxiom=axiom1;
    					boolean edited=false;
						
    					for(int u=0;u<numberOfMultiplication;u++) {
    						axiomMultiplied[u]=newAxiom;
    						for(int c=0;c<oldOP2placeholders.size();c++) {    							
    							while (axiomMultiplied[u].matches(".*\\"+oldOP2placeholders.get(c)+".*")) {   								
   									axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+oldOP2placeholders.get(c), mappingsOP2Placeholders.get(oldOP2placeholders.get(c)).get(u));
    	    						
    	    						pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
    	        	        		
    	        	        		matcher = pat.matcher(newAxiom);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {    	        	        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			if (!oldOP2placeholders.contains(currentPlaceholder)&&!notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) {
   	        	        					axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+currentPlaceholder, "?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	        	        					//get all new placeholders and also the same for OP
   	        	        					if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
   	            	        					ArrayList<String> pls = mappingsOP2Placeholders.get(currentPlaceholder);
   	            	        					if (!pls.contains("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1)))
   	            	        						pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        				}
   	            	        				else {
   	            	        					ArrayList<String> pls = new ArrayList<String>();    	            	        					
   	            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        					mappingsOP2Placeholders.put(currentPlaceholder, pls);   	            	        					   	            	        				
   	            	        				}
    	        	        			}
    	        	        		}
    	        	        		edited=true;
    							}    							    							
    						}    						
    						
    					}
    					    					
    					if (edited) {
    						//unionOf expansion inside
    						if (axiomMultiplied[0].matches(".*unionOf.*")) { 
    							mappingsOP2Placeholders.remove(placholdersInUnionOfAxiom.get(0));
    							pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
	        	        		ArrayList<String> placeholdersInUnion = new ArrayList<String>();
    							for(int k=0;k<numberOfMultiplication;k++) {
    								matcher = pat.matcher(axiomMultiplied[k]);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			//if (this.debuggingOutput) System.out.println("in unionOf "+currentPlaceholder);
    	        	        			placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
    	        	        		}
    							}
    							pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            					matcher = pat.matcher(axiomMultiplied[0]);
            					matcher.find();
            					axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\"+matcher.group(), placholdersInUnionOfAxiom.get(0));
    							String unionOf = "";
    							for(int pl=0;pl<placeholdersInUnion.size();pl++) {
    								if (pl!=0)
    									unionOf=unionOf+" or "+placeholdersInUnion.get(pl);
    								else 
    									unionOf=placeholdersInUnion.get(pl);
    							}
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							//axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf+" ) ");
    							axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf);
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							String[] arr = {axiomMultiplied[0]};
    							toReplaceOP2Axioms.put(originalAxiom, arr);
    							//remove this placeholder from  
    						}
    						/*
    						else if (axiomMultiplied[0].matches(".*disjointClasses.*")) {
    							if (this.debuggingOutput) System.out.println("disjoint classes");
    							pat = Pattern.compile("disjointClasses\\(\\?[0-9a-zA-Z_]*");
	        	        		ArrayList<String> placeholdersInDisjointness = new ArrayList<String>();
    							for(int k=0;k<numberOfMultiplication;k++) {
    								matcher = pat.matcher(axiomMultiplied[k]);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			if (this.debuggingOutput) System.out.println("in disjointness "+currentPlaceholder);    	        	        			
    	        	        		}
    							}    							
    							String disjointness = "";
    							for(int pl=0;pl<placeholdersInDisjointness.size();pl++) {
    								if (pl!=0)
    									disjointness=disjointness+" , "+placeholdersInDisjointness.get(pl);
    								else 
    									disjointness=placeholdersInDisjointness.get(pl);
    							}
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							//axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf+" ) ");
    							axiomMultiplied[0]=axiomMultiplied[0].replaceAll("disjointClasses(\\?[0-9a-zA-Z_]* \\) ", "disjointClasses:"+disjointness);
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							String[] arr = {axiomMultiplied[0]};
    							toReplaceOP2Axioms.put(originalAxiom, arr);
    						}*/
    						else {
    							//if (this.debuggingOutput) System.out.println(Arrays.toString(axiomMultiplied));
    							toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
    						}
    					}
    					else {
    						//04-10-11, just check whether this axiom does not have original axiom to be changed then it must be later on inspected whether it must be changed as a result of other placeholders were multiplied
    						OP2axiomsToInspect.add(axiom1);
    						//if (this.debuggingOutput) System.out.println("not edited "+axiom1);
    					}
        			}
        			//04-10-11, DONE branch for axioms not having original axiom to be changed then it must be later on inspected whether it must be changed as a result of other placeholders were multiplied
        			//if (this.debuggingOutput) System.out.println("axioms for maybe changed:"+OP2axiomsToInspect);
        			//if (this.debuggingOutput) System.out.println("placeholders in unionOf:"+placholdersInUnionOfAxiom);
        			if (this.debuggingOutput) System.out.println("here:"+mappingsOP2Placeholders);
        			for(String axiomInspection : OP2axiomsToInspect) {
        				//if (this.debuggingOutput) System.out.println(axiomInspection);
        				String originalAxiom=axiomInspection;
    					String[] axiomMultiplied = new String[numberOfMultiplication];
    					
    					String newAxiom="";
    					newAxiom=axiomInspection;
    					boolean edited=false;
    					oldOP2placeholders = new ArrayList<String>();
    					oldOP2placeholders.addAll(mappingsOP2Placeholders.keySet());
    					ArrayList<String> changedBeforeOP2Placeholders = new ArrayList<String>();
    					for(String s : mappingsOP2Placeholders.keySet()) {
    						changedBeforeOP2Placeholders.addAll(mappingsOP2Placeholders.get(s));
    					}
    					if (this.debuggingOutput) System.out.println("changed already before "+changedBeforeOP2Placeholders);
    					for(int u=0;u<numberOfMultiplication;u++) {
    						axiomMultiplied[u]=newAxiom;
    						for(int c=0;c<oldOP2placeholders.size();c++) {    							
    							while (axiomMultiplied[u].matches(".*\\"+oldOP2placeholders.get(c)+".*")) {   								
   									axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+oldOP2placeholders.get(c), mappingsOP2Placeholders.get(oldOP2placeholders.get(c)).get(u));
    	    						
    	    						pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
    	        	        		
    	        	        		matcher = pat.matcher(newAxiom);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();
    	        	        			if (this.debuggingOutput) System.out.println("current "+currentPlaceholder);
    	        	        			if (!changedBeforeOP2Placeholders.contains(currentPlaceholder)&&!notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) {
   	        	        					axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+currentPlaceholder, "?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	        	        					//get all new placeholders and also the same for OP
   	        	        					if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
   	            	        					ArrayList<String> pls = mappingsOP2Placeholders.get(currentPlaceholder);
   	            	        					if (!pls.contains("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1)))
   	            	        						pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        				}
   	            	        				else {
   	            	        					ArrayList<String> pls = new ArrayList<String>(); 
   	            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        					mappingsOP2Placeholders.put(currentPlaceholder, pls);
   	            	        				}
    	        	        			}
    	        	        		}
    	        	        		edited=true;
    	        	        		//if (this.debuggingOutput) System.out.println(axiomMultiplied[u]);
    							}    							    							
    						}    						
    						
    					}
    					if (edited) {
    						//unionOf expansion inside
    						if (axiomMultiplied[0].matches(".*unionOf.*")) {
    							pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
	        	        		ArrayList<String> placeholdersInUnion = new ArrayList<String>();
    							for(int k=0;k<numberOfMultiplication;k++) {
    								matcher = pat.matcher(axiomMultiplied[k]);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			//if (this.debuggingOutput) System.out.println("in unionOf "+currentPlaceholder);
    	        	        			placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
    	        	        		}
    							}
    							String unionOf = "";
    							for(int pl=0;pl<placeholdersInUnion.size();pl++) {
    								if (pl!=0)
    									unionOf=unionOf+" or "+placeholdersInUnion.get(pl);
    								else 
    									unionOf=placeholdersInUnion.get(pl);
    							}
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf);
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							String[] arr = {axiomMultiplied[0]};
    							toReplaceOP2Axioms.put(originalAxiom, arr);
    						}
    						else {
    							//if (this.debuggingOutput) System.out.println(Arrays.toString(axiomMultiplied));
    							toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
    						}
    					}
        			}
        				        				        			        			
        		}
        		else if (axiom.matches(".*unionOf\\(\\.\\.\\.\\?[0-9a-zA-Z_]* \\) \\) ")) {
        			//04-11-11, reusing the code from oneOf with varargs above - maybe there will be some bugs which will appear when more and more transformation patterns with this union construct will appear - just be aware of this and repair it on the fly 
        			//if (axiom.matches(".*\\{\\.\\.\\.\\?[0-9a-zA-Z_]* \\} ")) {
        			//TODO similarly as above for oneOf construct
        			if (this.debuggingOutput) System.out.println("varargs with unionOf...");
        			//System.exit(1);
        			pat = Pattern.compile("\\?[0-9a-zA-Z_]*");        			
            		
            		matcher = pat.matcher(axiom);
            		int p=0;
            		while(matcher.find()) {        			
            			placeholders[p]=matcher.group();
            			p++;
            		}
        			
            		//03-11-11,placeholders which should not be multiplied:
            		notMultipliedPlaceholdersOP1.add(placeholders[0]);
            		//if (this.debuggingOutput) System.out.println("constructor expansion operator @ applied on oneOf "+placeholders[1]);
            		//17-10-11, new one according to varargs in java, here "an arbitrary number of placeholders"
            		if (this.debuggingOutput) System.out.println("constructor expansion operator ... applied on unionOf "+placeholders[1]);
        			//29-09-11,add new axioms according to expansion:
        			//1st detetect this axiom using OWL-API, i.e. equivalentTo or subClassOf and generate entities placeholders
        			//currently just for one expansion construct in TP:
        			mappingsOP1Placeholders.put(placeholders[1], this.getEntitiesFromExpansionConstruct(ontologyURI,axiom,"unionOf"));
        			numberOfMultiplication = mappingsOP1Placeholders.get(placeholders[1]).size();
        			String oneOfAxiom = mappingsOP1Placeholders.get(placeholders[1]).toString().replaceAll("\\[|\\]", "");
        			oneOfAxiom = oneOfAxiom.replaceAll(",", " or ");
        			patternOP1.replaceAxiom(axiom, axiom.substring(0, axiom.indexOf("("))+"("+oneOfAxiom+" ) ");
        			//2nd (add new axioms to pattern OP1 which are multiplied if there is placeholder from oneOf)
        			//remove (or replace) the old one placeholder and add new placeholders to pattern.placeholders DONE
        			//get all axioms which have placeholders[1] inside (this could be somehow prepared before) DONE below        			
        			for (String axiom1 : patternOP1.getAxioms()) {
        				
        				if (axiom1.matches(".*\\"+placeholders[1]+".*")) {
        					String originalAxiom=axiom1;
        					String[] axiomMultiplied = new String[numberOfMultiplication];
        					for(int u=0;u<numberOfMultiplication;u++) {        						
        						axiomMultiplied[u]=axiom1.replaceAll("\\"+placeholders[1], mappingsOP1Placeholders.get(placeholders[1]).get(u));
        						
        						pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            	        		
            	        		matcher = pat.matcher(axiom1);
            	        		String currentPlaceholder="";
            	        		while(matcher.find()) {        			
            	        			currentPlaceholder=matcher.group();
            	        			if (!currentPlaceholder.equals(placeholders[1])) {
            	        				axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+currentPlaceholder, "?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
            	        				if (mappingsOP1Placeholders.containsKey(currentPlaceholder)) {
            	        					ArrayList<String> pls = mappingsOP1Placeholders.get(currentPlaceholder);
            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
            	        				}
            	        				else {
            	        					ArrayList<String> pls = new ArrayList<String>(); 
            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
            	        					mappingsOP1Placeholders.put(currentPlaceholder, pls);
            	        				}
            	        			}
            	        		}
            	        		//if (this.debuggingOutput) System.out.println(axiomMultiplied[u]);            	        		
        					}
        					toReplaceOP1Axioms.put(originalAxiom, axiomMultiplied);
        				}        				
        			}
        			//NOTE: adding new axioms can be done out of iteration over the same structure, see below in toReplaceOP1Axioms DONE        			
        			//and replace it by multiple appropriate number of axioms DONE  
        			//3rd (add new axioms to pattern OP2 which are multiplied if there is placeholder in link with placeholder from oneOf)        			
        			//get equivalent entities to placeholders[1] and store them as toReplaceEntities
        			//remove (or replace) the old one placeholder and add new placeholders to pattern.placeholders        			
        			
        			//problem that getLinks(Type.any) vraci HashMap takze tam nemuze byt jeden placeholder namapovan vicekrat. Zatim vsak ocekavam, ze max. dva jsou dost (v eq a v eqHet)
        			if (tp.getPT().getLinks(Type.eq).get(placeholders[1])!=null)        				
        				oldOP2placeholders.add(tp.getPT().getLinks(Type.eq).get(placeholders[1]));
        			if (tp.getPT().getLinks(Type.eqHet).get(placeholders[1])!=null) 
        				oldOP2placeholders.add(tp.getPT().getLinks(Type.eqHet).get(placeholders[1]));        			        			
        			for (String s : oldOP2placeholders) {        				
        				if (this.debuggingOutput) System.out.println(s); //s is one of old placeholder
        				mappingsOP2Placeholders.put(s, this.generateEntitiesPlaceholders(numberOfMultiplication, s));
        			}
        			//03-11-11, for ignoring some placeholders which should not be multiplied
        			if (tp.getPT().getLinks(Type.eq).get(placeholders[0])!=null)
        				notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(Type.eq).get(placeholders[0]));
        			if (tp.getPT().getLinks(Type.eqHet).get(placeholders[0])!=null) 
        				notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(Type.eqHet).get(placeholders[0]));        			        			        			
        			
        			if (this.debuggingOutput) System.out.println("no multiply "+notMultipliedPlaceholdersOP2);
        			
        			ArrayList<String> placholdersInUnionOfAxiom = new ArrayList<String>();
        			//get all axioms which have oldOP2placeholders (iterate with s) inside
        			//and replace it by multiple appropriate number of axioms, using the same as above for OP1 but now for OP2:
        			for (String axiom1 : patternOP2.getAxioms()) {
        				if (axiom1.matches(".*unionOf.*")) {
        					pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        					matcher = pat.matcher(axiom1);
        					matcher.find();
        					placholdersInUnionOfAxiom.add(matcher.group());        					
        				}
    					String originalAxiom=axiom1;
    					String[] axiomMultiplied = new String[numberOfMultiplication];
    					
    					String newAxiom="";
    					newAxiom=axiom1;
    					boolean edited=false;
						
    					for(int u=0;u<numberOfMultiplication;u++) {
    						axiomMultiplied[u]=newAxiom;
    						for(int c=0;c<oldOP2placeholders.size();c++) {    							
    							while (axiomMultiplied[u].matches(".*\\"+oldOP2placeholders.get(c)+".*")) {   								
   									axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+oldOP2placeholders.get(c), mappingsOP2Placeholders.get(oldOP2placeholders.get(c)).get(u));
    	    						
    	    						pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
    	        	        		
    	        	        		matcher = pat.matcher(newAxiom);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {    	        	        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			if (!oldOP2placeholders.contains(currentPlaceholder)&&!notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) {
   	        	        					axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+currentPlaceholder, "?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	        	        					//get all new placeholders and also the same for OP
   	        	        					if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
   	            	        					ArrayList<String> pls = mappingsOP2Placeholders.get(currentPlaceholder);
   	            	        					if (!pls.contains("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1)))
   	            	        						pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        				}
   	            	        				else {
   	            	        					ArrayList<String> pls = new ArrayList<String>();    	            	        					
   	            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        					mappingsOP2Placeholders.put(currentPlaceholder, pls);   	            	        					   	            	        				
   	            	        				}
    	        	        			}
    	        	        		}
    	        	        		edited=true;
    							}    							    							
    						}    						
    						
    					}
    					    					
    					if (edited) {
    						//unionOf expansion inside
    						if (axiomMultiplied[0].matches(".*unionOf.*")) { 
    							mappingsOP2Placeholders.remove(placholdersInUnionOfAxiom.get(0));
    							pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
	        	        		ArrayList<String> placeholdersInUnion = new ArrayList<String>();
    							for(int k=0;k<numberOfMultiplication;k++) {
    								matcher = pat.matcher(axiomMultiplied[k]);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			//if (this.debuggingOutput) System.out.println("in unionOf "+currentPlaceholder);
    	        	        			placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
    	        	        		}
    							}
    							pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            					matcher = pat.matcher(axiomMultiplied[0]);
            					matcher.find();
            					axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\"+matcher.group(), placholdersInUnionOfAxiom.get(0));
    							String unionOf = "";
    							for(int pl=0;pl<placeholdersInUnion.size();pl++) {
    								if (pl!=0)
    									unionOf=unionOf+" or "+placeholdersInUnion.get(pl);
    								else 
    									unionOf=placeholdersInUnion.get(pl);
    							}
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							//axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf+" ) ");
    							axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf);
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							String[] arr = {axiomMultiplied[0]};
    							toReplaceOP2Axioms.put(originalAxiom, arr);
    							//remove this placeholder from  
    						}
    						/*
    						else if (axiomMultiplied[0].matches(".*disjointClasses.*")) {
    							if (this.debuggingOutput) System.out.println("disjoint classes");
    							pat = Pattern.compile("disjointClasses\\(\\?[0-9a-zA-Z_]*");
	        	        		ArrayList<String> placeholdersInDisjointness = new ArrayList<String>();
    							for(int k=0;k<numberOfMultiplication;k++) {
    								matcher = pat.matcher(axiomMultiplied[k]);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			if (this.debuggingOutput) System.out.println("in disjointness "+currentPlaceholder);    	        	        			
    	        	        		}
    							}    							
    							String disjointness = "";
    							for(int pl=0;pl<placeholdersInDisjointness.size();pl++) {
    								if (pl!=0)
    									disjointness=disjointness+" , "+placeholdersInDisjointness.get(pl);
    								else 
    									disjointness=placeholdersInDisjointness.get(pl);
    							}
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							//axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf+" ) ");
    							axiomMultiplied[0]=axiomMultiplied[0].replaceAll("disjointClasses(\\?[0-9a-zA-Z_]* \\) ", "disjointClasses:"+disjointness);
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							String[] arr = {axiomMultiplied[0]};
    							toReplaceOP2Axioms.put(originalAxiom, arr);
    						}*/
    						else {
    							//if (this.debuggingOutput) System.out.println(Arrays.toString(axiomMultiplied));
    							toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
    						}
    					}
    					else {
    						//04-10-11, just check whether this axiom does not have original axiom to be changed then it must be later on inspected whether it must be changed as a result of other placeholders were multiplied
    						OP2axiomsToInspect.add(axiom1);
    						//if (this.debuggingOutput) System.out.println("not edited "+axiom1);
    					}
        			}
        			//04-10-11, DONE branch for axioms not having original axiom to be changed then it must be later on inspected whether it must be changed as a result of other placeholders were multiplied
        			//if (this.debuggingOutput) System.out.println("axioms for maybe changed:"+OP2axiomsToInspect);
        			//if (this.debuggingOutput) System.out.println("placeholders in unionOf:"+placholdersInUnionOfAxiom);
        			if (this.debuggingOutput) System.out.println("here:"+mappingsOP2Placeholders);
        			for(String axiomInspection : OP2axiomsToInspect) {
        				//if (this.debuggingOutput) System.out.println(axiomInspection);
        				String originalAxiom=axiomInspection;
    					String[] axiomMultiplied = new String[numberOfMultiplication];
    					
    					String newAxiom="";
    					newAxiom=axiomInspection;
    					boolean edited=false;
    					oldOP2placeholders = new ArrayList<String>();
    					oldOP2placeholders.addAll(mappingsOP2Placeholders.keySet());
    					ArrayList<String> changedBeforeOP2Placeholders = new ArrayList<String>();
    					for(String s : mappingsOP2Placeholders.keySet()) {
    						changedBeforeOP2Placeholders.addAll(mappingsOP2Placeholders.get(s));
    					}
    					if (this.debuggingOutput) System.out.println("changed already before "+changedBeforeOP2Placeholders);
    					for(int u=0;u<numberOfMultiplication;u++) {
    						axiomMultiplied[u]=newAxiom;
    						for(int c=0;c<oldOP2placeholders.size();c++) {    							
    							while (axiomMultiplied[u].matches(".*\\"+oldOP2placeholders.get(c)+".*")) {   								
   									axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+oldOP2placeholders.get(c), mappingsOP2Placeholders.get(oldOP2placeholders.get(c)).get(u));
    	    						
    	    						pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
    	        	        		
    	        	        		matcher = pat.matcher(newAxiom);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();
    	        	        			if (this.debuggingOutput) System.out.println("current "+currentPlaceholder);
    	        	        			if (!changedBeforeOP2Placeholders.contains(currentPlaceholder)&&!notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) {
   	        	        					axiomMultiplied[u]=axiomMultiplied[u].replaceAll("\\"+currentPlaceholder, "?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	        	        					//get all new placeholders and also the same for OP
   	        	        					if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
   	            	        					ArrayList<String> pls = mappingsOP2Placeholders.get(currentPlaceholder);
   	            	        					if (!pls.contains("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1)))
   	            	        						pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        				}
   	            	        				else {
   	            	        					ArrayList<String> pls = new ArrayList<String>(); 
   	            	        					pls.add("?_"+currentPlaceholder.replaceAll("\\?", "")+(u+1));
   	            	        					mappingsOP2Placeholders.put(currentPlaceholder, pls);
   	            	        				}
    	        	        			}
    	        	        		}
    	        	        		edited=true;
    	        	        		//if (this.debuggingOutput) System.out.println(axiomMultiplied[u]);
    							}    							    							
    						}    						
    						
    					}
    					if (edited) {
    						//unionOf expansion inside
    						if (axiomMultiplied[0].matches(".*unionOf.*")) {
    							pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
	        	        		ArrayList<String> placeholdersInUnion = new ArrayList<String>();
    							for(int k=0;k<numberOfMultiplication;k++) {
    								matcher = pat.matcher(axiomMultiplied[k]);
    	        	        		String currentPlaceholder="";
    	        	        		while(matcher.find()) {        			
    	        	        			currentPlaceholder=matcher.group();    	        	        			
    	        	        			//if (this.debuggingOutput) System.out.println("in unionOf "+currentPlaceholder);
    	        	        			placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
    	        	        		}
    							}
    							String unionOf = "";
    							for(int pl=0;pl<placeholdersInUnion.size();pl++) {
    								if (pl!=0)
    									unionOf=unionOf+" or "+placeholdersInUnion.get(pl);
    								else 
    									unionOf=placeholdersInUnion.get(pl);
    							}
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							axiomMultiplied[0]=axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "("+unionOf);
    							//if (this.debuggingOutput) System.out.println(axiomMultiplied[0]);
    							String[] arr = {axiomMultiplied[0]};
    							toReplaceOP2Axioms.put(originalAxiom, arr);
    						}
    						else {
    							//if (this.debuggingOutput) System.out.println(Arrays.toString(axiomMultiplied));
    							toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
    						}
    					}
        			}
        		} 
        	}
        }
        //DONE 
        //now transformation pattern is updated according to expansion constructors using varargs such as oneOf or unionOf:
        //4th generate or replace appropriate tp.pt links i.e. links between new placeholders in OP1 and new entities in OP2 ()
        //using mappingsOP1Placeholders and mappingsOP2Placeholders
        if (this.debuggingOutput) System.out.println(mappingsOP1Placeholders);
        if (this.debuggingOutput) System.out.println(mappingsOP2Placeholders);
        //04-10-11, trying to cope with PT part of TP
        PatternTransformation pt = tp.getPT();//.getLinks(Type.eq);
        
        for(String lhs : mappingsOP1Placeholders.keySet()) {
        	if (this.debuggingOutput) System.out.println("lhs:"+lhs);
        	//eq links:
        	if (pt.getLinks(Type.eq).containsKey(lhs)) {
        		String rhs = pt.getLinks(Type.eq).get(lhs);
        		//if (this.debuggingOutput) System.out.println("	"+rhs);
        		
        		String[] lhsNew = new String[numberOfMultiplication];
        		String[] rhsNew = new String[numberOfMultiplication];
        		
            	mappingsOP1Placeholders.get(lhs).toArray(lhsNew);
        		mappingsOP2Placeholders.get(rhs).toArray(rhsNew);
        		
        		pt.addLink(Type.eq, lhsNew, rhsNew);
        		pt.removeLink(Type.eq, lhs);
        		
        		pt.addLink(Type.any, lhsNew, rhsNew);
        		pt.removeLink(Type.any, lhs);
        		
        		//ntp (enp) naming stuff inside pattern transformation:
        		/*
        		if (pt.getENP().containsKey(rhs)) {
            		pt.replaceNTP(lhs, rhs, lhsNew, rhsNew);        		        		
            	}*/
        	}
        	//eqHet links:
        	if (this.debuggingOutput) System.out.println("PT:"+tp.getPT().getLinks(Type.any));
        	if (pt.getLinks(Type.eqHet).containsKey(lhs)) {
        		String rhs = pt.getLinks(Type.eqHet).get(lhs);
            	
        		String[] lhsNew = new String[numberOfMultiplication];
        		String[] rhsNew = new String[numberOfMultiplication];
        		
            	mappingsOP1Placeholders.get(lhs).toArray(lhsNew);
        		mappingsOP2Placeholders.get(rhs).toArray(rhsNew);
        		
        		pt.addLink(Type.eqHet, lhsNew, rhsNew);
        		pt.removeLink(Type.eqHet, lhs);
        		
        		if (!pt.getLinks(Type.any).containsKey(lhsNew[0])) {
        			//if (this.debuggingOutput) System.out.println("neni duplicita "+lhsNew);
        			pt.addLink(Type.any, lhsNew, rhsNew);
        			pt.removeLink(Type.any, lhs);
        		}
        		//ntp (enp) naming stuff inside pattern transformation:
        		/*
        		if (pt.getENP().containsKey(rhs)) {
            		pt.replaceNTP(lhs, rhs, lhsNew, rhsNew);        		        		
            	}*/
        	}        	
        }        
        //ntp (enp) naming stuff inside pattern transformation:
        
        for(String rhs : mappingsOP2Placeholders.keySet()) {
        	//if (this.debuggingOutput) System.out.println("old "+rhs);
        	if (pt.getENP().containsKey(rhs)) {
        		String oldInstructions = pt.getENP().get(rhs);
        		if (this.debuggingOutput) System.out.println("old instructions "+oldInstructions);
        		
        		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        		
        		matcher = pat.matcher(oldInstructions);
        		String currentPlaceholder="";
        		if(matcher.find()) {        			
        			currentPlaceholder=matcher.group();
        			if (mappingsOP1Placeholders.containsKey(currentPlaceholder)) {
	        			//04-10-11, NOTE current limitation. It only works for one placeholder now e.g. <ntp entity="?Y">OneOf+?X</ntp> or <ntp entity="?B">?a+_nc</ntp>   
	        			//oldInstructions=oldInstructions.replaceAll("\\"+currentPlaceholder, replacement)
	        			
	        			String[] lhsNew = new String[numberOfMultiplication];
	            		String[] rhsNew = new String[numberOfMultiplication];
	            		
	                	mappingsOP1Placeholders.get(currentPlaceholder).toArray(lhsNew);
	            		mappingsOP2Placeholders.get(rhs).toArray(rhsNew);
	        			
	        			pt.replaceNTP(currentPlaceholder, rhs, lhsNew, rhsNew);
        			}
        		}
        		        		        	
        	} 
        }
        
        //07-11-11, we should also take care in the opposite direction               
        for(String rhs : mappingsOP1Placeholders.keySet()) {
        	if (this.debuggingOutput) System.out.println("old "+rhs);
        	for (String s : pt.getENP().keySet()) {
        		if (pt.getENP().get(s).matches(".*"+rhs+".*")) {
            		//String oldInstructions = pt.getENP().get(rhs);
        			String oldNTP = s;        			
        			String newInstructions = "";
        			String oldInstructions = pt.getENP().get(s);
            		if (this.debuggingOutput) System.out.println("old instructions "+oldInstructions);
            		//rhs is OK but lhs will be new in a new way:
            		            		
            		int siz=0;
            		for (String ss : mappingsOP1Placeholders.get(rhs)) {            			            			            			            			
            			if (siz==0)
            				newInstructions=ss;
            			else
            				newInstructions+="+,+"+ss;
            				//newInstructions+="+,+"+ss;
            				//newInstructions+="+"+ss;
            			siz++;
            			if (this.debuggingOutput) System.out.println(newInstructions);
            		}
            		            		    	        			
        			//String[] lhsNew = new String[numberOfMultiplication];
            		//String[] rhsNew = new String[numberOfMultiplication];
            		
        			pt.replaceNTP2(s, oldInstructions, s, oldInstructions.replaceAll("\\"+rhs, newInstructions));            		
        			//public void replaceNTP(String lhsOld, String rhsOld, String[] lhsNew, String[] rhsNew) {
            	} 	            
        	}
        }
        	/*
        	if (pt.getENP().containsValue(rhs)) {
        		String oldInstructions = pt.getENP().get(rhs);
        		if (this.debuggingOutput) System.out.println("old instructions "+oldInstructions);
        		
        		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        		
        		matcher = pat.matcher(oldInstructions);
        		String currentPlaceholder="";
        		if(matcher.find()) {        			
        			currentPlaceholder=matcher.group();
        			if (mappingsOP1Placeholders.containsKey(currentPlaceholder)) {
	        			//04-10-11, NOTE current limitation. It only works for one placeholder now e.g. <ntp entity="?Y">OneOf+?X</ntp> or <ntp entity="?B">?a+_nc</ntp>   
	        			//oldInstructions=oldInstructions.replaceAll("\\"+currentPlaceholder, replacement)
	        			
	        			String[] lhsNew = new String[numberOfMultiplication];
	            		String[] rhsNew = new String[numberOfMultiplication];
	            		
	                	mappingsOP1Placeholders.get(currentPlaceholder).toArray(lhsNew);
	            		mappingsOP2Placeholders.get(rhs).toArray(rhsNew);
	        			
	        			pt.replaceNTP(currentPlaceholder, rhs, lhsNew, rhsNew);
        			}
        		}
        		        		        	
        	}*/
        //}*/
        
        //DONE
        //put also other generated placeholders into OP1 and OP2 using replacePlaceholder method and mappingsOP1Placeholders and mappingsOP2Placeholders
        //OP1:        
        for(String s : mappingsOP1Placeholders.keySet()) {        	
        	String[] pls =  new String[mappingsOP1Placeholders.get(s).size()];
        	mappingsOP1Placeholders.get(s).toArray(pls);        	
        	patternOP1.replacePlaceholder(s, pls);
        }
        //OP2:        
        for(String s : mappingsOP2Placeholders.keySet()) {        	
        	String[] pls =  new String[mappingsOP2Placeholders.get(s).size()];
        	mappingsOP2Placeholders.get(s).toArray(pls);        	
        	patternOP2.replacePlaceholder(s, pls);
        }        
        
        //OP1: for replacing oldAxiom where placeholders[1] where used and adding new generated axioms see above in branch if (axiom1.matches(".*\\"+placeholders[1]+".*")) { 
        for(String s: toReplaceOP1Axioms.keySet()) {
			patternOP1.replaceAxiom(s, toReplaceOP1Axioms.get(s));
		}
        //OP2: for replacing oldAxiom where oldOP2placeholders where used and adding new generated axioms see above in branch if (axiom1.matches(".*\\"+s+".*")) { 
        for(String s: toReplaceOP2Axioms.keySet()) {
			patternOP2.replaceAxiom(s, toReplaceOP2Axioms.get(s));
		}        
        //transformation pattern was updated using expansion constructs using varargs such oneOf or unionOf        
        if (this.debuggingOutput) System.out.println(tp);         
        
        //if (this.debuggingOutput) System.out.println(patternOP1);
		//if (this.debuggingOutput) System.out.println(patternOP2);
        //29-09-11, second we can apply SPARQL or Terp detection or resp. prepare query already with new pattern
        //prepare real (currently still) SPARQL or Terp query and the perform a detection
        int restrictionNumber=0;
        for (String axiom : patternOP1.getAxioms()) {
        	String originalAxiom = axiom;
        	restrictionNumber++;
        	//08-11-11, objectPropertyAssertion in RDF and ManchesterSyntax
        	if (axiom.matches("\\?[0-9a-zA-Z_]* \\?[0-9a-zA-Z_]* \\?[0-9a-zA-Z_]*")) {
        		if (this.debuggingOutput) System.out.println("object property assertion");
        	}
        	//04-11-11, implementace pro unionOf z Manchester syntaxe do RDF syntaxe
        	else if (axiom.matches(".* or .*")) {
        		if (this.debuggingOutput) System.out.println("je to tady: unionOf");
        		//String originalAxiom = axiom;
        		//axiom=axiom.replaceAll("\\{.*\\}", "");
        		StringTokenizer st = new StringTokenizer(originalAxiom, " or ");
        		ArrayList<String> operands = new ArrayList<String>();
        		while (st.hasMoreTokens()) {
        			operands.add(st.nextToken());
        		}        		
        		if(axiom.matches(".*equivalentTo.*")) {
        			axiom=axiom.replaceAll("\\(.*\\)", "");
        			axiom=axiom.replaceAll("equivalentTo", "owl:equivalentClass");
        			//axiom=axiom+" _:oneOf1.\n_:oneOf1 owl:oneOf "+originalAxiom+".\n";
        			axiom=axiom+" _:unionOf"+restrictionNumber+".\n_:unionOf"+restrictionNumber+" owl:unionOf "+originalAxiom.substring(originalAxiom.indexOf("("), originalAxiom.indexOf(")")).replace(" or ", " ")+")";
        		}
        		//TODO
        		else if(axiom.matches(".*subClassOf.*")) {
        			axiom=axiom.replaceAll("\\(.*\\)", "");
        			axiom=axiom.replaceAll("subClassOf", "rdfs:subClassOf");
        			//axiom=axiom+" _:oneOf1.\n_:oneOf1 owl:oneOf "+originalAxiom+".\n";
        			axiom=axiom+" _:unionOf"+restrictionNumber+".\n_:unionOf"+restrictionNumber+" owl:unionOf "+originalAxiom.substring(originalAxiom.indexOf("("), originalAxiom.indexOf(")")).replace(" or ", " ")+")";
        		}
        		//query.append(axiom);
        		if (patternOP1.getOptionalAxioms().contains(originalAxiom))
            		query.append("OPTIONAL { "+axiom+" }.\n");
            	else
            		query.append(axiom+".\n");
        	}        	
        	//07-09-11, implementace pro oneOf i.e. {..,..,..} in Manchester syntax
        	else if (axiom.matches(".*\\{.*\\} ")) {
        		if (this.debuggingOutput) System.out.println("je to tady");
        		//String originalAxiom = axiom;
        		//axiom=axiom.replaceAll("\\{.*\\}", "");
        		String enumerationPart = originalAxiom;
        		enumerationPart = enumerationPart.replaceAll("\\{", "(");
        		enumerationPart = enumerationPart.replaceAll("\\}", ")");
        		enumerationPart = enumerationPart.replaceAll(",", " ");
        		enumerationPart = enumerationPart.replaceAll(" $", "");	
        		enumerationPart = enumerationPart.substring(enumerationPart.indexOf("("));
        		if(axiom.matches(".*equivalentTo.*")) {
        			axiom=axiom.replaceAll("\\{.*\\}", "");
        			axiom=axiom.replaceAll("equivalentTo", "owl:equivalentClass");
        			//axiom=axiom+" _:oneOf1.\n_:oneOf1 owl:oneOf "+originalAxiom+".\n";
        			axiom=axiom+" _:oneOf"+restrictionNumber+".\n_:oneOf"+restrictionNumber+" owl:oneOf "+enumerationPart;
        		}
        		else if(axiom.matches(".*subClassOf.*")) {
        			axiom=axiom.replaceAll("\\{.*\\}", "");
        			axiom=axiom.replaceAll("subClassOf", "rdfs:subClassOf");
        			//axiom=axiom+" _:oneOf1.\n_:oneOf1 owl:oneOf "+originalAxiom+".\n";
        			axiom=axiom+" _:oneOf"+restrictionNumber+".\n_:oneOf"+restrictionNumber+" owl:oneOf "+enumerationPart;
        		}
        		//query.append(axiom);
        		//if (this.debuggingOutput) System.out.println("optional axioms:"+patternOP1.getOptionalAxioms());
        		//if (this.debuggingOutput) System.out.println(originalAxiom);
        		//if (this.debuggingOutput) System.out.println(axiom);
        		if (patternOP1.getOptionalAxioms().contains(originalAxiom))
            		query.append("OPTIONAL { "+axiom+" }.\n");
            	else
            		query.append(axiom+".\n");
        	}
        	//21-09-11, complementOf - specific dealing with complementOf because there is different number of placeholders
        	else if (axiom.matches(".*not.*")) {
        		//String originalAxiom = axiom;
        		//pat = Pattern.compile("\\?.");
        		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        		
        		matcher = pat.matcher(axiom);
        		int p=0;
        		while(matcher.find()) {        			
        			placeholders[p]=matcher.group();
        			p++;
        		}
        		
        		if (placeholders[2]!=null) {//some restriction as complementOf
        			if (originalAxiom.matches(".*subClassOf.*")) {
            			axiom=placeholders[0]+" rdfs:subClassOf _:complement"+restrictionNumber+".\n_:complement"+restrictionNumber+" owl:complementOf _:restriction"+restrictionNumber+".\n_:restriction"+restrictionNumber+" rdf:type owl:Restriction.\n";
            		}
            		else if (originalAxiom.matches(".*equivalentTo.*")) {
            			axiom=placeholders[0]+" owl:equivalentClass _:complement"+restrictionNumber+".\n_:complement"+restrictionNumber+" owl:complementOf _:restriction"+restrictionNumber+".\n_:restriction"+restrictionNumber+"	rdf:type owl:Restriction.\n";
            		}
        			
        			axiom=axiom+"_:restriction"+restrictionNumber+" owl:onProperty "+ placeholders[1]+ ".\n";        			
        			
        			if (originalAxiom.matches(".*min.*")) {
            			if (placeholders[3]!=null) {//qualified in OWL2
            				axiom=axiom+"_:restriction"+restrictionNumber+" owl:minQualifiedCardinality "+ placeholders[2]+ ".\n";
            				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
            				axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3];
            			}
            			else//OWL1
            				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:minCardinality "+ placeholders[2]+ ".\n";
            				axiom=axiom+"_:restriction"+restrictionNumber+" owl:minCardinality "+ placeholders[2];
        			}
        			//22-09-11,TODO:else if max atd.
        			else if (originalAxiom.matches(".*max.*")) {
            			if (placeholders[3]!=null) {//qualified in OWL2
            				axiom=axiom+"_:restriction"+restrictionNumber+" owl:maxQualifiedCardinality "+ placeholders[2]+ ".\n";
            				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
            				axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3];
            			}
            			else//OWL1
            				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:maxCardinality "+ placeholders[2]+ ".\n";
            				axiom=axiom+"_:restriction"+restrictionNumber+" owl:maxCardinality "+ placeholders[2];
        			}
        			else if (originalAxiom.matches(".*some.*")) {
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:someValuesFrom "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:someValuesFrom "+ placeholders[2];
        			}
        			else if (originalAxiom.matches(".*only.*")) {
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:allValuesFrom "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:allValuesFrom "+ placeholders[2];
        			}
        			else if (originalAxiom.matches(".*value.*")) {
            			//axiom=axiom+"_:restriction"+restrictionNumber+" owl:hasValue "+ placeholders[2]+ ".\n";        			        		
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:hasValue "+ placeholders[2];
            		}
            			
        		}
        		else {
	        		if (originalAxiom.matches(".*subClassOf.*")) {
	        			//axiom=placeholders[0]+" rdfs:subClassOf _:complement1.\n_:complement1 owl:complementOf "+placeholders[1]+".\n";
	        			axiom=placeholders[0]+" rdfs:subClassOf _:complement1.\n_:complement1 owl:complementOf "+placeholders[1];
	        		}
	        		else if (originalAxiom.matches(".*equivalentTo.*")) {
	        			//axiom=placeholders[0]+" owl:equivalentClass _:complement1.\n_:complement1 owl:complementOf "+placeholders[1]+".\n";
	        			axiom=placeholders[0]+" owl:equivalentClass _:complement1.\n_:complement1 owl:complementOf "+placeholders[1];
	        		}
        		}
        		//query.append(axiom);
        		if (patternOP1.getOptionalAxioms().contains(originalAxiom))
            		query.append("OPTIONAL { "+axiom+" }.\n");
            	else
            		query.append(axiom+".\n");
        	}
        	//20-04-10, docasna neohrabana implementace predtim nez to bude plne mozne pomoci Terp syntaxe
        	else if (axiom.matches(".*value.*")||axiom.matches(".*some.*")||axiom.matches(".*only.*")||axiom.matches(".*min.*")||axiom.matches(".*max.*")||axiom.matches(".*exactly.*")) {
        		//String originalAxiom = axiom;
        		//pat = Pattern.compile("\\?.");
        		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        		
        		matcher = pat.matcher(axiom);
        		int p=0;
        		while(matcher.find()) {        			
        			placeholders[p]=matcher.group();
        			p++;
        		}
        		        	
        		if (originalAxiom.matches(".*subClassOf.*")) {
        			axiom=placeholders[0]+" rdfs:subClassOf _:restriction"+restrictionNumber+".\n_:restriction"+restrictionNumber+" rdf:type owl:Restriction.\n";
        		}
        		else if (originalAxiom.matches(".*equivalentTo.*")) {
        			axiom=placeholders[0]+" owl:equivalentClass _:restriction"+restrictionNumber+".\n_:restriction"+restrictionNumber+"	rdf:type owl:Restriction.\n";
        		}
        		        		
        		axiom=axiom+"_:restriction"+restrictionNumber+" owl:onProperty "+ placeholders[1]+ ".\n";
        		
        		if (originalAxiom.matches(".*value.*")) {
        			//axiom=axiom+"_:restriction"+restrictionNumber+" owl:hasValue "+ placeholders[2]+ ".\n";        			        		
        			axiom=axiom+"_:restriction"+restrictionNumber+" owl:hasValue "+ placeholders[2];
        		} 
        		else if (originalAxiom.matches(".*some.*")) {
        			//axiom=axiom+"_:restriction"+restrictionNumber+" owl:someValuesFrom "+ placeholders[2]+ ".\n";
        			axiom=axiom+"_:restriction"+restrictionNumber+" owl:someValuesFrom "+ placeholders[2];
        		}
        		else if (originalAxiom.matches(".*only.*")) {
        			//axiom=axiom+"_:restriction"+restrictionNumber+" owl:allValuesFrom "+ placeholders[2]+ ".\n";
        			axiom=axiom+"_:restriction"+restrictionNumber+" owl:allValuesFrom "+ placeholders[2];
        		}
        		else if (originalAxiom.matches(".*min.*")) {
        			if (placeholders[3]!=null) {//qualified in OWL2
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:minQualifiedCardinality "+ placeholders[2]+ ".\n";
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        			else {//OWL1
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:minCardinality "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:minCardinality "+ placeholders[2]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        		}
        		else if (originalAxiom.matches(".*max.*")) {
        			if (placeholders[3]!=null) {//qualified in OWL2
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:maxQualifiedCardinality "+ placeholders[2]+ ".\n";
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        			else {//OWL1
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:maxCardinality "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:maxCardinality "+ placeholders[2]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        		}
        		else if (originalAxiom.matches(".*exactly.*")) {
        			if (placeholders[3]!=null) {//qualified in OWL2
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:qualifiedCardinality "+ placeholders[2]+ ".\n";
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:onClass "+ placeholders[3]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        			else {//OWL1
        				//axiom=axiom+"_:restriction"+restrictionNumber+" owl:cardinality "+ placeholders[2]+ ".\n";
        				axiom=axiom+"_:restriction"+restrictionNumber+" owl:cardinality "+ placeholders[2]+ ".\n";
        				//23-04-12, trick this can be applied only on owl:ObjectProperty NOTE maybe change in future
        				axiom=axiom+placeholders[1]+" rdf:type owl:ObjectProperty";
        			}
        		}
        		//axiom=axiom.replaceAll("\\(", "");
        		//axiom=axiom.replaceAll("\\)", "");
        		//query.append(axiom);
        		if (patternOP1.getOptionalAxioms().contains(originalAxiom))
            		query.append("OPTIONAL { "+axiom+" }.\n");
            	else
            		query.append(axiom+".\n");
        		
        	}
        	else if (axiom.matches(".*annotation.*")) {
        		//20-04-10, for now ignore annotation for detection
        	}        	
        	else {
	        	//17-12-10, replace urls with namespaces
        		for(String s : patternOP1.getNamespaces().keySet()) {
        			axiom=axiom.replaceAll(s, patternOP1.getNamespaces().get(s)+":");
        		}        		
        		//end of prefixes
        		//start for predicates
        		if (axiom.matches(".*subClassOf.*")) {
            		//String originalAxiom = axiom;
            		//pat = Pattern.compile("\\?.");
            		pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            		
            		matcher = pat.matcher(axiom);
            		int p=0;
            		//pair SubClassOf = new SubClassOfPair();
            		String subsumed = "";
            		String subsumer = "";
            		if (matcher.find()) subsumed=matcher.group();
            		//if (this.debuggingOutput) System.out.println("sub "+subsumed);
            		if (matcher.find()) subsumer=matcher.group();
            		//if (this.debuggingOutput) System.out.println("sub "+subsumer);
            		if (!subsumer.equals("")&&!subsumed.equals(""))
            			this.subClassOfs.add(new SubClassOfPair(subsumer,subsumed));
        		}
        		//axiom=axiom.replace("types", "rdf:type");
        		axiom=axiom.replace("domain", "rdfs:domain");
	        	axiom=axiom.replace("range", "rdfs:range");
	        	axiom=axiom.replace("subClassOf", "rdfs:subClassOf");
	        	axiom=axiom.replace("equivalentTo", "owl:equivalentClass");
	        	axiom=axiom.replace("disjointWith", "owl:disjointWith");
	        	axiom=axiom.replace("propertyDisjointWith", "owl:propertyDisjointWith");
	        	axiom=axiom.replace("inverseOf", "owl:inverseOf");
	        	axiom=axiom.replace("sameAs", "owl:sameAs");
	        	//axiom=axiom.replace("ObjectProperty", "owl:ObjectProperty");
	        	
	        	//04-11-11, ad-hoc implementation for characteristics of properties 
	        	if (axiom.matches("Irreflexive.*")||axiom.matches("Functional.*")||axiom.matches("InverseFunctional.*")||axiom.matches("Symmetric.*")||
	        			axiom.matches("Asymmetric.*")||axiom.matches("Reflexive.*")||axiom.matches("Transitive.*")) {
	        		String s = axiom.substring(0,axiom.indexOf(" "));
	        		s=s.replace("Irreflexive", "owl:IrreflexiveProperty");
	        		s=s.replace("Functional", "owl:FunctionalProperty");
	        		s=s.replace("InverseFunctional", "owl:InverseFunctionalProperty");
	        		s=s.replace("Symmetric", "owl:SymmetricProperty");
	        		s=s.replace("Asymmetric", "owl:AsymmetricProperty");
	        		s=s.replace("Reflexive", "owl:ReflexiveProperty");
	        		s=s.replace("Transitive", "owl:TransitiveProperty");
	        		axiom=axiom.substring(axiom.indexOf(" ")+1);
	        		axiom+=" rdf:type ";
	        		axiom+=s;
	        		if (this.debuggingOutput) System.out.println(axiom);
	        	}
	        	//axiom=axiom.replace("not", "owl:complementOf");
	        	//end of predicates
	        	//end of line:	      
	        	//query.append(axiom+".\n");
	        	if (patternOP1.getOptionalAxioms().contains(originalAxiom))
	        		query.append("OPTIONAL { "+axiom+" }.\n");
	        	else
	        		query.append(axiom+".\n");
        	}        	
        }
        //query.append("?x rdfs:subClassOf ?y.");
        //10-11-11, pouziti FILTER casti jen v pripade, ze ve SPARQL dotazu neni OPTIONAL, protoze
        //jinak by FILTER mohl byt prilis restriktivni
        if (patternOP1.getOptionalAxioms().size()==0)
        	query.append(filter);
        query.append(queryEnd);
        //querying using Pellet (in the case of SPARQL-DL) + Jena (in the case of SPARQL)
        //16-02-10,zvlastni pokud SPARQL neni SPARQL-DL nespadne to rovnou do Jena ale nevrati se nic!
        //solution->nepouzivam pellet reasoner PelletReasonerFactory.THE_SPEC ale PelletReasonerFactory.THE_SPEC        
        if (this.debuggingOutput) System.out.println(query);
        //27-07-11 commented because this.query must be returned from queryPattern method: this.query=query.toString();
        //13-04-10, how to use Terp syntax?
        //ARQTerpParser terpParser = new ARQTerpParser();
        //terpParser.registerFactory();
        //ARQTerpParser.getFactory();
        //ARQTerpParser.registerFactory();
        
        //terpParser.parse(arg0, arg1)
        
        //ARQTerpParser.registerFactory();
        
        //20-04-10, Terp:Query q = QueryFactory.create(query.toString(), TerpSyntax.getInstance());
        //String query1 = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> SELECT * WHERE { ?OP1_C rdfs:subClassOf _:restriction2. _:restriction2 rdf:type owl:Restriction. _:restriction2 owl:onProperty ?OP1_q. _:restriction2 owl:minCardinality ?OP1_m. ?OP1_q rdf:type owl:ObjectProperty.}";
        Query q = QueryFactory.create(query.toString());
        //Query q = QueryFactory.create(query1);
        //QueryExecution qe = SparqlDLExecutionFactory.create(q,m);
        QueryExecution qe = QueryExecutionFactory.create(q,m);        
        //QueryExecution qe = QueryExecutionFactory.create(q,m);
        //if (this.debuggingOutput) System.out.println(m.toString());
        if (this.debuggingOutput) System.out.println("setting: anonymous/Thing/Nothing checking on, naming aspect off (nextOne=true)");
        //06-06-11, for query time analysis
        long currentTime=0;
        long time=0;
        
        System.out.println(q);
        
        currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right Right before the SPARQL query execution:"+currentTime);
        time=currentTime;
        /*
        ResultSet rs1 = qe.execSelect();
        System.out.println("xxxtestxxx");
        //System.out.println(q.getResultVars());
        for ( ; rs1.hasNext() ; )		    	
	    {			    				    	
	    	QuerySolution soln = rs1.nextSolution() ;			    	
	    	//for (String s : variables) {
	    		//System.out.println(s);
	    	System.out.println(soln.get("OP1_C")+","+soln.get("OP1_q")+" "+soln.get("OP1_m"));
	    		//RDFNode a = soln.get(s) ;       // Get a result variable by name.					    
			    //System.out.println(s+"="+a.toString());
	    	//}
	    }
        System.out.println("xxxtestxxx");*/        
        qe = QueryExecutionFactory.create(q,m); 
        Iterator<QuerySolution> rs = qe.execSelect();
        
        //if (this.debuggingOutput) System.out.println(rs.toString());
        
        currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right after the SPARQL query execution (delta):"+(currentTime-time));
        time=currentTime;
        
        //ResultSetFormatter.out(rs);
        //checking naming constraints
        //17-02-10,ArrayList of XML bindings
        ArrayList<String> query_results = new ArrayList<String>();
        //HashSet<String> working_query_results = new HashSet<String>();
        //deprecated:StringBuilder xmlBinding = new StringBuilder("<query_results>\n");
        HashMap<String,String> sparqlBinding = new HashMap<String,String>();
        String value="";
        RDFNode node=null;
        boolean nextOne=false;
        NamingConstraintsImpl nsc = new NamingConstraintsImpl(true,this.dictionaryPath,this.modelsPath);
        //06-06-11, how many different combinations are there?
        int combinations=0;               
        
        currentTime=System.currentTimeMillis();        
        if (this.debuggingOutput) System.out.println("Right before the SPARQL results processing (delta):"+(currentTime-time));
        time=currentTime;
        Set<String> placeholdersOP1 = patternOP1.getPlaceholders().keySet(); //06-06-11,optimalizace
        //if (this.debuggingOutput) System.out.println("placeholdersOP1 "+placeholdersOP1);
        //07-06-11 now it is reduced by COMPARISON naming aspect before
        /*
        ArrayList<String> placeholdersOP1inNDPs = new ArrayList<String>(); //06-06-11,optimalizace
        ArrayList<String> placeholdersOP1NOTinNDPs = new ArrayList<String>(); //06-06-11,optimalizace
        for (NameDetectionPattern ndp : pattern.getNameDetectionPatterns()) {
        	placeholdersOP1inNDPs.addAll(ndp.getInvolvedPlaceholders());
        }
        for (String s : pattern.getPlaceholders().keySet()) {
        	if (!placeholdersOP1inNDPs.contains(s)) placeholdersOP1NOTinNDPs.add(s);
        }*/
        //if (this.debuggingOutput) System.out.println(placeholdersOP1inNDPs);
        //if (this.debuggingOutput) System.out.println(placeholdersOP1NOTinNDPs);
        for ( ; rs.hasNext() ; )	{
          //if (this.debuggingOutput) System.out.println(rs.getRowNumber()+" row...");
          combinations++;
          nextOne=false;
          //sparqlBinding = new HashMap<String,String>();
          sparqlBinding.clear();          
          //QuerySolution solution = rs.nextSolution() ;
          QuerySolution solution = rs.next() ;
	      //for (String p : placeholdersOP1inNDPs) {
          for (String p : placeholdersOP1) {
	    	  //if (this.debuggingOutput) System.out.println("p:"+p);
	    	  //node=(RDFNode)(solution.get(p));
	    	  node=solution.get(p);
	    	  if (node==null) {
	    		  continue;
	    	  }
	    	  if (node.isAnon()) {
	    		  nextOne=true;
	    		  //if (this.debuggingOutput) System.out.println("break anonymous"+node.toString());
	    		  break;	    		  
	    	  }
	    	  else {
	    		  value=node.toString();
	    		  if (this.ontologyNamespace.equals("")) this.ontologyNamespace=value.substring(0,value.indexOf("#")+1);
	    		  if (value.matches(".*XMLSchema.*"))
	    			  if (value.indexOf("^")!=-1)
	    				  value=value.substring(0,value.indexOf("^"));
	    			  else
		    			  value=value.substring(value.indexOf("#")+1);
	    		  else
	    			  //23-04-12 - attempt to cover more cases - sometime there is missing "#" and there is just "/" to depict local fragment of URI	    			  	    		  
	    			  if (value.indexOf("#")!=-1)
	    				  value=value.substring(value.indexOf("#")+1);
	    			  else 
	    				  value=value.substring(value.lastIndexOf("/")+1);	    		  
	    		  if (value.equals("Thing")||value.equals("Nothing")) {
	    			  nextOne=true;
	    			  //if (this.debuggingOutput) System.out.println("break Thing");
	    			  break;
	    		  }
	    		  //if (this.debuggingOutput) System.out.println("OK p:"+p+" value:"+value);	    		  
	    		  //System.out.println("OK p:"+p+" value:"+value);
	    	  }
	    	
	    	  //if (this.debuggingOutput) System.out.print(p+"="+value);
	    	  sparqlBinding.put(p, value);	    	  
	      }
	      //TODO: add if namingConstraints are OK then print it into XML as binding
	      //if (this.debuggingOutput) System.out.println(pattern.getNameDetectionPatterns());
	      //nextOne=true;//06-06-11, artificially naming aspect on/off nextOne=true-off;
    	  if (!nextOne) {
    		  //if (this.debuggingOutput) System.out.println("to check:"+sparqlBinding);
    		  if (nsc.checkNamingConstraints(sparqlBinding, patternOP1.getNameDetectionPatterns(), true)) {
    		  //deprecated:xmlBinding.append(outputXML(sparqlBinding));
    			  //if (this.debuggingOutput) System.out.println(sparqlBinding);    	
    			  //if (this.debuggingOutput) System.out.println("right:"+sparqlBinding);
    			  
    			  if (xmlSerialization) {
    				  String xml = outputXML(sparqlBinding);
    			      if (!query_results.contains(xml))
    			    	  query_results.add(xml);
    			  }
    			  else {
    				  //01-04-11, plain output instead of XML output
    				  String plain = outputPlain(sparqlBinding);    				  
    			      if (!query_results.contains(plain))
    			    	  query_results.add(plain);
    			  }
    		  }
    	  }
    	  //if (this.debuggingOutput) System.out.println("----------");
	      //if (this.debuggingOutput) System.out.println(sparqlBinding);
	    }    
        
        currentTime=System.currentTimeMillis();
        if (this.debuggingOutput) System.out.println("Right after the SPARQL results processing (delta):"+(currentTime-time));
        time=currentTime;
        
        //deprecated:xmlBinding.append("</query_results>\n");
		//deprecated:return xmlBinding.toString();
        if (this.debuggingOutput) System.out.println(combinations+" different combinations");
        
        //21-11-11, in order to close open files - there was a problem of "too many open files"
        nsc.finish();
        m.close();
        return query_results;
	}
	
	/**
	 * Method enabling replication of axiom according to two sets of old placeholders and new placeholders. 
	 * @param newAxiom	axiom on which replication should be applied
	 * @param mappingOldNewPlaceholders	mapping between old and new placeholders	
	 * @return replicated axiom
	 */
	public String replicateAxiom(String newAxiom, HashMap<String,String[]>mappingOldNewPlaceholders) {
		ArrayList<String[]> collectionNewPlaceholders = (ArrayList<String[]>)mappingOldNewPlaceholders.values();
		//30-09-11, we assume maximally two different set of new placeholders because e.g. a=b and a=B 
		//e.g. newAxiom: ?b_6_5_4 types ?B_9_8_7
		//e.g. or newAxiom ?W equivalentTo (?q some ?B_9_8_7 )
		//new placeholders: [?b_4, ?b_5, ?b_6] and [?B_7, ?B_8, ?B_9]
		String cAxiom=newAxiom;
		if (mappingOldNewPlaceholders.size()==2) {
			for(int i=(collectionNewPlaceholders.get(0).length-1);i>=0;i--) {
				for(int j=(collectionNewPlaceholders.get(1).length-1);j>=0;j--) {
					cAxiom=cAxiom.replaceAll("\\?"+collectionNewPlaceholders.get(0)[i], "");
				}
			}
		}
		else {
			for(int i=(collectionNewPlaceholders.get(0).length-1);i>=0;i--) {
				
			}
		}
		return "";
	}
	//newAxiom = this.replicateAxiom(newAxiom, mappingOldNewPlaceholders);
	
	//29-09-11, for getting number of placeholders entities in expansion construct,e.g. "oneOf", "unionOf"
	//now it is only for one appearance of expansion contruct at once
	//10-11-11, special condition added that there must be more than one entity in argument of oneOf or so
	public ArrayList<String> getEntitiesFromExpansionConstruct(String ontologyURI, String axiom, String expansionConstruct) {
	//public int getNumberOfEntitiesFromExpansionConstruct(String ontologyURI, String axiom, String expansionConstruct) {
		//init ontology and take entities
		//09-05-12
		//System.out.println("exp "+axiom);
		ArrayList<String> placeholders = new ArrayList<String>();
		int numberOfEntities=0;
		OWLOntology ontology = null;	
		OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
		OWLDataFactory factory = manager.getOWLDataFactory();
		try {
			//ontology:
			//this.ontology = manager.loadOntologyFromPhysicalURI(URI.create(url));			
			//09-03-10,ontology can be directly file as String or referring URL
			if ((ontologyURI.matches("^http.*"))||(ontologyURI.matches("^file.*"))) {
				ontology = manager.loadOntologyFromOntologyDocument(IRI.create(ontologyURI));
				//this.url=url;
			}
			else {
				//InputStream in = new ByteArrayInputStream(url.getBytes()); for owl-api 3.0.0
				//setOntology(this.manager.loadOntologyFromOntologyDocument(new StringInputSource(url))); for owl-api 2
				InputStream in = new ByteArrayInputStream(ontologyURI.getBytes()); //for owl-api 3.0.0
				ontology=manager.loadOntologyFromOntologyDocument(in);
			}							
			//if (this.debuggingOutput) System.out.println("base="+this.base);
			this.ontologyNamespace = getBaseURI(manager, ontology, ":");
			for(OWLClass cls : ontology.getClassesInSignature()) {
				if (axiom.matches(".*equivalentTo.*")) {
					for (OWLClassExpression exp : cls.getEquivalentClasses(ontology)) {
						if (expansionConstruct.equals("oneOf")) {
							if (exp instanceof OWLObjectOneOf) {								
								numberOfEntities=((OWLObjectOneOf) exp).getIndividuals().size();
								//10-11-11, special condition added that there must be more than one entity in argument of oneOf or so
								if (numberOfEntities==1) continue;
								placeholders=generateEntitiesPlaceholders(numberOfEntities);
								return placeholders; //29-09-11, just return first occurrence
								//return numberOfEntities;
							}							
							//29-09-11, NOTE: currently OWLDataOneOf of values is not supported							
						}
						else { //(expansionConstruct.equals("unionOf"))
							if (exp instanceof OWLObjectUnionOf) {
								numberOfEntities=0;
								Set<OWLClassExpression> allOperands = ((OWLObjectUnionOf) exp).getOperands();
								for (OWLClassExpression operand : allOperands) {
									if (operand instanceof OWLClass)
										numberOfEntities++;									
								}
								//29-09-11, currently this is restricted to named entities only
								if (numberOfEntities==allOperands.size()) {
									placeholders=generateEntitiesPlaceholders(numberOfEntities);
									return placeholders;
									//return numberOfEntities;
								}
								//else throw new ExpansionConstructException("Expansion construct is limited to named entities for unionOf construct.");
							}
						}
					}
				}				
				else { //(axiom.matches(".*subClassOf.*"))	
					//09-05-12
					//System.out.println("exp subClassOf");
					for (OWLClassExpression exp : cls.getSuperClasses(ontology)) {
						//09-05-12
						//System.out.println("exp "+exp);
						if (expansionConstruct.equals("oneOf")) {
							if (exp instanceof OWLObjectOneOf) {								
								numberOfEntities=((OWLObjectOneOf) exp).getIndividuals().size();
								//10-11-11, special condition added that there must be more than one entity in argument of oneOf or so
								if (numberOfEntities==1) continue;
								placeholders=generateEntitiesPlaceholders(numberOfEntities);
								return placeholders; //29-09-11, just return first occurrence
								//return numberOfEntities;
							}							
							//29-09-11, NOTE: currently OWLDataOneOf of values is not supported							
						}
						else { //(expansionConstruct.equals("unionOf"))
							if (exp instanceof OWLObjectUnionOf) {
								numberOfEntities=0;
								Set<OWLClassExpression> allOperands = ((OWLObjectUnionOf) exp).getOperands();
								for (OWLClassExpression operand : allOperands) {
									if (operand instanceof OWLClass)
										numberOfEntities++;									
								}
								//29-09-11, currently this is restricted to named entities only
								if (numberOfEntities==allOperands.size()) {
									placeholders=generateEntitiesPlaceholders(numberOfEntities);
									return placeholders;
									//return numberOfEntities;
								}
								//else throw new ExpansionConstructException("Expansion construct is limited to named entities for unionOf construct.");
							}
						}
					}
				}
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return placeholders;
		//return numberOfEntities;
	}
	//29-09-11, for generating placeholders like ?_1, ?_2, etc. which are reserved for this and they should be iterated over the detection of the whole ontology thanks to this.numberGeneratedPlaceholders
	private ArrayList<String> generateEntitiesPlaceholders(int number) {		
		ArrayList<String> placeholders = new ArrayList<String>();
		for(int i=this.numberGeneratedPlaceholders;i<(this.numberGeneratedPlaceholders+number);i++) {
			placeholders.add("?_"+i);			
		}
		this.numberGeneratedPlaceholders=this.numberGeneratedPlaceholders+number;
		//if (this.debuggingOutput) System.out.println(this.numberGeneratedPlaceholders);
		return placeholders;
	}
	
	//29-09-11, for generating placeholders like ?input_1, ?_2, etc.
	private ArrayList<String> generateEntitiesPlaceholders(int number, String oldPlaceholder) {		
		if (this.debuggingOutput) System.out.println(number + " " + oldPlaceholder);
		ArrayList<String> placeholders = new ArrayList<String>();
		for(int i=this.numberGeneratedPlaceholders;i<(this.numberGeneratedPlaceholders+number);i++) {
			placeholders.add("?_"+oldPlaceholder.replaceAll("\\?", "")+i);			
		}
		this.numberGeneratedPlaceholders=this.numberGeneratedPlaceholders+number;
		//if (this.debuggingOutput) System.out.println(this.numberGeneratedPlaceholders);
		return placeholders;
	}
	
	//10-06-11, 
	//combine it for the filter the case for two COMPARISONs a one COMPARISON
	private ArrayList<String> combineTwoComparisons(ArrayList<String> comparison1, ArrayList<String> comparison2) {					
		ArrayList<String> combinedPairWise = new ArrayList<String>();
			//comparison1.add("?B");
			/*for testing
			comparison1.clear();
			comparison1.add("a1");
			comparison1.add("a2");
			comparison1.add("a3");
			*/        		
			/*for testing
			comparison2.clear();        		 
			comparison2.add("b1");
			comparison2.add("b2");
			*/
			for(int i=0; i<comparison1.size();i++) {
				for (int j=0; j<comparison2.size();j++) {
					//if (this.debuggingOutput) System.out.println("("+comparison1.get(i)+" && "+comparison2.get(j)+")");
					combinedPairWise.add("("+comparison1.get(i)+" && "+comparison2.get(j)+")");
				}
			}
			return combinedPairWise;
	}
	/**
	 * Returns XML serialization of detected pattern instance.
	 * @param sparqlBinding	binding of placeholders to entities according to pattern instance 
	 * @return XML serialization of detected pattern instance.
	 */
	private String outputXML(HashMap<String,String> sparqlBinding) {
		StringBuilder output = new StringBuilder();
		output.append("<pattern_instance ontology=\""+this.ontologyURI+"\" tp=\""+this.patternURI+"\">\n");
		for (String s : sparqlBinding.keySet()) {
			output.append("<binding placeholder=\""+s+"\">"+sparqlBinding.get(s)+"</binding>\n");
		}
		output.append("</pattern_instance>\n");
		return output.toString();
	}
	
	//01-04-11, xml output for just one solution
	/**
	 * Converts detected pattern instance in plain text serialization into XML serialization.
	 */
	public static String outputOnePairXML(String ontology, String tp, String plain) {
		StringBuilder output = new StringBuilder();
		output.append("<pattern_instance ontology=\""+ontology+"\" tp=\""+tp+"\">\n");
		String s;
		StringTokenizer st1 = new StringTokenizer(plain,";");
		StringTokenizer st2;
		while (st1.hasMoreTokens()) {
			s="";
			s=st1.nextToken();
			st2 = new StringTokenizer(s,"=");
			output.append("<binding placeholder=\""+st2.nextToken()+"\">"+st2.nextToken()+"</binding>\n");					
		}
		output.append("</pattern_instance>\n");
		return output.toString();
	}
	
	//01-04-11, for plain output for xd transformation plugin for the case of multiple selection on a list
	/**
	 * Returns detected pattern instances in text plain serialization.
	 * @param sparqlBinding	binding placeholders to entities in the pattern instance
	 */
	private String outputPlain(HashMap<String,String> sparqlBinding) {
		StringBuilder output = new StringBuilder();
		int i=0;
		for (String s : sparqlBinding.keySet()) {
			//08-11-11, change of delimiter
			//output.append(s+"="+sparqlBinding.get(s)+" ");
			if (i==0) 
				output.append(s+"="+sparqlBinding.get(s));
			else
				output.append(";"+s+"="+sparqlBinding.get(s));
			i++;
		}		
		return output.toString();
	}
	
	//21-04-11, recursive query with input one pattern instance based on queryPattern
	//predtim probehl queryPattern takze this.query je uz sestaven
	/**
	 * This method performs recursive query along the taxonomy using given pattern_instance as a seed. It returns list of pattern instances.
	 * @param pattern_instance	pattern instance on which recursive detection along taxonomy should be applied
	 * @param tp	transformation pattern to be applied
	 * @param ontologyURI	link to ontology on which this recursive detection should be applied
	 * @param xmlSerialization true/false should these results be serialized in XML (true) or in plain text (false)
	 */
	public ArrayList<String> recursiveQuery(String pattern_instance, TransformationPattern tp, String ontologyURI, boolean xmlSerialization) {
		//if (this.debuggingOutput) System.out.println(this.subClassOfs);
		//if (this.debuggingOutput) System.out.println(this.ontologyNamespace);
		//System.exit(1);
		//22-04-11
		String prequery=this.query;
		//17-10-11, trying to make only simple query alng the taxonomy because we can assume that other conditions already hold
		String prequerySimple="PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT * \nWHERE {\n";
		ArrayList<String> skipPlaceholders=new ArrayList<String>(); //these placeholders are not already in SPARQL query
		for(SubClassOfPair p : this.subClassOfs) {
			String newSubsumerPlaceholder = p.subsumedPlaceholder; //this placeholder will be newly subsumer
			String replacerPlaceholder = p.subsumerPlaceholder; //this placeholder will instantiated with instance of new subsumer
			String s;
			String replacer="";
			StringTokenizer st1 = new StringTokenizer(pattern_instance, ";");
			StringTokenizer st2;
			while (st1.hasMoreTokens()) {
				s="";
				s=st1.nextToken();
				st2 = new StringTokenizer(s,"=");
				//this.query=this.query.replaceAll("subClassOf \\"+st2.nextToken(), "subClassOf <http://confOf#"+st2.nextToken()+">");
				if (st2.nextToken().equals(newSubsumerPlaceholder)) replacer="<"+this.ontologyNamespace+st2.nextToken()+">";
			}
			//if (this.debuggingOutput) System.out.println(newSubsumerPlaceholder+","+replacer+","+replacerPlaceholder);
			prequery=prequery.replaceAll("\\"+replacerPlaceholder, replacer);
			//if (!prequerySimple.matches(".*"+replacer+".*")) {
			prequerySimple+=newSubsumerPlaceholder+" rdfs:subClassOf "+replacer+".\n";			
			skipPlaceholders.add(replacerPlaceholder);
			//}
		}
		prequerySimple+="}\n";
		if (this.debuggingOutput) System.out.println(prequery);
		if (this.debuggingOutput) System.out.println(prequerySimple);
		//finally, hard-coded sparql query:
/*
		StringBuilder query = new StringBuilder();
		String queryBegin = 
            "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n" + 
            "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n" + 
            "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
		//for(String s : pattern.getNamespaces().keySet()) {
		//	queryBegin+="PREFIX "+pattern.getNamespaces().get(s)+": <"+s+">\n";			
		//how to get namespace of current ontology?}
		queryBegin+="\n" + 
            "SELECT * \n" + 
            "WHERE {\n";
        String queryEnd = "}";
        query.append(queryBegin);
        query.append("?B rdf:type owl:Class.\n");
        query.append("?B rdfs:subClassOf ");
		String s;
		StringTokenizer st1 = new StringTokenizer(pattern_instance);
		StringTokenizer st2;
		while (st1.hasMoreTokens()) {
			s="";
			s=st1.nextToken();
			st2 = new StringTokenizer(s,"=");
			//this.query=this.query.replaceAll("subClassOf \\"+st2.nextToken(), "subClassOf <http://confOf#"+st2.nextToken()+">");
			if (st2.nextToken().equals("?B")) query.append("<http://confOf#"+st2.nextToken()+">.\n");
		}				
		query.append(queryEnd);
		if (this.debuggingOutput) System.out.println(query);
		//System.exit(1);
	*/	
		OntologyPattern pattern=tp.getOP1();
		
		OntModel m = ModelFactory.createOntologyModel(PelletReasonerFactory.THE_SPEC); //for SPARQL-DL
		if ((ontologyURI.matches("^http.*"))||(ontologyURI.matches("^file.*")))
			m.read(ontologyURI);
		else {
			InputStream in = new ByteArrayInputStream(ontologyURI.getBytes());			
			m.read(in,"");
			try {
				in.close();
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
		
		//17-10-11, simple variant only targeting to taxonomyand one subClassOf
		//Query q = QueryFactory.create(prequery);
		Query q = QueryFactory.create(prequerySimple);
		
        //QueryExecution qe = SparqlDLExecutionFactory.create(q,m);
        QueryExecution qe = QueryExecutionFactory.create(q,m);        
        //QueryExecution qe = QueryExecutionFactory.create(q,m);
        ResultSet rs = qe.execSelect();
        //ResultSetFormatter.out(rs);
        //checking naming constraints
        //17-02-10,ArrayList of XML bindings
        ArrayList<String> query_results = new ArrayList<String>();
        //deprecated:StringBuilder xmlBinding = new StringBuilder("<query_results>\n");
        HashMap<String,String> sparqlBinding = new HashMap<String,String>();
        String value="";
        RDFNode node=null;
        boolean nextOne=false;
        //NamingConstraints nsc = new NamingConstraintsImpl(true,this.dictionaryPath,this.modelsPath);
        //if (rs == null) if (this.debuggingOutput) System.out.println("NULL NULL NULL");        
        for ( ; rs.hasNext() ; )	{
          nextOne=false;
          sparqlBinding = new HashMap<String,String>();
	      QuerySolution solution = rs.nextSolution() ;	      
	      for (String p : rs.getResultVars()) {
	    	  p="?"+p;
	    	  //if (this.debuggingOutput) System.out.println("-p-"+ p);
	      //for (String p : pattern.getPlaceholders().keySet()) {
	    	  //nextOne=false;
	    	  //if (this.debuggingOutput) System.out.println("p:"+p+solution.get(p));
	    	  if (skipPlaceholders.contains(p)) continue;
	    	  node=(RDFNode)(solution.get(p));
	    	  if (node.isAnon()) {
	    		  nextOne=true;
	    		  //if (this.debuggingOutput) System.out.println("break anonymous"+node.toString());
	    		  break;	    		  
	    	  }
	    	  else {
	    		  value=node.toString();
	    		  value=value.substring(value.indexOf("#")+1);
	    		  if (value.equals("Thing")||value.equals("Nothing")) {
	    			  nextOne=true;
	    			  //if (this.debuggingOutput) System.out.println("break Thing");
	    			  break;
	    		  }
	    		  //if (this.debuggingOutput) System.out.println("OK p:"+p+" value:"+value);
	    	  }
	    	  //if (this.debuggingOutput) System.out.print(p+"="+value);
	    	  sparqlBinding.put(p, value);	  
	      }
	      //TODO: add if namingConstraints are OK then print it into XML as binding
	      if (this.debuggingOutput) System.out.println("----------"+ nextOne);
	      if (this.debuggingOutput) System.out.println(sparqlBinding);
	      
	      //if (this.debuggingOutput) System.out.println(pattern.getNameDetectionPatterns());
    	  if (!nextOne) {
    		  //if (nsc.checkNamingConstraints(sparqlBinding, pattern.getNameDetectionPatterns())) {
    		  //deprecated:xmlBinding.append(outputXML(sparqlBinding));
    			  //if (this.debuggingOutput) System.out.println(sparqlBinding);
    	          //22-04-11, put back original instances of placeholders         
    	          for(SubClassOfPair p : this.subClassOfs) {
    				String oldSubsumerPlaceholder = p.subsumerPlaceholder;
    				String s;
    				String originalSuperClass="";
    				StringTokenizer st1 = new StringTokenizer(pattern_instance,";");
    				StringTokenizer st2;
    				while (st1.hasMoreTokens()) {
    					s="";
    					s=st1.nextToken();
    					st2 = new StringTokenizer(s,"=");
    					//this.query=this.query.replaceAll("subClassOf \\"+st2.nextToken(), "subClassOf <http://confOf#"+st2.nextToken()+">");
    					if (st2.nextToken().equals(oldSubsumerPlaceholder)) originalSuperClass=st2.nextToken();
    				}
    				//if (this.debuggingOutput) System.out.println(newSubsumerPlaceholder+","+replacer+","+replacerPlaceholder);
    				sparqlBinding.put(oldSubsumerPlaceholder, originalSuperClass);
    			  }    		 
    			  if (xmlSerialization)
    				  query_results.add(outputXML(sparqlBinding));
    			  else {
    				  //01-04-11, plain output instead of XML output
    				  query_results.add(outputPlain(sparqlBinding));
    			  }
    		  //}    	
    	  }
	    }        
        //deprecated:xmlBinding.append("</query_results>\n");
		//deprecated:return xmlBinding.toString();
        //22-04-11, add also the input pattern_instance
        String s;
		String replacer="";
		StringTokenizer st1 = new StringTokenizer(pattern_instance,";");
		StringTokenizer st2;
		sparqlBinding = new HashMap<String,String>();
		while (st1.hasMoreTokens()) {
			s="";
			s=st1.nextToken();
			st2 = new StringTokenizer(s,"=");
			sparqlBinding.put(st2.nextToken(), st2.nextToken());
		}
        if (xmlSerialization)
		  query_results.add(outputXML(sparqlBinding));
        else {
		  //01-04-11, plain output instead of XML output
		  query_results.add(outputPlain(sparqlBinding));
        }        
        
        m.close();
        
        return query_results;
	}	
	
	/**
	 * Testing method.
	 * @param args
	 */
	public static void main(String[] args) {		
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp_hasSome2.xml");
		//if (this.debuggingOutput) System.out.println(tp1);
		//if (this.debuggingOutput) System.out.println(detection.queryPattern(tp1.getOP1(), "file:///home/ondrej/doktorandsky/PatOMat/TPs/ontology/cmt.owl"));		
		
		//13-04-10, testing with new Terp syntax for SPARQL from Pellet 2.1.0
		//if (this.debuggingOutput) System.out.println(detection.queryPattern(new TransformationPatternImpl("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp_ce-basic.xml").getOP1(), "file:///home/ondrej/doktorandsky/PatOMat/TPs/ontology/cmt.owl"));
		//if (this.debuggingOutput) System.out.println(detection.queryPattern(new TransformationPatternImpl("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp_ce-hasValue.xml").getOP1(), "file:///home/ondrej/doktorandsky/PatOMat/TPs/ontology/testAVR1d.owl"));
		//if (this.debuggingOutput) System.out.println(detection.queryPattern(new TransformationPatternImpl("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp_hasSome2.xml").getOP1(), "file:///home/ondrej/doktorandsky/PatOMat/TPs/ontology/cmt.owl"));
		//if (this.debuggingOutput) System.out.println(detection.queryPattern(new TransformationPatternImpl("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp_l-specified-values.xml"), "file:///home/ondrej/doktorandsky/PatOMat/TPs/ontology/nary1.owl", true));		
		//if (this.debuggingOutput) System.out.println(detection.outputOnePairXML("?B=Camera_Ready_event ?A=Event "));
		if (detection.debuggingOutput) System.out.println(OntologyPatternDetectionImpl.outputOnePairXML("","","?B=Camera_Ready_event ?A=Event "));
	}
}
