package cz.vse.keg.patomat.detection;

import java.util.ArrayList;
import java.util.HashMap;

import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;

/**
 * OntologyPatternDetection interface represents structural and naming methods for ontology pattern detection 
 * @author Ondrej Zamazal
 * 
 */

public interface OntologyPatternDetection {

	//get the bindings for the last query/pattern
	@Deprecated
	public ArrayList<HashMap<String,String>> getPlaceholdersBinding();	
	
	//generic SPARQL queries
	//it takes URI of pattern as SPARQL query and URI of an ontology
	//it returns binding in XML format
	public ArrayList<String> queryPattern(String patternURI, String ontologyURI, boolean xmlSerialization, boolean reasoner);
	
	//it takes OntologyPattern for generating SPARQL query and URI of an ontology
	//it returns binding in XML format
	public ArrayList<String> queryPattern(TransformationPattern pattern, String ontologyURI, boolean xmlSerialization, boolean reasoner);
	
	//21-04-11, recursive querying with one pattern instance
	public ArrayList<String> recursiveQuery(String pattern_instance, TransformationPattern tp, String ontologyURI, boolean xmlSerialization);
	//public static String outputOnePairXML(String string);	
	//further specific SPARQL queries? - n-ary relations, specified values
}

/*implement:
 * 3 variants:
 * OntologyPatternDetectionGenericSPARQL
 * OntologyPatternDetectionGeneratedSPARQL (according to OP1)
 * OntologyPatternDetectionMatchingScenario
 */