package cz.vse.keg.patomat.detection;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;

/**
 * OntologyEntityDetection enables discovery of given entity in given ontology. 
 * @author Ondrej Zamazal
 * 
 */

public class OntologyEntityDetection {
	protected OntModel ontologyModel;
	protected String ontologyNamespace="";
	//TODO 03-05-11, class for ontology entity detection
		
	public OntologyEntityDetection(String ontologyURI, String ontologyNamespace) {
		this.ontologyNamespace=ontologyNamespace;
		this.ontologyModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
		if ((ontologyURI.matches("^http.*"))||(ontologyURI.matches("^file.*")))
			this.ontologyModel.read(ontologyURI);
		else {
			InputStream in = new ByteArrayInputStream(ontologyURI.getBytes());			
			this.ontologyModel.read(in,"");
		}
	}
	
	/**
	 * Returns an usage of given entity as a set of axioms in which given entity is employed. 
	 * @author Ondrej Zamazal
	 * @param entity	entity name 
	 * @return a set of axioms in which given entity is employed
	 */	
	public String getEntityUsage(String entity) {
		String result="";
		String query = "SELECT * WHERE { ";
		//query1 first variant there should two more variants
		String query1=query+"?a ?b <"+this.ontologyNamespace+entity+">.}";
		String query2=query+"?a <"+this.ontologyNamespace+entity+"> ?c.}";
		String query3=query+"<"+this.ontologyNamespace+entity+"> ?b ?c.}";
		Query q = QueryFactory.create(query1.toString());
        QueryExecution qe = QueryExecutionFactory.create(q,this.ontologyModel);        
        try {
			ResultSet results = qe.execSelect() ;
		    for ( ; results.hasNext() ; ) {
		    	QuerySolution soln = results.nextSolution() ;					    	
		    	RDFNode a = soln.get("?a") ;       // Get a result variable by name.
		    	RDFNode b = soln.get("?b") ;       // Get a result variable by name.
		    	if (a.isAnon() || b.isAnon()) continue;
			    //logResults.println(getLocalname(clusterEntities.get(i))+" "+getLocalname(x.toString())+" "+getLocalname(clusterEntities.get(j)));
		    	result+=getLocalname(a.toString())+" "+getLocalname(b.toString())+" "+entity+".\n";		    	
		    }
		    qe.close();
		}
		finally { qe.close() ; }
		//query2 second variant
		q = QueryFactory.create(query2.toString());
        qe = QueryExecutionFactory.create(q,this.ontologyModel);        
        try {
			ResultSet results = qe.execSelect() ;
		    for ( ; results.hasNext() ; ) {
		    	QuerySolution soln = results.nextSolution() ;					    	
		    	RDFNode a = soln.get("?a") ;       // Get a result variable by name.
		    	RDFNode c = soln.get("?c") ;       // Get a result variable by name.
		    	if (a.isAnon() || c.isAnon()) continue;
			    //logResults.println(getLocalname(clusterEntities.get(i))+" "+getLocalname(x.toString())+" "+getLocalname(clusterEntities.get(j)));
		    	result+=getLocalname(a.toString())+" "+entity+" "+getLocalname(c.toString())+".\n";		    	
		    }
		    qe.close();
		}
		finally { qe.close() ; }
		//query3 third variant
		q = QueryFactory.create(query3.toString());
        qe = QueryExecutionFactory.create(q,this.ontologyModel);        
        try {
			ResultSet results = qe.execSelect() ;
		    for ( ; results.hasNext() ; ) {
		    	QuerySolution soln = results.nextSolution() ;					    	
		    	RDFNode b = soln.get("?b") ;       // Get a result variable by name.
		    	RDFNode c = soln.get("?c") ;       // Get a result variable by name.
		    	if (b.isAnon() || c.isAnon()) continue;
			    //logResults.println(getLocalname(clusterEntities.get(i))+" "+getLocalname(x.toString())+" "+getLocalname(clusterEntities.get(j)));
		    	result+=entity+" "+getLocalname(b.toString())+" "+getLocalname(c.toString())+".\n";
		    }
		    qe.close();
		}
		finally { qe.close() ; }
		
        return result;
	}
	
	//method for getting localname for better printing
	/**
	 * Returns local fragment of URI.
	 * @param uri	full URI
	 */
	public String getLocalname(String uri) {
		String name="";
		if (uri.indexOf("#")!=-1) {				
			name=uri.substring(uri.indexOf("#")+1);
			name=name.trim();
			//System.out.println(name);
		}
		return name;
	}
	
	/**
	 * Testing method. 
	 */
	public static void main(String[] args) {
		OntologyEntityDetection entityDetection = new OntologyEntityDetection("file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-recursive-changed.owl","http://confOf#");
		System.out.println(entityDetection.getEntityUsage("Person"));
	}
}
