package cz.vse.keg.patomat;

import java.util.ArrayList;

import cz.vse.keg.patomat.detection.OntologyPatternDetection;
import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

import org.semanticweb.owlapi.model.OWLOntology;

/** 
 * TestLibrary class demonstrates pipeline of transformation where a tranformation pattern is applied on an ontology using recursive query along the taxonomy. This assumes installation of WordNet-3.0 at: 
 * /usr/share/WordNet-3.0" and Stanford POS-tagger at "/usr/share/models". This code is provided within java library release.
 * @author Ondrej Zamazal
 */

public class TestLibrary3 {
		
	public static void main(String[] args) {					
		boolean POStagger=false;//because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetection detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="http://nb.vse.cz/~svabo/patomat/ontology/confOf-recursive-imported.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		TransformationPattern tp1 = new TransformationPatternImpl("http://nb.vse.cz/~svabo/patomat/tp/tp_agentRoleV4a2.xml");
		System.out.println(tp1);
				
		ArrayList<String> binding=detection.queryPattern(tp1, ontology, false, false);
		System.out.println("Detected pattern instances:");
		for(String s : binding) {
			System.out.println("   "+s);
		}

		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		//selection of one pattern instance: ?B=Author;?A=Person and apply recursive detection along the taxonomy:		
		ArrayList<String> list = detection.recursiveQuery("?B=Author;?A=Person", tp1, ontology, false); 
		System.out.println("Recursive result:"+list);
		for(String s : list) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, "http://nb.vse.cz/~svabo/patomat/tp/tp_agentRoleV4a2.xml", s));
		}
		//29-06-12, nove kvuli dosazeni aktualnich bindings z instance InstructionGeneratorImpl
		System.out.println(ig.exportInstructions());
		for (String s : ig.getOldBindings().keySet()) {
			System.out.println("xxx "+s+":"+ig.getOldBindings().get(s));							
		}
		for (String s : ig.getBindings().keySet()) {
			System.out.println("xxx "+s+":"+ig.getBindings().get(s));							
		}
		transformation.setInstructions(ig.exportInstructions());
		//3.		
		//transformation.transformOntology(TransformationStrategy.Conservative,false);
		transformation.transformOntology(TransformationStrategy.RadicalKeep,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
}
