package cz.vse.keg.patomat;

import java.io.ByteArrayInputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/** 
 * TestLibrary class demonstrates pipeline of transformation where a tranformation pattern is applied on an ontology using all detected pattern instance. This assumes installation of WordNet-3.0 at: 
 * /usr/share/WordNet-3.0" and Stanford POS-tagger at "/usr/share/models". This code is provided within java library release.
 * @author Ondrej Zamazal
 */


public class TestLibrary2forORE {
	
	public static void printRenameInstructions(String instructions, String bindings) {
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		    dbf.setNamespaceAware(true); 
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(new ByteArrayInputStream(instructions.getBytes()));
			XPath xpath = XPathFactory.newInstance().newXPath();
			//String expression = "/instructions/rename/entity";		
		    String expression = "/instructions/entities/rename";
		    NodeList nodesOP;
			nodesOP = (NodeList) xpath.evaluate(expression, doc, XPathConstants.NODESET);			
			for(int i=0;i<nodesOP.getLength();i++) {				
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
				String original_name=((Element)nodesOP.item(i)).getAttribute("original_name");
				String new_name=((Element)nodesOP.item(i)).getTextContent();
				if (!original_name.equals(new_name)) {
					System.out.println(original_name+" to "+new_name);
					System.out.println(bindings);	
					//po vybrani teto instrukce se vygeneruje instrukce nove (ig.generateInstructions), zahrnuta mezi ostatni pripravene a pak se mohou aplikovat (transformation.setInstructions(ig.exportInstructions()))
				}
			}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {					
		//String tp1IRI="http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1a.xml";
		String tp1IRI="http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1b.xml";
		//String tp1IRI="http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1c.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="http://nb.vse.cz/~svabo/oaei2011/data/confOf.owl";
		
		OWLOntology ontologyOWL;
		OWLOntologyManager manager;		
		manager = OWLManager.createOWLOntologyManager();
		try {
			ontologyOWL = manager.loadOntologyFromOntologyDocument(IRI.create("http://nb.vse.cz/~svabo/oaei2011/data/confOf.owl"));
			
			ontologyOWL.getOWLOntologyManager();
			
			OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontologyOWL);
					
			boolean POStagger=true;		
			InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
			//detection and transformation instructions generation:
			for(String s : detection.queryPattern(tp1, ontology, false, true)) {
				System.out.println(s);
				//01-06-12, always clean instructions => generated instructions will deal with only last pattern instance
				ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath()); 
				ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
				System.out.println(ig.exportInstructions());
				//System.out.println("shorten instructions:");
				//printRenameInstructions(ig.exportInstructions(),s);
				System.out.println("===");
				//System.out.println(ig.exportInstructions());
				
			}		 
			System.exit(1);
			System.out.println(ig.exportInstructions());
			transformation.setInstructions(ig.exportInstructions());
			//System.exit(1);
			//transformation itself:
			transformation.transformOntology(TransformationStrategy.Progressive, true);
			transformation.saveOntology("");
			System.out.println(transformation.printOntology());
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
}
