package cz.vse.keg.patomat;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

import org.semanticweb.owlapi.model.OWLOntology;

/** 
 * TestLibrary class demonstrates pipeline of transformation where a tranformation pattern is applied on an ontology using all detected pattern instance. This assumes installation of WordNet-3.0 at: 
 * /usr/share/WordNet-3.0" and Stanford POS-tagger at "/usr/share/models". This code is provided within java library release.
 * @author Ondrej Zamazal
 */


public class TestLibrary2 {
	
	public static void main(String[] args) {					
		//String tp1IRI="http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1a.xml";
		//String tp1IRI="http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1b.xml";
		String tp1IRI="http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1c.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="http://nb.vse.cz/~svabo/oaei2011/data/confOf.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
				
		boolean POStagger=true;		
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		//detection and transformation instructions generation:
		for(String s : detection.queryPattern(tp1, ontology, false, true)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		 
		//System.exit(1);
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//transformation itself:
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
}
