package cz.vse.keg.patomat;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

import org.semanticweb.owlapi.model.OWLOntology;

/** 
 * TestLibrary class demonstrates pipeline of transformation where a tranformation pattern is applied on an ontology using only first detected pattern instance. This assumes installation of WordNet-3.0 at: 
 * /usr/share/WordNet-3.0" and Stanford POS-tagger at "/usr/share/models". This code is provided within java library release.
 * @author Ondrej Zamazal
 */

public class TestLibrary1 {
	
	public static void main(String[] args) {
		//Optional using part-of-speech tagger
		boolean POStagger=true;
	
		//preparatory phase: initialization
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="http://nb.vse.cz/~svabo/oaei2011/data/cmt.owl";
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		TransformationPattern tp1 = new TransformationPatternImpl("http://nb.vse.cz/~svabo/patomat/tp/tp_hasSome3.xml");
		
		//printing transformation pattern to be applied:
		System.out.println(tp1);
		
		//1st phase: pattern detection
		//getting first item in the case of only one selection for transformation
		String bindingPlaceholders = detection.queryPatternNamingAspect(tp1, ontology, false, true).get(0);
		
		//printing first detected pattern instance:
		System.out.println("1. one detected pattern instance in the given ontology:");
		System.out.println(bindingPlaceholders);
		
		//2nd phase: instruction generation
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());						
		ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1.getLocation(), bindingPlaceholders));
		//printing transformation instructions to be applied:
		System.out.println("2. generated transformation instructions:");
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//29-06-12
		/*
		for (String s : ig.getCurrentBindings().keySet()) {
			System.out.println("xxx "+s+":"+ig.getCurrentBindings().get(s));							
		}*/
		for (String s : ig.getBindings().keySet()) {
			System.out.println("xxx "+s+":"+ig.getBindings().get(s));							
		}
		
		//3rd phase: transformation of the ontology
		transformation.transformOntology(TransformationStrategy.Conservative, false);
		//an ontology is also saved in home directory:
		transformation.saveOntology("");
		//printing transformed ontology:
		System.out.println("3. ontology has been transformed and saved in home directory of an user:");
		System.out.println(transformation.printOntology());
	}
}
