package cz.vse.keg.patomat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

import lila.Demo;
import lila.LiLA;
import lila.syntax.Word;
import lila.tools.wordnet.NounSense;
import lila.tools.wordnet.PrintUtils;
import lila.tools.wordnet.Sense;

import org.semanticweb.owlapi.model.OWLOntology;

import cz.vse.keg.patomat.detection.OntologyPatternDetection;
import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.OntologyPatternImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformation.Type;

import cz.vse.keg.patomat.synonym.MyWordNet;

/**
 * @author Ondrej Zamazal
 * 
 */

public class Test {
	
	public static void test0() {
		//09-02-10
		//testing:
		/*
		TransformationPattern tp1 = new TransformationPatternImpl("");
		System.out.println(tp1.getOP1());
		System.out.println(tp1.getOP2());
		System.out.println(tp1.getPT().getLinks(Type.any));
		System.out.println(tp1.getENP());
		InstructionGenerator ig = new BasicInstructionGenerator(tp1);
		System.out.println("\nInstructions:");
		ig.getEntitiesForAdding();		
		ig.getEntitiesForRemoving();
		System.out.println("Rename entities:");
		System.out.println(ig.getEntitiesForRenaming());
		System.out.println("ADD axioms:");
		System.out.println(ig.getAxiomsForAdding());
		System.out.println("REMOVE axioms:");
		System.out.println(ig.getAxiomsForRemoving());
		*/
	}
	
	public static void test1original() {
		//10-02-10
		//testing real scenario apply tp_hasValue2 on ontology cmt.owl		
		//output: placeholders binding DONE in OntologyPatternDetectionImpl
		//now,manually:
		//HashMap for binding is deprecated, now it is XML, ie. preparation for RESTful service
		HashMap<String,String> binding = new HashMap<String,String>();
		binding.put("?p", "hasDecision");
		binding.put("?A", "Paper");
		binding.put("?B", "Decision");
		binding.put("?C", "Acceptance");
		//12-02-10,binding bude take XML od OntologyPatternDetection
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Acceptance</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		//bindingPlaceholders.append("</query_results>\n");
		System.out.println(bindingPlaceholders);
		//start BasicTransformationOntology
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/cmt.owl");
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_hasSome2.xml");		
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		//System.out.println(ig.getEntitiesForRenaming());
		//System.out.println(ig.getInstructions(binding));
		//transformation.setInstructions(ig.getInstructions(binding).toString());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());		
		transformation.transformOntology(TransformationStrategy.Conservative, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	//16-03-10
	public static void test2tp_basic() {
		//1.
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">ConferenceMember</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/cmt.owl");
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_ce-basic.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void test3tp_hasValue() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_ce-hasValue.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//1.
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		//30-03-10, just for testing purposes: not existing binding
		bindingPlaceholders.append("<binding placeholder=\"?A\">PresentedPaper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">hasStatus</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?a\">Acceptance</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/testAVR1d.owl");
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_ce-hasValue.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	//updated 28-07-11
	public static void test4tp_hasSome2() {
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_hasSome2.xml");
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		String ontology="file:///home/ondrej/prace/OAEI/10/data/ontologies/cmt.owl";
		System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//recursive?
		
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
		//bindingPlaceholders.append("<binding placeholder=\"?C\">Acceptance</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Rejection</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	//version according to new workflow as in XD Transformation Wizard plugin
	public static void test4tp_hasSome2V2() {
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_hasSome3.xml");
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		String ontology="file:///home/ondrej/prace/OAEI/10/data/ontologies/cmt.owl";
		System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
		
		//recursive?
		
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
		//bindingPlaceholders.append("<binding placeholder=\"?C\">Acceptance</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Rejection</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		
		detection.initBasicQueryForRecursion(tp1, ontology);
		
		//for(String s : detection.recursiveQuery("?A=Paper ?B=Decision ?C=Acceptance ?p=hasDecision ", tp1, ontology, false)) {
		for(String s : detection.recursiveQuery("?A=Paper ?B=Decision ?C=Rejection ?p=hasDecision ", tp1, ontology, false)) {
			System.out.println(s);
			//ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.model.ontologyIRI, this.model.tpIRI, s));
		}
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void testSKOS() {
		String tp1IRI="file:///home/ondrej/prace/ManchesterVisit/SKOStransformation/tp_skos1.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		//String ontology="file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/MICRO.owl";
		//String ontology="file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/camera.owl";
		String ontology="file:///home/ondrej/prace/ManchesterVisit/SKOStransformation/cmt.owl";
		//String ontology="file:///home/ondrej/wine.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Radical, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	//07-09-11, test transformation of nominals, replacing oneOf construct and hasValue
	public static void test11tp_nominals() {
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-1.xml");
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/small_pizza_with_nominalsVar1.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";
		System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		System.exit(1);
		//recursive?
		
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Acceptance</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		
		detection.initBasicQueryForRecursion(tp1, ontology);
		
		for(String s : detection.recursiveQuery("?A=Paper ?B=Decision ?C=Acceptance ?p=hasDecision ", tp1, ontology, false)) {
			System.out.println(s);
			//ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.model.ontologyIRI, this.model.tpIRI, s));
		}
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void test12tp_cardinality() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1lite.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/cardinality/cardinality_issue/tp_cardinality2liteMin.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality2liteExactly.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality2liteMin.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Cardinality1.owl";
		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, true, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//3. step
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void test13tp_disjoint() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/disjoint/tp_disjoint1.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Disjoint1.owl";
		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//3. step
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void test14tp_complement() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement1.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement4lite.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement5lite.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement6.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement6a.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Complement1.owl";
		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println("one result "+s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//3. step
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void test15tp_unionOf() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/union/tp_union1.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Union1.owl";
		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//3. step
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void test16tp_nominals() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-1.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";
		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//3. step
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void test17tp_intersection() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement1.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Intersection1.owl";		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		//23-09-11, preprocess an ontology, now just "decompose" all intersection
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";		
		System.out.println(ontology);
		System.exit(1);
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//3. step
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void test18tp_nominals() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-6.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		//TODO: change
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";		
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/small_pizza_with_nominals.owl";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/AfricanRedSlip.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_only() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_onlyEL2b.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_onlyEL2c.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_cardinalityMin() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_cardinalityELa.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_notSomeELa.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_complement() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_complementELa.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_notSomeELa.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testtp_classAsinstanceOntoDM() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		//String tp1IRI="file:///home/ondrej/prace/OAEI/11/DMontologies/OntoDMIssue/tp_classAsInstance.xml";
		String tp1IRI="file:///home/ondrej/prace/OAEI/11/DMontologies/OntoDMIssue/tp_classAsInstance.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_notSomeELa.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		//String ontology="file:///home/ondrej/prace/OAEI/11/DMontologies/OntoDMIssue/OntoDM.owl.xml";
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OntoDM.owl";
		//String ontology="file:///home/ondrej/prace/OAEI/11/DMontologies/OntoDMIssue/iao-main1.owl";
		///home/ondrej/prace/PatOMat/reasoning/testingOntoSet
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_disjointness() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_disjointEL1.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		System.exit(1);
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_nominals() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		//String ontology="file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/MICRO.owl";
		//String ontology="file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/camera.owl";
		String ontology="file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/wine.owl";
		//String ontology="file:///home/ondrej/wine.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_disjointProperties() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_disjointPropertiesEL1.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_irreflexive() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_IrreflexiveEL1.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_inverseOf() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_inverseOfEL.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_property_charactertistics() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_FunctionalEL1.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_SymmetricEL.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_AsymmetricEL.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	
	public static void testELtp_union() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_FunctionalEL1.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_SymmetricEL.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELa.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELb.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELbannotations.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_toELatOnce() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_FunctionalEL1.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_SymmetricEL.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELa.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELb.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELbannotations.xml";		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_toEL.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_toELallA.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_nominalsInLoop() {		
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		//String ontology="file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/MICRO.owl";		
		String ontology="file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/wine.owl";
		String localOntology;
			
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		localOntology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";		
		
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig;				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		//10-11-11,loop for replaccing all nominals in an ontology
		ArrayList<String> queryResults;
		queryResults = detection.queryPatternNamingAspect(tp1, localOntology, false, false);
		while (queryResults.size()>0) {			
			//reload:			
			transformation = new OntologyTransformationImpl(localOntology);
			ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
			
			for(String s : queryResults) {
				System.out.println(s);
				ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(localOntology, tp1IRI, s));
			}		
			System.out.println(ig.exportInstructions());
			transformation.setInstructions(ig.exportInstructions());
			//System.exit(1);
			//3. step
			transformation.transformOntology(TransformationStrategy.Progressive, false);
			transformation.saveOntology("");
			
			tp1 = new TransformationPatternImpl(tp1IRI);
			detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
			queryResults.clear();			
			queryResults = detection.queryPatternNamingAspect(tp1, localOntology, false, false);
		}				
		System.out.println(transformation.printOntology());									
	}
	
	public static void testELtp_toELTwoPatterns() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/cardinality/tp_cardinality1.xml");
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-3a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-4.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_someEL2a.xml";
		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_FunctionalEL1.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_SymmetricEL.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELa.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELb.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELbannotations.xml";		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_toEL.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_toEL3A.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_toEL3B.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		String ontology="file:///home/ondrej/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		//System.exit(1);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	//16-11-11, adjust OWLProfile using the code from Mathias Niepert
	public static void testELtp_OWL2EL() {
							
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
		String ontology="file:///home/ondrej/OWL2-EL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		
		transformation.adjustOWLProfile();					
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
		/*
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
		*/									
	}
	
	//15-12-11, for testing individuals replacing
	public static void testQLtp_individuals() {
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLQL/tp_individualsQL.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-QL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	//15-12-11, for testing individuals replacing
	public static void testQLtp_nominals() {
		//this pattern does not work because we would need to apply oneOf vararg concept within eq some {} axiom and oneOf vararg only works for eq {} or sub {}
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLQL/tp_nominalsQL.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-QL.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	//15-12-11, for testing nominals replacing
	public static void testLitetp_nominals() {
		String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLLite/tp_nominals-liteb.xml";
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		//transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		//transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		//ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		//transformation = new OntologyTransformationImpl(ontology);
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void test5tp_nary() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_l-n-ary-relation.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//1.
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		//30-03-10, just for testing purposes: not existing binding, TODO
		bindingPlaceholders.append("<binding placeholder=\"?A\">Reviewer</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">ReviewSubmission</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Paper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?D\">Review</binding>\n");		
		bindingPlaceholders.append("<binding placeholder=\"?p\">submitsReview</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?s\">reviewForPaper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?t\">reviewSubmitted</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/nary1.owl");
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_l-n-ary-relation.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null, false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void test6tp_specified_values() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_l-specified-values.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//1.
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		//30-03-10, just for testing purposes: not existing binding, TODO
		bindingPlaceholders.append("<binding placeholder=\"?A\">Topic</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">MultimediaTopic</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">ComputerNetworkTopic</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/nary1s.owl");
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_l-specified-values.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void test7tp_reasoning1() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//1.
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance>\n");
		//30-03-10, just for testing purposes: not existing binding, TODO
		bindingPlaceholders.append("<binding placeholder=\"?A\">PresentedPaper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">YourPaper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">TheirPaper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?D\">OwnPaper</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">hasStatus</binding>\n");	
		bindingPlaceholders.append("</pattern_instance>\n");
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/cmt.owl");
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
		//2.
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		transformation.setInstructions(ig.exportInstructions());
		//3.
		transformation.transformOntology(null,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void test8tp_agentRole() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//init phase
		boolean POStagger=false;//because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetection detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="file:///tmp/confOf.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_agentRoleV4a2.xml");
		System.out.println(tp1);
		
		//17-12-10:automatic detection								
		//17-12-10,detekce funguje, ale vraci se opravdu hodne dvojic ?B rdfs:subClassOf ?A.
		//jednou z techto dvojic je i kyzena: Author rdfs:subClassOf Person.
		System.out.println(detection.queryPattern(tp1, ontology, true, false));
		//e.g.:
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance ontology=\"file:///tmp/confOf.owl\">\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Author</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		//2.
		//17-12-10: in progress: InstructionGenerator
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());		
		//3.		
		//TODO: transformation.transformOntology();
		//transformation.transformOntology(null);
		transformation.transformOntology(TransformationStrategy.Radical,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void test9tp_agentRoleRecursive() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//init phase
		boolean POStagger=false;//because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetection detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-recursive-changed.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_agentRoleV4a2.xml");
		System.out.println(tp1);
		
		//17-12-10:automatic detection								
		//17-12-10,detekce funguje, ale vraci se opravdu hodne dvojic ?B rdfs:subClassOf ?A.
		//jednou z techto dvojic je i kyzena: Author rdfs:subClassOf Person.
		System.out.println(detection.queryPattern(tp1, ontology, false, false));
		//System.exit(1);
		//10-01-12, test because in XD plugin recursive application along the taxonomy does not work
		//TODO: najit chybu a opravit
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		System.out.println("Recursive results: "+detection.recursiveQuery("?B=Author;?A=Person", tp1, ontology, false));
		ArrayList<String> list = detection.recursiveQuery("?B=Author;?A=Person", tp1, ontology, false); 
		System.out.println("Recursive result:"+list);
		for(String s : list) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, "file:///home/ondrej/prace/PatOMat/TPs/tp_agentRoleV4a2.xml", s));
		}
		//konec testu 10-01-12
		//e.g.:
		//System.exit(1);
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");		
		//2.
		
		//18-02-11, 15-02-11,vicenasobne vyskyt pattern instance simulujici recursive option
		//pattern instance #1
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Author</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");		
		ig.generateInstructions(bindingPlaceholders.toString());
		//pattern instance #2
		bindingPlaceholders = new StringBuilder();
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">PaperAuthor</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		ig.generateInstructions(bindingPlaceholders.toString());
		//pattern instance #3
		bindingPlaceholders = new StringBuilder();
		bindingPlaceholders.append("<pattern_instance>\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">PosterAuthor</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		ig.generateInstructions(bindingPlaceholders.toString());
		System.out.println(ig.exportInstructions());
		//TODO:nebo take pattern instance #4 a #5, kde je A=Author a B=PaperAuthor ci B=PosterAuthor?				
		//System.exit(1);
		transformation.setInstructions(ig.exportInstructions());
		//3.		
		//TODO: transformation.transformOntology();
		//transformation.transformOntology(null);
		//transformation.transformOntology(TransformationStrategy.Conservative,false);
		transformation.transformOntology(TransformationStrategy.RadicalKeep,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
	}
	
	public static void test_tokenizer() {
		String s = "<pattern_instance>" +
		"<binding placeholder=\"?A\">Person</binding> " + 
		"<binding placeholder=\"?B\">Author</binding> " +
		"</pattern_instance> " +
		"<pattern_instance> " +
		"<binding placeholder=\"?A\">Person</binding> " +
		"<binding placeholder=\"?B\">PaperAuthor</binding> " +
		"</pattern_instance> " +
		"<pattern_instance> " +
		"<binding placeholder=\"?A\">Person</binding> " +
		"<binding placeholder=\"?B\">PosterAuthor</binding> " +
		"</pattern_instance> ";
		
		s=s.replaceAll("</pattern_instance>", "\t");
		StringTokenizer st = new StringTokenizer(s, "\t");
        String curBinding="";
        System.out.println(s);
        while (st.hasMoreTokens()) {
        	curBinding=st.nextToken();
        	System.out.println(curBinding);
        	curBinding+="</pattern_instance>\n";
        	System.out.println(curBinding);        	
        }
	}
	
	public static void test_lila(String slovo) throws Exception {
		Word word = new Word(slovo);
		try {
			Set<String> example = new HashSet<String>();
			//context for disambiguation:
			String s[] = new String[]{ "conference", "publication", "scientific", "research", "participant", "course" };
			for( int i=0; i<s.length; i++ ){
				example.add( s[i] );
			}
			
			LiLA m_lila = new LiLA();
			m_lila.setContext(example);//18-05-11,context for disambiguation
			//set context or you can iterate over all senses and you do not need to disambiguate (resp. disambiguation is up to you)
			
			System.out.println( "\n\nword="+ slovo +" category="+ word.getCategory() );
			System.out.println( "senses:\n"+ PrintUtils.toShortString( word.getSenses() ) ); 		
			
			//Sense sense = word.getSense();
			if( word.getSense() == null ){
				System.out.println( "\nno sense!" );
				return;
			}
			if( word.getSense() instanceof NounSense ){
				NounSense noun = (NounSense)word.getSense();
				System.out.println( "all hypernyms: "+ PrintUtils.toShortString( noun.getHypernyms() ) );
				System.out.println( "\nall hyponyms: "+ PrintUtils.toShortString( noun.getHyponyms() ) );
				System.out.println( "\nall meronyms: "+ PrintUtils.toShortString( noun.getMeronyms() ) );
			}
									
			//word( "agent" );
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void test10tp_participation_detectionV1() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//init phase
		boolean POStagger=true;//now we need it but we can off it because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported-tpi.owl";
		String ontology="file:////home/ondrej/prace/PatOMat/TPs/ontology/ekaw-imported-tpi.owl";
		//String ontology="file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported-ar.owl";
		//String ontology="file:////home/ondrej/prace/OAEI/10/data/ontologies/cmt.owl";
		//String ontology="file:////home/ondrej/prace/OAEI/10/data/ontologies/confOf.owl";
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/nary1s-changed1.owl";
		//String ontology="http://nb.vse.cz/~svabo/patomat/ontology/nary1s.owl";
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/testAVR1d.owl";
		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_agentRoleV4a2.xml");
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_ce-basic.xml");
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_ce-hasValue.xml");
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs//tp_l-specified-values.xml");
		//TransformationPattern tp1 = new TransformationPatternImpl("http://nb.vse.cz/~svabo/patomat/tp/tp_domain.xml");
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2a.xml");
		System.out.println(tp1);
		
		//17-12-10:automatic detection								
		//17-12-10,detekce funguje, ale vraci se opravdu hodne dvojic ?B rdfs:subClassOf ?A.
		//jednou z techto dvojic je i kyzena: Author rdfs:subClassOf Person.
		//System.out.println(detection.queryPattern(tp1, ontology, true));
		//System.out.println(detection.queryPattern(tp1, ontology, false));
		System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
		//07-06-11,test recursive after user's selection:
		//System.out.println(detection.recursiveQuery("?p=reviews ?D=Contribution ?C=Member_PC ?B=Reviewing_event ?A=Administrative_event", tp1, ontology, true));	
		/*
		//e.g.:
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance ontology=\"file:///tmp/confOf.owl\">\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Author</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		//2.
		//17-12-10: in progress: InstructionGenerator
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger);
		ig.generateInstructions(bindingPlaceholders.toString());
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());		
		//3.		
		//TODO: transformation.transformOntology();
		//transformation.transformOntology(null);
		transformation.transformOntology(TransformationStrategy.Radical);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
		*/
	}
	
	public static void test10tp_participation_detectionV2() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//init phase
		boolean POStagger=true;//now we need it but we can off it because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV1.xml");
		System.out.println(tp1);
		
		//17-12-10:automatic detection								
		//17-12-10,detekce funguje, ale vraci se opravdu hodne dvojic ?B rdfs:subClassOf ?A.
		//jednou z techto dvojic je i kyzena: Author rdfs:subClassOf Person.
		//System.out.println(detection.queryPattern(tp1, ontology, true));
		//System.out.println(detection.queryPattern(tp1, ontology, false));
		System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
		//07-06-11,test recursive after user's selection:
		detection.initBasicQueryForRecursion(tp1, ontology);
		//TODO: recursive query takes a lot of time which is a strange and should be investigated.
		System.out.println(detection.recursiveQuery("?p=reviews ?D=Contribution ?C=Member_PC ?B=Reviewing_event ?A=Event", tp1, ontology, true));	
		/*
		//e.g.:
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance ontology=\"file:///tmp/confOf.owl\">\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Author</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		//2.
		//17-12-10: in progress: InstructionGenerator
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger);
		ig.generateInstructions(bindingPlaceholders.toString());
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());		
		//3.		
		//TODO: transformation.transformOntology();
		//transformation.transformOntology(null);
		transformation.transformOntology(TransformationStrategy.Radical);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
		*/
	}
	
	public static void test10tp_participationV1() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//init phase
		boolean POStagger=true;//now we need it but we can off it because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetection detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl";
		//String ontology="file:////home/ondrej/prace/OAEI/10/data/ontologies/cmt.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV1.xml");
		System.out.println(tp1);
		
		//17-12-10:automatic detection								
		//17-12-10,detekce funguje, ale vraci se opravdu hodne dvojic ?B rdfs:subClassOf ?A.
		//jednou z techto dvojic je i kyzena: Author rdfs:subClassOf Person.
		//03-06-11,detection:
		//System.out.println(detection.queryPattern(tp1, ontology, true));
		//System.out.println(detection.queryPattern(tp1, ontology, false));
		
		//e.g.:
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance ontology=\"file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl\">\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Administrative_event</binding>\n");
		//or: bindingPlaceholders.append("<binding placeholder=\"?A\">Event</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Reviewing_event</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Member_PC</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?D\">Contribution</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">reviews</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		//2.
		//17-12-10: in progress: InstructionGenerator
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());		
		//3.		
		//TODO: transformation.transformOntology();
		//transformation.transformOntology(null);
		//transformation.transformOntology(TransformationStrategy.Radical);
		transformation.transformOntology(TransformationStrategy.Conservative,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
		
	}
	
	public static void test10tp_participationV2() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//init phase
		boolean POStagger=false;//now we need it but we can off it because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		String tpIRI = "file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2.xml";
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2.xml");
		System.out.println(tp1);
		
		//17-12-10:automatic detection								
		//17-12-10,detekce funguje, ale vraci se opravdu hodne dvojic ?B rdfs:subClassOf ?A.
		//jednou z techto dvojic je i kyzena: Author rdfs:subClassOf Person.
		//03-06-11,detection:
		//System.out.println(detection.queryPattern(tp1, ontology, true));
		//System.out.println(detection.queryPattern(tp1, ontology, false));
		
		//e.g.:
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		bindingPlaceholders.append("<pattern_instance ontology=\"file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl\">\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Event</binding>\n");
		//or: bindingPlaceholders.append("<binding placeholder=\"?A\">Event</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Reviewing_event</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Member_PC</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?D\">Contribution</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">reviews</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		//2.
		//17-12-10: in progress: InstructionGenerator
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		
		//11-10-11, test: recursive application along the taxonomy
		System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
		
		detection.initBasicQueryForRecursion(tp1, ontology);
		ArrayList<String> list = detection.recursiveQuery(" ?B=Reviewing_event ?A=Event ?C=Member_PC ?D=Contribution ?p=reviews ", tp1, ontology, false); 
		System.out.println("Recursive result:"+list);
		for(String s : list) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tpIRI, s));
		}
		
		//normal setting:
		ig.generateInstructions(bindingPlaceholders.toString());
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());		
		//3.		
		//TODO: transformation.transformOntology();
		//transformation.transformOntology(null);
		//transformation.transformOntology(TransformationStrategy.Radical);
		transformation.transformOntology(TransformationStrategy.Conservative,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
		
	}
	
	public static void test10tp_participationV2ekaw() {
		//TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
		//eg.
		//System.out.println(tp1.getOP1());
		//init phase
		boolean POStagger=true;//now we need it but we can off it because we do not need make_passive_verb() function which need POS-tagger
		//1.		
		//pattern detection
		OntologyPatternDetection detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		String ontology="file:////home/ondrej/prace/PatOMat/TPs/ontology/ekaw-imported-tpi.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		TransformationPattern tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2a.xml");
		System.out.println(tp1);
		
		//17-12-10:automatic detection								
		//17-12-10,detekce funguje, ale vraci se opravdu hodne dvojic ?B rdfs:subClassOf ?A.
		//jednou z techto dvojic je i kyzena: Author rdfs:subClassOf Person.
		//03-06-11,detection:
		//System.out.println(detection.queryPattern(tp1, ontology, true));
		//System.out.println(detection.queryPattern(tp1, ontology, false));
		
		//e.g.:
		StringBuilder bindingPlaceholders = new StringBuilder();
		//bindingPlaceholders.append("<query_results>\n");
		
		//?p=paperPresentedAs ?B=Individual_Presentation ?A=Event ?D=Individual_Presentation ?C=Document
		bindingPlaceholders.append("<pattern_instance ontology=\"file:///home/ondrej/prace/PatOMat/TPs/ontology/ekaw-imported.owl\">\n");
		bindingPlaceholders.append("<binding placeholder=\"?A\">Event</binding>\n");
		//or: bindingPlaceholders.append("<binding placeholder=\"?A\">Event</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?B\">Individual_Presentation</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?C\">Document</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?D\">Individual_Presentation</binding>\n");
		bindingPlaceholders.append("<binding placeholder=\"?p\">paperPresentedAs</binding>\n");
		bindingPlaceholders.append("</pattern_instance>\n");
		//2.
		//17-12-10: in progress: InstructionGenerator
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
		ig.generateInstructions(bindingPlaceholders.toString());
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());		
		//3.		
		//TODO: transformation.transformOntology();
		//transformation.transformOntology(null);
		//transformation.transformOntology(TransformationStrategy.Radical);
		//transformation.transformOntology(TransformationStrategy.Progressive);
		transformation.transformOntology(TransformationStrategy.RadicalKeep,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());
		
	}
	
	private static void word( String sLabel ) throws Exception {
		Word word = new Word( sLabel );
		System.out.println( "\n\nword="+ sLabel +" category="+ word.getCategory() );
		System.out.println( "senses:\n"+ PrintUtils.toShortString( word.getSenses() ) ); 
		print( word.getSense() );
	}
	
	private Set<String> createContext(){
		Set<String> example = new HashSet<String>();
		//context for disambiguation:
		String s[] = new String[]{ "conference", "publication", "scientific", "research", "participant", "course" };
		for( int i=0; i<s.length; i++ ){
			example.add( s[i] );
		}
		return example;
	}
	
	private static void print( Sense sense ) throws Exception {
		if( sense == null ){
			System.out.println( "\nno sense!" );
			return;
		}
		System.out.println( "\n"+ sense.toString() );
		if( sense instanceof NounSense ){
			NounSense noun = (NounSense)sense;
			System.out.println( "all hypernyms: "+ PrintUtils.toShortString( noun.getHypernyms() ) );
			System.out.println( "\nall hyponyms: "+ PrintUtils.toShortString( noun.getHyponyms() ) );
		}
	}
	
	private static void testWordNet() {
		String ontology="http://nb.vse.cz/~svabo/patomat/ontology/OWL2-EL.owl";
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0/", "/usr/share/models/");

		for (int i=0;i<=10000;i++) {
			MyWordNet myWordNet;
			myWordNet = new MyWordNet(transformation.getDictionaryPath());			
			myWordNet.finish();	
			myWordNet=null;
		}
		//13-12-11: I had problems with closing files which WordNet was using because mit-wn (jwi) did not close them properly
		//solution: I downloaded new version (JWI2.2.2). Now it seems it works fine.
	}
	
	private static void testHyperonym() {
		String ontology="http://nb.vse.cz/~svabo/patomat/ontology/OWL2-EL.owl";
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0/", "/usr/share/models/");

		MyWordNet myWordNet;
		myWordNet = new MyWordNet(transformation.getDictionaryPath());
		
		try {
			System.out.println(myWordNet.isHyperonym1("author", "person"));
			System.out.println(myWordNet.isHyperonym1("workshop", "event"));
			System.out.println(myWordNet.isHyperonym2(12, true, "author", "person"));
			System.out.println(myWordNet.isHyperonym2(12, true, "workshop", "event"));
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void testNamingPattern1() {		
		String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1.xml";		
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		
		//System.exit(1);
		boolean POStagger=true;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	public static void testNamingPattern1a() {		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2a.xml";
		String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2b.xml";
		
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf.owl";
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
		
		//System.exit(1);
		boolean POStagger=true;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPattern(tp1, ontology, false, true)) {
		//for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			//currently just detection so generation of instructions can be switched off: 
			//ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}		
		//currently just detection: 
		System.exit(1);
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());									
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
	//testNamingPattern1a();
		//testHyperonym();
		//testWordNet();
		//test1original();
		//test2tp_basic();
		test4tp_hasSome2();
		//test4tp_hasSome2V2();
	//test11tp_nominals();
		//test12tp_cardinality();
		//test13tp_disjoint();
		//test14tp_complement();
		//test15tp_unionOf();
		//test16tp_nominals();
		//test17tp_intersection();
		//test18tp_nominals();
		//testELtp_only();
		//testELtp_cardinalityMin();
		//testELtp_complement();
	//testELtp_nominals();		
		//testELtp_disjointness();
		//testELtp_disjointProperties();
		//testELtp_irreflexive();
		//testELtp_inverseOf();
		//testELtp_property_charactertistics();
		//testELtp_union();
		//testELtp_toELatOnce();
	//testELtp_nominalsInLoop();
	//testELtp_toELTwoPatterns();
	//testELtp_OWL2EL();
		//testQLtp_individuals(); OK
		//testQLtp_nominals(); NO
		//testLitetp_nominals();
		//testtp_classAsinstanceOntoDM();
		//test3tp_hasValue();
		//test5tp_nary();
		//test6tp_specified_values();
		//TODO
		//13-04-10, the following tp is not tested, we have no appropriate ontology for it and moreover it is pretty simple 
		//t7tp_reasoning1();
		//08-12-10
		//test8tp_agentRole();
		//18-02-11
		//testSKOS();
	//test9tp_agentRoleRecursive();
		//test_lila("car");
		//test_tokenizer();
		//test10tp_participation_detectionV1();
		//TODO: problem with second recursive application during XD Wizard:
		//test10tp_participation_detectionV2();
		//test10tp_participationV1();
		//test10tp_participationV2();
		//test10tp_participationV2ekaw();
	}

}

