package cz.vse.keg.patomat;

import org.semanticweb.owlapi.model.OWLOntology;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

/** 
 * RunTransformationForLogicalReasoning is the class for testing transformation within logical-reasoning use-case.
 * @author Ondrej Zamazal
 */
public class RunTransformationForLogicalReasoning {
	
	/** 
	 * Entry point to pipeline applying logical-reasoning use-case. This assumes installation of WordNet-3.0 at: 
	 * /usr/share/WordNet-3.0" and Stanford POS-tagger at "/usr/share/models".
	 * @param args[0] name of ontology from specific path: user.home/ISWC2011-demo/ontologyReasoning/ 
	 * @param args[1] name of transformation pattern from specific path: user.home/ISWC2011-demo/ontologyReasoning/
	 * @author Ondrej Zamazal
	 */
	public static void main(String[] args) {		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-5.xml";
		String path="file:///"+System.getProperty("user.home")+"/ISWC2011-demo/ontologyReasoning/";		
		String ontology=path+args[0];
		String tp1IRI=path+args[1];
		TransformationPattern tp1 = new TransformationPatternImpl(tp1IRI);		
		System.out.println(tp1);
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		//String ontology="http://nb.vse.cz/~svabo/oaei2009/data/cmt.owl";			
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl";
		//TODO: change
		//String ontology="file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";		
		
		OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
		//before detection there must be pre-processing of intersectionOf axioms to be decomposed
		transformation.preprocessOntology();
		//23-09-11, make a local copy of ontology for further steps like pre-processing:		
		transformation.saveOntology("");
		
		//23-09-11, get working link to copy of an ontology
		ontology="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+ontology.substring(ontology.lastIndexOf("/")+1,ontology.lastIndexOf("."))+".owl";
		//reload:
		transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
		boolean POStagger=false;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
			System.out.println(s);
			ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
		}
		transformation.setInstructions(ig.exportInstructions());
		//System.exit(1);
		//3. step
		if (args[2].equals("1")) 
			transformation.transformOntology(TransformationStrategy.Conservative,false);
		else if (args[2].equals("3"))
			transformation.transformOntology(TransformationStrategy.Radical,false);
		else 
			transformation.transformOntology(TransformationStrategy.Progressive,false);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());

	}

}
