/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.transformation.pattern;

import cz.vse.keg.patomat.naming.NameEntityImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator2;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformation;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InstructionGeneratorImpl2
implements InstructionGenerator2 {
    private TransformationPattern tp;
    private String ontology;
    private boolean POStagger;
    private String dictionaryPath;
    private String modelsPath;
    private HashSet<String> entitiesInstructions;
    private HashSet<String> opplScriptInstructions;
    private HashSet<String> opplScriptAddingInstructions;
    private HashSet<String> annotationsInstructions;
    private boolean debuggingOutput = false;
    private HashMap<String, String> binding;
    private HashMap<String, String> namingOP2;
    private boolean woOPPL = false;
    private ArrayList<String> specifiedOP2OptionalPlaceholders;
    private ArrayList<String> entitiesForAdding;
    private ArrayList<String> specifiedEntitiesForAdding;
    private ArrayList<String> entitiesForRetyping;
    private ArrayList<String> entitiesForRemoving;
    private HashMap<String, String> entitiesForRenaming;
    private HashMap<String, String> namingInstructions;

    public InstructionGeneratorImpl2(TransformationPattern tp, boolean POStagger, String dictionaryPath, String modelsPath) {
        this.tp = tp;
        this.POStagger = POStagger;
        this.dictionaryPath = dictionaryPath;
        this.modelsPath = modelsPath;
        this.entitiesInstructions = new HashSet();
        this.opplScriptInstructions = new HashSet();
        this.opplScriptAddingInstructions = new HashSet();
        this.annotationsInstructions = new HashSet();
        this.binding = new HashMap();
        this.namingOP2 = new HashMap();
    }

    @Override
    public HashMap<String, String> getOldBindings() {
        return this.binding;
    }

    @Override
    public HashMap<String, String> getBindings() {
        return this.namingOP2;
    }

    @Override
    public ArrayList<String> getAxiomsForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders) {
        ArrayList<String> axiomsForAdding = new ArrayList<String>();
        boolean forAdding = true;
        for (String s : this.tp.getOP2().getAxioms()) {
            Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            Matcher m = pat.matcher(s);
            while (m.find()) {
                if (this.tp.getPT().getLinks(PatternTransformation.Type.eqAnn).containsValue(m.group())) {
                    forAdding = false;
                    break;
                }
                if (!specifiedOP2OptionalPlaceholders.contains(m.group())) {
                    if (!this.tp.getPT().getLinks(PatternTransformation.Type.eq).containsValue(m.group()) && !this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(m.group())) continue;
                    forAdding = false;
                    break;
                }
                forAdding = true;
            }
            if (!forAdding) continue;
            axiomsForAdding.add(s);
        }
        return axiomsForAdding;
    }

    @Override
    public ArrayList<String> getAnnotationAxiomsForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders) {
        ArrayList<String> annotationAxiomsForAdding = new ArrayList<String>();
        boolean forAdding = true;
        for (String s : this.tp.getOP2().getAxioms()) {
            Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            Matcher m = pat.matcher(s);
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(s) + " annotation?");
            }
            while (m.find()) {
                if (this.tp.getPT().getLinks(PatternTransformation.Type.eqAnn).containsValue(m.group())) {
                    if (this.debuggingOutput) {
                        System.out.println(String.valueOf(s) + " yes annotation");
                    }
                    forAdding = true;
                    break;
                }
                if (!specifiedOP2OptionalPlaceholders.contains(m.group())) {
                    forAdding = false;
                    break;
                }
                if (this.debuggingOutput) {
                    System.out.println(String.valueOf(s) + " no annotation");
                }
                forAdding = false;
            }
            if (!forAdding) continue;
            annotationAxiomsForAdding.add(s);
        }
        block2: for (String s : this.tp.getOP2().getSpecifiedEntities().keySet()) {
            if (!this.tp.getOP2().getSpecifiedEntities().get(s).equals((Object)OntologyPattern.EntityType.AnnotationProperty)) continue;
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(s) + " annotation property to check");
            }
            for (String ss : this.tp.getOP2().getAxioms()) {
                if (this.debuggingOutput) {
                    System.out.println(String.valueOf(ss) + " annotation?");
                }
                if (!ss.matches(".*" + s + ".*")) continue;
                if (this.debuggingOutput) {
                    System.out.println(String.valueOf(s) + " ano anotace");
                }
                annotationAxiomsForAdding.add(ss);
                continue block2;
            }
        }
        return annotationAxiomsForAdding;
    }

    @Override
    public ArrayList<String> getAxiomsForRemoving(Set<String> specifiedOP1OptionalPlaceholders) {
        ArrayList<String> axiomsForRemoving = new ArrayList<String>();
        ArrayList<String> annotationProperties = new ArrayList<String>();
        boolean axiomRemoving = false;
        for (String s : this.tp.getOP1().getSpecifiedEntities().keySet()) {
            if (!this.tp.getOP1().getSpecifiedEntities().get(s).equals((Object)OntologyPattern.EntityType.AnnotationProperty)) continue;
            annotationProperties.add(s);
        }
        for (String s : this.tp.getOP1().getAxioms()) {
            axiomRemoving = true;
            Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            Matcher m = pat.matcher(s);
            while (m.find()) {
                if (specifiedOP1OptionalPlaceholders.contains(m.group())) continue;
                axiomRemoving = false;
                break;
            }
            for (String ss : annotationProperties) {
                if (!s.matches(".*" + ss + ".*")) continue;
                axiomRemoving = false;
                break;
            }
            if (!axiomRemoving) continue;
            axiomsForRemoving.add(s);
        }
        return axiomsForRemoving;
    }

    @Override
    public ArrayList<String> getEntitiesForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders) {
        ArrayList<String> entitiesForAdding = new ArrayList<String>();
        for (String s : this.tp.getOP2().getPlaceholders().keySet()) {
            if (this.tp.getPT().getLinks(PatternTransformation.Type.eq).containsValue(s) || this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("add ADD(" + s + ",ENP(" + this.tp.getPT().getENP().get(s) + ")");
            }
            entitiesForAdding.add(s);
        }
        return entitiesForAdding;
    }

    public ArrayList<String> getSpecifiedEntitiesForAdding() {
        ArrayList<String> specifiedEntitiesForAdding = new ArrayList<String>();
        for (String s : this.tp.getOP2().getSpecifiedEntities().keySet()) {
            if (this.tp.getPT().getLinks(PatternTransformation.Type.eq).containsValue(s) || this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("add ADD(" + s + ",ENP(" + this.tp.getPT().getENP().get(s) + ")");
            }
            specifiedEntitiesForAdding.add(s);
        }
        return specifiedEntitiesForAdding;
    }

    @Override
    public ArrayList<String> getEntitiesForRemoving(Set<String> specifiedOP1Placeholders) {
        ArrayList<String> entitiesForRemoving = new ArrayList<String>();
        for (String s : this.tp.getOP1().getPlaceholders().keySet()) {
            if (!specifiedOP1Placeholders.contains(s) || this.tp.getPT().getLinks(PatternTransformation.Type.any).containsKey(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("REMOVE(" + s + ")");
            }
            entitiesForRemoving.add(s);
        }
        return entitiesForRemoving;
    }

    @Override
    public ArrayList<String> getEntitiesForRetyping(ArrayList<String> specifiedOP2OptionalPlaceholders) {
        ArrayList<String> entitiesForRetyping = new ArrayList<String>();
        for (String s : this.tp.getOP2().getPlaceholders().keySet()) {
            if (!specifiedOP2OptionalPlaceholders.contains(s) || !this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(s) && !this.tp.getPT().getLinks(PatternTransformation.Type.eqAnn).containsValue(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("ADD(" + s + ",ENP(" + this.tp.getPT().getENP().get(s) + "))");
            }
            entitiesForRetyping.add(s);
        }
        return entitiesForRetyping;
    }

    @Override
    public void generateInstructions(String bindingPlaceholders, boolean init) {
        try {
            HashMap<String, String> binding = new HashMap<String, String>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new StringBufferInputStream(bindingPlaceholders));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/pattern_instance/binding";
            NodeList nodesOP = null;
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                binding.put(((Element)nodesOP.item(i)).getAttribute("placeholder"), ((Element)nodesOP.item(i)).getTextContent());
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/pattern_instance", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.ontology = ((Element)nodesOP.item(i)).getAttribute("ontology");
                ++i;
            }
            if (init) {
                this.specifiedOP2OptionalPlaceholders = this.getSpecifiedOP2OptionalPlaceholders(binding.keySet());
                if (this.debuggingOutput) {
                    System.out.println("specifiedOP2OptionalPlaceholders:" + this.specifiedOP2OptionalPlaceholders);
                }
                this.entitiesForAdding = this.getEntitiesForAdding(this.specifiedOP2OptionalPlaceholders);
                this.specifiedEntitiesForAdding = this.getSpecifiedEntitiesForAdding();
                this.entitiesForRetyping = this.getEntitiesForRetyping(this.specifiedOP2OptionalPlaceholders);
                this.entitiesForRemoving = this.getEntitiesForRemoving(binding.keySet());
                this.entitiesForRenaming = this.getEntitiesForRenaming(binding.keySet());
                this.namingInstructions = this.tp.getPT().getENP();
                for (String s : this.tp.getPT().getLinks(PatternTransformation.Type.any).keySet()) {
                    if (this.namingInstructions.containsKey(this.tp.getPT().getLinks(PatternTransformation.Type.any).get(s))) continue;
                    this.namingInstructions.put(this.tp.getPT().getLinks(PatternTransformation.Type.any).get(s), s);
                }
                if (this.debuggingOutput) {
                    System.out.println("binding:" + binding);
                }
                if (this.debuggingOutput) {
                    System.out.println("ni:" + this.namingInstructions);
                }
                if (this.debuggingOutput) {
                    System.out.println("entities for renaming:" + this.entitiesForRenaming);
                }
                if (this.debuggingOutput) {
                    System.out.println("entities for adding:" + this.entitiesForAdding);
                }
                if (this.debuggingOutput) {
                    System.out.println("specified entities for adding:" + this.entitiesForAdding);
                }
                if (this.debuggingOutput) {
                    System.out.println("entities for retyping:" + this.entitiesForRetyping);
                }
                if (this.debuggingOutput) {
                    System.out.println("entities for removing:" + this.entitiesForRemoving);
                }
            }
            this.generateInstructions(binding, false);
            this.binding = binding;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String exportInstructions() {
        StringBuilder xmlInstructions = new StringBuilder();
        xmlInstructions.append("<instructions ontology=\"" + this.ontology + "\" tp=\"" + this.tp.getLocation() + "\">\n");
        xmlInstructions.append("<entities>\n");
        for (String s : this.entitiesInstructions) {
            xmlInstructions.append(s);
        }
        xmlInstructions.append("</entities>\n");
        xmlInstructions.append("<oppl_script>\n");
        for (String s : this.opplScriptAddingInstructions) {
            xmlInstructions.append(s);
        }
        for (String s : this.opplScriptInstructions) {
            xmlInstructions.append(s);
        }
        xmlInstructions.append("</oppl_script>\n");
        xmlInstructions.append("<annotations>\n");
        for (String s : this.annotationsInstructions) {
            xmlInstructions.append(s);
        }
        xmlInstructions.append("</annotations>\n");
        xmlInstructions.append("</instructions>\n");
        return xmlInstructions.toString();
    }

    @Override
    public void generateInstructions(HashMap<String, String> binding, boolean init) {
        if (init) {
            this.specifiedOP2OptionalPlaceholders = this.getSpecifiedOP2OptionalPlaceholders(binding.keySet());
            if (this.debuggingOutput) {
                System.out.println("specifiedOP2OptionalPlaceholders:" + this.specifiedOP2OptionalPlaceholders);
            }
            this.entitiesForAdding = this.getEntitiesForAdding(this.specifiedOP2OptionalPlaceholders);
            this.specifiedEntitiesForAdding = this.getSpecifiedEntitiesForAdding();
            this.entitiesForRetyping = this.getEntitiesForRetyping(this.specifiedOP2OptionalPlaceholders);
            this.entitiesForRemoving = this.getEntitiesForRemoving(binding.keySet());
            this.entitiesForRenaming = this.getEntitiesForRenaming(binding.keySet());
            this.namingInstructions = this.tp.getPT().getENP();
            for (String s : this.tp.getPT().getLinks(PatternTransformation.Type.any).keySet()) {
                if (this.namingInstructions.containsKey(this.tp.getPT().getLinks(PatternTransformation.Type.any).get(s))) continue;
                this.namingInstructions.put(this.tp.getPT().getLinks(PatternTransformation.Type.any).get(s), s);
            }
            if (this.debuggingOutput) {
                System.out.println("binding:" + binding);
            }
            if (this.debuggingOutput) {
                System.out.println("ni:" + this.namingInstructions);
            }
            if (this.debuggingOutput) {
                System.out.println("entities for renaming:" + this.entitiesForRenaming);
            }
            if (this.debuggingOutput) {
                System.out.println("entities for adding:" + this.entitiesForAdding);
            }
            if (this.debuggingOutput) {
                System.out.println("specified entities for adding:" + this.entitiesForAdding);
            }
            if (this.debuggingOutput) {
                System.out.println("entities for retyping:" + this.entitiesForRetyping);
            }
            if (this.debuggingOutput) {
                System.out.println("entities for removing:" + this.entitiesForRemoving);
            }
        }
        NameEntityImpl ne = new NameEntityImpl(binding, this.POStagger, this.dictionaryPath, this.modelsPath);
        HashMap<String, Object> namingOP2 = new HashMap<String, Object>();
        if (!this.entitiesForRemoving.isEmpty()) {
            for (String s : this.entitiesForRemoving) {
                switch (this.tp.getOP1().getPlaceholders().get(s)) {
                    case ObjectProperty: {
                        this.entitiesInstructions.add("<remove type=\"ObjectProperty\">" + binding.get(s) + "</remove>\n");
                        break;
                    }
                    case AnnotationProperty: {
                        this.entitiesInstructions.add("<remove type=\"AnnotationProperty\">" + binding.get(s) + "</remove>\n");
                        break;
                    }
                    case DatatypeProperty: {
                        this.entitiesInstructions.add("<remove type=\"DatatypeProperty\">" + binding.get(s) + "</remove>\n");
                        break;
                    }
                    case Class: {
                        this.entitiesInstructions.add("<remove type=\"Class\">" + binding.get(s) + "</remove>\n");
                        break;
                    }
                    case Individual: {
                        this.entitiesInstructions.add("<remove type=\"Individual\">" + binding.get(s) + "</remove>\n");
                        break;
                    }
                    default: {
                        this.entitiesInstructions.add("<remove type=\"Uknown\">" + binding.get(s) + "</remove>\n");
                    }
                }
            }
        }
        if (!this.specifiedEntitiesForAdding.isEmpty()) {
            for (String s : this.specifiedEntitiesForAdding) {
                this.entitiesInstructions.add("<add>" + s + "</add>\n");
            }
        }
        for (String s : this.tp.getOP2().getPlaceholders().keySet()) {
            if (this.entitiesForAdding.contains(s)) {
                if (this.debuggingOutput) {
                    System.out.println("again:" + s + " " + this.namingInstructions.get(s));
                }
                if (this.namingInstructions.containsKey(s)) {
                    namingOP2.put(s, "!" + ne.getName(this.namingInstructions.get(s)).toString());
                    continue;
                }
                namingOP2.put(s, "!NTF");
                continue;
            }
            if (this.entitiesForRetyping.contains(s)) {
                if (this.namingInstructions.containsKey(s)) {
                    namingOP2.put(s, "!" + ne.getName(this.namingInstructions.get(s)));
                    continue;
                }
                namingOP2.put(s, "!NTF");
                continue;
            }
            if (!this.entitiesForRenaming.containsKey(s)) continue;
            if (this.namingInstructions.containsKey(s)) {
                String newName = ne.getName(this.namingInstructions.get(s)).toString();
                namingOP2.put(s, newName);
                switch (this.tp.getOP2().getPlaceholders().get(s)) {
                    case ObjectProperty: {
                        this.entitiesInstructions.add("<rename type=\"ObjectProperty\" original_name=\"" + binding.get(this.entitiesForRenaming.get(s)) + "\">" + (String)newName + "</rename>\n");
                        break;
                    }
                    case AnnotationProperty: {
                        this.entitiesInstructions.add("<rename type=\"AnnotationProperty\" original_name=\"" + binding.get(this.entitiesForRenaming.get(s)) + "\">" + (String)newName + "</rename>\n");
                        break;
                    }
                    case DatatypeProperty: {
                        this.entitiesInstructions.add("<rename type=\"DatatypeProperty\" original_name=\"" + binding.get(this.entitiesForRenaming.get(s)) + "\">" + (String)newName + "</rename>\n");
                        break;
                    }
                    case Class: {
                        this.entitiesInstructions.add("<rename type=\"Class\" original_name=\"" + binding.get(this.entitiesForRenaming.get(s)) + "\">" + (String)newName + "</rename>\n");
                        break;
                    }
                    case Individual: {
                        this.entitiesInstructions.add("<rename type=\"Individual\" original_name=\"" + binding.get(this.entitiesForRenaming.get(s)) + "\">" + (String)newName + "</rename>\n");
                        break;
                    }
                    case Literal: {
                        this.entitiesInstructions.add("<rename type=\"Literal\" original_name=\"" + binding.get(this.entitiesForRenaming.get(s)) + "\">" + (String)newName + "</rename>\n");
                        break;
                    }
                    default: {
                        this.entitiesInstructions.add("<rename type=\"Uknown\" original_name=\"" + binding.get(this.entitiesForRenaming.get(s)) + "\">" + (String)newName + "</rename>\n");
                        break;
                    }
                }
                continue;
            }
            namingOP2.put(s, binding.get(this.entitiesForRenaming.get(s)));
        }
        if (this.debuggingOutput) {
            System.out.println(namingOP2);
        }
        if (this.debuggingOutput) {
            System.out.println("Instructions in XML:");
        }
        String p = "";
        for (Map.Entry entry : namingOP2.entrySet()) {
            if (this.tp.getOP2().getPlaceholders().get(entry.getKey()).name().equals("Class")) continue;
            p = (String)entry.getValue();
            if (p.matches("!.*")) {
                p = "!" + p.substring(1, 2).toLowerCase() + p.substring(2);
            } else if (this.debuggingOutput) {
                System.out.println(p);
            }
            entry.setValue(p);
        }
        if (this.debuggingOutput) {
            System.out.println(namingOP2);
        }
        if (!this.woOPPL) {
            Matcher m;
            ArrayList<String> arrayList = this.getAxiomsForAdding(this.specifiedOP2OptionalPlaceholders);
            ArrayList<String> annotationAxiomsForAdding = this.getAnnotationAxiomsForAdding(this.specifiedOP2OptionalPlaceholders);
            ArrayList<String> axiomsForRemoving = this.getAxiomsForRemoving(binding.keySet());
            axiomsForRemoving = this.getAxiomsForRemoving(binding.keySet());
            ArrayList<String> axiomsForAddingFullName = new ArrayList<String>();
            ArrayList<String> axiomsForRemovingFullName = new ArrayList<String>();
            Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            StringBuilder str = new StringBuilder("BEGIN \n");
            int i = 0;
            for (String s : axiomsForRemoving) {
                ++i;
                m = pat.matcher(s);
                while (m.find()) {
                    if (this.debuggingOutput) {
                        System.out.println(s);
                    }
                    if (this.debuggingOutput) {
                        System.out.println("test " + m.group() + " cim " + binding.get(m.group()));
                    }
                    s = s.replaceAll("\\" + m.group() + " ", String.valueOf(binding.get(m.group())) + " ");
                    s = s.replaceAll("directSubClassOf", "subClassOf");
                }
                axiomsForRemovingFullName.add(s);
            }
            i = 0;
            for (String s : arrayList) {
                if (annotationAxiomsForAdding.contains(s)) continue;
                ++i;
                m = pat.matcher(s);
                while (m.find()) {
                    if (this.debuggingOutput) {
                        System.out.println("test " + m.group());
                    }
                    s = s.replaceAll("\\" + m.group(), (String)namingOP2.get(m.group()));
                    s = s.replaceAll("directSubClassOf", "subClassOf");
                }
                if (axiomsForRemovingFullName.contains(s)) {
                    axiomsForRemovingFullName.remove(s);
                    continue;
                }
                axiomsForAddingFullName.add(s);
            }
            for (String s : axiomsForRemovingFullName) {
                this.opplScriptInstructions.add("<remove>" + s + "</remove>\n");
                if (i != axiomsForRemoving.size()) {
                    str.append("REMOVE " + s + ",\n");
                    continue;
                }
                str.append("REMOVE " + s + "\n");
            }
            for (String s : axiomsForAddingFullName) {
                this.opplScriptInstructions.add("<add>" + s + "</add>\n");
                if (i != arrayList.size()) {
                    str.append("ADD " + s + ",\n");
                    continue;
                }
                str.append("ADD " + s + "\n");
            }
            str.append("END;");
            String annotationToEntity = "";
            for (String s : annotationAxiomsForAdding) {
                ++i;
                if (this.debuggingOutput) {
                    System.out.println(s);
                }
                System.out.println("annotation axiom " + s);
                m = pat.matcher(s);
                i = 0;
                while (m.find()) {
                    ++i;
                    annotationToEntity = this.tp.getOP2().getPlaceholders().get(m.group()).name();
                    s = s.replaceAll("\\" + m.group(), String.valueOf(annotationToEntity) + " " + (String)namingOP2.get(m.group()));
                }
                this.annotationsInstructions.add("<add>" + s + "</add>\n");
            }
        }
        if (this.debuggingOutput) {
            System.out.println(this.entitiesInstructions);
        }
        if (this.debuggingOutput) {
            System.out.println(this.opplScriptInstructions);
        }
        if (this.debuggingOutput) {
            System.out.println(this.annotationsInstructions);
        }
        this.namingOP2 = namingOP2;
        if (!this.entitiesForAdding.isEmpty()) {
            for (String string : this.entitiesForAdding) {
                if (!this.tp.getOP2().getPlaceholders().get(string).equals((Object)OntologyPattern.EntityType.Class)) continue;
                System.out.println("nova entita a je to trida od " + string + " k " + this.getBindings().get(string));
                this.opplScriptAddingInstructions.add("<add>" + this.getBindings().get(string) + " subClassOf Thing</add>\n");
            }
        }
        ne.finish();
    }

    @Override
    public HashMap<String, String> getEntitiesForRenaming(Set<String> specifiedOP1OptionalPlaceholders) {
        HashMap<String, String> entitiesForRenaming = new HashMap<String, String>();
        for (String key : this.tp.getPT().getLinks(PatternTransformation.Type.eq).keySet()) {
            if (!specifiedOP1OptionalPlaceholders.contains(key)) continue;
            entitiesForRenaming.put(key, "ENP(" + this.tp.getPT().getLinks(PatternTransformation.Type.eq).get(key) + ")");
            entitiesForRenaming.put(this.tp.getPT().getLinks(PatternTransformation.Type.eq).get(key), key);
        }
        return entitiesForRenaming;
    }

    @Override
    public ArrayList<String> getSpecifiedOP2OptionalPlaceholders(Set<String> specifiedOP1Placeholders) {
        ArrayList<String> specifiedOP2OptionalPlaceholders = new ArrayList<String>();
        for (String key : this.tp.getPT().getLinks(PatternTransformation.Type.eq).keySet()) {
            if (!specifiedOP1Placeholders.contains(key)) continue;
            specifiedOP2OptionalPlaceholders.add(this.tp.getPT().getLinks(PatternTransformation.Type.eq).get(key));
        }
        for (String key : this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).keySet()) {
            if (!specifiedOP1Placeholders.contains(key)) continue;
            specifiedOP2OptionalPlaceholders.add(this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(key));
        }
        return specifiedOP2OptionalPlaceholders;
    }
}

