/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.naming;

import cz.vse.keg.patomat.naming.NamingConstraints;
import cz.vse.keg.patomat.naming.NamingFunctionException;
import cz.vse.keg.patomat.string.Words;
import cz.vse.keg.patomat.synonym.MyWordNet;
import cz.vse.keg.patomat.transformation.pattern.NameDetectionPattern;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamingConstraintsImpl
implements NamingConstraints {
    protected Words words;
    protected MyWordNet myWordNet;
    protected ArrayList<String> classes;
    protected ArrayList<String> properties;
    protected ArrayList<String> individuals;
    protected HashMap<String, List<String>> placeholdersBindingCurrent;
    protected ArrayList<HashMap<String, List<String>>> placeholdersBinding;
    private boolean debuggingOutput = false;

    public NamingConstraintsImpl(boolean POStagger, String dictionaryPath, String modelsPath) {
        this.words = new Words(POStagger, dictionaryPath, modelsPath);
        this.myWordNet = new MyWordNet(dictionaryPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchEntities(String entity1, String entity2, float threshold, NameDetectionPattern.MeasureType measureType) {
        switch (measureType) {
            case EQUAL: {
                return entity1.equals(entity2);
            }
            case UNEQUAL: {
                if (!entity1.equals(entity2)) return true;
                return false;
            }
            case LEVENSHTEIN: {
                return false;
            }
            case JARO: {
                return false;
            }
            case HYPERONYM: {
                try {
                    if (entity1.equals(entity2)) {
                        if (!this.debuggingOutput) return true;
                        System.out.println(String.valueOf(entity1) + " " + entity2 + " " + true);
                        return true;
                    }
                    boolean hyperonym = this.myWordNet.isHyperonym2(5, true, entity1.toLowerCase(), entity2.toLowerCase());
                    if (!this.debuggingOutput) return hyperonym;
                    System.out.println(String.valueOf(entity1) + " " + entity2 + " " + hyperonym);
                    return hyperonym;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            case NOT_HYPERONYM: {
                try {
                    if (entity1.equals(entity2)) {
                        if (!this.debuggingOutput) return false;
                        System.out.println(String.valueOf(entity1) + " " + entity2 + " " + true);
                        return false;
                    }
                    boolean hyperonym = this.myWordNet.isHyperonym2(5, true, entity1.toLowerCase(), entity2.toLowerCase());
                    if (this.debuggingOutput) {
                        System.out.println(String.valueOf(entity1) + " " + entity2 + " " + hyperonym);
                    }
                    if (!hyperonym) return true;
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    private boolean compareEntities(String entity1, String entity2, float threshold, NameDetectionPattern.MeasureType measureType) {
        return true;
    }

    private String executeEntityCompared(String entityCompared, String binding) {
        String naming_function = "";
        String parameter = "";
        if (entityCompared.matches("^.*\\(.*\\)$")) {
            boolean nested_patterns = true;
            ArrayList<String> nst_patterns = new ArrayList<String>();
            while (nested_patterns) {
                naming_function = entityCompared.substring(0, entityCompared.indexOf("("));
                nst_patterns.add(naming_function);
                parameter = entityCompared.substring(entityCompared.indexOf("(") + 1, entityCompared.lastIndexOf(")"));
                if (parameter.matches(".*\\(.*\\)")) {
                    nested_patterns = true;
                    entityCompared = parameter;
                    continue;
                }
                nested_patterns = false;
            }
            if (this.debuggingOutput) {
                System.out.println(nst_patterns);
            }
            parameter = binding;
            int i = nst_patterns.size() - 1;
            while (i >= 0) {
                block24: {
                    if (this.debuggingOutput) {
                        System.out.println((String)nst_patterns.get(i));
                    }
                    naming_function = (String)nst_patterns.get(i);
                    if (this.debuggingOutput) {
                        System.out.println(String.valueOf(naming_function) + " over " + parameter);
                    }
                    String conceptNames = "";
                    String hn = "";
                    try {
                        if (naming_function.equals("head_noun")) {
                            conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                            hn = this.words.getMT(conceptNames);
                            parameter = String.valueOf(hn.substring(0, 1).toUpperCase()) + hn.substring(1);
                            break block24;
                        }
                        if (naming_function.equals("head_term")) {
                            conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                            hn = this.words.getMT(conceptNames);
                            parameter = String.valueOf(hn.substring(0, 1).toUpperCase()) + hn.substring(1);
                            break block24;
                        }
                        if (naming_function.equals("get_first")) {
                            parameter = "";
                            break block24;
                        }
                        if (naming_function.equals("object_term")) {
                            conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                            hn = this.words.getMT(conceptNames);
                            parameter = String.valueOf(hn.substring(0, 1).toUpperCase()) + hn.substring(1);
                            break block24;
                        }
                        if (naming_function.equals("complement_head_noun")) {
                            parameter = this.words.getComplementHeadNoun(parameter);
                            break block24;
                        }
                        if (naming_function.equals("passive_verb")) {
                            parameter = this.words.getVerbPassiveForm(parameter);
                            break block24;
                        }
                        if (naming_function.equals("word_lemma")) {
                            parameter = this.words.nlp.getOneWordLemma(parameter);
                            break block24;
                        }
                        if (naming_function.equals("make_passive_verb")) {
                            conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                            if (this.words.nlp.getOneWordTag(parameter = this.words.getMT(conceptNames)).equals("VB")) {
                                this.words.getVerbPassiveForm(parameter);
                            } else {
                                ArrayList relatedTerms = this.myWordNet.getRelatedWord(parameter);
                                if (relatedTerms != null) {
                                    for (String r : relatedTerms) {
                                        if (!this.words.nlp.getOneWordTag(r).equals("VB") && !this.words.nlp.getOneWordTag(r).equals("JJ")) continue;
                                        String passive = this.words.getVerbPassiveForm(r);
                                        parameter = String.valueOf(passive.substring(0, 1).toUpperCase()) + passive.substring(1);
                                        break;
                                    }
                                }
                            }
                            if (this.debuggingOutput) {
                                System.out.println(">>passive variant is " + parameter);
                            }
                            break block24;
                        }
                        throw new NamingFunctionException("This function " + naming_function + " is not currently supported. Please wait for the next release.");
                    }
                    catch (NamingFunctionException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                --i;
            }
            return parameter;
        }
        if (entityCompared.matches("^\\?.*")) {
            return binding;
        }
        return entityCompared;
    }

    private ArrayList<String> initEntityComparison(String entityCompared) {
        String naming_function = "";
        String parameter = "";
        boolean nested_patterns = true;
        ArrayList<String> nst_patterns = new ArrayList<String>();
        while (nested_patterns) {
            naming_function = entityCompared.substring(0, entityCompared.indexOf("("));
            nst_patterns.add(naming_function);
            parameter = entityCompared.substring(entityCompared.indexOf("(") + 1, entityCompared.lastIndexOf(")"));
            if (parameter.matches(".*\\(.*\\)")) {
                nested_patterns = true;
                entityCompared = parameter;
                continue;
            }
            nested_patterns = false;
        }
        return nst_patterns;
    }

    private String executeEntityCompared(String entityCompared, HashMap<String, String> sparqlBinding) {
        String naming_function = "";
        String parameter = "";
        if (entityCompared.matches("^.*\\(.*\\)$")) {
            boolean nested_patterns = true;
            ArrayList<String> nst_patterns = new ArrayList<String>();
            while (nested_patterns) {
                naming_function = entityCompared.substring(0, entityCompared.indexOf("("));
                nst_patterns.add(naming_function);
                parameter = entityCompared.substring(entityCompared.indexOf("(") + 1, entityCompared.lastIndexOf(")"));
                if (parameter.matches(".*\\(.*\\)")) {
                    nested_patterns = true;
                    entityCompared = parameter;
                    continue;
                }
                nested_patterns = false;
            }
            if (this.debuggingOutput) {
                System.out.println(nst_patterns);
            }
            parameter = sparqlBinding.get(parameter);
            int i = nst_patterns.size() - 1;
            while (i >= 0) {
                block19: {
                    if (this.debuggingOutput) {
                        System.out.println((String)nst_patterns.get(i));
                    }
                    naming_function = (String)nst_patterns.get(i);
                    if (this.debuggingOutput) {
                        System.out.println(String.valueOf(naming_function) + " over " + parameter);
                    }
                    String conceptNames = "";
                    String hn = "";
                    try {
                        if (naming_function.equals("head_noun")) {
                            conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                            hn = this.words.getMT(conceptNames);
                            if (this.debuggingOutput) {
                                System.out.println("head noun is " + hn);
                            }
                            parameter = String.valueOf(hn.substring(0, 1).toUpperCase()) + hn.substring(1);
                            break block19;
                        }
                        if (naming_function.equals("head_term")) {
                            conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                            hn = this.words.getMT(conceptNames);
                            parameter = String.valueOf(hn.substring(0, 1).toUpperCase()) + hn.substring(1);
                            break block19;
                        }
                        if (naming_function.equals("get_first")) {
                            parameter = "";
                            break block19;
                        }
                        if (naming_function.equals("object_term")) {
                            conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                            hn = this.words.getMT(conceptNames);
                            parameter = String.valueOf(hn.substring(0, 1).toUpperCase()) + hn.substring(1);
                            break block19;
                        }
                        if (naming_function.equals("complement_head_noun")) {
                            parameter = this.words.getComplementHeadNoun(parameter);
                            break block19;
                        }
                        if (naming_function.equals("passive_verb")) {
                            parameter = this.words.getVerbPassiveForm(parameter);
                            break block19;
                        }
                        if (naming_function.equals("word_lemma")) {
                            parameter = this.words.nlp.getOneWordLemma(parameter);
                            break block19;
                        }
                        throw new NamingFunctionException("This function " + naming_function + " is not currently supported. Please wait for the next release.");
                    }
                    catch (NamingFunctionException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                --i;
            }
            return parameter;
        }
        if (entityCompared.matches("^\\?.*")) {
            return sparqlBinding.get(entityCompared);
        }
        return entityCompared;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeEntityExist(String entityCompared, HashMap<String, String> sparqlBinding) {
        String naming_function = "";
        ArrayList<String> parameters = new ArrayList<String>();
        String parameter = "";
        if (!entityCompared.matches("^.*\\(.*\\)$")) return false;
        Pattern pat = Pattern.compile("^.*\\(");
        Matcher m = pat.matcher(entityCompared);
        while (m.find()) {
            naming_function = m.group();
        }
        naming_function = naming_function.replaceAll("\\(", "");
        pat = Pattern.compile("\\(.*\\)$");
        m = pat.matcher(entityCompared);
        while (m.find()) {
            parameter = m.group();
        }
        parameter = parameter.replaceAll("\\(", "");
        parameter = parameter.replaceAll("\\)", "");
        StringTokenizer st1 = new StringTokenizer(parameter, ",");
        while (st1.hasMoreTokens()) {
            parameters.add(st1.nextToken());
        }
        parameters.set(0, sparqlBinding.get(parameters.get(0)));
        parameter = sparqlBinding.get(parameter);
        if (this.debuggingOutput) {
            System.out.println("test:" + parameters);
        }
        String conceptNames = "";
        String hn = "";
        if (this.debuggingOutput) {
            System.out.println("enf:" + naming_function + ",ep: " + parameter);
        }
        try {
            String r;
            if (naming_function.equals("delimiter_camel-case")) {
                pat = Pattern.compile(".+[A-Z].+");
                m = pat.matcher(parameter);
                if (this.debuggingOutput) {
                    System.out.println("[A-Z]");
                }
                if (!m.matches()) return false;
                return true;
            }
            if (naming_function.equals("delimiter_underscore")) {
                if (parameter.indexOf("_") == -1) return false;
                return true;
            }
            if (naming_function.equals("delimiter_hyphen")) {
                if (parameter.indexOf("-") == -1) return false;
                return true;
            }
            if (!naming_function.equals("verb_form")) {
                if (!naming_function.equals("isHyperonymOf")) throw new NamingFunctionException("This function " + naming_function + " is not currently supported. Please wait for the next release.");
                if (!this.debuggingOutput) return false;
                System.out.println(String.valueOf((String)parameters.get(0)) + " " + (String)parameters.get(1));
                return false;
            }
            if (this.words.nlp.getOneWordTag(parameter).equals("VB")) {
                return true;
            }
            ArrayList relatedTerms = this.myWordNet.getRelatedWord(parameter);
            if (relatedTerms == null) {
                return false;
            }
            Iterator iterator = relatedTerms.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                r = (String)iterator.next();
                if (this.words.nlp.getOneWordTag(r).matches("VB.")) return true;
            } while (!this.words.nlp.getOneWordTag(r).equals("VB"));
            return true;
        }
        catch (NamingFunctionException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void putPlaceholderBinding(String placeholder, String binding) {
        if (this.placeholdersBindingCurrent.containsKey(placeholder)) {
            List<String> bindings = this.placeholdersBindingCurrent.get(placeholder);
            bindings.add(binding);
        } else {
            ArrayList<String> bindings = new ArrayList<String>();
            bindings.add(binding);
            this.placeholdersBindingCurrent.put(placeholder, bindings);
        }
    }

    private void executeComparingEntities(OntologyPattern op, String p1, NameDetectionPattern ndp, String s1) {
        String entity1 = "";
        String entity2 = "";
        entity1 = p1.equals("specified entity") ? s1 : this.executeEntityCompared(ndp.getEntity1(), s1);
        if (this.debuggingOutput) {
            System.out.println("comparing entity1>" + s1);
        }
        if (ndp.getInvolvedPlaceholdersEntity2().isEmpty()) {
            if (this.debuggingOutput) {
                System.out.println("entity2 no placeholders");
            }
            if (this.matchEntities(entity1, ndp.getEntity2(), ndp.getThreshold(), ndp.getMeasureType())) {
                if (this.debuggingOutput) {
                    System.out.println(String.valueOf(s1) + " matches " + ndp.getEntity2());
                }
                this.putPlaceholderBinding(p1, s1);
            }
        } else {
            block6: for (String p2 : ndp.getInvolvedPlaceholdersEntity2()) {
                switch (op.getPlaceholders().get(p2)) {
                    case Class: {
                        for (String s2 : this.classes) {
                            entity2 = this.executeEntityCompared(ndp.getEntity2(), s2);
                            if (this.debuggingOutput) {
                                System.out.println("comparing entity2>" + s2);
                            }
                            if (!this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) continue;
                            if (this.debuggingOutput) {
                                System.out.println(String.valueOf(s1) + " matches " + s2);
                            }
                            this.putPlaceholderBinding(p1, s1);
                            this.putPlaceholderBinding(p2, s2);
                        }
                        continue block6;
                    }
                    case ObjectProperty: {
                        for (String s2 : this.properties) {
                            entity2 = this.executeEntityCompared(ndp.getEntity2(), s2);
                            if (this.debuggingOutput) {
                                System.out.println("comparing entity2>" + entity2);
                            }
                            if (!this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) continue;
                            if (this.debuggingOutput) {
                                System.out.println(String.valueOf(s1) + " matches " + s2);
                            }
                            this.putPlaceholderBinding(p1, s1);
                            this.putPlaceholderBinding(p2, s2);
                        }
                        continue block6;
                    }
                    case DatatypeProperty: {
                        for (String s2 : this.properties) {
                            entity2 = this.executeEntityCompared(ndp.getEntity2(), s2);
                            if (this.debuggingOutput) {
                                System.out.println("comparing entity2>" + entity2);
                            }
                            if (!this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) continue;
                            if (this.debuggingOutput) {
                                System.out.println(String.valueOf(s1) + " matches " + s2);
                            }
                            this.putPlaceholderBinding(p1, s1);
                            this.putPlaceholderBinding(p2, s2);
                        }
                        continue block6;
                    }
                    case Individual: {
                        for (String s2 : this.individuals) {
                            entity2 = this.executeEntityCompared(ndp.getEntity2(), s2);
                            if (this.debuggingOutput) {
                                System.out.println("comparing entity2>" + entity2);
                            }
                            if (!this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) continue;
                            if (this.debuggingOutput) {
                                System.out.println(String.valueOf(s1) + " matches " + s2);
                            }
                            this.putPlaceholderBinding(p1, s1);
                            this.putPlaceholderBinding(p2, s2);
                        }
                        continue block6;
                    }
                }
            }
        }
    }

    public ArrayList<HashMap<String, List<String>>> checkNamingConstraints(OntologyPattern op, ArrayList<String> classes, ArrayList<String> properties, ArrayList<String> individuals, ArrayList<NameDetectionPattern> ndps) {
        this.placeholdersBinding = new ArrayList();
        this.placeholdersBindingCurrent = new HashMap();
        this.classes = classes;
        this.properties = properties;
        this.individuals = individuals;
        for (NameDetectionPattern ndp : ndps) {
            switch (ndp.getNamePatternType()) {
                case COMPARISON: {
                    this.placeholdersBindingCurrent = new HashMap();
                    if (ndp.getInvolvedPlaceholdersEntity1().isEmpty()) {
                        if (this.debuggingOutput) {
                            System.out.println("no placeholders");
                        }
                        this.executeComparingEntities(op, "specified entity", ndp, ndp.getEntity1());
                    } else {
                        if (this.debuggingOutput) {
                            System.out.println(ndp);
                        }
                        block10: for (String p1 : ndp.getInvolvedPlaceholdersEntity1()) {
                            if (this.debuggingOutput) {
                                System.out.println("p1>" + p1);
                            }
                            switch (op.getPlaceholders().get(p1)) {
                                case Class: {
                                    for (String s1 : classes) {
                                        if (this.debuggingOutput) {
                                            System.out.println("s1>" + s1);
                                        }
                                        this.executeComparingEntities(op, p1, ndp, s1);
                                    }
                                    continue block10;
                                }
                                case ObjectProperty: {
                                    for (String s1 : properties) {
                                        this.executeComparingEntities(op, p1, ndp, s1);
                                    }
                                }
                                case DatatypeProperty: {
                                    for (String s1 : properties) {
                                        this.executeComparingEntities(op, p1, ndp, s1);
                                    }
                                    continue block10;
                                }
                                case Individual: {
                                    for (String s1 : individuals) {
                                        this.executeComparingEntities(op, p1, ndp, s1);
                                    }
                                    continue block10;
                                }
                            }
                        }
                    }
                    if (this.debuggingOutput) {
                        System.out.println(this.placeholdersBindingCurrent);
                    }
                    this.placeholdersBinding.add(this.placeholdersBindingCurrent);
                }
            }
        }
        return this.placeholdersBinding;
    }

    public boolean checkNamingConstraints(HashMap<String, String> sparqlBinding, ArrayList<NameDetectionPattern> ndps, boolean comparison) {
        block4: for (NameDetectionPattern ndp : ndps) {
            switch (ndp.getNamePatternType()) {
                case COMPARISON: {
                    if (!comparison || this.matchEntities(this.executeEntityCompared(ndp.getEntity1(), sparqlBinding), this.executeEntityCompared(ndp.getEntity2(), sparqlBinding), ndp.getThreshold(), ndp.getMeasureType())) continue block4;
                    return false;
                }
                case EXIST: {
                    if (this.executeEntityExist(ndp.getEntity1(), sparqlBinding)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void finish() {
        this.myWordNet.finish();
        this.words.finish();
    }

    @Override
    public boolean checkNamingConstraints(HashMap<String, String> sparqlBinding, ArrayList<NameDetectionPattern> ndps) {
        for (NameDetectionPattern ndp : ndps) {
            switch (ndp.getNamePatternType()) {
                case EXIST: {
                    if (this.executeEntityExist(ndp.getEntity1(), sparqlBinding)) break;
                    return false;
                }
            }
        }
        return true;
    }
}

