/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.naming;

import cz.vse.keg.patomat.naming.NameEntity;
import cz.vse.keg.patomat.naming.NamingFunctionException;
import cz.vse.keg.patomat.string.Words;
import cz.vse.keg.patomat.synonym.MyWordNet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameEntityImpl
implements NameEntity {
    protected HashMap<String, String> binding;
    protected ArrayList<String> instructions;
    protected Words words;
    protected MyWordNet myWordNet;
    private boolean debuggingOutput = false;

    public NameEntityImpl(HashMap<String, String> binding, boolean POStagger, String dictionaryPath, String modelsPath) {
        this.binding = binding;
        this.words = new Words(POStagger, dictionaryPath, modelsPath);
        this.myWordNet = new MyWordNet(dictionaryPath);
    }

    private String getDelimiterOfURIfragment(String URIfragment) {
        URIfragment = URIfragment.replaceAll("head_noun", "");
        URIfragment = URIfragment.replaceAll("head_term", "");
        URIfragment = URIfragment.replaceAll("object_term", "");
        URIfragment = URIfragment.replaceAll("make_delimiter_underscore", "");
        URIfragment = URIfragment.replaceAll("make_delimiter_camel-case", "");
        URIfragment = URIfragment.replaceAll("make_delimiter_hyphen", "");
        URIfragment = URIfragment.replaceAll("make_passive_verb", "");
        URIfragment = URIfragment.replaceAll("verb_form", "");
        String delimiter = (URIfragment = URIfragment.replaceAll("complement_head_noun", "")).indexOf("_") != -1 ? "_" : (URIfragment.indexOf("-") != -1 ? "-" : "camelcase");
        return delimiter;
    }

    private ArrayList<String> getListOfInstructions(String namingInstructions) {
        Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        Matcher m = pat.matcher(namingInstructions);
        while (m.find()) {
            if (this.debuggingOutput) {
                System.out.println("\\" + m.group() + " replaced by " + this.binding.get(m.group()));
            }
            namingInstructions = namingInstructions.replaceAll("\\" + m.group(), this.binding.get(m.group()));
        }
        ArrayList<String> ins = new ArrayList<String>();
        if (namingInstructions.matches(".*camel-case.*")) {
            ins.add(namingInstructions);
            return ins;
        }
        if (namingInstructions.indexOf("+") != -1) {
            StringTokenizer st = new StringTokenizer(namingInstructions, "+");
            String delimiter = this.getDelimiterOfURIfragment(namingInstructions);
            boolean numberMode = false;
            int sum = 0;
            String first = st.nextToken();
            if (first.matches("[0-9]*")) {
                numberMode = true;
                sum = Integer.valueOf(first);
            } else {
                numberMode = false;
                if (!delimiter.equals("camelcase")) {
                    ins.add(String.valueOf(first) + delimiter);
                } else {
                    ins.add(first);
                }
            }
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                if (numberMode) {
                    sum += Integer.valueOf(next).intValue();
                    continue;
                }
                if (!delimiter.equals("camelcase")) {
                    if (st.hasMoreTokens()) {
                        ins.add(String.valueOf(next) + delimiter);
                        continue;
                    }
                    ins.add(next);
                    continue;
                }
                ins.add(next);
            }
            if (numberMode) {
                ins.add(String.valueOf(sum));
            }
        } else if (namingInstructions.indexOf("-") != -1) {
            StringTokenizer st = new StringTokenizer(namingInstructions, "-");
            boolean numberMode = false;
            int sum = 0;
            String first = st.nextToken();
            if (first.matches("[0-9]*")) {
                numberMode = true;
                sum = Integer.valueOf(first);
            } else {
                numberMode = false;
                ins.add(first);
            }
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                if (numberMode) {
                    sum -= Integer.valueOf(next).intValue();
                    continue;
                }
                ins.add(next);
            }
            if (numberMode) {
                ins.add(String.valueOf(sum));
            }
        } else {
            ins.add(namingInstructions);
        }
        return ins;
    }

    @Override
    public StringBuilder getName(String namingInstructions) {
        if (this.debuggingOutput) {
            System.out.println("po vstupu:" + namingInstructions);
        }
        StringBuilder str = new StringBuilder();
        this.instructions = this.getListOfInstructions(namingInstructions);
        boolean plainName = true;
        String naming_function = "";
        String parameter = "";
        if (this.debuggingOutput) {
            System.out.println("instructions:" + this.instructions);
        }
        if (this.instructions.equals("")) {
            return str;
        }
        block3: for (String s : this.instructions) {
            if (s.matches("^.*\\(.*\\)$")) {
                plainName = false;
                Pattern pat = Pattern.compile("^.*\\(");
                Matcher m = pat.matcher(s);
                while (m.find()) {
                    naming_function = m.group();
                }
                naming_function = naming_function.replaceAll("\\(", "");
                pat = Pattern.compile("\\(.*\\)$");
                m = pat.matcher(s);
                while (m.find()) {
                    parameter = m.group();
                }
                parameter = parameter.replaceAll("\\(", "");
                parameter = parameter.replaceAll("\\)", "");
                String hn = "";
                String conceptNames = "";
                if (this.debuggingOutput) {
                    System.out.println("nf:" + naming_function + ",p: " + parameter);
                }
                try {
                    String[] tokens;
                    String delimiter;
                    if (naming_function.equals("head_noun")) {
                        conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                        hn = this.words.getMT(conceptNames);
                        str.append(hn.substring(0, 1).toUpperCase());
                        str.append(hn.substring(1));
                        continue;
                    }
                    if (naming_function.equals("make_passive_verb")) {
                        conceptNames = this.words.secondSplit(this.words.splitName(" " + parameter).toString());
                        if (this.words.nlp.getOneWordTag(parameter = this.words.getMT(conceptNames)).equals("VB")) {
                            this.words.getVerbPassiveForm(parameter);
                            continue;
                        }
                        ArrayList relatedTerms = this.myWordNet.getRelatedWord(parameter);
                        if (relatedTerms == null) {
                            str.append(parameter);
                            continue;
                        }
                        for (String r : relatedTerms) {
                            if (this.words.nlp.getOneWordTag(r).matches("VB.") || this.words.nlp.getOneWordTag(r).equals("VB")) {
                                String passive = this.words.getVerbPassiveForm(r);
                                str.append(String.valueOf(passive.substring(0, 1).toUpperCase()) + passive.substring(1));
                                continue block3;
                            }
                            str.append(parameter);
                        }
                        continue;
                    }
                    if (naming_function.equals("make_delimiter_underscore")) {
                        delimiter = "camel";
                        if (parameter.indexOf("_") != -1) {
                            delimiter = "_";
                        } else if (parameter.indexOf("-") != -1) {
                            delimiter = "-";
                        }
                        if (delimiter.equals("-")) {
                            str.append(parameter.replaceAll("-", "_"));
                            continue;
                        }
                        pat = Pattern.compile("[A-Z]");
                        m = pat.matcher(parameter);
                        tokens = pat.split(parameter);
                        int i = 1;
                        while (m.find()) {
                            if (i == 1) {
                                str.append(String.valueOf(m.group().toLowerCase()) + tokens[i++]);
                                continue;
                            }
                            str.append("-" + m.group().toLowerCase() + tokens[i++]);
                        }
                        str = new StringBuilder(String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1));
                        continue;
                    }
                    if (naming_function.equals("make_delimiter_hyphen")) {
                        delimiter = "camel";
                        if (parameter.indexOf("_") != -1) {
                            delimiter = "_";
                        } else if (parameter.indexOf("-") != -1) {
                            delimiter = "-";
                        }
                        if (delimiter.equals("_")) {
                            str.append(parameter.replaceAll("_", "-"));
                            continue;
                        }
                        pat = Pattern.compile("[A-Z]");
                        m = pat.matcher(parameter);
                        tokens = pat.split(parameter);
                        int i = 1;
                        while (m.find()) {
                            if (i == 1) {
                                str.append(String.valueOf(m.group().toLowerCase()) + tokens[i++]);
                                continue;
                            }
                            str.append("_" + m.group().toLowerCase() + tokens[i++]);
                        }
                        continue;
                    }
                    if (naming_function.equals("make_delimiter_camel-case")) {
                        delimiter = "";
                        if (parameter.indexOf("_") != -1) {
                            delimiter = "_";
                        } else if (parameter.indexOf("-") != -1) {
                            delimiter = "-";
                        }
                        if (delimiter.equals("")) {
                            str.append(parameter);
                            break;
                        }
                        tokens = parameter.split(delimiter);
                        int j = 0;
                        while (j < tokens.length) {
                            if (j > 0) {
                                str.append(tokens[j].substring(0, 1).toUpperCase());
                                str.append(tokens[j].substring(1));
                            } else {
                                str.append(tokens[j]);
                            }
                            ++j;
                        }
                        if (!this.debuggingOutput) continue;
                        System.out.println(Arrays.toString(parameter.split(delimiter)));
                        continue;
                    }
                    if (naming_function.equals("complement_head_noun")) {
                        str.append(this.words.getComplementHeadNoun(parameter));
                        continue;
                    }
                    throw new NamingFunctionException("This function " + naming_function + " is not currently supported. Please wait for the next release.");
                }
                catch (NamingFunctionException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            str.append(s);
        }
        if (plainName && this.binding.containsKey(namingInstructions)) {
            return new StringBuilder(this.binding.get(namingInstructions));
        }
        return str;
    }

    @Override
    public void finish() {
        this.myWordNet.finish();
        this.words.finish();
    }
}

