/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.usecase.logicalreasoning;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;

public class OWL2ELProfileTransformation {
    OntologyTransformation<OWLOntology> transformation;
    String ontologyIRI;
    private boolean debuggingOutput = true;
    PrintWriter summary;

    public OWL2ELProfileTransformation(String ontology) {
        this.ontologyIRI = ontology;
        this.transformation = new OntologyTransformationImpl(ontology);
        try {
            this.summary = new PrintWriter(new FileWriter("/home/ondrej/conferences.papers/RR2012/experiment/transformationSummary-25-05-12.dat", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String detectForbiddenAxioms(boolean remove) {
        String result = "";
        ArrayList<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
        OWL2ELProfile profile = new OWL2ELProfile();
        OWLProfileReport report = profile.checkOntology(this.transformation.getOntology());
        if (this.debuggingOutput) {
            System.out.println("The following axioms are more expressive than OWL2 EL:");
        }
        result = "The following axioms are more expressive than OWL2 EL:";
        int i = 0;
        for (OWLProfileViolation v : report.getViolations()) {
            ++i;
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(i) + ".:" + v + "\n");
            }
            result = String.valueOf(result) + i + ".:" + v + "\n";
            if (v.getAxiom() == null) continue;
            removeAxioms.add(new RemoveAxiom(this.transformation.getOntology(), v.getAxiom()));
        }
        if (remove) {
            this.transformation.getManager().applyChanges(removeAxioms);
            this.transformation.saveOntology("");
        }
        return "," + i;
    }

    private void applySuitableTransformationPatterns() {
        ArrayList<String> queryResults;
        InstructionGeneratorImpl ig;
        TransformationPatternImpl tp1;
        int nr_applications;
        long time;
        OWL2ELProfile profile = new OWL2ELProfile();
        OWLProfileReport report = profile.checkOntology(this.transformation.getOntology());
        String tp1IRI = "";
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        boolean POStagger = false;
        boolean apply_tp_complementEL = false;
        boolean apply_tp_cardinalityEL = false;
        boolean apply_tp_decomposedNominalsELeq = false;
        boolean apply_tp_decomposedNominalsELsub = false;
        for (OWLProfileViolation v : report.getViolations()) {
            if (v.toString().matches(".*ObjectComplementOf\\(ObjectAllValuesFrom.*")) {
                apply_tp_complementEL = true;
                if (!this.debuggingOutput) continue;
                System.out.println("to apply complement TP on " + v.getAxiom());
                continue;
            }
            if (v.toString().matches(".*ObjectMinCardinality.*")) {
                apply_tp_cardinalityEL = true;
                if (!this.debuggingOutput) continue;
                System.out.println("to apply cardinality TP on " + v.getAxiom());
                continue;
            }
            if (v.toString().matches(".*EquivalentClasses\\(.*ObjectOneOf.*")) {
                apply_tp_decomposedNominalsELeq = true;
                if (!this.debuggingOutput) continue;
                System.out.println("to apply decomposed nominals eq TP on " + v.getAxiom());
                continue;
            }
            if (!v.toString().matches(".*SubClassOf\\(.*ObjectOneOf.*") || v.toString().matches(".*SubClassOf\\(.*AllValuesFrom.*")) continue;
            apply_tp_decomposedNominalsELsub = true;
            if (!this.debuggingOutput) continue;
            System.out.println("to apply decomposed nominals sub TP on " + v.getAxiom());
        }
        if (apply_tp_complementEL) {
            long currentTime = 0L;
            currentTime = System.currentTimeMillis();
            time = 0L;
            time = currentTime;
            nr_applications = 0;
            this.transformation.finish();
            this.transformation = new OntologyTransformationImpl(this.ontologyIRI, "/usr/share/WordNet-3.0/", "/usr/share/models/");
            tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_complementEL.xml";
            tp1 = new TransformationPatternImpl(tp1IRI);
            ig = new InstructionGeneratorImpl(tp1, POStagger, this.transformation.getDictionaryPath(), this.transformation.getModelsPath());
            for (String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
                ++nr_applications;
                if (this.debuggingOutput) {
                    System.out.println(s);
                }
                ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
            }
            this.transformation.setInstructions(ig.exportInstructions());
            this.transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
            this.transformation.saveOntology("");
            currentTime = System.currentTimeMillis();
            this.summary.print("," + nr_applications + "," + (currentTime - time));
        } else {
            this.summary.print(",0,0.0");
        }
        if (apply_tp_cardinalityEL) {
            long currentTime = 0L;
            currentTime = System.currentTimeMillis();
            time = 0L;
            time = currentTime;
            nr_applications = 0;
            this.transformation.finish();
            this.transformation = new OntologyTransformationImpl(this.ontologyIRI);
            tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_cardinalityEL.xml";
            tp1 = new TransformationPatternImpl(tp1IRI);
            ig = new InstructionGeneratorImpl(tp1, POStagger, this.transformation.getDictionaryPath(), this.transformation.getModelsPath());
            for (String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
                ++nr_applications;
                if (this.debuggingOutput) {
                    System.out.println(s);
                }
                ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
            }
            this.transformation.setInstructions(ig.exportInstructions());
            System.out.println(ig.exportInstructions());
            if (this.transformation.willTransformOntology()) {
                this.transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
                this.transformation.saveOntology("");
                currentTime = System.currentTimeMillis();
                this.summary.print("," + nr_applications + "," + (currentTime - time));
            } else {
                this.summary.print(",0,0.0");
            }
        } else {
            this.summary.print(",0,0.0");
        }
        if (apply_tp_cardinalityEL) {
            long currentTime = 0L;
            currentTime = System.currentTimeMillis();
            time = 0L;
            time = currentTime;
            nr_applications = 0;
            this.transformation.finish();
            this.transformation = new OntologyTransformationImpl(this.ontologyIRI);
            tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_cardinalityEL1.xml";
            tp1 = new TransformationPatternImpl(tp1IRI);
            ig = new InstructionGeneratorImpl(tp1, POStagger, this.transformation.getDictionaryPath(), this.transformation.getModelsPath());
            for (String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
                ++nr_applications;
                if (this.debuggingOutput) {
                    System.out.println(s);
                }
                ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
            }
            this.transformation.setInstructions(ig.exportInstructions());
            if (this.transformation.willTransformOntology()) {
                this.transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
                this.transformation.saveOntology("");
                currentTime = System.currentTimeMillis();
                this.summary.print("," + nr_applications + "," + (currentTime - time));
            } else {
                this.summary.print(",0,0.0");
            }
        } else {
            this.summary.print(",0,0.0");
        }
        if (apply_tp_decomposedNominalsELeq) {
            long currentTime = 0L;
            currentTime = System.currentTimeMillis();
            time = 0L;
            time = currentTime;
            nr_applications = 0;
            tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
            tp1 = new TransformationPatternImpl(tp1IRI);
            queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
            while (queryResults.size() > 0) {
                this.transformation.finish();
                this.transformation = new OntologyTransformationImpl(this.ontologyIRI);
                ig = new InstructionGeneratorImpl(tp1, POStagger, this.transformation.getDictionaryPath(), this.transformation.getModelsPath());
                for (String s : queryResults) {
                    ++nr_applications;
                    if (this.debuggingOutput) {
                        System.out.println(s);
                    }
                    ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
                }
                if (this.debuggingOutput) {
                    System.out.println(ig.exportInstructions());
                }
                this.transformation.setInstructions(ig.exportInstructions());
                if (this.transformation.willTransformOntology()) {
                    this.transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
                    this.transformation.saveOntology("");
                }
                tp1 = new TransformationPatternImpl(tp1IRI);
                detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
                queryResults.clear();
                queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
            }
            currentTime = System.currentTimeMillis();
            this.summary.print("," + nr_applications + "," + (currentTime - time));
        } else {
            this.summary.print(",0,0.0");
        }
        if (apply_tp_decomposedNominalsELsub) {
            long currentTime = 0L;
            currentTime = System.currentTimeMillis();
            time = 0L;
            time = currentTime;
            nr_applications = 0;
            tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELb.xml";
            tp1 = new TransformationPatternImpl(tp1IRI);
            queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
            while (queryResults.size() > 0) {
                this.transformation.finish();
                this.transformation = new OntologyTransformationImpl(this.ontologyIRI);
                ig = new InstructionGeneratorImpl(tp1, POStagger, this.transformation.getDictionaryPath(), this.transformation.getModelsPath());
                for (String s : queryResults) {
                    ++nr_applications;
                    if (this.debuggingOutput) {
                        System.out.println(s);
                    }
                    ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
                }
                if (this.debuggingOutput) {
                    System.out.println(ig.exportInstructions());
                }
                this.transformation.setInstructions(ig.exportInstructions());
                if (this.transformation.willTransformOntology()) {
                    this.transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
                    this.transformation.saveOntology("");
                }
                tp1 = new TransformationPatternImpl(tp1IRI);
                detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
                queryResults.clear();
                queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
            }
            currentTime = System.currentTimeMillis();
            this.summary.print("," + nr_applications + "," + (currentTime - time));
        } else {
            this.summary.print(",0,0.0");
        }
    }

    public void runTransformationToOWL2ELProfile() {
        this.transformation.preprocessOntology();
        this.transformation.saveOntology("");
        this.ontologyIRI = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + this.ontologyIRI.substring(this.ontologyIRI.lastIndexOf("/") + 1, this.ontologyIRI.lastIndexOf(".")) + ".owl";
        this.summary.print(this.detectForbiddenAxioms(false));
        this.applySuitableTransformationPatterns();
        this.transformation.preprocessOntology();
        this.transformation.finish();
        this.transformation = new OntologyTransformationImpl(this.ontologyIRI);
        this.summary.print(this.detectForbiddenAxioms(true));
        this.summary.println(this.detectForbiddenAxioms(false));
        this.transformation.saveOntology("");
        this.transformation.finish();
        this.summary.close();
    }

    public static void main(String[] args) {
        String path = "file:///home/ondrej/conferences.papers/RR2012/experiment/ontologies/";
        int i = 1;
        while (i < 64) {
            System.out.println("ontology:" + i);
            File soubor = new File("/home/ondrej/conferences.papers/RR2012/experiment/ontologies/" + i + ".owl");
            if (soubor.canRead()) {
                OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation(String.valueOf(path) + i + ".owl");
                elProfileTr.summary.print(String.valueOf(i) + ".owl");
                elProfileTr.runTransformationToOWL2ELProfile();
            }
            ++i;
        }
    }
}

