/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.detection;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import cz.vse.keg.patomat.detection.OntologyPatternDetection;
import cz.vse.keg.patomat.naming.NamingConstraintsImpl;
import cz.vse.keg.patomat.transformation.pattern.NameDetectionPattern;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformation;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class OntologyPatternDetectionImpl
implements OntologyPatternDetection {
    private String patternURI = "";
    private String ontologyURI = "";
    private String query = "";
    private ArrayList<SubClassOfPair> subClassOfs = null;
    private String ontologyNamespace = "";
    private String dictionaryPath;
    private String modelsPath;
    private int numberGeneratedPlaceholders = 1;
    private boolean debuggingOutput = false;

    public OntologyPatternDetectionImpl(String dictionaryPath, String modelsPath) {
        this.dictionaryPath = dictionaryPath;
        this.modelsPath = modelsPath;
    }

    private String getBaseURI(OWLOntologyManager manager, OWLOntology ontology, String namespace) {
        Map nsMap = null;
        OWLOntologyFormat format = manager.getOntologyFormat(ontology);
        if (format instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat nsFormat = (PrefixOWLOntologyFormat)format;
            nsMap = nsFormat.getPrefixName2PrefixMap();
            return (String)nsMap.get(namespace);
        }
        return "";
    }

    public String getOntologyNamespace() {
        return this.ontologyNamespace;
    }

    @Override
    public ArrayList<HashMap<String, String>> getPlaceholdersBinding() {
        return null;
    }

    @Override
    public ArrayList<String> queryPattern(String patternURI, String ontologyURI, boolean xmlSerialization, boolean reasoner) {
        return null;
    }

    public void initBasicQueryForRecursion(TransformationPattern tp, String ontologyURI) {
        OntologyPattern pattern = tp.getOP1();
        this.ontologyURI = ontologyURI;
        this.patternURI = tp.getLocation();
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        if (ontologyURI.matches("^http.*") || ontologyURI.matches("^file.*")) {
            m.read(ontologyURI);
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(ontologyURI.getBytes());
            m.read((InputStream)in, "");
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StringBuilder query = new StringBuilder();
        String queryBegin = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
        for (String s : pattern.getNamespaces().keySet()) {
            queryBegin = String.valueOf(queryBegin) + "PREFIX " + pattern.getNamespaces().get(s) + ": <" + s + ">\n";
        }
        queryBegin = String.valueOf(queryBegin) + "\nSELECT * \nWHERE {\n";
        String queryEnd = "}";
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> individuals = new ArrayList<String>();
        query.append(queryBegin);
        for (String p : pattern.getPlaceholders().keySet()) {
            if (pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.Class)) {
                query.append(String.valueOf(p) + " rdf:type owl:Class.\n");
                classes.add(p);
                continue;
            }
            if (pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.ObjectProperty)) {
                query.append(String.valueOf(p) + " rdf:type owl:ObjectProperty.\n");
                properties.add(p);
                continue;
            }
            if (pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.DatatypeProperty)) {
                query.append(String.valueOf(p) + " rdf:type owl:DataProperty.\n");
                properties.add(p);
                continue;
            }
            if (!pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.Individual)) continue;
            query.append(String.valueOf(p) + " rdf:type owl:Individual.\n");
            individuals.add(p);
        }
        String filter = "";
        if (classes.size() >= 2 || properties.size() >= 2 || individuals.size() >= 2) {
            int j;
            filter = "FILTER (";
            if (classes.size() >= 2) {
                int i = 0;
                while (i < classes.size()) {
                    j = i + 1;
                    while (j < classes.size()) {
                        if (i != j) {
                            filter = String.valueOf(filter) + (String)classes.get(i);
                            filter = String.valueOf(filter) + " != " + (String)classes.get(j);
                            if (i + 2 != classes.size() || j + 1 != classes.size()) {
                                filter = String.valueOf(filter) + " && ";
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (properties.size() >= 2) {
                if (classes.size() >= 2) {
                    filter = String.valueOf(filter) + " && ";
                }
                int i = 0;
                while (i < properties.size()) {
                    j = i + 1;
                    while (j < properties.size()) {
                        if (i != j) {
                            filter = String.valueOf(filter) + (String)properties.get(i);
                            filter = String.valueOf(filter) + " != " + (String)properties.get(j);
                            if (i + 2 != properties.size() || j + 1 != properties.size()) {
                                filter = String.valueOf(filter) + " && ";
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (individuals.size() >= 2) {
                if (classes.size() >= 2 || properties.size() >= 2) {
                    filter = String.valueOf(filter) + " && ";
                }
                int i = 0;
                while (i < individuals.size()) {
                    j = 2;
                    while (j < individuals.size()) {
                        filter = String.valueOf(filter) + (String)individuals.get(i);
                        filter = String.valueOf(filter) + " != " + (String)individuals.get(j);
                        if (i + 2 != individuals.size() || j + 1 != individuals.size()) {
                            filter = String.valueOf(filter) + " && ";
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            filter = String.valueOf(filter) + ")\n";
        }
        String[] placeholders = new String[4];
        for (String axiom : pattern.getAxioms()) {
            Pattern pat;
            String originalAxiom;
            if (axiom.matches(".*\\{.*\\}")) {
                originalAxiom = axiom;
                originalAxiom = originalAxiom.replaceAll("\\{", "(");
                originalAxiom = originalAxiom.replaceAll("\\}", ")");
                originalAxiom = originalAxiom.replaceAll(",", " ");
                originalAxiom = originalAxiom.replaceAll(" $", "");
                originalAxiom = originalAxiom.substring(originalAxiom.indexOf("("));
                if (axiom.matches(".*equivalentTo.*")) {
                    axiom = axiom.replaceAll("\\{.*\\}", "");
                    axiom = axiom.replaceAll("equivalentTo", "owl:equivalentClass");
                    axiom = String.valueOf(axiom) + " _:oneOf1.\n_:oneOf1 owl:oneOf " + originalAxiom + ".\n";
                } else if (axiom.matches(".*subClassOf.*")) {
                    axiom = axiom.replaceAll("\\{.*\\}", "");
                    axiom = axiom.replaceAll("subClassOf", "rdfs:subClassOf");
                    axiom = String.valueOf(axiom) + " _:oneOf1.\n_:oneOf1 owl:oneOf " + originalAxiom + ".\n";
                }
                query.append(axiom);
                continue;
            }
            if (axiom.matches(".*value.*") || axiom.matches(".*some.*") || axiom.matches(".*only.*") || axiom.matches(".*min.*") || axiom.matches(".*max.*") || axiom.matches(".*exactly.*")) {
                originalAxiom = axiom;
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                Matcher matcher = pat.matcher(axiom);
                int p = 0;
                while (matcher.find()) {
                    placeholders[p] = matcher.group();
                    ++p;
                }
                if (originalAxiom.matches(".*subClassOf.*")) {
                    axiom = String.valueOf(placeholders[0]) + " rdfs:subClassOf _:restriction1.\n_:restriction1 rdf:type owl:Restriction.\n";
                } else if (originalAxiom.matches(".*equivalentTo.*")) {
                    axiom = String.valueOf(placeholders[0]) + " owl:equivalentClass _:restriction1.\n_:restriction1\trdf:type owl:Restriction.\n";
                }
                axiom = String.valueOf(axiom) + "_:restriction1 owl:onProperty " + placeholders[1] + ".\n";
                if (originalAxiom.matches(".*value.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction1 owl:hasValue " + placeholders[2] + ".\n";
                } else if (originalAxiom.matches(".*some.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction1 owl:someValuesFrom " + placeholders[2] + ".\n";
                } else if (originalAxiom.matches(".*only.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction1 owl:allValuesFrom " + placeholders[2] + ".\n";
                } else if (originalAxiom.matches(".*min.*")) {
                    if (!placeholders[3].isEmpty()) {
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:minQualifiedCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:onClass " + placeholders[3] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    } else {
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:minCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    }
                } else if (originalAxiom.matches(".*max.*")) {
                    if (!placeholders[3].isEmpty()) {
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:maxQualifiedCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:onClass " + placeholders[3] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    } else {
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:maxCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[2] + " rdf:type owl:ObjectProperty";
                    }
                } else if (originalAxiom.matches(".*exactly.*")) {
                    if (!placeholders[3].isEmpty()) {
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:qualifiedCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:onClass " + placeholders[3] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    } else {
                        axiom = String.valueOf(axiom) + "_:restriction1 owl:cardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    }
                }
                query.append(axiom);
                continue;
            }
            if (axiom.matches(".*annotation.*")) continue;
            for (String s : pattern.getNamespaces().keySet()) {
                axiom = axiom.replaceAll(s, String.valueOf(pattern.getNamespaces().get(s)) + ":");
            }
            if (axiom.matches(".*subClassOf.*")) {
                originalAxiom = axiom;
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                Matcher matcher = pat.matcher(axiom);
                boolean p = false;
                String subsumed = "";
                String subsumer = "";
                if (matcher.find()) {
                    subsumed = matcher.group();
                }
                if (matcher.find()) {
                    subsumer = matcher.group();
                }
                if (!subsumer.equals("") && !subsumed.equals("")) {
                    this.subClassOfs.add(new SubClassOfPair(subsumer, subsumed));
                }
            }
            axiom = axiom.replace("domain", "rdfs:domain");
            axiom = axiom.replace("range", "rdfs:range");
            axiom = axiom.replace("subClassOf", "rdfs:subClassOf");
            axiom = axiom.replace("equivalentTo", "owl:equivalentClass");
            axiom = axiom.replace("disjointWith", "owl:disjointWith");
            axiom = axiom.replace("propertyDisjointWith", "owl:propertyDisjointWith");
            query.append(String.valueOf(axiom) + ".\n");
        }
        query.append(filter);
        query.append(queryEnd);
        if (this.debuggingOutput) {
            System.out.println(query);
        }
        this.query = query.toString();
        m.close();
    }

    @Override
    public ArrayList<String> queryPattern(TransformationPattern tp, String ontologyURI, boolean xmlSerialization, boolean reasoner) {
        boolean sparqlDL = false;
        this.subClassOfs = new ArrayList();
        OntologyPattern pattern = tp.getOP1();
        this.ontologyURI = ontologyURI;
        this.patternURI = tp.getLocation();
        OntModel m = reasoner ? ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC) : ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntDocumentManager dm = m.getDocumentManager();
        dm.setProcessImports(false);
        if (ontologyURI.matches("^http.*") || ontologyURI.matches("^file.*")) {
            m.read(ontologyURI);
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(ontologyURI.getBytes());
            m.read((InputStream)in, "");
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StringBuilder query = new StringBuilder();
        String queryBegin = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX sparqldl: <http://pellet.owldl.com/ns/sdle#>\n";
        for (String s : pattern.getNamespaces().keySet()) {
            queryBegin = String.valueOf(queryBegin) + "PREFIX " + pattern.getNamespaces().get(s) + ": <" + s + ">\n";
        }
        queryBegin = String.valueOf(queryBegin) + "\nSELECT * \nWHERE {\n";
        String queryEnd = "}";
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> individuals = new ArrayList<String>();
        query.append(queryBegin);
        for (String p : pattern.getPlaceholders().keySet()) {
            if (pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.Class)) {
                query.append(String.valueOf(p) + " rdf:type owl:Class.\n");
                classes.add(p);
                continue;
            }
            if (pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.ObjectProperty)) {
                query.append(String.valueOf(p) + " rdf:type owl:ObjectProperty.\n");
                properties.add(p);
                continue;
            }
            if (pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.DatatypeProperty)) {
                query.append(String.valueOf(p) + " rdf:type owl:DataProperty.\n");
                properties.add(p);
                continue;
            }
            if (!pattern.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.Individual)) continue;
            query.append(String.valueOf(p) + " rdf:type owl:Individual.\n");
            individuals.add(p);
        }
        String filter = "";
        if (classes.size() >= 2 || properties.size() >= 2 || individuals.size() >= 2) {
            int j;
            filter = "FILTER (";
            if (classes.size() >= 2) {
                int i = 0;
                while (i < classes.size()) {
                    j = i + 1;
                    while (j < classes.size()) {
                        if (i != j) {
                            filter = String.valueOf(filter) + (String)classes.get(i);
                            filter = String.valueOf(filter) + " != " + (String)classes.get(j);
                            if (i + 2 != classes.size() || j + 1 != classes.size()) {
                                filter = String.valueOf(filter) + " && ";
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (properties.size() >= 2) {
                if (classes.size() >= 2) {
                    filter = String.valueOf(filter) + " && ";
                }
                int i = 0;
                while (i < properties.size()) {
                    j = i + 1;
                    while (j < properties.size()) {
                        if (i != j) {
                            filter = String.valueOf(filter) + (String)properties.get(i);
                            filter = String.valueOf(filter) + " != " + (String)properties.get(j);
                            if (i + 2 != properties.size() || j + 1 != properties.size()) {
                                filter = String.valueOf(filter) + " && ";
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (individuals.size() >= 2) {
                if (classes.size() >= 2 || properties.size() >= 2) {
                    filter = String.valueOf(filter) + " && ";
                }
                int i = 0;
                while (i < individuals.size()) {
                    j = 2;
                    while (j < individuals.size()) {
                        filter = String.valueOf(filter) + (String)individuals.get(i);
                        filter = String.valueOf(filter) + " != " + (String)individuals.get(j);
                        if (i + 2 != individuals.size() || j + 1 != individuals.size()) {
                            filter = String.valueOf(filter) + " && ";
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            filter = String.valueOf(filter) + ")\n";
        }
        String[] placeholders = new String[3];
        for (String axiom : pattern.getAxioms()) {
            Pattern pat;
            String originalAxiom;
            if (axiom.matches(".*@.*")) {
                if (axiom.matches(".*@{\\?[0-9a-zA-Z_]*}")) {
                    if (!this.debuggingOutput) continue;
                    System.out.println("constructor expansion operator @ applied on oneOf");
                    continue;
                }
                axiom.matches(".*@unionOf(\\?[0-9a-zA-Z_]*)");
                continue;
            }
            if (axiom.matches(".*not.*")) {
                originalAxiom = axiom;
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                Matcher matcher = pat.matcher(axiom);
                int p = 0;
                while (matcher.find()) {
                    placeholders[p] = matcher.group();
                    ++p;
                }
                if (placeholders[2] != null) {
                    if (originalAxiom.matches(".*subClassOf.*")) {
                        axiom = String.valueOf(placeholders[0]) + " rdfs:subClassOf _:complement1.\n_:complement1 owl:complementOf _:restriction1.\n_:restriction1 rdf:type owl:Restriction.\n";
                    } else if (originalAxiom.matches(".*equivalentTo.*")) {
                        axiom = String.valueOf(placeholders[0]) + " owl:equivalentClass _:complement1.\n_:complement1 owl:complementOf _:restriction1.\n_:restriction1\trdf:type owl:Restriction.\n";
                    }
                    axiom = String.valueOf(axiom) + "_:restriction1 owl:onProperty " + placeholders[1] + ".\n";
                    if (originalAxiom.matches(".*min.*")) {
                        if (placeholders[3] != null) {
                            axiom = String.valueOf(axiom) + "_:restriction1 owl:minQualifiedCardinality " + placeholders[2] + ".\n";
                            axiom = String.valueOf(axiom) + "_:restriction1 owl:onClass " + placeholders[3] + ".\n";
                            axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                        } else {
                            axiom = String.valueOf(axiom) + "_:restriction1 owl:minCardinality " + placeholders[2] + ".\n";
                            axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                        }
                    }
                } else if (originalAxiom.matches(".*subClassOf.*")) {
                    axiom = String.valueOf(placeholders[0]) + " rdfs:subClassOf _:complement1.\n_:complement1 owl:complementOf " + placeholders[1] + ".\n";
                } else if (originalAxiom.matches(".*equivalentTo.*")) {
                    axiom = String.valueOf(placeholders[0]) + " owl:equivalentClass _:complement1.\n_:complement1 owl:complementOf " + placeholders[1] + ".\n";
                }
                query.append(axiom);
                continue;
            }
            if (axiom.matches(".*value.*") || axiom.matches(".*some.*") || axiom.matches(".*only.*")) {
                originalAxiom = axiom;
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                Matcher matcher = pat.matcher(axiom);
                int p = 0;
                while (matcher.find()) {
                    placeholders[p] = matcher.group();
                    ++p;
                }
                if (originalAxiom.matches("subClassOf")) {
                    axiom = String.valueOf(placeholders[0]) + " rdfs:subClassOfs _:restriction1.\n_:restriction1 rdf:type owl:Restriction.\n";
                } else if (originalAxiom.matches(".*equivalentTo.*")) {
                    axiom = String.valueOf(placeholders[0]) + " owl:equivalentClass _:restriction1.\n_:restriction1\trdf:type owl:Restriction.\n";
                }
                axiom = String.valueOf(axiom) + "_:restriction1 owl:onProperty " + placeholders[1] + ".\n";
                if (originalAxiom.matches(".*value.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction1 owl:hasValue " + placeholders[2] + ".\n";
                } else if (originalAxiom.matches(".*some.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction1 owl:someValuesFrom " + placeholders[2] + ".\n";
                } else if (originalAxiom.matches(".*only.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction1 owl:allValuesFrom " + placeholders[2] + ".\n";
                }
                query.append(axiom);
                continue;
            }
            if (axiom.matches(".*annotation.*")) continue;
            for (String s : pattern.getNamespaces().keySet()) {
                axiom = axiom.replaceAll(s, String.valueOf(pattern.getNamespaces().get(s)) + ":");
            }
            if (axiom.matches(".*directSubClassOf.*")) {
                sparqlDL = true;
            } else if (axiom.matches(".*subClassOf.*")) {
                originalAxiom = axiom;
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                Matcher matcher = pat.matcher(axiom);
                boolean p = false;
                String subsumed = "";
                String subsumer = "";
                if (matcher.find()) {
                    subsumed = matcher.group();
                }
                if (matcher.find()) {
                    subsumer = matcher.group();
                }
                if (!subsumer.equals("") && !subsumed.equals("")) {
                    this.subClassOfs.add(new SubClassOfPair(subsumer, subsumed));
                }
            }
            axiom = axiom.replace("domain", "rdfs:domain");
            axiom = axiom.replace("range", "rdfs:range");
            axiom = axiom.replace("subClassOf", "rdfs:subClassOf");
            axiom = axiom.replace("equivalentTo", "owl:equivalentClass");
            axiom = axiom.replace("disjointWith", "owl:disjointWith");
            axiom = axiom.replace("propertyDisjointWith", "owl:propertyDisjointWith");
            axiom = axiom.replace("directSubClassOf", "sparqldl:directSubClassOf");
            query.append(String.valueOf(axiom) + ".\n");
        }
        query.append(filter);
        query.append(queryEnd);
        if (this.debuggingOutput) {
            System.out.println(query);
        }
        this.query = query.toString();
        Query q = QueryFactory.create((String)query.toString());
        QueryExecution qe = sparqlDL ? SparqlDLExecutionFactory.create((Query)q, (Model)m) : QueryExecutionFactory.create((Query)q, (Model)m);
        if (this.debuggingOutput) {
            System.out.println("setting: anonymous/Thing/Nothing checking on, naming aspect off (nextOne=true)");
        }
        long currentTime = 0L;
        long time = 0L;
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right before the SPARQL query execution:" + currentTime);
        }
        time = currentTime;
        ResultSet rs = qe.execSelect();
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right after the SPARQL query execution (delta):" + (currentTime - time));
        }
        time = currentTime;
        ArrayList<String> query_results = new ArrayList<String>();
        HashMap<String, String> sparqlBinding = new HashMap<String, String>();
        String value = "";
        RDFNode node = null;
        boolean nextOne = false;
        NamingConstraintsImpl nsc = new NamingConstraintsImpl(true, this.dictionaryPath, this.modelsPath);
        int combinations = 0;
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right before the xxx SPARQL results processing (delta):" + (currentTime - time));
        }
        time = currentTime;
        ArrayList<String> placeholdersOP1inNDPs = new ArrayList<String>();
        ArrayList<String> placeholdersOP1NOTinNDPs = new ArrayList<String>();
        for (NameDetectionPattern ndp : pattern.getNameDetectionPatterns()) {
            placeholdersOP1inNDPs.addAll(ndp.getInvolvedPlaceholders());
        }
        for (String s : pattern.getPlaceholders().keySet()) {
            if (placeholdersOP1inNDPs.contains(s)) continue;
            placeholdersOP1NOTinNDPs.add(s);
        }
        while (rs.hasNext()) {
            ++combinations;
            nextOne = false;
            sparqlBinding.clear();
            QuerySolution solution = (QuerySolution)rs.next();
            for (String p : placeholdersOP1inNDPs) {
                node = solution.get(p);
                if (node.isAnon()) {
                    nextOne = true;
                    break;
                }
                value = node.toString();
                if (this.ontologyNamespace.equals("")) {
                    this.ontologyNamespace = value.substring(0, value.indexOf("#") + 1);
                }
                if ((value = value.indexOf("#") != -1 ? value.substring(value.indexOf("#") + 1) : value.substring(value.lastIndexOf("/") + 1)).equals("Thing") || value.equals("Nothing")) {
                    nextOne = true;
                    break;
                }
                sparqlBinding.put(p, value);
            }
            if (this.debuggingOutput) {
                System.out.println(pattern.getNameDetectionPatterns() + " " + nextOne);
            }
            if (nextOne || !nsc.checkNamingConstraints(sparqlBinding, pattern.getNameDetectionPatterns(), true)) continue;
            for (String p : placeholdersOP1NOTinNDPs) {
                node = solution.get(p);
                if (node.isAnon()) {
                    nextOne = true;
                    break;
                }
                value = node.toString();
                if (this.ontologyNamespace.equals("")) {
                    this.ontologyNamespace = value.substring(0, value.indexOf("#") + 1);
                }
                if ((value = value.substring(value.indexOf("#") + 1)).equals("Thing") || value.equals("Nothing")) {
                    nextOne = true;
                    break;
                }
                sparqlBinding.put(p, value);
            }
            if (xmlSerialization) {
                query_results.add(this.outputXML(sparqlBinding));
                continue;
            }
            query_results.add(this.outputPlain(sparqlBinding));
        }
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right after the SPARQL results processing (delta):" + (currentTime - time));
        }
        time = currentTime;
        if (this.debuggingOutput) {
            System.out.println(String.valueOf(combinations) + " different combinations");
        }
        nsc.finish();
        m.close();
        return query_results;
    }

    public ArrayList<String> queryPatternNamingAspect(TransformationPattern pattern, String ontologyURI, boolean xmlSerialization, boolean reasoner) {
        long currentTime = 0L;
        long time = 0L;
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right before the detection:" + currentTime);
        }
        time = currentTime;
        OntologyPattern op = pattern.getOP1();
        OWLOntology ontology = null;
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        try {
            if (ontologyURI.matches("^http.*") || ontologyURI.matches("^file.*")) {
                ontology = manager.loadOntologyFromOntologyDocument(IRI.create((String)ontologyURI));
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(ontologyURI.getBytes());
                ontology = manager.loadOntologyFromOntologyDocument((InputStream)in);
            }
            this.ontologyNamespace = this.getBaseURI(manager, ontology, ":");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (OWLClass cls : ontology.getClassesInSignature()) {
            if (!(cls instanceof OWLNamedObject)) continue;
            classes.add(cls.toStringID().substring(cls.toStringID().indexOf("#") + 1));
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (OWLObjectProperty oprp : ontology.getObjectPropertiesInSignature()) {
            if (!(oprp instanceof OWLNamedObject)) continue;
            properties.add(oprp.toStringID().substring(oprp.toStringID().indexOf("#") + 1));
        }
        for (OWLDataProperty dprp : ontology.getDataPropertiesInSignature()) {
            if (!(dprp instanceof OWLNamedObject)) continue;
            properties.add(dprp.toStringID().substring(dprp.toStringID().indexOf("#") + 1));
        }
        ArrayList<String> individuals = new ArrayList<String>();
        for (OWLNamedIndividual ind : ontology.getIndividualsInSignature()) {
            individuals.add(ind.toStringID().substring(ind.toStringID().indexOf("#") + 1));
        }
        NamingConstraintsImpl nsc = new NamingConstraintsImpl(true, this.dictionaryPath, this.modelsPath);
        ArrayList<HashMap<String, List<String>>> placeholdersBinding = nsc.checkNamingConstraints(op, classes, properties, individuals, op.getNameDetectionPatterns());
        if (this.debuggingOutput) {
            System.out.println("placeholdersBinding " + placeholdersBinding);
        }
        ArrayList<String> results = this.queryPatternStructuralAspect(pattern, ontologyURI, placeholdersBinding, xmlSerialization, reasoner);
        if (this.debuggingOutput) {
            System.out.println("results " + results);
        }
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right after the detection (delta):" + (currentTime - time));
        }
        time = currentTime;
        nsc.finish();
        return results;
    }

    private void addPlaceholdersMapping(HashMap<String, ArrayList<String>> mappingsPlaceholders, String currentPlaceholder, int u) {
        if (mappingsPlaceholders.containsKey(currentPlaceholder)) {
            ArrayList<String> pls = mappingsPlaceholders.get(currentPlaceholder);
            pls.add(String.valueOf(currentPlaceholder) + (u + 1));
        } else {
            ArrayList<String> pls = new ArrayList<String>();
            pls.add(String.valueOf(currentPlaceholder) + (u + 1));
            mappingsPlaceholders.put(currentPlaceholder, pls);
        }
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<String> queryPatternStructuralAspect(TransformationPattern tp, String ontologyURI, ArrayList<HashMap<String, List<String>>> placeholdersBinding, boolean xmlSerialization, boolean reasoner) {
        this.subClassOfs = new ArrayList<E>();
        patternOP1 = tp.getOP1();
        m = reasoner != false ? ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC) : ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        this.ontologyURI = ontologyURI;
        this.patternURI = tp.getLocation();
        if (ontologyURI.matches("^http.*") || ontologyURI.matches("^file.*")) {
            m.read(ontologyURI);
        } else {
            in = new ByteArrayInputStream(ontologyURI.getBytes());
            m.read((InputStream)in, "");
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        query = new StringBuilder();
        queryBegin = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
        for (String s : patternOP1.getNamespaces().keySet()) {
            queryBegin = String.valueOf(queryBegin) + "PREFIX " + patternOP1.getNamespaces().get(s) + ": <" + s + ">\n";
        }
        queryBegin = String.valueOf(queryBegin) + "\nSELECT * \nWHERE {\n";
        queryEnd = "}";
        classes = new ArrayList<String>();
        properties = new ArrayList<String>();
        individuals = new ArrayList<String>();
        query.append(queryBegin);
        if (!placeholdersBinding.isEmpty()) {
            for (String p : patternOP1.getPlaceholders().keySet()) {
                if (patternOP1.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.Class)) {
                    classes.add(p);
                    continue;
                }
                if (patternOP1.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.ObjectProperty)) {
                    properties.add(p);
                    continue;
                }
                if (patternOP1.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.DatatypeProperty)) {
                    properties.add(p);
                    continue;
                }
                if (!patternOP1.getPlaceholders().get(p).equals((Object)OntologyPattern.EntityType.Individual)) continue;
                individuals.add(p);
            }
        }
        filter = "";
        if (!placeholdersBinding.isEmpty()) {
            andCombinationsAll = new ArrayList<ArrayList<E>>();
            combination = "";
            for (HashMap<String, List<String>> placeholdersBindingOne : placeholdersBinding) {
                andCombinations = new ArrayList<String>();
                lists = new ArrayList<ArrayList>(placeholdersBindingOne.size());
                placeholders1 = new ArrayList<String>();
                max = 0;
                for (String s : placeholdersBindingOne.keySet()) {
                    list = (ArrayList)placeholdersBindingOne.get(s);
                    lists.add(list);
                    placeholders1.add(s);
                    max = list.size();
                }
                i = 0;
                while (i < max) {
                    j = 0;
                    for (ArrayList li : lists) {
                        if (li.size() - 1 >= i) {
                            combination = j == 0 ? String.valueOf(combination) + (String)placeholders1.get(j) + "=<" + this.ontologyNamespace + (String)li.get(i) + ">" : String.valueOf(combination) + " && " + (String)placeholders1.get(j) + "=<" + this.ontologyNamespace + (String)li.get(i) + ">";
                        }
                        ++j;
                    }
                    andCombinations.add(combination);
                    combination = "";
                    ++i;
                }
                andCombinationsAll.add(andCombinations);
            }
            numberOfComparisons = andCombinationsAll.size();
            combined = new ArrayList<E>();
            if (numberOfComparisons > 1) {
                combined = this.combineTwoComparisons((ArrayList)andCombinationsAll.get(0), (ArrayList)andCombinationsAll.get(1));
                i = 2;
                while (i < numberOfComparisons) {
                    combined = this.combineTwoComparisons(combined, (ArrayList)andCombinationsAll.get(i));
                    ++i;
                }
                if (this.debuggingOutput) {
                    System.out.println("final combined:" + combined);
                }
            } else {
                if (this.debuggingOutput) {
                    System.out.println("just only one COMPARSION in TP");
                }
                if (((ArrayList)andCombinationsAll.get(0)).size() > 1) {
                    j = 0;
                    while (j < ((ArrayList)andCombinationsAll.get(0)).size() - 1) {
                        combined.add((String)((ArrayList)andCombinationsAll.get(0)).get(j) + " || " + (String)((ArrayList)andCombinationsAll.get(0)).get(j + 1));
                        ++j;
                    }
                } else if (((ArrayList)andCombinationsAll.get(0)).size() > 0) {
                    combined.add((String)((ArrayList)andCombinationsAll.get(0)).get(0));
                }
            }
            if (!combined.isEmpty()) {
                filter = "FILTER (";
                i = 0;
                while (i < combined.size()) {
                    filter = String.valueOf(filter) + (String)combined.get(i) + "\n";
                    if (i != combined.size() - 1) {
                        filter = String.valueOf(filter) + " || ";
                    }
                    ++i;
                }
                filter = String.valueOf(filter) + ") \n";
            }
        } else if (classes.size() >= 2 || properties.size() >= 2 || individuals.size() >= 2) {
            if (placeholdersBinding.isEmpty()) {
                filter = "FILTER (";
            }
            if (classes.size() >= 2) {
                i = 0;
                while (i < classes.size()) {
                    j = i + 1;
                    while (j < classes.size()) {
                        if (i != j) {
                            filter = String.valueOf(filter) + (String)classes.get(i);
                            filter = String.valueOf(filter) + " != " + (String)classes.get(j);
                            if (i + 2 != classes.size() || j + 1 != classes.size()) {
                                filter = String.valueOf(filter) + " && ";
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (properties.size() >= 2) {
                if (classes.size() >= 2) {
                    filter = String.valueOf(filter) + " && ";
                }
                i = 0;
                while (i < properties.size()) {
                    j = i + 1;
                    while (j < properties.size()) {
                        if (i != j) {
                            filter = String.valueOf(filter) + (String)properties.get(i);
                            filter = String.valueOf(filter) + " != " + (String)properties.get(j);
                            if (i + 2 != properties.size() || j + 1 != properties.size()) {
                                filter = String.valueOf(filter) + " && ";
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (individuals.size() >= 2) {
                if (classes.size() >= 2 || properties.size() >= 2) {
                    filter = String.valueOf(filter) + " && ";
                }
                i = 0;
                while (i < individuals.size()) {
                    j = i + 1;
                    while (j < individuals.size()) {
                        filter = String.valueOf(filter) + (String)individuals.get(i);
                        filter = String.valueOf(filter) + " != " + (String)individuals.get(j);
                        if (i + 2 != individuals.size() || j + 1 != individuals.size()) {
                            filter = String.valueOf(filter) + " && ";
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            filter = String.valueOf(filter) + ")\n";
        }
        placeholders = new String[4];
        toReplaceOP1Axioms = new HashMap<String, String[]>();
        toReplaceOP2Axioms = new HashMap<Object, String[]>();
        patternOP2 = tp.getOP2();
        oldOP2placeholders = new ArrayList<String>();
        mappingsOP1Placeholders = new HashMap<String, ArrayList>();
        mappingsOP2Placeholders = new HashMap<String, ArrayList>();
        numberOfMultiplication = 0;
        OP2axiomsToInspect = new ArrayList<String>();
        notMultipliedPlaceholdersOP1 = new ArrayList<String>();
        notMultipliedPlaceholdersOP2 = new ArrayList<String>();
        for (String axiom : patternOP1.getAxioms()) {
            block230: {
                if (!axiom.matches(".*\\.\\.\\..*")) continue;
                if (this.debuggingOutput) {
                    System.out.println("constructor expansion operator @ applied on oneOf");
                }
                if (!axiom.matches(".*\\{\\.\\.\\.\\?[0-9a-zA-Z_]* \\} ")) break block230;
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                matcher = pat.matcher(axiom);
                p = 0;
                while (matcher.find()) {
                    placeholders[p] = matcher.group();
                    ++p;
                }
                notMultipliedPlaceholdersOP1.add(placeholders[0]);
                if (this.debuggingOutput) {
                    System.out.println("constructor expansion operator ... applied on oneOf " + placeholders[1]);
                }
                mappingsOP1Placeholders.put(placeholders[1], this.getEntitiesFromExpansionConstruct(ontologyURI, axiom, "oneOf"));
                numberOfMultiplication = ((ArrayList)mappingsOP1Placeholders.get(placeholders[1])).size();
                oneOfAxiom = ((ArrayList)mappingsOP1Placeholders.get(placeholders[1])).toString().replaceAll("\\[|\\]", "");
                oneOfAxiom = oneOfAxiom.replaceAll(",", " ,");
                patternOP1.replaceAxiom(axiom, String.valueOf(axiom.substring(0, axiom.indexOf(".") - 1)) + "{" + oneOfAxiom + " } ");
                for (String axiom1 : patternOP1.getAxioms()) {
                    if (!axiom1.matches(".*\\" + placeholders[1] + ".*")) continue;
                    originalAxiom = axiom1;
                    axiomMultiplied = new String[numberOfMultiplication];
                    u = 0;
                    while (u < numberOfMultiplication) {
                        axiomMultiplied[u] = axiom1.replaceAll("\\" + placeholders[1], (String)((ArrayList)mappingsOP1Placeholders.get(placeholders[1])).get(u));
                        pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                        matcher = pat.matcher(axiom1);
                        currentPlaceholder = "";
                        while (matcher.find()) {
                            currentPlaceholder = matcher.group();
                            if (currentPlaceholder.equals(placeholders[1])) continue;
                            axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + currentPlaceholder, "?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                            if (mappingsOP1Placeholders.containsKey(currentPlaceholder)) {
                                pls = (ArrayList)mappingsOP1Placeholders.get(currentPlaceholder);
                                pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                continue;
                            }
                            pls = new ArrayList();
                            pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                            mappingsOP1Placeholders.put(currentPlaceholder, pls);
                        }
                        ++u;
                    }
                    toReplaceOP1Axioms.put((String)originalAxiom, axiomMultiplied);
                }
                if (tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[1]) != null) {
                    oldOP2placeholders.add(tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[1]));
                }
                if (tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[1]) != null) {
                    oldOP2placeholders.add(tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[1]));
                }
                for (String s : oldOP2placeholders) {
                    if (this.debuggingOutput) {
                        System.out.println(s);
                    }
                    mappingsOP2Placeholders.put(s, this.generateEntitiesPlaceholders(numberOfMultiplication, s));
                }
                if (tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[0]) != null) {
                    notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[0]));
                }
                if (tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[0]) != null) {
                    notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[0]));
                }
                if (this.debuggingOutput) {
                    System.out.println("no multiply " + notMultipliedPlaceholdersOP2);
                }
                placholdersInUnionOfAxiom = new ArrayList<String>();
                for (String axiom1 : patternOP2.getAxioms()) {
                    if (axiom1.matches(".*unionOf.*")) {
                        pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                        matcher = pat.matcher(axiom1);
                        matcher.find();
                        placholdersInUnionOfAxiom.add(matcher.group());
                    }
                    originalAxiom = axiom1;
                    axiomMultiplied = new String[numberOfMultiplication];
                    newAxiom = "";
                    newAxiom = axiom1;
                    edited = false;
                    u = 0;
                    while (u < numberOfMultiplication) {
                        axiomMultiplied[u] = newAxiom;
                        c = 0;
                        ** GOTO lbl292
                        {
                            axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + (String)oldOP2placeholders.get(c), (String)((ArrayList)mappingsOP2Placeholders.get(oldOP2placeholders.get(c))).get(u));
                            pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                            matcher = pat.matcher((CharSequence)newAxiom);
                            currentPlaceholder = "";
                            while (matcher.find()) {
                                currentPlaceholder = matcher.group();
                                if (oldOP2placeholders.contains(currentPlaceholder) || notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) continue;
                                axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + currentPlaceholder, "?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
                                    pls = (ArrayList)mappingsOP2Placeholders.get(currentPlaceholder);
                                    if (pls.contains("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1))) continue;
                                    pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                    continue;
                                }
                                pls = new ArrayList();
                                pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                mappingsOP2Placeholders.put(currentPlaceholder, pls);
                            }
                            edited = true;
                            do {
                                if (axiomMultiplied[u].matches(".*\\" + (String)oldOP2placeholders.get(c) + ".*")) continue block25;
                                ++c;
lbl292:
                                // 2 sources

                            } while (c < oldOP2placeholders.size());
                        }
                        ++u;
                    }
                    if (edited) {
                        if (axiomMultiplied[0].matches(".*unionOf.*")) {
                            mappingsOP2Placeholders.remove(placholdersInUnionOfAxiom.get(0));
                            pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
                            placeholdersInUnion = new ArrayList<String>();
                            k = 0;
                            while (k < numberOfMultiplication) {
                                matcher = pat.matcher(axiomMultiplied[k]);
                                currentPlaceholder = "";
                                while (matcher.find()) {
                                    currentPlaceholder = matcher.group();
                                    placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
                                }
                                ++k;
                            }
                            pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                            matcher = pat.matcher(axiomMultiplied[0]);
                            matcher.find();
                            axiomMultiplied[0] = axiomMultiplied[0].replaceAll("\\" + matcher.group(), (String)placholdersInUnionOfAxiom.get(0));
                            unionOf = "";
                            pl = 0;
                            while (pl < placeholdersInUnion.size()) {
                                unionOf = pl != 0 ? String.valueOf(unionOf) + " or " + (String)placeholdersInUnion.get(pl) : (String)placeholdersInUnion.get(pl);
                                ++pl;
                            }
                            axiomMultiplied[0] = axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "(" + unionOf);
                            arr = new String[]{axiomMultiplied[0]};
                            toReplaceOP2Axioms.put(originalAxiom, arr);
                            continue;
                        }
                        toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
                        continue;
                    }
                    OP2axiomsToInspect.add(axiom1);
                }
                if (this.debuggingOutput) {
                    System.out.println("here:" + mappingsOP2Placeholders);
                }
                originalAxiom = OP2axiomsToInspect.iterator();
                while (originalAxiom.hasNext()) {
                    originalAxiom = axiomInspection = originalAxiom.next();
                    axiomMultiplied = new String[numberOfMultiplication];
                    newAxiom = "";
                    newAxiom = axiomInspection;
                    edited = false;
                    oldOP2placeholders = new ArrayList<E>();
                    oldOP2placeholders.addAll(mappingsOP2Placeholders.keySet());
                    changedBeforeOP2Placeholders = new ArrayList<E>();
                    for (String s : mappingsOP2Placeholders.keySet()) {
                        changedBeforeOP2Placeholders.addAll((Collection)mappingsOP2Placeholders.get(s));
                    }
                    if (this.debuggingOutput) {
                        System.out.println("changed already before " + changedBeforeOP2Placeholders);
                    }
                    u = 0;
                    while (u < numberOfMultiplication) {
                        axiomMultiplied[u] = newAxiom;
                        c = 0;
                        ** GOTO lbl384
                        {
                            axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + (String)oldOP2placeholders.get(c), (String)((ArrayList)mappingsOP2Placeholders.get(oldOP2placeholders.get(c))).get(u));
                            pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                            matcher = pat.matcher((CharSequence)newAxiom);
                            currentPlaceholder = "";
                            while (matcher.find()) {
                                currentPlaceholder = matcher.group();
                                if (this.debuggingOutput) {
                                    System.out.println("current " + currentPlaceholder);
                                }
                                if (changedBeforeOP2Placeholders.contains(currentPlaceholder) || notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) continue;
                                axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + currentPlaceholder, "?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
                                    pls = (ArrayList)mappingsOP2Placeholders.get(currentPlaceholder);
                                    if (pls.contains("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1))) continue;
                                    pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                    continue;
                                }
                                pls = new ArrayList();
                                pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                mappingsOP2Placeholders.put(currentPlaceholder, pls);
                            }
                            edited = true;
                            do {
                                if (axiomMultiplied[u].matches(".*\\" + (String)oldOP2placeholders.get(c) + ".*")) continue block34;
                                ++c;
lbl384:
                                // 2 sources

                            } while (c < oldOP2placeholders.size());
                        }
                        ++u;
                    }
                    if (!edited) continue;
                    if (axiomMultiplied[0].matches(".*unionOf.*")) {
                        pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
                        placeholdersInUnion = new ArrayList<String>();
                        k = 0;
                        while (k < numberOfMultiplication) {
                            matcher = pat.matcher(axiomMultiplied[k]);
                            currentPlaceholder = "";
                            while (matcher.find()) {
                                currentPlaceholder = matcher.group();
                                placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
                            }
                            ++k;
                        }
                        unionOf = "";
                        pl = 0;
                        while (pl < placeholdersInUnion.size()) {
                            unionOf = pl != 0 ? String.valueOf(unionOf) + " or " + (String)placeholdersInUnion.get(pl) : (String)placeholdersInUnion.get(pl);
                            ++pl;
                        }
                        axiomMultiplied[0] = axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "(" + unionOf);
                        arr = new String[]{axiomMultiplied[0]};
                        toReplaceOP2Axioms.put(originalAxiom, arr);
                        continue;
                    }
                    toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
                }
                continue;
            }
            if (!axiom.matches(".*unionOf\\(\\.\\.\\.\\?[0-9a-zA-Z_]* \\) \\) ")) continue;
            if (this.debuggingOutput) {
                System.out.println("varargs with unionOf...");
            }
            pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            matcher = pat.matcher(axiom);
            p = 0;
            while (matcher.find()) {
                placeholders[p] = matcher.group();
                ++p;
            }
            notMultipliedPlaceholdersOP1.add(placeholders[0]);
            if (this.debuggingOutput) {
                System.out.println("constructor expansion operator ... applied on unionOf " + placeholders[1]);
            }
            mappingsOP1Placeholders.put(placeholders[1], this.getEntitiesFromExpansionConstruct(ontologyURI, axiom, "unionOf"));
            numberOfMultiplication = ((ArrayList)mappingsOP1Placeholders.get(placeholders[1])).size();
            oneOfAxiom = ((ArrayList)mappingsOP1Placeholders.get(placeholders[1])).toString().replaceAll("\\[|\\]", "");
            oneOfAxiom = oneOfAxiom.replaceAll(",", " or ");
            patternOP1.replaceAxiom(axiom, String.valueOf(axiom.substring(0, axiom.indexOf("("))) + "(" + oneOfAxiom + " ) ");
            for (String axiom1 : patternOP1.getAxioms()) {
                if (!axiom1.matches(".*\\" + placeholders[1] + ".*")) continue;
                originalAxiom = axiom1;
                axiomMultiplied = new String[numberOfMultiplication];
                u = 0;
                while (u < numberOfMultiplication) {
                    axiomMultiplied[u] = axiom1.replaceAll("\\" + placeholders[1], (String)((ArrayList)mappingsOP1Placeholders.get(placeholders[1])).get(u));
                    pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                    matcher = pat.matcher(axiom1);
                    currentPlaceholder = "";
                    while (matcher.find()) {
                        currentPlaceholder = matcher.group();
                        if (currentPlaceholder.equals(placeholders[1])) continue;
                        axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + currentPlaceholder, "?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                        if (mappingsOP1Placeholders.containsKey(currentPlaceholder)) {
                            pls = (ArrayList)mappingsOP1Placeholders.get(currentPlaceholder);
                            pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                            continue;
                        }
                        pls = new ArrayList();
                        pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                        mappingsOP1Placeholders.put(currentPlaceholder, pls);
                    }
                    ++u;
                }
                toReplaceOP1Axioms.put((String)originalAxiom, axiomMultiplied);
            }
            if (tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[1]) != null) {
                oldOP2placeholders.add(tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[1]));
            }
            if (tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[1]) != null) {
                oldOP2placeholders.add(tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[1]));
            }
            axiomInspection = oldOP2placeholders.iterator();
            while (axiomInspection.hasNext()) {
                s = axiomInspection.next();
                if (this.debuggingOutput) {
                    System.out.println(s);
                }
                mappingsOP2Placeholders.put(s, this.generateEntitiesPlaceholders(numberOfMultiplication, s));
            }
            if (tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[0]) != null) {
                notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(PatternTransformation.Type.eq).get(placeholders[0]));
            }
            if (tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[0]) != null) {
                notMultipliedPlaceholdersOP2.add(tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(placeholders[0]));
            }
            if (this.debuggingOutput) {
                System.out.println("no multiply " + notMultipliedPlaceholdersOP2);
            }
            placholdersInUnionOfAxiom = new ArrayList<E>();
            for (String axiom1 : patternOP2.getAxioms()) {
                if (axiom1.matches(".*unionOf.*")) {
                    pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                    matcher = pat.matcher(axiom1);
                    matcher.find();
                    placholdersInUnionOfAxiom.add(matcher.group());
                }
                originalAxiom = axiom1;
                axiomMultiplied = new String[numberOfMultiplication];
                newAxiom = "";
                newAxiom = axiom1;
                edited = false;
                u = 0;
                while (u < numberOfMultiplication) {
                    axiomMultiplied[u] = newAxiom;
                    c = 0;
                    ** GOTO lbl533
                    {
                        axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + (String)oldOP2placeholders.get(c), (String)((ArrayList)mappingsOP2Placeholders.get(oldOP2placeholders.get(c))).get(u));
                        pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                        matcher = pat.matcher((CharSequence)newAxiom);
                        currentPlaceholder = "";
                        while (matcher.find()) {
                            currentPlaceholder = matcher.group();
                            if (oldOP2placeholders.contains(currentPlaceholder) || notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) continue;
                            axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + currentPlaceholder, "?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                            if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
                                pls = (ArrayList)mappingsOP2Placeholders.get(currentPlaceholder);
                                if (pls.contains("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1))) continue;
                                pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                continue;
                            }
                            pls = new ArrayList();
                            pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                            mappingsOP2Placeholders.put(currentPlaceholder, pls);
                        }
                        edited = true;
                        do {
                            if (axiomMultiplied[u].matches(".*\\" + (String)oldOP2placeholders.get(c) + ".*")) continue block47;
                            ++c;
lbl533:
                            // 2 sources

                        } while (c < oldOP2placeholders.size());
                    }
                    ++u;
                }
                if (edited) {
                    if (axiomMultiplied[0].matches(".*unionOf.*")) {
                        mappingsOP2Placeholders.remove(placholdersInUnionOfAxiom.get(0));
                        pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
                        placeholdersInUnion = new ArrayList<String>();
                        k = 0;
                        while (k < numberOfMultiplication) {
                            matcher = pat.matcher(axiomMultiplied[k]);
                            currentPlaceholder = "";
                            while (matcher.find()) {
                                currentPlaceholder = matcher.group();
                                placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
                            }
                            ++k;
                        }
                        pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                        matcher = pat.matcher(axiomMultiplied[0]);
                        matcher.find();
                        axiomMultiplied[0] = axiomMultiplied[0].replaceAll("\\" + matcher.group(), (String)placholdersInUnionOfAxiom.get(0));
                        unionOf = "";
                        pl = 0;
                        while (pl < placeholdersInUnion.size()) {
                            unionOf = pl != 0 ? String.valueOf(unionOf) + " or " + (String)placeholdersInUnion.get(pl) : (String)placeholdersInUnion.get(pl);
                            ++pl;
                        }
                        axiomMultiplied[0] = axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "(" + unionOf);
                        arr = new String[]{axiomMultiplied[0]};
                        toReplaceOP2Axioms.put(originalAxiom, arr);
                        continue;
                    }
                    toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
                    continue;
                }
                OP2axiomsToInspect.add(axiom1);
            }
            if (this.debuggingOutput) {
                System.out.println("here:" + mappingsOP2Placeholders);
            }
            originalAxiom = OP2axiomsToInspect.iterator();
            while (originalAxiom.hasNext()) {
                originalAxiom = axiomInspection = originalAxiom.next();
                axiomMultiplied = new String[numberOfMultiplication];
                newAxiom = "";
                newAxiom = axiomInspection;
                edited = false;
                oldOP2placeholders = new ArrayList<E>();
                oldOP2placeholders.addAll(mappingsOP2Placeholders.keySet());
                changedBeforeOP2Placeholders = new ArrayList<E>();
                for (String s : mappingsOP2Placeholders.keySet()) {
                    changedBeforeOP2Placeholders.addAll((Collection)mappingsOP2Placeholders.get(s));
                }
                if (this.debuggingOutput) {
                    System.out.println("changed already before " + changedBeforeOP2Placeholders);
                }
                u = 0;
                while (u < numberOfMultiplication) {
                    axiomMultiplied[u] = newAxiom;
                    c = 0;
                    ** GOTO lbl625
                    {
                        axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + (String)oldOP2placeholders.get(c), (String)((ArrayList)mappingsOP2Placeholders.get(oldOP2placeholders.get(c))).get(u));
                        pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                        matcher = pat.matcher((CharSequence)newAxiom);
                        currentPlaceholder = "";
                        while (matcher.find()) {
                            currentPlaceholder = matcher.group();
                            if (this.debuggingOutput) {
                                System.out.println("current " + currentPlaceholder);
                            }
                            if (changedBeforeOP2Placeholders.contains(currentPlaceholder) || notMultipliedPlaceholdersOP2.contains(currentPlaceholder)) continue;
                            axiomMultiplied[u] = axiomMultiplied[u].replaceAll("\\" + currentPlaceholder, "?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                            if (mappingsOP2Placeholders.containsKey(currentPlaceholder)) {
                                pls = (ArrayList)mappingsOP2Placeholders.get(currentPlaceholder);
                                if (pls.contains("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1))) continue;
                                pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                                continue;
                            }
                            pls = new ArrayList();
                            pls.add("?_" + currentPlaceholder.replaceAll("\\?", "") + (u + 1));
                            mappingsOP2Placeholders.put(currentPlaceholder, pls);
                        }
                        edited = true;
                        do {
                            if (axiomMultiplied[u].matches(".*\\" + (String)oldOP2placeholders.get(c) + ".*")) continue block56;
                            ++c;
lbl625:
                            // 2 sources

                        } while (c < oldOP2placeholders.size());
                    }
                    ++u;
                }
                if (!edited) continue;
                if (axiomMultiplied[0].matches(".*unionOf.*")) {
                    pat = Pattern.compile("unionOf\\(\\?[0-9a-zA-Z_]*");
                    placeholdersInUnion = new ArrayList<String>();
                    k = 0;
                    while (k < numberOfMultiplication) {
                        matcher = pat.matcher(axiomMultiplied[k]);
                        currentPlaceholder = "";
                        while (matcher.find()) {
                            currentPlaceholder = matcher.group();
                            placeholdersInUnion.add(currentPlaceholder.replaceAll("unionOf\\(", ""));
                        }
                        ++k;
                    }
                    unionOf = "";
                    pl = 0;
                    while (pl < placeholdersInUnion.size()) {
                        unionOf = pl != 0 ? String.valueOf(unionOf) + " or " + (String)placeholdersInUnion.get(pl) : (String)placeholdersInUnion.get(pl);
                        ++pl;
                    }
                    axiomMultiplied[0] = axiomMultiplied[0].replaceAll("\\(unionOf\\(\\?[0-9a-zA-Z_]* \\) ", "(" + unionOf);
                    arr = new String[]{axiomMultiplied[0]};
                    toReplaceOP2Axioms.put(originalAxiom, arr);
                    continue;
                }
                toReplaceOP2Axioms.put(originalAxiom, axiomMultiplied);
            }
        }
        if (this.debuggingOutput) {
            System.out.println(mappingsOP1Placeholders);
        }
        if (this.debuggingOutput) {
            System.out.println(mappingsOP2Placeholders);
        }
        pt = tp.getPT();
        for (String lhs : mappingsOP1Placeholders.keySet()) {
            if (this.debuggingOutput) {
                System.out.println("lhs:" + lhs);
            }
            if (pt.getLinks(PatternTransformation.Type.eq).containsKey(lhs)) {
                rhs = pt.getLinks(PatternTransformation.Type.eq).get(lhs);
                lhsNew = new String[numberOfMultiplication];
                rhsNew = new String[numberOfMultiplication];
                ((ArrayList)mappingsOP1Placeholders.get(lhs)).toArray(lhsNew);
                ((ArrayList)mappingsOP2Placeholders.get(rhs)).toArray(rhsNew);
                pt.addLink(PatternTransformation.Type.eq, lhsNew, rhsNew);
                pt.removeLink(PatternTransformation.Type.eq, lhs);
                pt.addLink(PatternTransformation.Type.any, lhsNew, rhsNew);
                pt.removeLink(PatternTransformation.Type.any, lhs);
            }
            if (this.debuggingOutput) {
                System.out.println("PT:" + tp.getPT().getLinks(PatternTransformation.Type.any));
            }
            if (!pt.getLinks(PatternTransformation.Type.eqHet).containsKey(lhs)) continue;
            rhs = pt.getLinks(PatternTransformation.Type.eqHet).get(lhs);
            lhsNew = new String[numberOfMultiplication];
            rhsNew = new String[numberOfMultiplication];
            ((ArrayList)mappingsOP1Placeholders.get(lhs)).toArray(lhsNew);
            ((ArrayList)mappingsOP2Placeholders.get(rhs)).toArray(rhsNew);
            pt.addLink(PatternTransformation.Type.eqHet, lhsNew, rhsNew);
            pt.removeLink(PatternTransformation.Type.eqHet, lhs);
            if (pt.getLinks(PatternTransformation.Type.any).containsKey(lhsNew[0])) continue;
            pt.addLink(PatternTransformation.Type.any, lhsNew, rhsNew);
            pt.removeLink(PatternTransformation.Type.any, lhs);
        }
        for (String rhs : mappingsOP2Placeholders.keySet()) {
            if (!pt.getENP().containsKey(rhs)) continue;
            oldInstructions = pt.getENP().get(rhs);
            if (this.debuggingOutput) {
                System.out.println("old instructions " + oldInstructions);
            }
            pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            matcher = pat.matcher(oldInstructions);
            currentPlaceholder = "";
            if (!matcher.find() || !mappingsOP1Placeholders.containsKey(currentPlaceholder = matcher.group())) continue;
            lhsNew = new String[numberOfMultiplication];
            rhsNew = new String[numberOfMultiplication];
            ((ArrayList)mappingsOP1Placeholders.get(currentPlaceholder)).toArray(lhsNew);
            ((ArrayList)mappingsOP2Placeholders.get(rhs)).toArray(rhsNew);
            pt.replaceNTP((String)currentPlaceholder, rhs, lhsNew, rhsNew);
        }
        for (String rhs : mappingsOP1Placeholders.keySet()) {
            if (this.debuggingOutput) {
                System.out.println("old " + rhs);
            }
            for (String s : pt.getENP().keySet()) {
                if (!pt.getENP().get(s).matches(".*" + rhs + ".*")) continue;
                oldNTP = s;
                newInstructions = "";
                oldInstructions = pt.getENP().get(s);
                if (this.debuggingOutput) {
                    System.out.println("old instructions " + oldInstructions);
                }
                siz = 0;
                for (String ss : (ArrayList)mappingsOP1Placeholders.get(rhs)) {
                    newInstructions = siz == 0 ? ss : String.valueOf(newInstructions) + "+,+" + ss;
                    ++siz;
                    if (!this.debuggingOutput) continue;
                    System.out.println(newInstructions);
                }
                pt.replaceNTP2(s, oldInstructions, s, oldInstructions.replaceAll("\\" + rhs, newInstructions));
            }
        }
        for (String s : mappingsOP1Placeholders.keySet()) {
            pls = new String[((ArrayList)mappingsOP1Placeholders.get(s)).size()];
            ((ArrayList)mappingsOP1Placeholders.get(s)).toArray((T[])pls);
            patternOP1.replacePlaceholder(s, (String[])pls);
        }
        for (String s : mappingsOP2Placeholders.keySet()) {
            pls = new String[((ArrayList)mappingsOP2Placeholders.get(s)).size()];
            ((ArrayList)mappingsOP2Placeholders.get(s)).toArray((T[])pls);
            patternOP2.replacePlaceholder(s, (String[])pls);
        }
        for (String s : toReplaceOP1Axioms.keySet()) {
            patternOP1.replaceAxiom(s, (String[])toReplaceOP1Axioms.get(s));
        }
        for (String s : toReplaceOP2Axioms.keySet()) {
            patternOP2.replaceAxiom(s, (String[])toReplaceOP2Axioms.get(s));
        }
        if (this.debuggingOutput) {
            System.out.println(tp);
        }
        restrictionNumber = 0;
        pls = patternOP1.getAxioms().iterator();
        while (pls.hasNext()) {
            originalAxiom = axiom = (String)pls.next();
            ++restrictionNumber;
            if (axiom.matches("\\?[0-9a-zA-Z_]* \\?[0-9a-zA-Z_]* \\?[0-9a-zA-Z_]*")) {
                if (!this.debuggingOutput) continue;
                System.out.println("object property assertion");
                continue;
            }
            if (axiom.matches(".* or .*")) {
                if (this.debuggingOutput) {
                    System.out.println("je to tady: unionOf");
                }
                st = new StringTokenizer(originalAxiom, " or ");
                operands = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    operands.add(st.nextToken());
                }
                if (axiom.matches(".*equivalentTo.*")) {
                    axiom = axiom.replaceAll("\\(.*\\)", "");
                    axiom = axiom.replaceAll("equivalentTo", "owl:equivalentClass");
                    axiom = String.valueOf(axiom) + " _:unionOf" + restrictionNumber + ".\n_:unionOf" + restrictionNumber + " owl:unionOf " + originalAxiom.substring(originalAxiom.indexOf("("), originalAxiom.indexOf(")")).replace(" or ", " ") + ")";
                } else if (axiom.matches(".*subClassOf.*")) {
                    axiom = axiom.replaceAll("\\(.*\\)", "");
                    axiom = axiom.replaceAll("subClassOf", "rdfs:subClassOf");
                    axiom = String.valueOf(axiom) + " _:unionOf" + restrictionNumber + ".\n_:unionOf" + restrictionNumber + " owl:unionOf " + originalAxiom.substring(originalAxiom.indexOf("("), originalAxiom.indexOf(")")).replace(" or ", " ") + ")";
                }
                if (patternOP1.getOptionalAxioms().contains(originalAxiom)) {
                    query.append("OPTIONAL { " + axiom + " }.\n");
                    continue;
                }
                query.append(String.valueOf(axiom) + ".\n");
                continue;
            }
            if (axiom.matches(".*\\{.*\\} ")) {
                if (this.debuggingOutput) {
                    System.out.println("je to tady");
                }
                enumerationPart = originalAxiom;
                enumerationPart = enumerationPart.replaceAll("\\{", "(");
                enumerationPart = enumerationPart.replaceAll("\\}", ")");
                enumerationPart = enumerationPart.replaceAll(",", " ");
                enumerationPart = enumerationPart.replaceAll(" $", "");
                enumerationPart = enumerationPart.substring(enumerationPart.indexOf("("));
                if (axiom.matches(".*equivalentTo.*")) {
                    axiom = axiom.replaceAll("\\{.*\\}", "");
                    axiom = axiom.replaceAll("equivalentTo", "owl:equivalentClass");
                    axiom = String.valueOf(axiom) + " _:oneOf" + restrictionNumber + ".\n_:oneOf" + restrictionNumber + " owl:oneOf " + enumerationPart;
                } else if (axiom.matches(".*subClassOf.*")) {
                    axiom = axiom.replaceAll("\\{.*\\}", "");
                    axiom = axiom.replaceAll("subClassOf", "rdfs:subClassOf");
                    axiom = String.valueOf(axiom) + " _:oneOf" + restrictionNumber + ".\n_:oneOf" + restrictionNumber + " owl:oneOf " + enumerationPart;
                }
                if (patternOP1.getOptionalAxioms().contains(originalAxiom)) {
                    query.append("OPTIONAL { " + axiom + " }.\n");
                    continue;
                }
                query.append(String.valueOf(axiom) + ".\n");
                continue;
            }
            if (axiom.matches(".*not.*")) {
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                matcher = pat.matcher(axiom);
                p = 0;
                while (matcher.find()) {
                    placeholders[p] = matcher.group();
                    ++p;
                }
                if (placeholders[2] != null) {
                    if (originalAxiom.matches(".*subClassOf.*")) {
                        axiom = String.valueOf(placeholders[0]) + " rdfs:subClassOf _:complement" + restrictionNumber + ".\n_:complement" + restrictionNumber + " owl:complementOf _:restriction" + restrictionNumber + ".\n_:restriction" + restrictionNumber + " rdf:type owl:Restriction.\n";
                    } else if (originalAxiom.matches(".*equivalentTo.*")) {
                        axiom = String.valueOf(placeholders[0]) + " owl:equivalentClass _:complement" + restrictionNumber + ".\n_:complement" + restrictionNumber + " owl:complementOf _:restriction" + restrictionNumber + ".\n_:restriction" + restrictionNumber + "\trdf:type owl:Restriction.\n";
                    }
                    axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:onProperty " + placeholders[1] + ".\n";
                    if (originalAxiom.matches(".*min.*")) {
                        if (placeholders[3] != null) {
                            axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:minQualifiedCardinality " + placeholders[2] + ".\n";
                            axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:onClass " + placeholders[3];
                        } else {
                            axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:minCardinality " + placeholders[2];
                        }
                    } else if (originalAxiom.matches(".*max.*")) {
                        if (placeholders[3] != null) {
                            axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:maxQualifiedCardinality " + placeholders[2] + ".\n";
                            axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:onClass " + placeholders[3];
                        } else {
                            axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:maxCardinality " + placeholders[2];
                        }
                    } else if (originalAxiom.matches(".*some.*")) {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:someValuesFrom " + placeholders[2];
                    } else if (originalAxiom.matches(".*only.*")) {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:allValuesFrom " + placeholders[2];
                    } else if (originalAxiom.matches(".*value.*")) {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:hasValue " + placeholders[2];
                    }
                } else if (originalAxiom.matches(".*subClassOf.*")) {
                    axiom = String.valueOf(placeholders[0]) + " rdfs:subClassOf _:complement1.\n_:complement1 owl:complementOf " + placeholders[1];
                } else if (originalAxiom.matches(".*equivalentTo.*")) {
                    axiom = String.valueOf(placeholders[0]) + " owl:equivalentClass _:complement1.\n_:complement1 owl:complementOf " + placeholders[1];
                }
                if (patternOP1.getOptionalAxioms().contains(originalAxiom)) {
                    query.append("OPTIONAL { " + axiom + " }.\n");
                    continue;
                }
                query.append(String.valueOf(axiom) + ".\n");
                continue;
            }
            if (axiom.matches(".*value.*") || axiom.matches(".*some.*") || axiom.matches(".*only.*") || axiom.matches(".*min.*") || axiom.matches(".*max.*") || axiom.matches(".*exactly.*")) {
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                matcher = pat.matcher(axiom);
                p = 0;
                while (matcher.find()) {
                    placeholders[p] = matcher.group();
                    ++p;
                }
                if (originalAxiom.matches(".*subClassOf.*")) {
                    axiom = String.valueOf(placeholders[0]) + " rdfs:subClassOf _:restriction" + restrictionNumber + ".\n_:restriction" + restrictionNumber + " rdf:type owl:Restriction.\n";
                } else if (originalAxiom.matches(".*equivalentTo.*")) {
                    axiom = String.valueOf(placeholders[0]) + " owl:equivalentClass _:restriction" + restrictionNumber + ".\n_:restriction" + restrictionNumber + "\trdf:type owl:Restriction.\n";
                }
                axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:onProperty " + placeholders[1] + ".\n";
                if (originalAxiom.matches(".*value.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:hasValue " + placeholders[2];
                } else if (originalAxiom.matches(".*some.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:someValuesFrom " + placeholders[2];
                } else if (originalAxiom.matches(".*only.*")) {
                    axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:allValuesFrom " + placeholders[2];
                } else if (originalAxiom.matches(".*min.*")) {
                    if (placeholders[3] != null) {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:minQualifiedCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:onClass " + placeholders[3] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    } else {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:minCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    }
                } else if (originalAxiom.matches(".*max.*")) {
                    if (placeholders[3] != null) {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:maxQualifiedCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:onClass " + placeholders[3] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    } else {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:maxCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    }
                } else if (originalAxiom.matches(".*exactly.*")) {
                    if (placeholders[3] != null) {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:qualifiedCardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:onClass " + placeholders[3] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    } else {
                        axiom = String.valueOf(axiom) + "_:restriction" + restrictionNumber + " owl:cardinality " + placeholders[2] + ".\n";
                        axiom = String.valueOf(axiom) + placeholders[1] + " rdf:type owl:ObjectProperty";
                    }
                }
                if (patternOP1.getOptionalAxioms().contains(originalAxiom)) {
                    query.append("OPTIONAL { " + axiom + " }.\n");
                    continue;
                }
                query.append(String.valueOf(axiom) + ".\n");
                continue;
            }
            if (axiom.matches(".*annotation.*")) continue;
            for (String s : patternOP1.getNamespaces().keySet()) {
                axiom = axiom.replaceAll(s, String.valueOf(patternOP1.getNamespaces().get(s)) + ":");
            }
            if (axiom.matches(".*subClassOf.*")) {
                pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
                matcher = pat.matcher(axiom);
                p = false;
                subsumed = "";
                subsumer = "";
                if (matcher.find()) {
                    subsumed = matcher.group();
                }
                if (matcher.find()) {
                    subsumer = matcher.group();
                }
                if (!subsumer.equals("") && !subsumed.equals("")) {
                    this.subClassOfs.add(new SubClassOfPair(subsumer, subsumed));
                }
            }
            axiom = axiom.replace("domain", "rdfs:domain");
            axiom = axiom.replace("range", "rdfs:range");
            axiom = axiom.replace("subClassOf", "rdfs:subClassOf");
            axiom = axiom.replace("equivalentTo", "owl:equivalentClass");
            axiom = axiom.replace("disjointWith", "owl:disjointWith");
            axiom = axiom.replace("propertyDisjointWith", "owl:propertyDisjointWith");
            axiom = axiom.replace("inverseOf", "owl:inverseOf");
            if ((axiom = axiom.replace("sameAs", "owl:sameAs")).matches("Irreflexive.*") || axiom.matches("Functional.*") || axiom.matches("InverseFunctional.*") || axiom.matches("Symmetric.*") || axiom.matches("Asymmetric.*") || axiom.matches("Reflexive.*") || axiom.matches("Transitive.*")) {
                s = axiom.substring(0, axiom.indexOf(" "));
                s = s.replace("Irreflexive", "owl:IrreflexiveProperty");
                s = s.replace("Functional", "owl:FunctionalProperty");
                s = s.replace("InverseFunctional", "owl:InverseFunctionalProperty");
                s = s.replace("Symmetric", "owl:SymmetricProperty");
                s = s.replace("Asymmetric", "owl:AsymmetricProperty");
                s = s.replace("Reflexive", "owl:ReflexiveProperty");
                s = s.replace("Transitive", "owl:TransitiveProperty");
                axiom = axiom.substring(axiom.indexOf(" ") + 1);
                axiom = String.valueOf(axiom) + " rdf:type ";
                axiom = String.valueOf(axiom) + s;
                if (this.debuggingOutput) {
                    System.out.println(axiom);
                }
            }
            if (patternOP1.getOptionalAxioms().contains(originalAxiom)) {
                query.append("OPTIONAL { " + axiom + " }.\n");
                continue;
            }
            query.append(String.valueOf(axiom) + ".\n");
        }
        if (patternOP1.getOptionalAxioms().size() == 0) {
            query.append(filter);
        }
        query.append(queryEnd);
        if (this.debuggingOutput) {
            System.out.println(query);
        }
        q = QueryFactory.create((String)query.toString());
        qe = QueryExecutionFactory.create((Query)q, (Model)m);
        if (this.debuggingOutput) {
            System.out.println("setting: anonymous/Thing/Nothing checking on, naming aspect off (nextOne=true)");
        }
        currentTime = 0L;
        time = 0L;
        System.out.println(q);
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right Right before the SPARQL query execution:" + currentTime);
        }
        time = currentTime;
        qe = QueryExecutionFactory.create((Query)q, (Model)m);
        rs = qe.execSelect();
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right after the SPARQL query execution (delta):" + (currentTime - time));
        }
        time = currentTime;
        query_results = new ArrayList<String>();
        sparqlBinding = new HashMap<String, String>();
        value = "";
        node = null;
        nextOne = false;
        nsc = new NamingConstraintsImpl(true, this.dictionaryPath, this.modelsPath);
        combinations = 0;
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right before the SPARQL results processing (delta):" + (currentTime - time));
        }
        time = currentTime;
        placeholdersOP1 = patternOP1.getPlaceholders().keySet();
        while (rs.hasNext()) {
            ++combinations;
            nextOne = false;
            sparqlBinding.clear();
            solution = (QuerySolution)rs.next();
            for (String p : placeholdersOP1) {
                node = solution.get(p);
                if (node == null) continue;
                if (node.isAnon()) {
                    nextOne = true;
                    break;
                }
                value = node.toString();
                if (this.ontologyNamespace.equals("")) {
                    this.ontologyNamespace = value.substring(0, value.indexOf("#") + 1);
                }
                value = value.matches(".*XMLSchema.*") ? (value.indexOf("^") != -1 ? value.substring(0, value.indexOf("^")) : value.substring(value.indexOf("#") + 1)) : (value.indexOf("#") != -1 ? value.substring(value.indexOf("#") + 1) : value.substring(value.lastIndexOf("/") + 1));
                if (value.equals("Thing") || value.equals("Nothing")) {
                    nextOne = true;
                    break;
                }
                sparqlBinding.put(p, value);
            }
            if (nextOne || !nsc.checkNamingConstraints(sparqlBinding, patternOP1.getNameDetectionPatterns(), true)) continue;
            if (xmlSerialization) {
                xml = this.outputXML(sparqlBinding);
                if (query_results.contains(xml)) continue;
                query_results.add(xml);
                continue;
            }
            plain = this.outputPlain(sparqlBinding);
            if (query_results.contains(plain)) continue;
            query_results.add(plain);
        }
        currentTime = System.currentTimeMillis();
        if (this.debuggingOutput) {
            System.out.println("Right after the SPARQL results processing (delta):" + (currentTime - time));
        }
        time = currentTime;
        if (this.debuggingOutput) {
            System.out.println(String.valueOf(combinations) + " different combinations");
        }
        nsc.finish();
        m.close();
        return query_results;
    }

    public String replicateAxiom(String newAxiom, HashMap<String, String[]> mappingOldNewPlaceholders) {
        ArrayList collectionNewPlaceholders = (ArrayList)mappingOldNewPlaceholders.values();
        String cAxiom = newAxiom;
        if (mappingOldNewPlaceholders.size() == 2) {
            int i = ((String[])collectionNewPlaceholders.get(0)).length - 1;
            while (i >= 0) {
                int j = ((String[])collectionNewPlaceholders.get(1)).length - 1;
                while (j >= 0) {
                    cAxiom = cAxiom.replaceAll("\\?" + ((String[])collectionNewPlaceholders.get(0))[i], "");
                    --j;
                }
                --i;
            }
        } else {
            int i = ((String[])collectionNewPlaceholders.get(0)).length - 1;
            while (i >= 0) {
                --i;
            }
        }
        return "";
    }

    public ArrayList<String> getEntitiesFromExpansionConstruct(String ontologyURI, String axiom, String expansionConstruct) {
        ArrayList<String> placeholders = new ArrayList<String>();
        int numberOfEntities = 0;
        OWLOntology ontology = null;
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        try {
            if (ontologyURI.matches("^http.*") || ontologyURI.matches("^file.*")) {
                ontology = manager.loadOntologyFromOntologyDocument(IRI.create((String)ontologyURI));
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(ontologyURI.getBytes());
                ontology = manager.loadOntologyFromOntologyDocument((InputStream)in);
            }
            this.ontologyNamespace = this.getBaseURI(manager, ontology, ":");
            for (OWLClass cls : ontology.getClassesInSignature()) {
                Set allOperands;
                if (axiom.matches(".*equivalentTo.*")) {
                    for (OWLClassExpression exp : cls.getEquivalentClasses(ontology)) {
                        if (expansionConstruct.equals("oneOf")) {
                            if (!(exp instanceof OWLObjectOneOf) || (numberOfEntities = ((OWLObjectOneOf)exp).getIndividuals().size()) == 1) continue;
                            placeholders = this.generateEntitiesPlaceholders(numberOfEntities);
                            return placeholders;
                        }
                        if (!(exp instanceof OWLObjectUnionOf)) continue;
                        numberOfEntities = 0;
                        allOperands = ((OWLObjectUnionOf)exp).getOperands();
                        for (OWLClassExpression operand : allOperands) {
                            if (!(operand instanceof OWLClass)) continue;
                            ++numberOfEntities;
                        }
                        if (numberOfEntities != allOperands.size()) continue;
                        placeholders = this.generateEntitiesPlaceholders(numberOfEntities);
                        return placeholders;
                    }
                    continue;
                }
                for (OWLClassExpression exp : cls.getSuperClasses(ontology)) {
                    if (expansionConstruct.equals("oneOf")) {
                        if (!(exp instanceof OWLObjectOneOf) || (numberOfEntities = ((OWLObjectOneOf)exp).getIndividuals().size()) == 1) continue;
                        placeholders = this.generateEntitiesPlaceholders(numberOfEntities);
                        return placeholders;
                    }
                    if (!(exp instanceof OWLObjectUnionOf)) continue;
                    numberOfEntities = 0;
                    allOperands = ((OWLObjectUnionOf)exp).getOperands();
                    for (OWLClassExpression operand : allOperands) {
                        if (!(operand instanceof OWLClass)) continue;
                        ++numberOfEntities;
                    }
                    if (numberOfEntities != allOperands.size()) continue;
                    placeholders = this.generateEntitiesPlaceholders(numberOfEntities);
                    return placeholders;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return placeholders;
    }

    private ArrayList<String> generateEntitiesPlaceholders(int number) {
        ArrayList<String> placeholders = new ArrayList<String>();
        int i = this.numberGeneratedPlaceholders;
        while (i < this.numberGeneratedPlaceholders + number) {
            placeholders.add("?_" + i);
            ++i;
        }
        this.numberGeneratedPlaceholders += number;
        return placeholders;
    }

    private ArrayList<String> generateEntitiesPlaceholders(int number, String oldPlaceholder) {
        if (this.debuggingOutput) {
            System.out.println(String.valueOf(number) + " " + oldPlaceholder);
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        int i = this.numberGeneratedPlaceholders;
        while (i < this.numberGeneratedPlaceholders + number) {
            placeholders.add("?_" + oldPlaceholder.replaceAll("\\?", "") + i);
            ++i;
        }
        this.numberGeneratedPlaceholders += number;
        return placeholders;
    }

    private ArrayList<String> combineTwoComparisons(ArrayList<String> comparison1, ArrayList<String> comparison2) {
        ArrayList<String> combinedPairWise = new ArrayList<String>();
        int i = 0;
        while (i < comparison1.size()) {
            int j = 0;
            while (j < comparison2.size()) {
                combinedPairWise.add("(" + comparison1.get(i) + " && " + comparison2.get(j) + ")");
                ++j;
            }
            ++i;
        }
        return combinedPairWise;
    }

    private String outputXML(HashMap<String, String> sparqlBinding) {
        StringBuilder output = new StringBuilder();
        output.append("<pattern_instance ontology=\"" + this.ontologyURI + "\" tp=\"" + this.patternURI + "\">\n");
        for (String s : sparqlBinding.keySet()) {
            output.append("<binding placeholder=\"" + s + "\">" + sparqlBinding.get(s) + "</binding>\n");
        }
        output.append("</pattern_instance>\n");
        return output.toString();
    }

    public static String outputOnePairXML(String ontology, String tp, String plain) {
        StringBuilder output = new StringBuilder();
        output.append("<pattern_instance ontology=\"" + ontology + "\" tp=\"" + tp + "\">\n");
        StringTokenizer st1 = new StringTokenizer(plain, ";");
        while (st1.hasMoreTokens()) {
            String s = "";
            s = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(s, "=");
            output.append("<binding placeholder=\"" + st2.nextToken() + "\">" + st2.nextToken() + "</binding>\n");
        }
        output.append("</pattern_instance>\n");
        return output.toString();
    }

    private String outputPlain(HashMap<String, String> sparqlBinding) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        for (String s : sparqlBinding.keySet()) {
            if (i == 0) {
                output.append(String.valueOf(s) + "=" + sparqlBinding.get(s));
            } else {
                output.append(";" + s + "=" + sparqlBinding.get(s));
            }
            ++i;
        }
        return output.toString();
    }

    @Override
    public ArrayList<String> recursiveQuery(String pattern_instance, TransformationPattern tp, String ontologyURI, boolean xmlSerialization) {
        String prequery = this.query;
        String prequerySimple = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT * \nWHERE {\n";
        ArrayList<String> skipPlaceholders = new ArrayList<String>();
        for (SubClassOfPair p : this.subClassOfs) {
            String newSubsumerPlaceholder = p.subsumedPlaceholder;
            String replacerPlaceholder = p.subsumerPlaceholder;
            String replacer = "";
            StringTokenizer st1 = new StringTokenizer(pattern_instance, ";");
            while (st1.hasMoreTokens()) {
                String s = "";
                s = st1.nextToken();
                StringTokenizer st2 = new StringTokenizer(s, "=");
                if (!st2.nextToken().equals(newSubsumerPlaceholder)) continue;
                replacer = "<" + this.ontologyNamespace + st2.nextToken() + ">";
            }
            prequery = prequery.replaceAll("\\" + replacerPlaceholder, replacer);
            prequerySimple = String.valueOf(prequerySimple) + newSubsumerPlaceholder + " rdfs:subClassOf " + replacer + ".\n";
            skipPlaceholders.add(replacerPlaceholder);
        }
        prequerySimple = String.valueOf(prequerySimple) + "}\n";
        if (this.debuggingOutput) {
            System.out.println(prequery);
        }
        if (this.debuggingOutput) {
            System.out.println(prequerySimple);
        }
        OntologyPattern pattern = tp.getOP1();
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        if (ontologyURI.matches("^http.*") || ontologyURI.matches("^file.*")) {
            m.read(ontologyURI);
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(ontologyURI.getBytes());
            m.read((InputStream)in, "");
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Query q = QueryFactory.create((String)prequerySimple);
        QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)m);
        ResultSet rs = qe.execSelect();
        ArrayList<String> query_results = new ArrayList<String>();
        HashMap<String, String> sparqlBinding = new HashMap<String, String>();
        String value = "";
        RDFNode node = null;
        boolean nextOne = false;
        while (rs.hasNext()) {
            nextOne = false;
            sparqlBinding = new HashMap();
            QuerySolution solution = rs.nextSolution();
            for (String string : rs.getResultVars()) {
                String string2 = "?" + string;
                if (skipPlaceholders.contains(string2)) continue;
                node = solution.get(string2);
                if (node.isAnon()) {
                    nextOne = true;
                    break;
                }
                value = node.toString();
                if ((value = value.substring(value.indexOf("#") + 1)).equals("Thing") || value.equals("Nothing")) {
                    nextOne = true;
                    break;
                }
                sparqlBinding.put(string2, value);
            }
            if (this.debuggingOutput) {
                System.out.println("----------" + nextOne);
            }
            if (this.debuggingOutput) {
                System.out.println(sparqlBinding);
            }
            if (nextOne) continue;
            for (SubClassOfPair subClassOfPair : this.subClassOfs) {
                String oldSubsumerPlaceholder = subClassOfPair.subsumerPlaceholder;
                String originalSuperClass = "";
                StringTokenizer st1 = new StringTokenizer(pattern_instance, ";");
                while (st1.hasMoreTokens()) {
                    String s = "";
                    s = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(s, "=");
                    if (!st2.nextToken().equals(oldSubsumerPlaceholder)) continue;
                    originalSuperClass = st2.nextToken();
                }
                sparqlBinding.put(oldSubsumerPlaceholder, originalSuperClass);
            }
            if (xmlSerialization) {
                query_results.add(this.outputXML(sparqlBinding));
                continue;
            }
            query_results.add(this.outputPlain(sparqlBinding));
        }
        String string = "";
        StringTokenizer st1 = new StringTokenizer(pattern_instance, ";");
        sparqlBinding = new HashMap();
        while (st1.hasMoreTokens()) {
            String s = "";
            s = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(s, "=");
            sparqlBinding.put(st2.nextToken(), st2.nextToken());
        }
        if (xmlSerialization) {
            query_results.add(this.outputXML(sparqlBinding));
        } else {
            query_results.add(this.outputPlain(sparqlBinding));
        }
        m.close();
        return query_results;
    }

    public static void main(String[] args) {
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        if (detection.debuggingOutput) {
            System.out.println(OntologyPatternDetectionImpl.outputOnePairXML("", "", "?B=Camera_Ready_event ?A=Event "));
        }
    }

    class SubClassOfPair {
        String subsumerPlaceholder = "";
        String subsumedPlaceholder = "";

        SubClassOfPair(String subsumer, String subsumed) {
            this.subsumerPlaceholder = subsumer;
            this.subsumedPlaceholder = subsumed;
        }

        public String toString() {
            return String.valueOf(this.subsumedPlaceholder) + " subClassOf " + this.subsumerPlaceholder;
        }
    }
}

