/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestLibrary2forORETrans {
    public static void printRenameInstructions(String instructions, String bindings) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(instructions.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/instructions/entities/rename";
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                String new_name;
                String original_name = ((Element)nodesOP.item(i)).getAttribute("original_name");
                if (!original_name.equals(new_name = ((Element)nodesOP.item(i)).getTextContent())) {
                    System.out.println(String.valueOf(original_name) + " to " + new_name);
                    System.out.println(bindings);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String tp1IRI = "http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1b.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "http://www.mindswap.org/2005/debugging/ontologies/koala.owl";
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        try {
            OWLOntology ontologyOWL = manager.loadOntologyFromOntologyDocument(IRI.create((String)ontology));
            ontologyOWL.getOWLOntologyManager();
            OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontologyOWL);
            boolean POStagger = true;
            InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
            String instructions = "<instructions ontology=\"http://www.mindswap.org/2005/debugging/ontologies/koala.owl\" tp=\"http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1b.xml\"><entities> <rename type=\"Class\" original_name=\"Habitat\">Habitat</rename><rename type=\"Class\" original_name=\"Koala\">KoalaHabitat</rename></entities><annotations></annotations></instructions>";
            transformation.setInstructions(instructions);
            transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
            transformation.saveOntology("");
            System.out.println(transformation.printOntology());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

