/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

public class RunTransformationForLogicalReasoning {
    public static void main(String[] args) {
        String path = "file:///" + System.getProperty("user.home") + "/ISWC2011-demo/ontologyReasoning/";
        String ontology = String.valueOf(path) + args[0];
        String tp1IRI = String.valueOf(path) + args[1];
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        if (args[2].equals("1")) {
            transformation.transformOntology(OntologyTransformation.TransformationStrategy.Conservative, false);
        } else if (args[2].equals("3")) {
            transformation.transformOntology(OntologyTransformation.TransformationStrategy.Radical, false);
        } else {
            transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        }
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }
}

