/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.usecase.naming;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.meronym.MyWordNet2;
import cz.vse.keg.patomat.string.Words;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.semanticweb.owlapi.model.OWLOntology;

public class ChildParentNP {
    boolean serverVersion = true;
    TransformationPattern tp;
    String tpIRI = this.serverVersion ? "http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1c.xml" : "file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2b.xml";
    OntologyTransformation<OWLOntology> transformation;
    Words words;
    MyWordNet2 myMeronymy;
    PrintWriter summary;

    ChildParentNP() {
        this.tp = new TransformationPatternImpl(this.tpIRI);
        this.words = new Words(true, "/usr/share/WordNet-3.0", "/usr/share/models");
        this.myMeronymy = new MyWordNet2("/usr/share/WordNet-3.0");
        try {
            this.summary = this.serverVersion ? new PrintWriter(new FileWriter("/home/svabo/codes/NamingPatternExperiment/summary23-05-12.dat", true)) : new PrintWriter(new FileWriter("/home/ondrej/projects/LOD2/WP3/summary23-05-12.dat", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void detectNP(String ontology) throws Exception {
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        this.transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(this.tp, POStagger, this.transformation.getDictionaryPath(), this.transformation.getModelsPath());
        try {
            for (String s : detection.queryPattern(this.tp, ontology, false, true)) {
                String n1 = s.substring(s.indexOf("=") + 1, s.indexOf(";"));
                String n2 = s.substring(s.lastIndexOf("=") + 1);
                this.checkMeronymy(n1, n2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void transform(OntologyTransformation transformation, InstructionGenerator ig) {
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public void checkMeronymy(String name1, String name2) {
        System.out.println(String.valueOf(name1) + " " + name2);
        try {
            String conceptNames1 = this.words.secondSplit(this.words.splitName(" " + name1).toString());
            String hn1 = this.words.getMT(conceptNames1);
            String conceptNames2 = this.words.secondSplit(this.words.splitName(" " + name2).toString());
            String hn2 = this.words.getMT(conceptNames2);
            System.out.println(String.valueOf(hn1) + " " + hn2);
            boolean meronymy = this.myMeronymy.isMeronym2(15, true, hn1, hn2);
            if (meronymy) {
                this.summary.println(String.valueOf(name1) + " " + hn1 + "," + name2 + " " + hn2);
            }
            System.out.println(meronymy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ChildParentNP cpNP = new ChildParentNP();
        try {
            cpNP.detectNP("file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf.owl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

