/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.transformation;

import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import cz.vse.keg.patomat.oppl.MyParserFactory;
import cz.vse.keg.patomat.oppl.MyParserFactory1;
import cz.vse.keg.patomat.transformation.Entity;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.pattern.EntityTypeException;
import cz.vse.keg.patomat.util.URLGrabber;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.OPPLScript;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.common.JUnitTestErrorListener;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLEntityRemover;
import org.semanticweb.owlapi.util.OWLEntityRenamer;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OntologyTransformationImpl
implements OntologyTransformation<OWLOntology> {
    protected OWLOntology ontology;
    protected OWLOntologyManager manager;
    protected OWLDataFactory factory;
    protected String base;
    protected String url;
    protected String tpLocation;
    protected StringBuilder OPPLinstructionsAdding;
    protected StringBuilder OPPLinstructionsRemoving;
    protected ArrayList<String> annotationsDueToRemovingAxioms;
    protected ArrayList<String> annotationsDueToAddingAxioms;
    protected HashMap<Entity, String> renamingEntitiesInstructions;
    protected HashSet<Entity> removingEntities;
    protected HashSet<String> addingAnnotationsAxioms;
    protected HashMap<String, String> newNamespaces;
    protected String dictionaryPath;
    protected String modelsPath;
    private boolean debuggingOutput;

    @Override
    public boolean willTransformOntology() {
        return !this.removingEntities.isEmpty() || !this.OPPLinstructionsRemoving.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;") || !this.renamingEntitiesInstructions.isEmpty() || !this.OPPLinstructionsAdding.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;") || !this.addingAnnotationsAxioms.isEmpty();
    }

    public OntologyTransformationImpl(String url) {
        block10: {
            this.url = "";
            this.tpLocation = "";
            this.debuggingOutput = false;
            try {
                BufferedReader vstup = new BufferedReader(new FileReader("config.properties"));
                String row = vstup.readLine();
                if (row != null) {
                    this.dictionaryPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                if ((row = vstup.readLine()) != null) {
                    this.modelsPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                vstup.close();
            }
            catch (FileNotFoundException e) {
                if (this.debuggingOutput) {
                    System.out.println("File does not exist");
                }
            }
            catch (IOException e) {
                if (!this.debuggingOutput) break block10;
                System.out.println("Error on input of a file");
            }
        }
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.OPPLinstructionsRemoving = new StringBuilder();
        this.annotationsDueToRemovingAxioms = new ArrayList();
        this.annotationsDueToAddingAxioms = new ArrayList();
        this.OPPLinstructionsAdding = new StringBuilder();
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.url = url;
        this.newNamespaces = new HashMap();
        try {
            if (this.url.matches("^http.*") || this.url.matches("^file.*")) {
                this.setOntology(this.manager.loadOntologyFromOntologyDocument(IRI.create((String)this.url)));
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(this.url.getBytes());
                this.ontology = this.manager.loadOntologyFromOntologyDocument((InputStream)in);
                ((InputStream)in).close();
            }
            this.base = this.getBaseURI(":");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OntologyTransformationImpl(OWLOntology ont) {
        block7: {
            this.url = "";
            this.tpLocation = "";
            this.debuggingOutput = false;
            try {
                BufferedReader vstup = new BufferedReader(new FileReader("config.properties"));
                String row = vstup.readLine();
                if (row != null) {
                    this.dictionaryPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                if ((row = vstup.readLine()) != null) {
                    this.modelsPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                vstup.close();
            }
            catch (FileNotFoundException e) {
                if (this.debuggingOutput) {
                    System.out.println("File does not exist");
                }
            }
            catch (IOException e) {
                if (!this.debuggingOutput) break block7;
                System.out.println("Error on input of a file");
            }
        }
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.OPPLinstructionsRemoving = new StringBuilder();
        this.annotationsDueToRemovingAxioms = new ArrayList();
        this.annotationsDueToAddingAxioms = new ArrayList();
        this.OPPLinstructionsAdding = new StringBuilder();
        this.ontology = ont;
        this.manager = this.ontology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.newNamespaces = new HashMap();
        this.base = this.getBaseURI("");
        if (this.base == null) {
            this.base = this.getBaseURI();
        }
        this.url = this.base;
    }

    public OntologyTransformationImpl(OWLOntology ont, String dictionaryPath, String modelsPath) {
        this.url = "";
        this.tpLocation = "";
        this.debuggingOutput = false;
        this.ontology = ont;
        this.dictionaryPath = dictionaryPath;
        this.modelsPath = modelsPath;
        this.manager = this.ontology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.OPPLinstructionsRemoving = new StringBuilder();
        this.annotationsDueToRemovingAxioms = new ArrayList();
        this.annotationsDueToAddingAxioms = new ArrayList();
        this.OPPLinstructionsAdding = new StringBuilder();
        this.newNamespaces = new HashMap();
        this.base = this.getBaseURI("");
        if (this.base == null) {
            this.base = this.getBaseURI();
        }
        this.url = this.base;
    }

    public OntologyTransformationImpl(String url, String wordnetPath, String modelPath) {
        this.url = "";
        this.tpLocation = "";
        this.debuggingOutput = false;
        this.dictionaryPath = wordnetPath;
        this.modelsPath = modelPath;
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.OPPLinstructionsRemoving = new StringBuilder();
        this.annotationsDueToRemovingAxioms = new ArrayList();
        this.annotationsDueToAddingAxioms = new ArrayList();
        this.OPPLinstructionsAdding = new StringBuilder();
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.url = url;
        this.newNamespaces = new HashMap();
        try {
            if (this.url.matches("^http.*") || this.url.matches("^file.*")) {
                this.setOntology(this.manager.loadOntologyFromOntologyDocument(IRI.create((String)this.url)));
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(this.url.getBytes());
                this.ontology = this.manager.loadOntologyFromOntologyDocument((InputStream)in);
                ((InputStream)in).close();
            }
            this.base = this.getBaseURI(":");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getBaseURI(String namespace) {
        Map nsMap = null;
        OWLOntologyFormat format = this.manager.getOntologyFormat(this.ontology);
        if (format instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat nsFormat = (PrefixOWLOntologyFormat)format;
            nsMap = nsFormat.getPrefixName2PrefixMap();
            return (String)nsMap.get(namespace);
        }
        return "";
    }

    private String getBaseURI() {
        Iterator iterator = this.ontology.getClassesInSignature().iterator();
        if (iterator.hasNext()) {
            OWLClass c = (OWLClass)iterator.next();
            return c.toStringID().substring(0, c.toStringID().indexOf("#") + 1);
        }
        return "";
    }

    private void setNewPrefix(String prefix, String namespace) {
        OWLOntologyFormat format = this.manager.getOntologyFormat(this.ontology);
        if (format instanceof PrefixOWLOntologyFormat) {
            ((PrefixOWLOntologyFormat)format).setPrefix(prefix, namespace);
        }
    }

    @Override
    public void setInstructions(String instructions) {
        try {
            String ss;
            StringTokenizer st;
            String sout;
            String sin;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(instructions.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/instructions/entities/rename";
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                if (!((Element)nodesOP.item(i)).getAttribute("original_name").equals(((Element)nodesOP.item(i)).getTextContent())) {
                    this.renamingEntitiesInstructions.put(new Entity(((Element)nodesOP.item(i)).getAttribute("original_name"), ((Element)nodesOP.item(i)).getAttribute("type")), ((Element)nodesOP.item(i)).getTextContent());
                }
                ++i;
            }
            expression = "/instructions";
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.tpLocation = ((Element)nodesOP.item(i)).getAttribute("tp");
                ++i;
            }
            expression = "/instructions/entities/remove";
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.removingEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), ((Element)nodesOP.item(i)).getAttribute("type")));
                ++i;
            }
            expression = "/instructions/annotations/add";
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.addingAnnotationsAxioms.add(((Element)nodesOP.item(i)).getTextContent().replaceAll("!", ""));
                ++i;
            }
            this.OPPLinstructionsRemoving.append("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y ");
            this.OPPLinstructionsAdding.append("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y ");
            this.OPPLinstructionsRemoving.append("BEGIN\n");
            this.OPPLinstructionsAdding.append("BEGIN\n");
            nodesOP = (NodeList)xpath.evaluate("/instructions/oppl_script/add", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                sin = nodesOP.item(i).getTextContent();
                sout = "";
                if (sin.matches(".* equivalentTo .*")) {
                    String pat = "";
                    if (!sin.startsWith("!")) {
                        pat = sin.substring(0, sin.indexOf(" "));
                        if (this.debuggingOutput) {
                            System.out.println("   " + pat);
                        }
                        if (sin.matches("^.*#" + pat + " $")) {
                            if (this.debuggingOutput) {
                                System.out.println("a pak zde");
                            }
                            if (this.debuggingOutput) {
                                System.out.print("using OWL API to create this equivalentTo axiom:");
                            }
                            StringTokenizer st2 = new StringTokenizer(sin);
                            String class1 = st2.nextToken();
                            st2.nextToken();
                            String class2 = st2.nextToken();
                            if (this.debuggingOutput) {
                                System.out.println(String.valueOf(this.base) + class1 + " " + class2);
                            }
                            this.manager.addAxiom(this.ontology, (OWLAxiom)this.factory.getOWLEquivalentClassesAxiom((OWLClassExpression)this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + class1))), (OWLClassExpression)this.factory.getOWLClass(IRI.create((String)class2))));
                        }
                    }
                }
                st = new StringTokenizer(sin);
                while (st.hasMoreTokens()) {
                    ss = st.nextToken();
                    if (this.debuggingOutput) {
                        System.out.println("Problem?" + ss);
                    }
                    if (ss.matches("^!http://.*")) {
                        this.newNamespaces.put(ss.substring(ss.lastIndexOf("/") + 1, ss.lastIndexOf(".")), ss.substring(1, ss.indexOf("#") + 1));
                        sout = String.valueOf(sout) + "!" + ss.substring(ss.lastIndexOf("/") + 1, ss.lastIndexOf(".")) + ":" + ss.substring(ss.indexOf("#") + 1) + " ";
                        continue;
                    }
                    sout = ss.startsWith("(") && ss.indexOf("#") != -1 ? String.valueOf(sout) + "(" + ss.substring(ss.indexOf("#") + 1) + " " : String.valueOf(sout) + ss.substring(ss.indexOf("#") + 1) + " ";
                }
                sout = sout.replace("propertyDisjointWith", "disjointWith");
                if (i != nodesOP.getLength() - 1) {
                    this.OPPLinstructionsAdding.append("ADD " + sout + ",\n");
                    this.annotationsDueToAddingAxioms.add(sout);
                } else {
                    this.OPPLinstructionsAdding.append("ADD " + sout + "\n");
                    this.annotationsDueToAddingAxioms.add(sout);
                }
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/instructions/oppl_script/remove", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                sin = nodesOP.item(i).getTextContent();
                sout = "";
                st = new StringTokenizer(sin);
                while (st.hasMoreTokens()) {
                    ss = st.nextToken();
                    if (this.debuggingOutput) {
                        System.out.println("Problem?" + ss);
                    }
                    sout = ss.startsWith("(") && ss.indexOf("#") != -1 ? String.valueOf(sout) + "(" + ss.substring(ss.indexOf("#") + 1) + " " : String.valueOf(sout) + ss.substring(ss.indexOf("#") + 1) + " ";
                }
                sout = sout.replace("propertyDisjointWith", "disjointWith");
                if (i != nodesOP.getLength() - 1) {
                    this.OPPLinstructionsRemoving.append("REMOVE " + sout + ",\n");
                    this.annotationsDueToRemovingAxioms.add(sout);
                } else {
                    this.OPPLinstructionsRemoving.append("REMOVE " + sout + "\n");
                    this.annotationsDueToRemovingAxioms.add(sout);
                }
                ++i;
            }
            this.OPPLinstructionsRemoving.append("END;\n");
            this.OPPLinstructionsAdding.append("END;\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOntology(OWLOntology o) {
        this.ontology = o;
    }

    @Override
    public OWLOntology transformOntology(OntologyTransformation.TransformationStrategy ts, boolean addAnnotationsForRemovedAddedAxioms) {
        OPPLScript script;
        OPPLParser p;
        JUnitTestErrorListener errorListener;
        TreeSet<OWLAnnotation> annotations;
        if (ts == null) {
            ts = OntologyTransformation.TransformationStrategy.Progressive;
        }
        String annotationNS = "http://nb.vse.cz/~svabo/PatternAnnotation.owl#";
        if (this.debuggingOutput) {
            System.out.println(this.OPPLinstructionsRemoving.toString().trim());
        }
        if (this.debuggingOutput) {
            System.out.println(this.OPPLinstructionsAdding.toString().trim());
        }
        for (String s : this.newNamespaces.keySet()) {
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(s) + "," + this.newNamespaces.get(s));
            }
            this.setNewPrefix(s, this.newNamespaces.get(s));
        }
        if (ts.equals((Object)OntologyTransformation.TransformationStrategy.Radical) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalKeep) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalRemove)) {
            ArrayList<AddAxiom> newAxioms = new ArrayList<AddAxiom>();
            ArrayList<AddAxiom> newAnnotatedAxioms = new ArrayList<AddAxiom>();
            block32: for (Entity e : this.removingEntities) {
                try {
                    switch (e.getType()) {
                        case ObjectProperty: {
                            continue block32;
                        }
                        case DatatypeProperty: {
                            continue block32;
                        }
                        case Class: {
                            OWLClass clss = this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                            OWLClass superClss = null;
                            for (OWLClassExpression c : clss.getSuperClasses(this.ontology)) {
                                if (!(c instanceof OWLClass)) continue;
                                superClss = (OWLClass)c;
                                break;
                            }
                            annotations = new TreeSet();
                            for (OWLAxiom ax : clss.getReferencingAxioms(this.ontology)) {
                                if ((ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalKeep) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalRemove)) && !(ax instanceof OWLDeclarationAxiom)) {
                                    OWLAnnotationProperty property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(this.base) + "annotation:remove_warning_by")));
                                    OWLLiteral annLiteral = this.factory.getOWLLiteral(this.tpLocation);
                                    annotations.add(this.factory.getOWLAnnotation(property, (OWLAnnotationValue)annLiteral));
                                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(this.base) + "annotation:remove_warning_for")));
                                    IRI annValue = IRI.create((String)clss.toStringID());
                                    annotations.add(this.factory.getOWLAnnotation(property, (OWLAnnotationValue)annValue));
                                    newAnnotatedAxioms.add(new AddAxiom(this.ontology, ax.getAnnotatedAxiom(annotations)));
                                }
                                if (!ts.equals((Object)OntologyTransformation.TransformationStrategy.Radical)) continue;
                                if (ax instanceof OWLObjectPropertyRangeAxiom) {
                                    OWLObjectPropertyRangeAxiom axRangeNew = this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)((OWLObjectPropertyRangeAxiom)ax).getProperty(), (OWLClassExpression)superClss);
                                    newAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)axRangeNew));
                                    continue;
                                }
                                if (!(ax instanceof OWLObjectPropertyDomainAxiom)) continue;
                                OWLObjectPropertyDomainAxiom axDomainNew = this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)((OWLObjectPropertyDomainAxiom)ax).getProperty(), (OWLClassExpression)superClss);
                                newAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)axDomainNew));
                            }
                            continue block32;
                        }
                        case Individual: {
                            continue block32;
                        }
                        default: {
                            throw new EntityTypeException("Unrecognized entity type.");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.manager.applyChanges(newAnnotatedAxioms);
            this.manager.applyChanges(newAxioms);
        }
        if (!ts.equals((Object)OntologyTransformation.TransformationStrategy.Conservative) && !this.OPPLinstructionsRemoving.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;")) {
            if (addAnnotationsForRemovedAddedAxioms) {
                OWLAnnotationProperty property;
                annotations = new TreeSet<OWLAnnotation>();
                if (this.debuggingOutput) {
                    System.out.println("Removed axioms:");
                }
                if (this.annotationsDueToRemovingAxioms.size() > 0) {
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "annotation:removed_axiom")));
                    this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)property)));
                }
                for (String string : this.annotationsDueToRemovingAxioms) {
                    if (this.debuggingOutput) {
                        System.out.println(string);
                    }
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "annotation:removed_axiom")));
                    OWLLiteral annLiteral = this.factory.getOWLLiteral(string);
                    this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, this.factory.getOWLAnnotation(property, (OWLAnnotationValue)annLiteral)));
                }
            }
            PelletReasonerFactory reasonerFactory = new PelletReasonerFactory();
            OWLReasoner reasoner = null;
            System.out.println("oppl instructions removing:");
            System.out.println(this.OPPLinstructionsRemoving.toString());
            this.OPPLinstructionsRemoving = new StringBuilder(this.OPPLinstructionsRemoving.toString().replaceAll("baseNamespace@", this.base));
            System.out.println(this.OPPLinstructionsRemoving.toString());
            ArrayList removals = new ArrayList();
            try {
                errorListener = new JUnitTestErrorListener();
                p = new MyParserFactory1(this.manager, this.ontology, reasoner).build((ErrorListener)errorListener);
                script = p.parse(this.OPPLinstructionsRemoving.toString());
                for (OWLAxiomChange axiom : script.getActions()) {
                    System.out.println(axiom);
                    removals.add(axiom);
                }
                this.manager.applyChanges((List)removals);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ts.equals((Object)OntologyTransformation.TransformationStrategy.Radical) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalRemove)) {
            OWLEntityRemover remover = new OWLEntityRemover(this.manager, Collections.singleton(this.ontology));
            block37: for (Entity e : this.removingEntities) {
                try {
                    switch (e.getType()) {
                        case ObjectProperty: {
                            remover.visit(this.factory.getOWLObjectProperty(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block37;
                        }
                        case DatatypeProperty: {
                            remover.visit(this.factory.getOWLDataProperty(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block37;
                        }
                        case Class: {
                            remover.visit(this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block37;
                        }
                        case Individual: {
                            remover.visit(this.factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block37;
                        }
                        default: {
                            throw new EntityTypeException("Unrecognized entity type.");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.manager.applyChanges(remover.getChanges());
        }
        OWLEntityRenamer renamer = new OWLEntityRenamer(this.manager, Collections.singleton(this.ontology));
        block38: for (Entity e : this.renamingEntitiesInstructions.keySet()) {
            OWLObjectProperty entity = null;
            try {
                switch (e.getType()) {
                    case ObjectProperty: {
                        entity = this.factory.getOWLObjectProperty(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case DatatypeProperty: {
                        entity = this.factory.getOWLDataProperty(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Class: {
                        entity = this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Individual: {
                        entity = this.factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Literal: {
                        continue block38;
                    }
                    default: {
                        throw new EntityTypeException("Unrecognized entity type.");
                    }
                }
                if (this.debuggingOutput) {
                    System.out.println(entity + ":" + this.renamingEntitiesInstructions.get(e));
                }
                this.manager.applyChanges(renamer.changeIRI((OWLEntity)entity, IRI.create((String)(String.valueOf(this.base) + this.renamingEntitiesInstructions.get(e)))));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!this.OPPLinstructionsAdding.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;")) {
            if (addAnnotationsForRemovedAddedAxioms) {
                OWLAnnotationProperty property;
                if (this.debuggingOutput) {
                    System.out.println("Added axioms:");
                }
                if (this.annotationsDueToAddingAxioms.size() > 0) {
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "annotation:added_axiom")));
                    this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)property)));
                }
                for (String s : this.annotationsDueToAddingAxioms) {
                    if (this.debuggingOutput) {
                        System.out.println(s);
                    }
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "annotation:added_axiom")));
                    OWLLiteral annLiteral = this.factory.getOWLLiteral(s);
                    this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, this.factory.getOWLAnnotation(property, (OWLAnnotationValue)annLiteral)));
                }
            }
            PelletReasonerFactory reasonerFactory = new PelletReasonerFactory();
            OWLReasoner reasoner = null;
            try {
                System.out.println("oppl instructions adding:");
                System.out.println(this.OPPLinstructionsAdding.toString());
                errorListener = new JUnitTestErrorListener();
                p = new MyParserFactory(this.manager, this.ontology, reasoner).build((ErrorListener)errorListener);
                script = p.parse(this.OPPLinstructionsAdding.toString());
                for (OWLAxiomChange axiom : script.getActions()) {
                    this.manager.applyChange((OWLOntologyChange)axiom);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String entityType = "";
        IRI subject = null;
        OWLAnnotationProperty predicate = null;
        IRI annotationValue = null;
        OWLAnnotationAssertionAxiom annotationAxiom = null;
        AddAxiom axiomToAdd = null;
        for (String string : this.addingAnnotationsAxioms) {
            try {
                StringTokenizer st;
                if (this.debuggingOutput) {
                    System.out.println(string);
                }
                if ((entityType = (st = new StringTokenizer(string, " ")).nextToken()).equals("ObjectProperty")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("DatatypeProperty")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Class")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Individual")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else {
                    if (!entityType.equals("AnonymousIndividual")) break;
                    subject = this.factory.getOWLAnonymousIndividual(st.nextToken());
                }
                String p2 = st.nextToken();
                predicate = p2.matches("^http://.*") ? this.factory.getOWLAnnotationProperty(IRI.create((String)p2)) : this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(this.base) + p2)));
                entityType = st.nextToken();
                if (entityType.equals("ObjectProperty")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("DatatypeProperty")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Class")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Individual")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("AnonymousIndividual")) {
                    annotationValue = this.factory.getOWLAnonymousIndividual(st.nextToken());
                } else {
                    if (!entityType.equals("Literal")) break;
                    annotationValue = this.factory.getOWLLiteral(st.nextToken());
                }
                annotationAxiom = this.factory.getOWLAnnotationAssertionAxiom(predicate, (OWLAnnotationSubject)subject, (OWLAnnotationValue)annotationValue);
                axiomToAdd = new AddAxiom(this.ontology, (OWLAxiom)annotationAxiom);
                this.manager.applyChange((OWLOntologyChange)axiomToAdd);
                if (!this.debuggingOutput) continue;
                System.out.println(axiomToAdd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void preprocessOntology() {
        ArrayList<AddAxiom> addAxioms = new ArrayList<AddAxiom>();
        ArrayList<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
        for (OWLClass cls : this.ontology.getClassesInSignature()) {
            Set allOperands;
            for (OWLClassExpression exp : cls.getEquivalentClasses(this.ontology)) {
                if (!(exp instanceof OWLDisjointUnionAxiom)) continue;
                if (this.debuggingOutput) {
                    System.out.println("DisjointUnionOf " + exp);
                }
                allOperands = ((OWLObjectUnionOf)exp).getOperands();
                for (OWLClassExpression operand : allOperands) {
                    if (!this.debuggingOutput) continue;
                    System.out.println(" " + operand);
                }
            }
            for (OWLClassExpression exp : cls.getSuperClasses(this.ontology)) {
                if (exp instanceof OWLObjectIntersectionOf) {
                    allOperands = ((OWLObjectIntersectionOf)exp).getOperands();
                    for (OWLClassExpression operand : allOperands) {
                        addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, operand)));
                    }
                    removeAxioms.add(new RemoveAxiom(this.ontology, (OWLAxiom)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, exp)));
                }
                if (!(exp instanceof OWLDisjointUnionAxiom)) continue;
                if (this.debuggingOutput) {
                    System.out.println("DisjointUnionOf " + exp);
                }
                allOperands = ((OWLObjectUnionOf)exp).getOperands();
                for (OWLClassExpression operand : allOperands) {
                    if (!this.debuggingOutput) continue;
                    System.out.println(" " + operand);
                }
            }
            for (OWLClassExpression exp : cls.getDisjointClasses(this.ontology)) {
                addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{cls, (OWLClass)exp})));
            }
            for (OWLDisjointUnionAxiom disUn : this.ontology.getDisjointUnionAxioms(cls)) {
                addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)disUn.getOWLDisjointClassesAxiom()));
                addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)disUn.getOWLEquivalentClassesAxiom()));
                removeAxioms.add(new RemoveAxiom(this.ontology, (OWLAxiom)disUn));
            }
        }
        this.manager.applyChanges(addAxioms);
        this.manager.applyChanges(removeAxioms);
    }

    @Override
    public void adjustOWLProfile() {
        ArrayList<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
        OWL2ELProfile profile = new OWL2ELProfile();
        OWLProfileReport report = profile.checkOntology(this.ontology);
        System.out.println("The following axioms are more expressive than OWL2 EL. They are removed from the ontology:");
        int i = 0;
        for (OWLProfileViolation v : report.getViolations()) {
            System.out.println(String.valueOf(++i) + ".:" + v + "\n");
            if (v.getAxiom() == null) continue;
            removeAxioms.add(new RemoveAxiom(this.ontology, v.getAxiom()));
        }
    }

    @Override
    public void saveOntology(String url) {
        try {
            if (url.matches("^file.*")) {
                if (this.debuggingOutput) {
                    System.out.println(url.substring(url.lastIndexOf("/") + 1, url.indexOf(".")));
                }
                this.manager.saveOntology(this.ontology, IRI.create((String)(String.valueOf(url.substring(0, url.indexOf("."))) + "-transformed.owl")));
                this.manager.saveOntology(this.ontology, IRI.create((String)("file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf(".")) + ".owl")));
            } else {
                if (this.debuggingOutput) {
                    System.out.println(this.url);
                }
                if (this.url.indexOf(".") == -1) {
                    this.manager.saveOntology(this.ontology, IRI.create((String)("file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/ontology.owl")));
                } else {
                    this.manager.saveOntology(this.ontology, IRI.create((String)("file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + this.url.substring(this.url.lastIndexOf("/") + 1, this.url.lastIndexOf(".")) + ".owl")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String printOntology() {
        try {
            String s = this.url.indexOf(".") == -1 ? URLGrabber.getDocumentAsString((String)("file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/ontology.owl")) : URLGrabber.getDocumentAsString((String)("file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + this.url.substring(this.url.lastIndexOf("/") + 1, this.url.lastIndexOf(".")) + ".owl"));
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    @Override
    public String getDictionaryPath() {
        return this.dictionaryPath;
    }

    @Override
    public String getModelsPath() {
        return this.modelsPath;
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public OWLOntologyManager getManager() {
        return this.manager;
    }

    @Override
    public void finish() {
        this.manager.removeOntology(this.ontology);
        this.ontology = null;
    }
}

