/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.usecase.logicalreasoning;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import java.util.ArrayList;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWL2QLProfile;
import org.semanticweb.owlapi.profiles.OWL2RLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;

public class OWL2QLProfileTransformation {
    OntologyTransformation<OWLOntology> transformation;
    String ontologyIRI;
    private boolean debuggingOutput = true;

    public OWL2QLProfileTransformation(String ontology) {
        this.ontologyIRI = ontology;
        this.transformation = new OntologyTransformationImpl(ontology);
    }

    public String detectForbiddenAxioms(boolean remove) {
        String result = "";
        ArrayList<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
        OWL2QLProfile profile = new OWL2QLProfile();
        OWLProfileReport report = profile.checkOntology(this.transformation.getOntology());
        if (this.debuggingOutput) {
            System.out.println("The following axioms are more expressive than OWL2 RL:");
        }
        result = "The following axioms are more expressive than OWL2 RL:";
        int i = 0;
        for (OWLProfileViolation v : report.getViolations()) {
            ++i;
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(i) + ".:" + v + "\n");
            }
            result = String.valueOf(result) + i + ".:" + v + "\n";
            if (v.getAxiom() == null) continue;
            removeAxioms.add(new RemoveAxiom(this.transformation.getOntology(), v.getAxiom()));
        }
        if (remove) {
            this.transformation.getManager().applyChanges(removeAxioms);
        }
        return result;
    }

    private void applySuitableTransformationPatterns() {
        OWL2RLProfile profile = new OWL2RLProfile();
        OWLProfileReport report = profile.checkOntology(this.transformation.getOntology());
        String tp1IRI = "";
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        boolean POStagger = false;
        boolean apply_tp_complementEL = false;
        boolean apply_tp_cardinalityEL = false;
        boolean apply_tp_decomposedNominalsELeq = false;
        boolean apply_tp_decomposedNominalsELsub = false;
    }

    public void runTransformationToOWL2QLProfile() {
        this.transformation.preprocessOntology();
        this.transformation.saveOntology("");
        this.ontologyIRI = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + this.ontologyIRI.substring(this.ontologyIRI.lastIndexOf("/") + 1, this.ontologyIRI.lastIndexOf(".")) + ".owl";
        this.detectForbiddenAxioms(false);
        this.transformation.saveOntology("");
        this.transformation.finish();
    }

    public static void main(String[] args) {
        OWL2QLProfileTransformation qlProfileTr = new OWL2QLProfileTransformation("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl");
        qlProfileTr.runTransformationToOWL2QLProfile();
    }
}

