/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.oppl;

import java.util.ArrayList;
import java.util.Map;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.entity.OWLEntityCreationException;
import org.coode.oppl.entity.OWLEntityCreationSet;
import org.coode.oppl.entity.OWLEntityFactory;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class MyEntityFactoryScript1
implements OWLEntityFactory {
    private OPPLAbstractFactory factory;
    private static final char[] forbiddenCharacters = new char[]{'\'', '>', '<', '`', '\"'};

    public MyEntityFactoryScript1(OPPLAbstractFactory f) {
        this.factory = f;
    }

    private String getNamespace(String namespace) {
        Map nsMap = null;
        OWLOntologyFormat format = this.factory.getOntologyManager().getOntologyFormat(this.factory.getOntology());
        if (format instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat nsFormat = (PrefixOWLOntologyFormat)format;
            nsMap = nsFormat.getPrefixName2PrefixMap();
            return (String)nsMap.get(namespace);
        }
        return "";
    }

    private IRI buildIRI(String shortName) {
        System.out.println("Hello I am here " + shortName);
        System.out.println("HHHello I am here " + this.getNamespace(":") + shortName);
        return IRI.create((String)(String.valueOf(this.getNamespace(":")) + shortName));
    }

    private String buildFragment(String label) {
        StringBuilder b = new StringBuilder(label);
        int i = 0;
        while (i < b.length()) {
            char c = b.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                b.setCharAt(i, '_');
            }
            ++i;
        }
        return b.toString().replaceAll("[_]+", "_");
    }

    private String buildLabelString(String label) {
        String toReturn = label.trim();
        char[] cArray = forbiddenCharacters;
        int n = forbiddenCharacters.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            toReturn = toReturn.replace(String.valueOf(c), "");
            ++n2;
        }
        return toReturn;
    }

    public OWLEntityCreationSet<OWLClass> createOWLClass(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLClass.class, shortName, baseIRI);
    }

    public OWLEntityCreationSet<OWLDataProperty> createOWLDataProperty(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLDataProperty.class, shortName, baseIRI);
    }

    public <T extends OWLEntity> OWLEntityCreationSet<T> createOWLEntity(Class<T> type, String shortName, IRI baseIRI) throws OWLEntityCreationException {
        String label = this.buildLabelString(shortName);
        String realShortName = "";
        realShortName = label.indexOf(":") == -1 ? this.buildFragment(label) : label;
        IRI anIRI = this.buildIRI(realShortName);
        T entity = this.getOWLEntity(type, anIRI);
        OWLDeclarationAxiom declarationAxiom = this.factory.getOWLDataFactory().getOWLDeclarationAxiom(entity);
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(this.factory.getOntology(), (OWLAxiom)declarationAxiom));
        if (!realShortName.equals(shortName)) {
            OWLAnnotationProperty rdfsLabel = this.factory.getOWLDataFactory().getRDFSLabel();
            OWLAnnotation owlAnnotation = this.factory.getOWLDataFactory().getOWLAnnotation(rdfsLabel, (OWLAnnotationValue)this.factory.getOWLDataFactory().getOWLLiteral(label));
            OWLAnnotationAssertionAxiom owlAnnotationAssertionAxiom = this.factory.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)entity.getIRI(), owlAnnotation);
            AddAxiom extraChange = new AddAxiom(this.factory.getOntology(), (OWLAxiom)owlAnnotationAssertionAxiom);
            changes.add(extraChange);
        }
        return new OWLEntityCreationSet(entity, changes);
    }

    public OWLEntityCreationSet<OWLNamedIndividual> createOWLIndividual(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLNamedIndividual.class, shortName, baseIRI);
    }

    public OWLEntityCreationSet<OWLObjectProperty> createOWLObjectProperty(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLObjectProperty.class, shortName, baseIRI);
    }

    public OWLEntityCreationSet<OWLAnnotationProperty> createOWLAnnotationProperty(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLAnnotationProperty.class, shortName, baseIRI);
    }

    private <T extends OWLEntity> T getOWLEntity(Class<T> type, IRI IRI2) {
        if (OWLClass.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLClass(IRI2);
        }
        if (OWLObjectProperty.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLObjectProperty(IRI2);
        }
        if (OWLDataProperty.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLDataProperty(IRI2);
        }
        if (OWLNamedIndividual.class.isAssignableFrom(type)) {
            return (T)this.factory.getOWLDataFactory().getOWLNamedIndividual(IRI2);
        }
        return null;
    }

    private <T extends OWLEntity> boolean isValidNewID(String shortName, IRI baseIRI, Class<T> type) {
        return baseIRI.equals(this.factory.getOntology().getOntologyID().getOntologyIRI());
    }

    public <T extends OWLEntity> OWLEntityCreationSet<T> preview(Class<T> type, String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(type, shortName, baseIRI);
    }

    public void tryCreate(Class<? extends OWLEntity> type, String shortName, IRI baseIRI) throws OWLEntityCreationException {
        if (!this.isValidNewID(shortName, baseIRI, type)) {
            throw new OWLEntityCreationException("Invalid name: " + shortName + "for an " + type.getName());
        }
    }
}

