/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.detection;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class OntologyEntityDetection {
    protected OntModel ontologyModel;
    protected String ontologyNamespace = "";

    public OntologyEntityDetection(String ontologyURI, String ontologyNamespace) {
        this.ontologyNamespace = ontologyNamespace;
        this.ontologyModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        if (ontologyURI.matches("^http.*") || ontologyURI.matches("^file.*")) {
            this.ontologyModel.read(ontologyURI);
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(ontologyURI.getBytes());
            this.ontologyModel.read((InputStream)in, "");
        }
    }

    public String getEntityUsage(String entity) {
        RDFNode c;
        RDFNode a;
        QuerySolution soln;
        ResultSet results;
        String result = "";
        String query = "SELECT * WHERE { ";
        String query1 = String.valueOf(query) + "?a ?b <" + this.ontologyNamespace + entity + ">.}";
        String query2 = String.valueOf(query) + "?a <" + this.ontologyNamespace + entity + "> ?c.}";
        String query3 = String.valueOf(query) + "<" + this.ontologyNamespace + entity + "> ?b ?c.}";
        Query q = QueryFactory.create((String)query1.toString());
        QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)this.ontologyModel);
        try {
            results = qe.execSelect();
            while (results.hasNext()) {
                soln = results.nextSolution();
                a = soln.get("?a");
                RDFNode b = soln.get("?b");
                if (a.isAnon() || b.isAnon()) continue;
                result = String.valueOf(result) + this.getLocalname(a.toString()) + " " + this.getLocalname(b.toString()) + " " + entity + ".\n";
            }
            qe.close();
        }
        finally {
            qe.close();
        }
        q = QueryFactory.create((String)query2.toString());
        qe = QueryExecutionFactory.create((Query)q, (Model)this.ontologyModel);
        try {
            results = qe.execSelect();
            while (results.hasNext()) {
                soln = results.nextSolution();
                a = soln.get("?a");
                c = soln.get("?c");
                if (a.isAnon() || c.isAnon()) continue;
                result = String.valueOf(result) + this.getLocalname(a.toString()) + " " + entity + " " + this.getLocalname(c.toString()) + ".\n";
            }
            qe.close();
        }
        finally {
            qe.close();
        }
        q = QueryFactory.create((String)query3.toString());
        qe = QueryExecutionFactory.create((Query)q, (Model)this.ontologyModel);
        try {
            results = qe.execSelect();
            while (results.hasNext()) {
                soln = results.nextSolution();
                RDFNode b = soln.get("?b");
                c = soln.get("?c");
                if (b.isAnon() || c.isAnon()) continue;
                result = String.valueOf(result) + entity + " " + this.getLocalname(b.toString()) + " " + this.getLocalname(c.toString()) + ".\n";
            }
            qe.close();
        }
        finally {
            qe.close();
        }
        return result;
    }

    public String getLocalname(String uri) {
        String name = "";
        if (uri.indexOf("#") != -1) {
            name = uri.substring(uri.indexOf("#") + 1);
            name = name.trim();
        }
        return name;
    }

    public static void main(String[] args) {
        OntologyEntityDetection entityDetection = new OntologyEntityDetection("file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-recursive-changed.owl", "http://confOf#");
        System.out.println(entityDetection.getEntityUsage("Person"));
    }
}

