/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestLibrary2forORE {
    public static void printRenameInstructions(String instructions, String bindings) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(instructions.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/instructions/entities/rename";
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                String new_name;
                String original_name = ((Element)nodesOP.item(i)).getAttribute("original_name");
                if (!original_name.equals(new_name = ((Element)nodesOP.item(i)).getTextContent())) {
                    System.out.println(String.valueOf(original_name) + " to " + new_name);
                    System.out.println(bindings);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String tp1IRI = "http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1b.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "http://nb.vse.cz/~svabo/oaei2011/data/confOf.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPattern(tp1, ontology, false, true)) {
            System.out.println(s);
            ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
            System.out.println("shorten instructions:");
            TestLibrary2forORE.printRenameInstructions(ig.exportInstructions(), s);
            System.out.println("===");
        }
        System.exit(1);
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }
}

