/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.synonym.MyWordNet;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import lila.LiLA;
import lila.syntax.Word;
import lila.tools.wordnet.NounSense;
import lila.tools.wordnet.PrintUtils;
import lila.tools.wordnet.Sense;

public class Test {
    public static void test0() {
    }

    public static void test1original() {
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("?p", "hasDecision");
        binding.put("?A", "Paper");
        binding.put("?B", "Decision");
        binding.put("?C", "Acceptance");
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Acceptance</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        System.out.println(bindingPlaceholders);
        OntologyTransformationImpl transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/cmt.owl");
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_hasSome2.xml");
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Conservative, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test2tp_basic() {
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">ConferenceMember</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        OntologyTransformationImpl transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/cmt.owl");
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_ce-basic.xml");
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test3tp_hasValue() {
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">PresentedPaper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">hasStatus</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?a\">Acceptance</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        OntologyTransformationImpl transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/testAVR1d.owl");
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_ce-hasValue.xml");
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test4tp_hasSome2() {
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_hasSome2.xml");
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/OAEI/10/data/ontologies/cmt.owl";
        System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Rejection</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test4tp_hasSome2V2() {
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_hasSome3.xml");
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/OAEI/10/data/ontologies/cmt.owl";
        System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Rejection</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        detection.initBasicQueryForRecursion(tp1, ontology);
        for (String s : detection.recursiveQuery("?A=Paper ?B=Decision ?C=Rejection ?p=hasDecision ", tp1, ontology, false)) {
            System.out.println(s);
        }
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testSKOS() {
        String tp1IRI = "file:///home/ondrej/prace/ManchesterVisit/SKOStransformation/tp_skos1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/ManchesterVisit/SKOStransformation/cmt.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Radical, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test11tp_nominals() {
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-1.xml");
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";
        System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
        System.exit(1);
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Paper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Decision</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Acceptance</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">hasDecision</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        detection.initBasicQueryForRecursion(tp1, ontology);
        for (String s : detection.recursiveQuery("?A=Paper ?B=Decision ?C=Acceptance ?p=hasDecision ", tp1, ontology, false)) {
            System.out.println(s);
        }
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test12tp_cardinality() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/cardinality/cardinality_issue/tp_cardinality2liteMin.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Cardinality1.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, true, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test13tp_disjoint() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/disjoint/tp_disjoint1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Disjoint1.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test14tp_complement() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement6.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Complement1.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println("one result " + s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test15tp_unionOf() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/union/tp_union1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Union1.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test16tp_nominals() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test17tp_intersection() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/complement/tp_complement1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Intersection1.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        System.out.println(ontology);
        System.exit(1);
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test18tp_nominals() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/nominal_replacement/tp_nominals-6.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/AfricanRedSlip.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_only() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_onlyEL2c.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_cardinalityMin() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_cardinalityELa.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_complement() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_complementELa.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testtp_classAsinstanceOntoDM() {
        String tp1IRI = "file:///home/ondrej/prace/OAEI/11/DMontologies/OntoDMIssue/tp_classAsInstance.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OntoDM.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        System.exit(1);
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_disjointness() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_disjointEL1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        System.exit(1);
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_nominals() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/wine.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_disjointProperties() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_disjointPropertiesEL1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_irreflexive() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_IrreflexiveEL1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_inverseOf() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_inverseOfEL.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_property_charactertistics() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_AsymmetricEL.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_union() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/tp_unionELbannotations.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_toELatOnce() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_toELallA.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_nominalsInLoop() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/wine.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        String localOntology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        boolean POStagger = false;
        ArrayList<String> queryResults = detection.queryPatternNamingAspect(tp1, localOntology, false, false);
        while (queryResults.size() > 0) {
            transformation = new OntologyTransformationImpl(localOntology);
            InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
            for (String s : queryResults) {
                System.out.println(s);
                ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(localOntology, tp1IRI, s));
            }
            System.out.println(ig.exportInstructions());
            transformation.setInstructions(ig.exportInstructions());
            transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
            transformation.saveOntology("");
            tp1 = new TransformationPatternImpl(tp1IRI);
            detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
            queryResults.clear();
            queryResults = detection.queryPatternNamingAspect(tp1, localOntology, false, false);
        }
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_toELTwoPatterns() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_toEL3A.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.preprocessOntology();
        transformation.saveOntology("");
        ontology = "file:///" + System.getProperty("user.home").replaceAll("\\\\", "/") + "/" + ontology.substring(ontology.lastIndexOf("/") + 1, ontology.lastIndexOf(".")) + ".owl";
        transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testELtp_OWL2EL() {
        String ontology = "file:///home/ondrej/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        transformation.adjustOWLProfile();
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testQLtp_individuals() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLQL/tp_individualsQL.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-QL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testQLtp_nominals() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLQL/tp_nominalsQL.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-QL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testLitetp_nominals() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/reasoning/toOWLLite/tp_nominals-liteb.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = false;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test5tp_nary() {
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Reviewer</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">ReviewSubmission</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Paper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?D\">Review</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">submitsReview</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?s\">reviewForPaper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?t\">reviewSubmitted</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        OntologyTransformationImpl transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/nary1.owl");
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_l-n-ary-relation.xml");
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test6tp_specified_values() {
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Topic</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">MultimediaTopic</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">ComputerNetworkTopic</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        OntologyTransformationImpl transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/nary1s.owl");
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_l-specified-values.xml");
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test7tp_reasoning1() {
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">PresentedPaper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">YourPaper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">TheirPaper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?D\">OwnPaper</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">hasStatus</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        OntologyTransformationImpl transformation = new OntologyTransformationImpl("file:///home/ondrej/prace/PatOMat/TPs/ontology/cmt.owl");
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_reasoning1.xml");
        System.out.println(tp1);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(null, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test8tp_agentRole() {
        boolean POStagger = false;
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///tmp/confOf.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_agentRoleV4a2.xml");
        System.out.println(tp1);
        System.out.println(detection.queryPattern(tp1, ontology, true, false));
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance ontology=\"file:///tmp/confOf.owl\">\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Author</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Radical, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test9tp_agentRoleRecursive() {
        boolean POStagger = false;
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-recursive-changed.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_agentRoleV4a2.xml");
        System.out.println(tp1);
        System.out.println(detection.queryPattern(tp1, ontology, false, false));
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        System.out.println("Recursive results: " + detection.recursiveQuery("?B=Author;?A=Person", tp1, ontology, false));
        ArrayList<String> list = detection.recursiveQuery("?B=Author;?A=Person", tp1, ontology, false);
        System.out.println("Recursive result:" + list);
        for (String s : list) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, "file:///home/ondrej/prace/PatOMat/TPs/tp_agentRoleV4a2.xml", s));
        }
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Author</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        ig.generateInstructions(bindingPlaceholders.toString());
        bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">PaperAuthor</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        ig.generateInstructions(bindingPlaceholders.toString());
        bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance>\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Person</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">PosterAuthor</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        ig.generateInstructions(bindingPlaceholders.toString());
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.RadicalKeep, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test_tokenizer() {
        String s = "<pattern_instance><binding placeholder=\"?A\">Person</binding> <binding placeholder=\"?B\">Author</binding> </pattern_instance> <pattern_instance> <binding placeholder=\"?A\">Person</binding> <binding placeholder=\"?B\">PaperAuthor</binding> </pattern_instance> <pattern_instance> <binding placeholder=\"?A\">Person</binding> <binding placeholder=\"?B\">PosterAuthor</binding> </pattern_instance> ";
        s = s.replaceAll("</pattern_instance>", "\t");
        StringTokenizer st = new StringTokenizer(s, "\t");
        String curBinding = "";
        System.out.println(s);
        while (st.hasMoreTokens()) {
            curBinding = st.nextToken();
            System.out.println(curBinding);
            curBinding = String.valueOf(curBinding) + "</pattern_instance>\n";
            System.out.println(curBinding);
        }
    }

    public static void test_lila(String slovo) throws Exception {
        Word word = new Word(slovo);
        try {
            HashSet<String> example = new HashSet<String>();
            String[] s = new String[]{"conference", "publication", "scientific", "research", "participant", "course"};
            int i = 0;
            while (i < s.length) {
                example.add(s[i]);
                ++i;
            }
            LiLA m_lila = new LiLA();
            m_lila.setContext(example);
            System.out.println("\n\nword=" + slovo + " category=" + word.getCategory());
            System.out.println("senses:\n" + PrintUtils.toShortString((Sense[])word.getSenses()));
            if (word.getSense() == null) {
                System.out.println("\nno sense!");
                return;
            }
            if (word.getSense() instanceof NounSense) {
                NounSense noun = (NounSense)word.getSense();
                System.out.println("all hypernyms: " + PrintUtils.toShortString((Sense[])noun.getHypernyms()));
                System.out.println("\nall hyponyms: " + PrintUtils.toShortString((Sense[])noun.getHyponyms()));
                System.out.println("\nall meronyms: " + PrintUtils.toShortString((Sense[])noun.getMeronyms()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test10tp_participation_detectionV1() {
        boolean POStagger = true;
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:////home/ondrej/prace/PatOMat/TPs/ontology/ekaw-imported-tpi.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2a.xml");
        System.out.println(tp1);
        System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
    }

    public static void test10tp_participation_detectionV2() {
        boolean POStagger = true;
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV1.xml");
        System.out.println(tp1);
        System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
        detection.initBasicQueryForRecursion(tp1, ontology);
        System.out.println(detection.recursiveQuery("?p=reviews ?D=Contribution ?C=Member_PC ?B=Reviewing_event ?A=Event", tp1, ontology, true));
    }

    public static void test10tp_participationV1() {
        boolean POStagger = true;
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV1.xml");
        System.out.println(tp1);
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance ontology=\"file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl\">\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Administrative_event</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Reviewing_event</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Member_PC</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?D\">Contribution</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">reviews</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Conservative, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test10tp_participationV2() {
        boolean POStagger = false;
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:////home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        String tpIRI = "file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2.xml");
        System.out.println(tp1);
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance ontology=\"file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf-imported.owl\">\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Event</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Reviewing_event</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Member_PC</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?D\">Contribution</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">reviews</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, true));
        detection.initBasicQueryForRecursion(tp1, ontology);
        ArrayList<String> list = detection.recursiveQuery(" ?B=Reviewing_event ?A=Event ?C=Member_PC ?D=Contribution ?p=reviews ", tp1, ontology, false);
        System.out.println("Recursive result:" + list);
        for (String s : list) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tpIRI, s));
        }
        ig.generateInstructions(bindingPlaceholders.toString());
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Conservative, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void test10tp_participationV2ekaw() {
        boolean POStagger = true;
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:////home/ondrej/prace/PatOMat/TPs/ontology/ekaw-imported-tpi.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        TransformationPatternImpl tp1 = new TransformationPatternImpl("file:///home/ondrej/prace/PatOMat/TPs/tp_participationV2a.xml");
        System.out.println(tp1);
        StringBuilder bindingPlaceholders = new StringBuilder();
        bindingPlaceholders.append("<pattern_instance ontology=\"file:///home/ondrej/prace/PatOMat/TPs/ontology/ekaw-imported.owl\">\n");
        bindingPlaceholders.append("<binding placeholder=\"?A\">Event</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?B\">Individual_Presentation</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?C\">Document</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?D\">Individual_Presentation</binding>\n");
        bindingPlaceholders.append("<binding placeholder=\"?p\">paperPresentedAs</binding>\n");
        bindingPlaceholders.append("</pattern_instance>\n");
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateInstructions(bindingPlaceholders.toString());
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.RadicalKeep, false);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    private static void word(String sLabel) throws Exception {
        Word word = new Word(sLabel);
        System.out.println("\n\nword=" + sLabel + " category=" + word.getCategory());
        System.out.println("senses:\n" + PrintUtils.toShortString((Sense[])word.getSenses()));
        Test.print(word.getSense());
    }

    private Set<String> createContext() {
        HashSet<String> example = new HashSet<String>();
        String[] s = new String[]{"conference", "publication", "scientific", "research", "participant", "course"};
        int i = 0;
        while (i < s.length) {
            example.add(s[i]);
            ++i;
        }
        return example;
    }

    private static void print(Sense sense) throws Exception {
        if (sense == null) {
            System.out.println("\nno sense!");
            return;
        }
        System.out.println("\n" + sense.toString());
        if (sense instanceof NounSense) {
            NounSense noun = (NounSense)sense;
            System.out.println("all hypernyms: " + PrintUtils.toShortString((Sense[])noun.getHypernyms()));
            System.out.println("\nall hyponyms: " + PrintUtils.toShortString((Sense[])noun.getHyponyms()));
        }
    }

    private static void testWordNet() {
        String ontology = "http://nb.vse.cz/~svabo/patomat/ontology/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0/", "/usr/share/models/");
        int i = 0;
        while (i <= 10000) {
            MyWordNet myWordNet = new MyWordNet(transformation.getDictionaryPath());
            myWordNet.finish();
            Object var3_3 = null;
            ++i;
        }
    }

    private static void testHyperonym() {
        String ontology = "http://nb.vse.cz/~svabo/patomat/ontology/OWL2-EL.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0/", "/usr/share/models/");
        MyWordNet myWordNet = new MyWordNet(transformation.getDictionaryPath());
        try {
            System.out.println(myWordNet.isHyperonym1("author", "person"));
            System.out.println(myWordNet.isHyperonym1("workshop", "event"));
            System.out.println(myWordNet.isHyperonym2(12, true, "author", "person"));
            System.out.println(myWordNet.isHyperonym2(12, true, "workshop", "event"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testNamingPattern1() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
            System.out.println(s);
            ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
        }
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void testNamingPattern1a() {
        String tp1IRI = "file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2b.xml";
        TransformationPatternImpl tp1 = new TransformationPatternImpl(tp1IRI);
        System.out.println(tp1);
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
        String ontology = "file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf.owl";
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology);
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        for (String s : detection.queryPattern(tp1, ontology, false, true)) {
            System.out.println(s);
        }
        System.exit(1);
        System.out.println(ig.exportInstructions());
        transformation.setInstructions(ig.exportInstructions());
        transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
        transformation.saveOntology("");
        System.out.println(transformation.printOntology());
    }

    public static void main(String[] args) throws Exception {
        Test.test4tp_hasSome2();
    }
}

