/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.namepattern;

import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.util.Iterator;

public class NLP {
    private Morphology morphology;
    private boolean debuggingOutput = false;

    public NLP(String modelsPath, boolean debuggingOutput) {
        try {
            this.morphology = new Morphology();
            this.debuggingOutput = debuggingOutput;
            MaxentTagger.init((String)(String.valueOf(modelsPath) + "/left3words-wsj-0-18.tagger"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void posTag(String bag) {
        try {
            String taggedString = MaxentTagger.tagString((String)"Here's a tagged string.");
            String taggedString2 = MaxentTagger.tagString((String)"This is your life.");
            if (this.debuggingOutput) {
                System.out.println(taggedString);
            }
            if (this.debuggingOutput) {
                System.out.println(taggedString2);
            }
            Sentence taggedSentence = MaxentTagger.tagStringTokenized((String)bag);
            for (TaggedWord currentWord : taggedSentence) {
                Word lemWord = this.morphology.stem(new Word(currentWord.word()));
                if (!this.debuggingOutput) continue;
                System.out.println(lemWord + ",tag:" + currentWord.tag());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getOneWordTag(String oneWord) {
        try {
            Sentence taggedSentence = MaxentTagger.tagStringTokenized((String)oneWord);
            Iterator it = taggedSentence.iterator();
            if (it.hasNext()) {
                TaggedWord currentWord = (TaggedWord)it.next();
                return currentWord.tag();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getOneWordLemma(String oneWord) {
        try {
            Sentence taggedSentence = MaxentTagger.tagStringTokenized((String)oneWord);
            Iterator it = taggedSentence.iterator();
            if (it.hasNext()) {
                TaggedWord currentWord = (TaggedWord)it.next();
                Word lemWord = this.morphology.stem(new Word(currentWord.word()));
                return lemWord.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public void finish() {
        this.morphology = null;
    }

    public static void main(String[] srgs) {
        NLP tagger = new NLP("/usr/share/models/", true);
        String s = "has";
        tagger.posTag("electronic document stored");
        if (tagger.debuggingOutput) {
            System.out.println(tagger.getOneWordTag("married"));
        }
        if (tagger.debuggingOutput) {
            System.out.println(tagger.getOneWordLemma("married"));
        }
    }
}

