package cz.vse.keg.patomat.string2;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.*;
//import cz.vse.keg.patomat.util.URLGrabber;
import cz.vse.keg.patomat.namepattern.NLP;

public class Words2 {
	public int numHyphen=0;
	public int numCamel=0;
	public int numUnderscore=0;
	public int numDot=0;
    public NLP nlp;
    private HashMap<String, String> passive_verbs;
    private boolean POStagger; //28-07-09,whether we will use POStagger or not
  /*
	public Words() {
	  this.POStagger=false;
	}
  */
  public Words2(boolean POStagger, String dictionaryPath, String modelsPath) {
	  if (POStagger) { 
		  //initialize class NLP with NLP stuff
		  nlp = new NLP(modelsPath, false);		  
		  
		//03-06-11, nacteni souboru s pasivnimi tvary sloves
		  passive_verbs=new HashMap<String,String>();
		  try {
			  //BufferedReader vstup = new BufferedReader(new FileReader ("/usr/share/WordNet-3.0/dict/verb.exc"));
			  BufferedReader vstup = new BufferedReader(new FileReader (dictionaryPath+"/dict/verb.exc"));
			  String row;
			  row = vstup.readLine();
			  while (row != null) {
				  StringTokenizer st = new StringTokenizer(row);
				  String passive=st.nextToken();
				  if (nlp.getOneWordTag(passive).equals("VBN")) {
					  passive_verbs.put(st.nextToken(), passive);
				  }			  
				  row = vstup.readLine();
			  }
			  vstup.close();
		  }
		  catch (FileNotFoundException e) {
			System.out.println ("File does not exist");
		  }
		  catch (IOException e){
			System.out.println ("Error on input of a file");
		  }
		  //System.out.println(passive_verbs);
	  }
	  
	  this.POStagger=POStagger;
	  	  
  }
	
	
  //metoda, ktera jen zjisti, zda se nazev sklada z vice tokenu
  public boolean multiTokenName(String name) {
  	name = name.substring(1);
  	if (name.indexOf("_")!=-1) return true;
  	else if (name.indexOf("-")!=-1) return true;
  	else if (name.matches(".*[A-Z].*")) return true;
  	else return false;
  }
  
  public String splitName(String name) {
  //public ArrayList<String> splitName(String name) {
  	//underscore _, hyphen -, lowercaseToUppercase
  	//firstly we should determine the delimiter
  	String delimiter="";
  	String strings[]=null;
  	//ArrayList<String> result = new ArrayList<String>();
  	//if -here is two names delimited with space eg. UnionOf(Paper Author)  	 
  	//    	
  	if (name.indexOf("_")!=-1) {
  		delimiter="_";
  		numUnderscore++;
  	}
  	else if (name.indexOf(".")!=-1) {
  		delimiter="[.]"; //NOTE: novinka,18.4.2008
  		numDot++;
  	}
  	else if (name.indexOf("-")!=-1) {
  		delimiter="-";
  		numHyphen++;
  	}
  	//else if (name.indexOf(".")!=-1) delimiter="."; //NOTE: novinka,18.4.2008
  	else if (name.matches(".*[A-Z].*")) {
  		delimiter="upper";
  		numCamel++;
  	}
  	//then split the string
  	if (delimiter.equals("upper")) {
  		//15-07-09,new way of tokenisation in the case of camel word:
  		boolean previousBig=false;
  		char[] chars = name.toCharArray();
  		String newName="";
  		for (int i=0;i<chars.length;i++) {
  			if ((new String(chars,i,1)).matches("[A-Z]")) {
  				if (previousBig) {
  					newName+=new String(chars,i,1);
  					previousBig=true;
  				}
  				else {  					
  					newName+="%"+new String(chars,i,1);
  					previousBig=true;
  				}
  			}
  			else {
  				newName+=new String(chars,i,1);
  				previousBig=false;
  			}
  		}  		
  		strings = newName.split("%");  		  		
  	}
  	else if (delimiter.equals("")) {
  		strings = new String[1];
  		strings[0]=name;
  	}
  	else {
  		strings = name.split(delimiter);
  	}  	  	
  	//strings.toString()
  	//NOTE,26-09-08:plati tento nebo nasledujici radek!
  	//for(int i=0;i<strings.length;i++) result.add(strings[i].toLowerCase());
  	//for(int i=0;i<strings.length;i++) result.add(strings[i]);
  	//return result;
  	return Arrays.toString(strings).toLowerCase().replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(",", "");
  }
  //mnozinove porovnani pro "difference_sety"
  public boolean compareSets(ArrayList set1, ArrayList set2) {
  	Iterator it;
  	//set1.add("ahoj");
  	//set1.add("jak");
  	//set2.add("jak");
  	//set2.add("ahoj");  	
  	//set2.add("se");
  	
  	if (set1.size()!=set2.size()) {
  		return false;
  	}
  	else {
  		it = set1.iterator();
  		while (it.hasNext()) {
  			if (!set2.contains((String)it.next())) {
  				return false;
  			}
  		}
  		return true;
  	}
  }
  
  //26-09-08, porovnat, zda maji nejake shodne slovo
  public boolean compareTokenSets(ArrayList<String> set1, ArrayList<String> set2) {
  	//10-08-09,vsechny slova nahradim jejich lemmaty=>vyssi pravdepodobnost sharedToken
	ArrayList<String> set1a = new ArrayList<String>(set1.size());
	ArrayList<String> set2a = new ArrayList<String>(set2.size());
	if(POStagger) {
  		for(String s : set1) {
  			set1a.add(nlp.getOneWordLemma(s));
  		}		
  		for(String s : set2) {
  			set2a.add(nlp.getOneWordLemma(s));
  		}
  	}
	else {
		set1a=set1;
		set2a=set2;
	}
	  
	Iterator it;
  	//set1a.add("ahoj");
  	//set1a.add("jak");
  	//set2a.add("jak");
  	//set2a.add("ahoj");  	
  	//set2a.add("se");  	
  	int size1=set1a.size();
  	int size2=set2a.size();
  	//from upper_case to lower_case
  	//for(int i=0;i++;i<=size1) {
  	//	set1a
  	//}
  	set1a.remove(0);
  	set2a.remove(0);
  	//System.out.println(set1a);
  	//System.out.println(set2a);
  	  	
  	if (size1>=size2) {
  		it = set1a.iterator();
  		while (it.hasNext()) {
  			if (set2a.contains((String)it.next())) {
  				return true;
  			}
  		}
  		return false;
  	}
  	else {
  		it = set2a.iterator();
  		while (it.hasNext()) {
  			if (set1a.contains((String)it.next())) {
  				return true;
  			}
  		}
  		return false;
  	}
  }
  
  //27-12-08, ziskani sdileneho slova ve dvou ArrayListech
  public String getSharedToken(ArrayList set1, ArrayList set2) {
  	Iterator it;
 // 	set1.add("PERSON");
 // 	set1.add("Thing");
 // 	set2.add("PERSON");
 // 	set2.add("Thing");  	  	
  	int size1=set1.size();
  	int size2=set2.size();
  	//from upper_case to lower_case
  	//for(int i=0;i++;i<=size1) {
  	//	set1
  	//}
  	String s="";
  	
  	if (size1>=size2) {
  		it = set1.iterator();
  		while (it.hasNext()) {
  			s=(String)it.next();
  			if (set2.contains(s)) {
  				return s;
  			}
  		}
  		return "";
  	}
  	else {
  		it = set2.iterator();
  		while (it.hasNext()) {
  			s=(String)it.next();
  			if (set1.contains(s)) {
  				return s;
  			}
  		}
  		return "";
  	}
  }
  
  public boolean fuzzyCompareSets(ArrayList set1, ArrayList set2) {
	//set1.add("ahoj");
  	//set1.add("jak");
  	//set1.add("ako");
  	//set2.add("jak");
  	//set2.add("ahoj");  	
  	//set2.add("se");
  	//set2.add("ako");
  	//set2.add("pako");
  	//set2.add("proc");
	
  	Iterator it;
  	ArrayList set;
  	int size1=set1.size();
  	int size2=set2.size();
  	int match=0;
  	double need_matches=0;
  	int need_m=0;
  	
  	if (size1>=size2) {
  		need_matches=(size1-1)*0.5;  		
  		it = set1.iterator();
  		set=set2;
  	}
  	else {
  		need_matches=(size2-1)*0.5;
  		it = set2.iterator();
  		set=set1;
  	}  	  	
  	need_m=(int)need_matches;  	  	  	
  	it.next();//NOTE:na prvni pozici je jmeno ontologie
  	while (it.hasNext()) {
  		if (set.contains((String)it.next())) {
  			match++;
  		}
  		//else return false;
  		//System.out.println(match+","+need_matches);
  	}
  	if (match>=need_matches) return true;
  	else return false;
  	//return true;
  }
  
  public boolean wordPresence(String what, String where) {
  	boolean presence = false;
  	//assuming "what" is string of this form> "[paper,author]"
  	//assuming "where" is string of this form> "comment(hello paper author)" or just sentence  	  	  	
  	what = what.substring(1,what.length()-1);  
  	where = where.toLowerCase();  	  	
  	//odstraneni "[" a "]"
  	if ((what.indexOf("[")!=-1)&&(what.indexOf("]")!=-1)) {
  		what = what.substring(1,what.length()-1);  
  	}
  	if ((where.indexOf("[")!=-1)&&(where.indexOf("]")!=-1)) {
  		where = where.substring(1,where.length()-1);  
  	}
  	System.out.println(what);	
  	System.out.println(where);	
  	StringTokenizer st = new StringTokenizer(what,","); 
  	while (st.hasMoreTokens()) {
  		String next=(st.nextToken()).replaceAll("\\(","");
  		next=next.replaceAll("\\)","");
  		if (where.matches(".*"+next+".*")) {
  			presence=true;
  		}
  	}
  	return presence;
  }
  
  //split from concept
  public String secondSplit(String concept) {   	  
  	
  	if ((concept.indexOf("[")!=-1)&&(concept.indexOf("]")!=-1)) {
  		concept = concept.substring(1,concept.length()-1);  
  	}
  	concept=concept.replaceAll(",","");
  	/*
  	StringTokenizer st = new StringTokenizer(concept,","); 
  	sresult="";
  	while (st.hasMoreTokens()) {
  		s="";
  		String next=(st.nextToken()).replaceAll("\\(","");
  		next=next.replaceAll("\\)","");  		
  		//if (next.equals("")) break;
  		result=splitName(next);
  		result=next;
  		s=result.toString();
  		System.out.println(s+" huu");
  		if ((s.indexOf("[")!=-1)&&(s.indexOf("]")!=-1)) {
  			s = s.substring(1,s.length()-1);  
  		}
  		sresult+=s; 		
  	}
  	sresult=sresult.replaceAll(",","");
  	return sresult.replaceAll("  "," ");
  	*/
  	return concept;
  }
  
  //method for joining one-letter-words like U R L into URL
  public String joinLetters(String concept) {
  	String result="";
  	String next;
  	StringTokenizer st = new StringTokenizer(concept," "); 
  	while(st.hasMoreTokens()) {
  		next = st.nextToken();
  		if (next.length()>1) result+=" "+next+" ";
  		else result+=next;
  	}
  	return result;
  }
  
  //method for getting main term, lexical head or head noun
  //28-07-09,it is possible to use POS tagger, maybe it is more expensive
  /**
   *@deprecated please now use getHeadNoun(String concept)
   *@see getHeadNoun(String concept)
   */
  public String getMT(String concept) throws Exception {
  	//NOTE: v pozdejsich verzich by to chtelo spojit s metodou create_table_cluster z Chief class
  	//spojeni jednopismennych "slov"
  	concept=joinLetters(concept);
  	//28-07-09,using POS tagger or not
  	ArrayList<String> preps = new ArrayList<String>();
  	ArrayList<String> verbs = new ArrayList<String>();
  	boolean preposition = false; //"IN"
  	boolean passive_verb = false; //"VBN"
  	boolean gerund_verb = false; //"VBG"
  	String POStag="";  	  
  	if (!POStagger) {
  		//slovnik prepositions jako ArrayList  	  	
  		preps.add("as");
  		preps.add("in");
  	  	preps.add("of");
  	  	preps.add("not");//it is not preposition, of course
  	  	preps.add("at");
  	  	preps.add("without");
  	  	preps.add("after");
  	  	preps.add("before");
  	  	preps.add("about");
  	  	preps.add("from");
  	  	preps.add("towards");
  	  	preps.add("against");
  	  	preps.add("for");
  	  	preps.add("above");
  	  	preps.add("beside");
  	  	preps.add("beneath");
  	  	  	  	
	  	//verbs = URLGrabber.getDocumentAsList("file:///C:/D/ondra/doktorandsky/Protege/src/verbsPassive.txt");
	  	verbs.add("added");
	  	verbs.add("done");
	  	verbs.add("included");
  	}  	
  	//preps.add("in");
  	//preps.add("in");
  	//slovnik sloves?
  	ArrayList<String> meta = new ArrayList<String>();
  	//co,meta,non,sub,super
  	meta.add("co");
  	meta.add("meta");
  	meta.add("non");
  	meta.add("sub");
  	meta.add("super");
  	//casti slov jako take off, ... up apod.
  	ArrayList<String> parts = new ArrayList<String>();
  	parts.add("off");
  	parts.add("up");
  	
  	int rule2exc=-1;
  	StringTokenizer st = new StringTokenizer(concept," "); 
  	ArrayList<String> conceptName = new ArrayList<String>();  	
  	
  	String main_term="";
  	String s;
  	int i=0;
  	while (st.hasMoreTokens()) {  		  		
  		passive_verb=false;
  		gerund_verb=false;
  		preposition=false;
  		
  		String next=st.nextToken();
  		next=next.toLowerCase();  	
  		if (POStagger) {
  			POStag=nlp.getOneWordTag(next);
  			if (POStag.equals("VBN")||POStag.equals("VBD")) {
  				passive_verb=true;
  			}
  			else if (POStag.equals("VBG")) {
  				gerund_verb=true;
  			}
  			else if (POStag.equals("IN")) {
  				preposition=true;
  			}
  		}
  		else {
  			if (preps.contains(next)) preposition=true;
  			else if (verbs.contains(next)) passive_verb=true;
  		}  		
  		conceptName.add(next);
  		//19-11-08,spojeni "meta" spojek s nasledujicim slovem
  		if (i>0) {
  			if (meta.contains(((String)conceptName.get(i-1)))) {
  				//System.out.println("tady");
  				conceptName.set(i,((String)conceptName.get(i-1))+((String)conceptName.get(i)));
  				//conceptName.remove(i-1); IndexOutOfBoundsException ale nevim proc, 19-11-08
  			}  			
  		}
  		//rule2, NOTE,28-07-09,this begining of rule is not very clear for me now
  		//NOTE,29-07-09,partinomy?, eg. amino-acid-part-of-protein-population,head noun not before of but after part-of
  		//BUT there can be the case like "isPartOf" then head noun cannot be after PartOf
  		if (i>0&&preposition&&rule2exc==-1) {  			
  			if ((((String)conceptName.get(i-1)).equals("part"))||
  				((String)conceptName.get(i-1)).equals("parts")) {
  				rule2exc=i;  				
  			}
  			else {
  			//rule2 - preposition rule
  				main_term=(String)conceptName.get(i-1);//slovo pred predlozkou
  				//18-11-08, pokud je tam sloveso v pasivu
  				if (verbs.contains(main_term)) {
  					main_term=(String)conceptName.get(i-2); //slovo pred slovesem
				}
  				return main_term;
  			}  			  			
  		}
  		else if (passive_verb) {
  		//rule 3
  			if (i>1) {
  				main_term=(String)conceptName.get(i-1);//slovo pred slovesem
  				return main_term;
  			}
  			else { 
  				i++;
  				continue;  			
  			}
  		}
  		//System.out.println("|"+i+next+"|");
  		i++;
  	}
  	i--;
  	//rule1-last word is number - numberFormatException
  	//NOTE,28-07-09,the following "number" rule is not very clear for me now
  	
  	try {  	
  		Integer num = new Integer((String)conceptName.get(i));
  		if (((String)conceptName.get(0)).length()==1) {
  		//jestli je to jednopismenne slovo, pak mt je to nasl. slovo
  			if (conceptName.size()>1) {
  				main_term=(String)conceptName.get(1);
  			}
  			else {
  				main_term=(String)conceptName.get(0);
  			}
  		}
  		else main_term=(String)conceptName.get(0);//je to cislo;
  		return main_term;
  	}
  	catch (NumberFormatException e){
  		//System.err.println("Neni to cislo");
  		//continue;  		
  	} 
  	if (rule2exc!=-1) {
  		System.out.println("rule2exception "+rule2exc+","+concept+i);
  		if (rule2exc==(i)) main_term=(String)conceptName.get(rule2exc-1);//29-07-09,pokud je part_of posledni v retezci, pak head noun je token pred of napr. part
  		else main_term=(String)conceptName.get(rule2exc+1);//token na pozici rule2exc+1 je head noun
  	} else
  	//rule1-last word is number - numberFormatException
  	/*
  	try {  	
  		Integer num = new Integer((String)conceptName.get(i));
  		main_term="hula";//(String)conceptName.get(0);
  	}
  	catch (NumberFormatException e){
  		System.out.println("Neni to cislo");
  		//continue;  		
  	}
  	*/ 
  	//rule4, spojovani slov, jedna se vlastne o opravu nedokonale tokenizace
  	if (parts.contains((String)conceptName.get(i))) {
  		//System.out.println("hahoj");
  		if (i>0) {
  			main_term=(String)conceptName.get(i-1)+(String)conceptName.get(i);  	
  		}
  		else main_term=(String)conceptName.get(i);
  	}
  	
  	//rule 5 aplikovano jen, pokud se vyuziva i POStagger
  	//rule 5, pokud je na 1. pozici gerundium pak MT neboli head_noun je toto  	
  	//03-06-11,momentalne vypnuto kvuli gerundiualnimu pripadu, kde to neni head_noun, Reviewing_event
  	/*
  	else if (POStagger) {
	  		if (nlp.getOneWordTag(((String)conceptName.get(0))).equals("VBG")) {
	  			main_term=(String)conceptName.get(0);//gerundium
	  			System.out.println("gerundium");
	  			return main_term;  		
	  		}
	  		else main_term=(String)conceptName.get(i);//DEFAULT RULE
  	}*/
  	//DEFAULT RULE
  	else {
  		main_term=(String)conceptName.get(i);  		
  	}  	
  	return main_term;
  }
  
  //13-11-12, pokus o vylepseni puvodni metody getMT - nyni getHeadNoun
  public String getHeadNoun(String concept) throws Exception {
  	//spojeni jednopismennych "slov", napr. u r l -> url
  	concept=joinLetters(concept);
  	//28-07-09,using POS tagger or not
  	ArrayList<String> preps = new ArrayList<String>();
  	ArrayList<String> verbs = new ArrayList<String>();
  	boolean preposition = false; //"IN"
  	boolean passive_verb = false; //"VBN"
  	boolean gerund_verb = false; //"VBG"
  	String POStag="";  	  
  	if (!POStagger) {
  		//slovnik prepositions jako ArrayList  	  	
  		preps.add("as");
  		preps.add("in");
  	  	preps.add("of");
  	  	preps.add("not");//it is not preposition, of course
  	  	preps.add("at");
  	  	preps.add("without");
  	  	preps.add("after");
  	  	preps.add("before");
  	  	preps.add("about");
  	  	preps.add("from");
  	  	preps.add("towards");
  	  	preps.add("against");
  	  	preps.add("for");
  	  	preps.add("above");
  	  	preps.add("beside");
  	  	preps.add("beneath");
  	  	  	  	
	  	//verbs = URLGrabber.getDocumentAsList("file:///C:/D/ondra/doktorandsky/Protege/src/verbsPassive.txt");
	  	verbs.add("added");
	  	verbs.add("done");
	  	verbs.add("included");
  	}  	
  	//preps.add("in");
  	//preps.add("in");
  	//slovnik sloves?
  	ArrayList<String> meta = new ArrayList<String>();
  	//co,meta,non,sub,super
  	meta.add("co");
  	meta.add("meta");
  	meta.add("non");
  	meta.add("sub");
  	meta.add("super");
  	//casti slov jako take off, ... up apod.
  	ArrayList<String> parts = new ArrayList<String>();
  	parts.add("off");
  	parts.add("up");
  	
  	int rule2exc=-1;
  	StringTokenizer st = new StringTokenizer(concept," "); 
  	ArrayList<String> conceptName = new ArrayList<String>();  	
  	
  	String main_term="";
  	String s;
  	int i=0;
  	while (st.hasMoreTokens()) {  		  		
  		passive_verb=false;
  		gerund_verb=false;
  		preposition=false;
  		
  		String next=st.nextToken();
  		next=next.toLowerCase();  	
  		if (POStagger) {
  			POStag=nlp.getOneWordTag(next);
  			if (POStag.equals("VBN")||POStag.equals("VBD")) {
  				passive_verb=true;
  			}
  			else if (POStag.equals("VBG")) {
  				gerund_verb=true;
  			}
  			else if (POStag.equals("IN")) {
  				preposition=true;
  			}
  		}
  		else {
  			if (preps.contains(next)) preposition=true;
  			else if (verbs.contains(next)) passive_verb=true;
  		}  		
  		conceptName.add(next);
  		//19-11-08,spojeni "meta" spojek s nasledujicim slovem
  		if (i>0) {
  			if (meta.contains(((String)conceptName.get(i-1)))) {
  				//System.out.println("tady");
  				conceptName.set(i,((String)conceptName.get(i-1))+((String)conceptName.get(i)));
  				//conceptName.remove(i-1); IndexOutOfBoundsException ale nevim proc, 19-11-08
  			}  			
  		}
  		//rule2, NOTE,28-07-09,this begining of rule is not very clear for me now
  		//NOTE,29-07-09,partinomy?, eg. amino-acid-part-of-protein-population,head noun not before of but after part-of
  		//BUT there can be the case like "isPartOf" then head noun cannot be after PartOf
  		if (i>0&&preposition&&rule2exc==-1) {  			
  			if ((((String)conceptName.get(i-1)).equals("part"))||
  				((String)conceptName.get(i-1)).equals("parts")) {
  				rule2exc=i;  				
  			}
  			else {
  			//rule2 - preposition rule
  				main_term=(String)conceptName.get(i-1);//slovo pred predlozkou
  				//18-11-08, pokud je tam sloveso v pasivu
  				if (verbs.contains(main_term)) {
  					main_term=(String)conceptName.get(i-2); //slovo pred slovesem
				}
  				return main_term;
  			}  			  			
  		}
  		else if (passive_verb) {
  		//rule 3
  			if (i>1) {
  				main_term=(String)conceptName.get(i-1);//slovo pred slovesem
  				return main_term;
  			}
  			else { 
  				i++;
  				continue;  			
  			}
  		}
  		//System.out.println("|"+i+next+"|");
  		i++;
  	}
  	i--;
  	//rule1-last word is number - numberFormatException
  	//NOTE,28-07-09,the following "number" rule is not very clear for me now
  	
  	try {  	
  		Integer num = new Integer((String)conceptName.get(i));
  		if (((String)conceptName.get(0)).length()==1) {
  		//jestli je to jednopismenne slovo, pak mt je to nasl. slovo
  			if (conceptName.size()>1) {
  				main_term=(String)conceptName.get(1);
  			}
  			else {
  				main_term=(String)conceptName.get(0);
  			}
  		}
  		else main_term=(String)conceptName.get(0);//je to cislo;
  		return main_term;
  	}
  	catch (NumberFormatException e){
  		//System.err.println("Neni to cislo");
  		//continue;  		
  	} 
  	if (rule2exc!=-1) {
  		System.out.println("rule2exception "+rule2exc+","+concept+i);
  		if (rule2exc==(i)) main_term=(String)conceptName.get(rule2exc-1);//29-07-09,pokud je part_of posledni v retezci, pak head noun je token pred of napr. part
  		else main_term=(String)conceptName.get(rule2exc+1);//token na pozici rule2exc+1 je head noun
  	} else
  	//rule1-last word is number - numberFormatException
  	/*
  	try {  	
  		Integer num = new Integer((String)conceptName.get(i));
  		main_term="hula";//(String)conceptName.get(0);
  	}
  	catch (NumberFormatException e){
  		System.out.println("Neni to cislo");
  		//continue;  		
  	}
  	*/ 
  	//rule4, spojovani slov, jedna se vlastne o opravu nedokonale tokenizace
  	if (parts.contains((String)conceptName.get(i))) {
  		//System.out.println("hahoj");
  		if (i>0) {
  			main_term=(String)conceptName.get(i-1)+(String)conceptName.get(i);  	
  		}
  		else main_term=(String)conceptName.get(i);
  	}
  	
  	//rule 5 aplikovano jen, pokud se vyuziva i POStagger
  	//rule 5, pokud je na 1. pozici gerundium pak MT neboli head_noun je toto  	
  	//03-06-11,momentalne vypnuto kvuli gerundiualnimu pripadu, kde to neni head_noun, Reviewing_event
  	/*
  	else if (POStagger) {
	  		if (nlp.getOneWordTag(((String)conceptName.get(0))).equals("VBG")) {
	  			main_term=(String)conceptName.get(0);//gerundium
	  			System.out.println("gerundium");
	  			return main_term;  		
	  		}
	  		else main_term=(String)conceptName.get(i);//DEFAULT RULE
  	}*/
  	//DEFAULT RULE
  	else {
  		main_term=(String)conceptName.get(i);  		
  	}  	
  	return main_term;
  }
  
  public boolean porovnej(String aCode, String etalonCode2) {
  	//System.out.println(etalonCode2);
  	//System.out.println(aCode);
  	aCode=aCode.replace("|","");
  	return aCode.matches("^"+etalonCode2+".*");
  }
  
  public int getLevels(String code) {
  	int i=0;
  	StringTokenizer st = new StringTokenizer(code,"|"); 
  	//boolean noNullLevel=true;
  	String next;
  	while (st.hasMoreTokens()) {
  		next=st.nextToken();
  		if (next.equals("0")) {
  			break;
  		}
  		else {
  			i++;
  		}
  	}  	
  	return i;
  }
  
  public String getFirstLevel(String code) {
  	code = code.substring(0,code.indexOf("|"));
  	return code;
  }
  
  //19-02-09,return TRUE if head_noun1 of concept is at the different position of word than it is suspected
  //ie. it indicates that head_noun1 of concept was badly detected 
  public boolean bad_head_noun(String concept,String head_noun) {
  	String conceptNames=secondSplit((splitName(" "+concept).toString()));    
    StringTokenizer st = new StringTokenizer(conceptNames," "); 
    while (st.hasMoreTokens()) {  		  		
  		String next=st.nextToken();
  		next=next.toLowerCase();
  		if (next.equals(head_noun)) {
  			return true; //TRUE as originally bad head_noun1 of concept
  		}
  	}
  	return false;    
  }
  //03-06-11,for getting complement of head noun
  public String getComplementHeadNoun(String conceptName) {
	String splitted=secondSplit((splitName(" "+conceptName).toString()));
	System.out.println(splitted);
	try {
		String head_noun=getMT(splitted);
		System.out.println(head_noun);
		StringTokenizer st = new StringTokenizer(splitted);
		String complement="";
		while(st.hasMoreTokens()) {
			String token=st.nextToken();
			if (!token.equals(head_noun)) complement+=token.substring(0,1).toUpperCase()+token.substring(1);
		}
		return complement;
	}
	catch(Exception e) {
		e.printStackTrace();
	}
	return "";
  }
  //03-06-11, using /usr/share/WordNet-3.0/dict/verb.exc if there is no passive tense than I make it simply like +e
  public String getVerbPassiveForm(String word) {
	  if (passive_verbs.containsKey(word))
		  return passive_verbs.get(word);
	  else return word+"ed";
  }
  
  public void finish() {
	  if (POStagger)
		  this.nlp.finish();
  }
  
  public static void main(String[] args) {
  	try {
  		long currentTime=0;
	    long time=0;	    
	    /*
  		Words2 words1 = new Words2(true, "/usr/share/WordNet-3.0", "/usr/share/models");  		
  		currentTime=System.currentTimeMillis();
	    time=currentTime;
	    */  		
  		/*
  		String parameter1="MGEDExtendedOntology";  		
  		String conceptNames2 = words1.secondSplit((words1.splitName(parameter1)));
  		System.out.println(conceptNames2);
  		String hn1=words1.getMT(conceptNames2);
		System.out.println(hn1);  		
  		System.exit(1);
  		*/
	    /*
  		for(int i=0;i<500;i++) {	  		
	  		String parameter="MGEDExtendedOntology";
	  		String conceptNames1=words1.splitName(parameter);
			String hn=words1.getHeadNoun(conceptNames1);
			System.out.println(hn);
  		}
  		currentTime=System.currentTimeMillis();		
		System.out.println("Time:"+((currentTime-time)/1000));
		System.exit(1);
		*/
  	//System.out.println(wordPresence((splitName(args[0])).toString(),(splitName(args[1])).toString()));
  	//System.out.println(wordPresence("[label,comment]",(splitName("[LabelComment]")).toString()));
  	//System.out.println(wordPresence((splitName("[Terrorist_Group]")).toString(),(splitName("[Terrorist_Group]")).toString()));
  	//System.out.println(wordPresence(args[0],args[1]));//what,where
  	//System.out.println(wordPresence("[conference,document]","[conference,paper]"));//what,where
  	//System.out.println(wordPresence("[presentation, of, paper]","[[ObjectUnionOf( Abstract Paper)]"));//what,where
  	//System.out.println(splitName("E35.Title"));
  	//TODO: nejak nejde spravne rozdelit PsychicalObject; proc?
  	
  	//System.out.println(splitName("MD_SpatialAttributeSupplement"));  	
  	//System.out.println(splitName(" SpatialAttributeSupplement"));  	
  	//System.out.println(secondSplit("[MD, SpatialAttributeSupplement]"));
  	//System.out.println(secondSplit("[MD, Spatial-Attribute-Supplement]"));
  	//System.out.println(secondSplit("[ , Banking, Service]"));  	
  	
  	//System.out.println(joinLetters("U R L"));
  	//System.out.println(getMT("  n halo iuu U R L IN Plan Aircraft Take"));
  	//System.out.println(getMT(" Oil cake of neem"));
  	//System.out.println(getMT(" 2"));
  	//System.out.println(getMT(" ,co, author"));
  	//System.out.println(splitName("definedBy"));
  	//System.out.println(splitName(" defined By"));
  //System.out.println(compareSets());
  	//String aCode="26|1|2|1|0|0|0|0|0|";
  	//String etalonCode2="^26|1.*";
  	//System.out.println(aCode.matches("^17.*"));
  	//etalonCode2=etalonCode2.replace("|","\\\\|");
  	//System.out.println(etalonCode2);
  	//System.out.println(aCode.matches("^"+etalonCode2.replaceAll("|","\\\\|")+".*"));
  	//System.out.println(porovnej(aCode,etalonCode2));  	
  	//String [] strings = new String[20];
  	//String name = " E52.Time-Span";
  	//strings = name.split("[.]");
  	//for(int i=0;i<strings.length;i++) System.out.println(strings[i]);
  	//System.out.println(splitName(" E52.Time-Span")); 
  	//System.out.println(secondSplit("[ E52, Time-Span]"));  	 	
  	//20.4.2008, problemy s "." jako oddelovacem
  	//rada: vyzkousej co dela strings = name.split(delimiter) s "[.]"
  	//System.out.println(getLevels("1|0|0|0|0|0|0|0|0|0|0|0|0|0|"));
  	//System.out.println(getFirstLevel("121|1|2|0|0|0|0|0|0|0|0|0|0|0|"));
  	/*ArrayList set1 = new ArrayList();
  	ArrayList set2 = new ArrayList();
  	System.out.println(getSharedToken(set1,set2));
  	*/
  	/*if (multiTokenName("Abstract")) {
  		System.out.println("multiple");
  	}*/ 	
  	/*
  		if (bad_head_noun("Invitation_Of_Review_Phhase","phase")) {
  		System.out.println("YES");
  	}
  	else System.out.println("NO");
  	*/
  	Words2 words = new Words2(true, "/usr/share/WordNet-3.0", "/usr/share/models");
  	//String name="hasURL";
  	//System.out.println(words.secondSplit((words.splitName(" "+name).toString())));
  	/*String name = "electronic document stored";
  	System.out.println(words.getMT(name));
  	System.out.println(words.getMT("paper author"));
  	System.out.println(words.getMT("part of seamless database")); //TODO,29-07-09 it is not really OK now head noun is seamless but token database should be head noun! so we can add some rule like omit POS tag JJ - adjective*/
  	/*
  	ArrayList set1 = new ArrayList();
  	ArrayList set2 = new ArrayList();
  	set1.add("late");set1.add("harvest");
  	set2.add("thing");
  	System.out.println(words.compareTokenSets(set1, set2));
  	*/
  	//System.out.println(fuzzyCompareSets(set1,set2));
  	//String name="Accepting_final_manuscript";
  	//String name="non_member";
  	//String name="IASTED_non_member";  	
  /*	String name="Meta-Reviewer";  	
  	String conceptNames="";
  	conceptNames=secondSplit((splitName(" "+name).toString()));
  	String mainTerm=Words.getMT(conceptNames);      		
  	System.out.println(conceptNames);  	
  	System.out.println(mainTerm); 
  	
  	String uri="http://nb.vse.cz/~svabo/oaei2009/data/MICRO.owl";  	
  	System.out.println(uri);
  	System.out.println(uri.lastIndexOf("//"));
  	System.out.println(uri.indexOf("."));
  	String file = uri.substring(uri.lastIndexOf("/")+1,uri.lastIndexOf(".")); 	  	
	System.out.println(file);  	*/
  	//System.out.println(words.getComplementHeadNoun("Administrative_Reviewing_event"));
  	//02-06-11
  	/*
  	System.out.println(words.getComplementHeadNoun("Reviewing_event"));
  	System.out.println(words.nlp.getOneWordLemma("Reviewing"));
  	System.out.println(words.nlp.getOneWordLemma("reviews")); //but in ontology there is an error: reviewes
  	*/
  	//System.out.println(words.nlp.getOneWordLemma("Reviewing_event"));
  	System.out.println(words.nlp.getOneWordTag("reject"));
  	System.exit(1);
  	String conceptNames="";
  	//conceptNames=words.secondSplit((words.splitName(" paperPresentedAs").toString()));
  	conceptNames=words.secondSplit((words.splitName(" IndividualPresentation").toString()));
  	System.out.println(words.getMT(conceptNames));
  	//System.out.println(words.getVerbPassiveForm("reject"));
  	words.finish();
	}
  	catch (Exception e1) {
  		e1.printStackTrace();
  	}  	
  }
}