package cz.vse.keg.patomat.meronym;

import java.util.*;
import java.io.*;
import java.net.*;
import edu.mit.jwi.item.*;
import edu.mit.jwi.*;

//18-05-12, I made from MyWordNet -MyWordNet2 because there is some code lost and in MyWordNet2 there is some new code
public class MyWordNet3 {
	
	public IDictionary dict;
	public String path;
	public int iteration;
	
	public MyWordNet3(String wnhome) {		
		try {			
			if (!wnhome.equals("")) {
				this.path = wnhome + File.separator + "dict";
				URL url = new URL("file", null, path);
				dict = new edu.mit.jwi.Dictionary(url);
				dict.open();
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void finish() {
		dict.close();
	}					
	
	public boolean isMeronym2(int maxIteration,boolean allSenses,String word1,String word2) throws Exception {		
		HashSet<edu.mit.jwi.item.IWord> stackWords2 = new HashSet();
		HashSet<Integer> supersenses = new HashSet();
		
		//boolean allSenses = true;
		
		// look up first sense of the word "dog"
		IIndexWord idxWord = dict.getIndexWord(word1, POS.NOUN);				
		//IWordID wordID = idxWord.getWordIDs().get(0);
		if (idxWord==null) return false;
		List<IWordID> wordsID = idxWord.getWordIDs();
		//09-02-09, get all senses of word "dog" in one heap stackWords
		HashSet<IWord> stackWords = new HashSet(); 
		ISynset synset;
		for(IWordID iword : wordsID) {
			IWord word = dict.getWord(iword);			
			stackWords.add(word);
			synset = word.getSynset();
			//03-04-09,kontrolni vypis pro pripadne shlukovani
			//System.out.println(synset.getOffSet());
			//System.out.println(((ILexFile)synset.getLexicalFile()).getNumber()));
			//			
			//11-02-09,supersenses from initial senses of inpt word
			supersenses.add(new Integer(((ILexFile)synset.getLexicalFile()).getNumber()));
		}
		
		if (stackWords.size()!=0) {
			return meronymIterate2(maxIteration,allSenses,stackWords,word2,supersenses);
		}
		else return false;		
	}
	
	public boolean meronymIterate2(int maxIteration,boolean allSenses,HashSet<IWord> stackWords, String word2,HashSet<Integer> supersenses) throws Exception {				
		int _goto = 0;
		int max_iteration = maxIteration; //if we reached noun from noun.Tops supersense -> 3 iterations
		int current_iteration = 0;
		//16-05-12, limit true means that it will count numbers of iterations
		boolean limit = true;
		
		do
        {
            switch(_goto)
            {
                case 0:                
                {
                    HashSet stackWords2 = new HashSet();
		 			stackWords2.clear();
		
					if (limit) {
						current_iteration++;
						if (current_iteration==max_iteration) {
							//System.out.println("MAX ITERATION MAX");
							return false;
						}
					}
					
					ISynset synset;
					List<IWord> words;
					//System.out.println("current words:"+stackWords);
					for (IWord sword : stackWords) {
						//sword=(IWord)it.next();
						//System.out.println("***on turn "+sword+" on turn***");
						//stackWords.remove(sword);
						synset = sword.getSynset();
						//System.out.println("word "+sword+":"+ new Integer(((ILexFile)synset.getLexicalFile()).getNumber()));
						List<ISynsetID> hypernyms = synset.getRelatedSynsets(Pointer.MERONYM_PART);
						//System.out.println("number of meronyms "+hypernyms.size()+" for word "+sword);
						for(ISynsetID sid : hypernyms) {				
							//asi zde nekontrolovat, zda ma spravne cislo supersense (lexfile)?			
							words = dict.getSynset(sid).getWords();
							//System.out.print(sid + " {");
							//11-02-09,z hyperonym dam do stackWords jen to prvni, ostatni hyperonyma na ziskani nadrazenych pojmu nic nepridaji
							stackWords2.add(words.get(0));
							//11-02-09,heuristika, if se dosahne na slovo z noun.Tops (==3) probehnou dve iterace
							ISynset synset2 = ((IWord)words.get(0)).getSynset();
							if (((ILexFile)synset2.getLexicalFile()).getNumber()==3) {
								limit = true;
							}
							for(Iterator<IWord> i = words.iterator(); i.hasNext();){
								IWord iword2 = i.next();
								//System.out.println("hyperonymuma "+iword2);
								if (((String)iword2.getLemma()).equals(word2)) {
									this.iteration = current_iteration;
									//System.out.println(iword2);
									return true;
								}
								//System.out.println("meronymum "+iword2);
								//AllHypernyms.add(iword2.getLemma());
								//stackWords2.add(iword2);z hyperonym dam do stackWords jen to prvni, ostatni hyperonyma na ziskani nadrazenych pojmu nic nepridaji//melo by to byt ze spravneho supersense, zajisteno
								//09-02-09,get all same lemma also with differenct meanings
								if (allSenses) {
									IIndexWord idxWord2 = dict.getIndexWord(iword2.getLemma(), POS.NOUN);
									if (idxWord2!=null) {					
										List<IWordID> wordsID2 = idxWord2.getWordIDs();
										for(IWordID iword2a : wordsID2) {
											IWord word2a = dict.getWord(iword2a);
											if (iword2!=word2a) {
												ISynset synset1 = word2a.getSynset();
												//11-02-09,just senses that are from initial input word, so not all senses of same lemma
												//System.out.println("under inspection "+word2a);
												if (supersenses.contains(new Integer(((ILexFile)synset1.getLexicalFile()).getNumber()))) {
													//System.out.println("TRUE "+word2a);
													stackWords2.add(word2a);
												}								
											}								
										}
									}
								}
								//end of same lemma with dif. meaning part													
							}
						}
						//System.out.println("current words 2:"+stackWords2);
					}
					stackWords.clear();
					stackWords=new HashSet(stackWords2);					
					if (stackWords2.size()!=0) {               
						//System.out.println("NEXT ITERATION");
						stackWords2.clear();
						_goto = 0;
						continue;										
					}
					else return false;
                }                                                    				
             }
        } while(true);							
	}
	
	public boolean hyperonymIterate2(int maxIteration,boolean allSenses,HashSet<IWord> stackWords,String word2,HashSet<Integer> supersenses) throws Exception {		
		
		int _goto = 0;
		int max_iteration = maxIteration; //if we reached noun from noun.Tops supersense -> 3 iterations
		int current_iteration = 0;
		boolean limit = false;
		
		do
        {
            switch(_goto)
            {
                case 0:                
                {
                    HashSet stackWords2 = new HashSet();
		 			stackWords2.clear();
		
					if (limit) {
						current_iteration++;
						if (current_iteration==max_iteration) {
							//System.out.println("MAX ITERATION MAX");
							return false;
						}
					}
					
					ISynset synset;
					List<IWord> words;				
					for (IWord sword : stackWords) {						
						synset = sword.getSynset();
						//System.out.println("word "+sword+":"+ new Integer(((ILexFile)synset.getLexicalFile()).getNumber()));
						List<ISynsetID> hypernyms = synset.getRelatedSynsets(Pointer.HYPERNYM);
						for(ISynsetID sid : hypernyms) {				
							//asi zde nekontrolovat, zda ma spravne cislo supersense (lexfile)?			
							words = dict.getSynset(sid).getWords();							
							//11-02-09,z hyperonym dam do stackWords jen to prvni, ostatni hyperonyma na ziskani nadrazenych pojmu nic nepridaji
							//if not allSenses it will always take at least just first word (sense) for next iteration
							stackWords2.add(words.get(0));
							//11-02-09,heuristika, if se dosahne na slovo z noun.Tops (==3) probehnou dve iterace
							ISynset synset2 = ((IWord)words.get(0)).getSynset();
							if (((ILexFile)synset2.getLexicalFile()).getNumber()==3) {
								limit = true;
							}
							for(Iterator<IWord> i = words.iterator(); i.hasNext();) {
								IWord iword2 = i.next();
								//System.out.println("hyperonyma "+iword2);
								if (((String)iword2.getLemma()).equals(word2)) {
									return true;
								}								
								//09-02-09,get all same lemma also with different meanings
								if (allSenses) {
									IIndexWord idxWord2 = dict.getIndexWord(iword2.getLemma(), POS.NOUN);
									if (idxWord2!=null) {					
										List<IWordID> wordsID2 = idxWord2.getWordIDs();
										for(IWordID iword2a : wordsID2) {
											IWord word2a = dict.getWord(iword2a);
											if (iword2!=word2a) {
												ISynset synset1 = word2a.getSynset();
												//11-02-09,just senses that are from initial input word, so not all senses of same lemma
												//System.out.println("under inspection "+word2a);
												if (supersenses.contains(new Integer(((ILexFile)synset1.getLexicalFile()).getNumber()))) {
												//System.out.println("TRUE "+word2a);
													stackWords2.add(word2a);
												}								
											}								
										}
									}
								}
								//end of same lemma with dif. meaning part													
							}
						}			
					}
					stackWords.clear();
					stackWords=new HashSet(stackWords2);					
					if (stackWords2.size()!=0) {               
						//System.out.println("NEXT ITERATION");
						stackWords2.clear();
						_goto = 0;
						continue;										
					}
					else return false;
                }                                                    				
             }
        } while(true);							
	}	
	
	//allSenses true means that all lemmas with different meanings will be included that is quite controversial...
	//int maxIteration after we reach on first noun.Tops
	public boolean isHyperonym2(int maxIteration,boolean allSenses,String word1,String word2) throws Exception {				
		HashSet<Integer> supersenses = new HashSet();			
		// look up first sense of the word
		IIndexWord idxWord = dict.getIndexWord(word1, POS.NOUN);						
		if (idxWord==null) return false;
		List<IWordID> wordsID = idxWord.getWordIDs();
		//09-02-09, get all senses of word in one heap stackWords
		HashSet<IWord> stackWords = new HashSet(); 
		ISynset synset;
		for(IWordID iword : wordsID) {
			IWord word = dict.getWord(iword);			
			stackWords.add(word);
			synset = word.getSynset();
			//supersenses from initial senses of inpt word
			supersenses.add(new Integer(((ILexFile)synset.getLexicalFile()).getNumber()));
		}
		
		if (stackWords.size()!=0) {
			return hyperonymIterate2(maxIteration,allSenses,stackWords,word2,supersenses);
		}
		else return false;		
	}													
	
	public ArrayList<String> getRelatedWord(String name) {
		ArrayList<String> related = new ArrayList<String>();		
		IIndexWord idxWord = dict.getIndexWord(name, POS.NOUN);		
		if (idxWord == null) return null;
		List<IWordID> wordsID = idxWord.getWordIDs();		
		for(IWordID iword : wordsID){
			IWord word = dict.getWord(iword);
			List<IWordID> relatedIDs = word.getRelatedWords();			
			for(IWordID w : relatedIDs) {
				related.add(dict.getWord(w).getLemma());				
			}
		}
		return related;
	}
	
	private void testEfficiency() {
		long currentTime=0;
	    long time=0;
	    currentTime=System.currentTimeMillis();
		time=currentTime;		
		try {									
			for(int i=0;i<459;i++) {
				System.out.println(i);
				if (this.isHyperonym2(5,true,"ontology","modification")) {
					System.out.println("true hypernym");		
				}
			}
		}
		catch (Exception e) {
    		e.printStackTrace();
    		System.out.println(e.getCause());
    	}
		currentTime=System.currentTimeMillis();
		System.out.println("It takes:"+((currentTime-time)/1000));			
	}
	
	public static void main(String[] args) {		
		try {						
			MyWordNet3 myWordNet = new MyWordNet3("/usr/share/WordNet-3.0/");
			myWordNet.testEfficiency();
			System.exit(1);
			/*System.out.println("******");			
			//if (myWordNet.isHyperonym2(15,false,"speaker","presenter")) {
			 */
			
			if (myWordNet.isMeronym2(2,true,"body","hand")) {
				System.out.println("true meronym");		
			}
			else System.out.println("false meronym");
			if (myWordNet.isMeronym2(3,true,"hand","promenade")) {
				System.out.println("true meronym");		
			}
			else System.out.println("false meronym");	
			if (myWordNet.isHyperonym2(4,true,"mouse","artefact")) {
				System.out.println("true hypernym");		
			}
			else System.out.println("false hypernym");
			
			/*
			for (String s : myWordNet.getRelatedWord("acceptance")) {
				System.out.println(s);
			}*/
		}		
		catch (Exception e) {
    		e.printStackTrace();
    		System.out.println(e.getCause());
    	}
	}
}