/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.meronym;

import edu.mit.jwi.Dictionary;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MyWordNet2 {
    public IDictionary dict;
    public String path;
    public int iteration;

    public MyWordNet2(String wnhome) {
        try {
            if (wnhome.equals("")) {
                wnhome = "/home/exmo/zamazal/WordNet-2.0/";
            }
            this.path = String.valueOf(wnhome) + File.separator + "dict";
            URL url = new URL("file", null, this.path);
            this.dict = new Dictionary(url);
            this.dict.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        this.dict.close();
    }

    public boolean synonym(String word1, String word2) throws Exception {
        HashSet<String> synonyms = new HashSet<String>();
        IIndexWord idxWord = this.dict.getIndexWord(word1, POS.NOUN);
        if (idxWord == null) {
            return false;
        }
        List wordsID = idxWord.getWordIDs();
        for (IWordID iword : wordsID) {
            IWord word = this.dict.getWord(iword);
            ISynset synset = word.getSynset();
            for (IWord w : synset.getWords()) {
                synonyms.add(w.getLemma());
            }
        }
        return synonyms.contains(word2);
    }

    public boolean isHyperonym1(String word1, String word2) throws Exception {
        return this.hyperonym(word1, word2, this.dict);
    }

    public boolean isHyperonym2(int maxIteration, boolean allSenses, String word1, String word2) throws Exception {
        return this.hyperonymAllLevels(maxIteration, allSenses, word1, word2, this.dict);
    }

    public boolean isMeronym2(int maxIteration, boolean allSenses, String word1, String word2) throws Exception {
        return this.meronymAllLevels(maxIteration, allSenses, word1, word2, this.dict);
    }

    public boolean hyperonym(String word1, String word2, IDictionary dict) throws Exception {
        HashSet<String> AllHypernyms = new HashSet<String>();
        IIndexWord idxWord = dict.getIndexWord(word1, POS.NOUN);
        if (idxWord == null) {
            return false;
        }
        List wordsID = idxWord.getWordIDs();
        for (IWordID iword : wordsID) {
            IWord word = dict.getWord(iword);
            ISynset synset = word.getSynset();
            List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
            for (ISynsetID sid : hypernyms) {
                List words = dict.getSynset(sid).getWords();
                for (IWord iword2 : words) {
                    AllHypernyms.add(iword2.getLemma());
                    ISynset synset2 = iword2.getSynset();
                    List hypernyms2 = synset2.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
                    for (ISynsetID sid2 : hypernyms2) {
                        List words2 = dict.getSynset(sid2).getWords();
                        for (IWord iword3 : words2) {
                            AllHypernyms.add(iword3.getLemma());
                            if (this.hyperonymNoRecursive(iword3.getLemma().toString(), word2, dict)) {
                                return true;
                            }
                            ISynset synset3 = iword3.getSynset();
                            List hypernyms3 = synset3.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
                            for (ISynsetID sid3 : hypernyms3) {
                                List words3 = dict.getSynset(sid3).getWords();
                                for (IWord iword4 : words3) {
                                    AllHypernyms.add(iword4.getLemma());
                                    if (!this.hyperonymNoRecursive(iword4.getLemma().toString(), word2, dict)) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return AllHypernyms.contains(word2);
    }

    public boolean hyperonymNoRecursive(String word1, String word2, IDictionary dict) throws Exception {
        HashSet<String> AllHypernyms = new HashSet<String>();
        IIndexWord idxWord = dict.getIndexWord(word1, POS.NOUN);
        if (idxWord == null) {
            return false;
        }
        List wordsID = idxWord.getWordIDs();
        for (IWordID iword : wordsID) {
            IWord word = dict.getWord(iword);
            ISynset synset = word.getSynset();
            List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
            for (ISynsetID sid : hypernyms) {
                List words = dict.getSynset(sid).getWords();
                for (IWord iword2 : words) {
                    AllHypernyms.add(iword2.getLemma());
                    ISynset synset2 = iword2.getSynset();
                    List hypernyms2 = synset2.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
                    for (ISynsetID sid2 : hypernyms2) {
                        List words2 = dict.getSynset(sid2).getWords();
                        for (IWord iword3 : words2) {
                            AllHypernyms.add(iword3.getLemma());
                            ISynset synset3 = iword3.getSynset();
                            List hypernyms3 = synset3.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
                            for (ISynsetID sid3 : hypernyms3) {
                                List words3 = dict.getSynset(sid3).getWords();
                                for (IWord iword4 : words3) {
                                    AllHypernyms.add(iword4.getLemma());
                                }
                            }
                        }
                    }
                }
            }
        }
        return AllHypernyms.contains(word2);
    }

    public boolean hyperonymIterate(boolean allSenses, HashSet<IWord> stackWords, IDictionary dict, String word2, HashSet<Integer> supersenses) throws Exception {
        System.out.println("NEXT ITERATION");
        HashSet<IWord> stackWords2 = new HashSet<IWord>();
        stackWords2.clear();
        for (IWord sword : stackWords) {
            ISynset synset = sword.getSynset();
            List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
            for (ISynsetID sid : hypernyms) {
                List words = dict.getSynset(sid).getWords();
                stackWords2.add((IWord)words.get(0));
                for (IWord iword2 : words) {
                    IIndexWord idxWord2;
                    if (iword2.getLemma().equals(word2)) {
                        return true;
                    }
                    if (!allSenses || (idxWord2 = dict.getIndexWord(iword2.getLemma(), POS.NOUN)) == null) continue;
                    List wordsID2 = idxWord2.getWordIDs();
                    for (IWordID iword2a : wordsID2) {
                        ISynset synset1;
                        IWord word2a = dict.getWord(iword2a);
                        if (iword2 == word2a || !supersenses.contains(new Integer((synset1 = word2a.getSynset()).getLexicalFile().getNumber()))) continue;
                        stackWords2.add(word2a);
                    }
                }
            }
        }
        if (stackWords2.size() != 0) {
            return this.hyperonymIterate(allSenses, stackWords2, dict, word2, supersenses);
        }
        return false;
    }

    public boolean hyperonymIterate2(int maxIteration, boolean allSenses, HashSet<IWord> stackWords, IDictionary dict, String word2, HashSet<Integer> supersenses) throws Exception {
        int _goto = 0;
        int max_iteration = maxIteration;
        int current_iteration = 0;
        boolean limit = false;
        block3: while (true) {
            switch (_goto) {
                case 0: {
                    HashSet stackWords2 = new HashSet();
                    stackWords2.clear();
                    if (limit && ++current_iteration == max_iteration) {
                        return false;
                    }
                    for (IWord sword : stackWords) {
                        ISynset synset = sword.getSynset();
                        List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
                        for (ISynsetID sid : hypernyms) {
                            List words = dict.getSynset(sid).getWords();
                            stackWords2.add(words.get(0));
                            ISynset synset2 = ((IWord)words.get(0)).getSynset();
                            if (synset2.getLexicalFile().getNumber() == 3) {
                                limit = true;
                            }
                            for (IWord iword2 : words) {
                                IIndexWord idxWord2;
                                if (iword2.getLemma().equals(word2)) {
                                    return true;
                                }
                                if (!allSenses || (idxWord2 = dict.getIndexWord(iword2.getLemma(), POS.NOUN)) == null) continue;
                                List wordsID2 = idxWord2.getWordIDs();
                                for (IWordID iword2a : wordsID2) {
                                    ISynset synset1;
                                    IWord word2a = dict.getWord(iword2a);
                                    if (iword2 == word2a || !supersenses.contains(new Integer((synset1 = word2a.getSynset()).getLexicalFile().getNumber()))) continue;
                                    stackWords2.add(word2a);
                                }
                            }
                        }
                    }
                    stackWords.clear();
                    stackWords = new HashSet(stackWords2);
                    if (stackWords2.size() != 0) {
                        stackWords2.clear();
                        _goto = 0;
                        continue block3;
                    }
                    return false;
                }
            }
        }
    }

    public boolean meronymIterate2(int maxIteration, boolean allSenses, HashSet<IWord> stackWords, IDictionary dict, String word2, HashSet<Integer> supersenses) throws Exception {
        int _goto = 0;
        int max_iteration = maxIteration;
        int current_iteration = 0;
        boolean limit = true;
        block3: while (true) {
            switch (_goto) {
                case 0: {
                    HashSet stackWords2 = new HashSet();
                    stackWords2.clear();
                    if (limit && ++current_iteration == max_iteration) {
                        return false;
                    }
                    for (IWord sword : stackWords) {
                        ISynset synset = sword.getSynset();
                        List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.MERONYM_PART);
                        for (ISynsetID sid : hypernyms) {
                            List words = dict.getSynset(sid).getWords();
                            stackWords2.add(words.get(0));
                            ISynset synset2 = ((IWord)words.get(0)).getSynset();
                            if (synset2.getLexicalFile().getNumber() == 3) {
                                limit = true;
                            }
                            for (IWord iword2 : words) {
                                IIndexWord idxWord2;
                                if (iword2.getLemma().equals(word2)) {
                                    this.iteration = current_iteration;
                                    return true;
                                }
                                if (!allSenses || (idxWord2 = dict.getIndexWord(iword2.getLemma(), POS.NOUN)) == null) continue;
                                List wordsID2 = idxWord2.getWordIDs();
                                for (IWordID iword2a : wordsID2) {
                                    ISynset synset1;
                                    IWord word2a = dict.getWord(iword2a);
                                    if (iword2 == word2a || !supersenses.contains(new Integer((synset1 = word2a.getSynset()).getLexicalFile().getNumber()))) continue;
                                    stackWords2.add(word2a);
                                }
                            }
                        }
                    }
                    stackWords.clear();
                    stackWords = new HashSet(stackWords2);
                    if (stackWords2.size() != 0) {
                        stackWords2.clear();
                        _goto = 0;
                        continue block3;
                    }
                    return false;
                }
            }
        }
    }

    public boolean hyperonymAllLevels(int maxIteration, boolean allSenses, String word1, String word2, IDictionary dict) throws Exception {
        HashSet stackWords2 = new HashSet();
        HashSet<Integer> supersenses = new HashSet<Integer>();
        IIndexWord idxWord = dict.getIndexWord(word1, POS.NOUN);
        if (idxWord == null) {
            return false;
        }
        List wordsID = idxWord.getWordIDs();
        HashSet<IWord> stackWords = new HashSet<IWord>();
        for (IWordID iword : wordsID) {
            IWord word = dict.getWord(iword);
            stackWords.add(word);
            ISynset synset = word.getSynset();
            supersenses.add(new Integer(synset.getLexicalFile().getNumber()));
        }
        if (stackWords.size() != 0) {
            return this.hyperonymIterate2(maxIteration, allSenses, stackWords, dict, word2, supersenses);
        }
        return false;
    }

    public boolean meronymAllLevels(int maxIteration, boolean allSenses, String word1, String word2, IDictionary dict) throws Exception {
        HashSet stackWords2 = new HashSet();
        HashSet<Integer> supersenses = new HashSet<Integer>();
        IIndexWord idxWord = dict.getIndexWord(word1, POS.NOUN);
        if (idxWord == null) {
            return false;
        }
        List wordsID = idxWord.getWordIDs();
        HashSet<IWord> stackWords = new HashSet<IWord>();
        for (IWordID iword : wordsID) {
            IWord word = dict.getWord(iword);
            stackWords.add(word);
            ISynset synset = word.getSynset();
            supersenses.add(new Integer(synset.getLexicalFile().getNumber()));
        }
        if (stackWords.size() != 0) {
            return this.meronymIterate2(maxIteration, allSenses, stackWords, dict, word2, supersenses);
        }
        return false;
    }

    public void testDictionary() throws IOException {
        IIndexWord idxWord = this.dict.getIndexWord("car", POS.NOUN);
        List wordsID = idxWord.getWordIDs();
        for (IWordID iword : wordsID) {
            IWord word = this.dict.getWord(iword);
            System.out.println("****************");
            System.out.println("Id = " + iword);
            System.out.println("Lemma = " + word.getLemma());
            System.out.println("Gloss = " + word.getSynset().getGloss());
            ISynset synset = word.getSynset();
            System.out.println("###synonyms###");
            for (IWord w : synset.getWords()) {
                System.out.println(w.getLemma());
            }
            System.out.println("###hypernyms###");
            List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
            for (ISynsetID sid : hypernyms) {
                List words = this.dict.getSynset(sid).getWords();
                System.out.print(sid + " {");
                Iterator i = words.iterator();
                while (i.hasNext()) {
                    IWord word2 = (IWord)i.next();
                    System.out.print(word2.getLemma());
                    if (i.hasNext()) {
                        System.out.print(", ");
                    }
                    ISynset synset2 = word2.getSynset();
                    System.out.println("###hypernyms 2nd level###");
                    List hypernyms2 = synset2.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
                    for (ISynsetID sid2 : hypernyms2) {
                        List words2 = this.dict.getSynset(sid2).getWords();
                        System.out.print(sid2 + " {");
                        Iterator k = words2.iterator();
                        while (k.hasNext()) {
                            System.out.print(((IWord)k.next()).getLemma());
                            if (!k.hasNext()) continue;
                            System.out.print(", ");
                        }
                        System.out.println("}");
                    }
                    System.out.println("}");
                }
            }
            System.out.println("###hyponyms###");
            List hyponyms = synset.getRelatedSynsets((IPointer)Pointer.HYPONYM);
            for (ISynsetID sid : hyponyms) {
                List wordsh = this.dict.getSynset(sid).getWords();
                System.out.print(sid + " {");
                Iterator j = wordsh.iterator();
                while (j.hasNext()) {
                    System.out.print(((IWord)j.next()).getLemma());
                    if (!j.hasNext()) continue;
                    System.out.print(", ");
                }
                System.out.println("}");
            }
            System.out.println("###meronyms###");
            List meronyms = synset.getRelatedSynsets((IPointer)Pointer.MERONYM_PART);
            List mers = word.getRelatedWords((IPointer)Pointer.MERONYM_PART);
            for (ISynsetID sid : meronyms) {
                List wordm = this.dict.getSynset(sid).getWords();
                System.out.print(sid + " {");
                Iterator j = wordm.iterator();
                while (j.hasNext()) {
                    System.out.print(((IWord)j.next()).getLemma());
                    if (!j.hasNext()) continue;
                    System.out.print(", ");
                }
                System.out.println("}");
            }
            for (IWordID w : mers) {
                System.out.println("has part:" + w.getLemma());
            }
        }
    }

    public void getSynonyms(IDictionary dict) {
        IIndexWord idxWord = dict.getIndexWord("dog", POS.NOUN);
        IWordID wordID = (IWordID)idxWord.getWordIDs().get(0);
        IWord word = dict.getWord(wordID);
        ISynset synset = word.getSynset();
        for (IWord w : synset.getWords()) {
            System.out.println(w.getLemma());
        }
    }

    public void getMeronyms(IDictionary dict) {
        IIndexWord idxWord = dict.getIndexWord("car", POS.NOUN);
        IWordID wordID = (IWordID)idxWord.getWordIDs().get(0);
        IWord word = dict.getWord(wordID);
        ISynset synset = word.getSynset();
        List meronyms = synset.getRelatedSynsets((IPointer)Pointer.MERONYM_PART);
        for (ISynsetID sid : meronyms) {
            List words = dict.getSynset(sid).getWords();
            System.out.print(sid + " {");
            Iterator i = words.iterator();
            while (i.hasNext()) {
                System.out.print(((IWord)i.next()).getLemma());
                if (!i.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.println("}");
        }
    }

    public boolean tryPairOFMeronyms(IDictionary dict, String word1, String word2) {
        IIndexWord idxWord = dict.getIndexWord(word1, POS.NOUN);
        IWordID wordID = (IWordID)idxWord.getWordIDs().get(0);
        IWord word = dict.getWord(wordID);
        ISynset synset = word.getSynset();
        List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.MERONYM_PART);
        for (ISynsetID sid : hypernyms) {
            List words = dict.getSynset(sid).getWords();
            System.out.print(sid + " {");
            Iterator i = words.iterator();
            while (i.hasNext()) {
                String s = ((IWord)i.next()).getLemma();
                System.out.print(s);
                if (s.equals(word2)) {
                    System.out.println();
                    System.out.println("Voila:");
                    System.out.println(word2);
                    return true;
                }
                if (!i.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.println("}");
        }
        return false;
    }

    public void getHypernyms(IDictionary dict) {
        IIndexWord idxWord = dict.getIndexWord("house", POS.NOUN);
        IWordID wordID = (IWordID)idxWord.getWordIDs().get(0);
        IWord word = dict.getWord(wordID);
        ISynset synset = word.getSynset();
        List hypernyms = synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM);
        for (ISynsetID sid : hypernyms) {
            List words = dict.getSynset(sid).getWords();
            System.out.print(sid + " {");
            Iterator i = words.iterator();
            while (i.hasNext()) {
                System.out.print(((IWord)i.next()).getLemma());
                if (!i.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.println("}");
        }
    }

    public ArrayList<String> getRelatedWord(String name) {
        ArrayList<String> related = new ArrayList<String>();
        IIndexWord idxWord = this.dict.getIndexWord(name, POS.NOUN);
        if (idxWord == null) {
            return null;
        }
        List wordsID = idxWord.getWordIDs();
        for (IWordID iword : wordsID) {
            IWord word = this.dict.getWord(iword);
            List relatedIDs = word.getRelatedWords();
            for (IWordID w : relatedIDs) {
                related.add(w.getLemma());
            }
        }
        return related;
    }

    public static void main(String[] args) {
        try {
            MyWordNet2 myWordNet = new MyWordNet2("/usr/share/WordNet-3.0");
            System.out.println(myWordNet.isMeronym2(15, true, "face", "pupil"));
            System.out.println("number of levels/iterations is " + myWordNet.iteration);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getCause());
        }
    }
}

