/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.coode.parsers.DisposableOWLEntityChecker;
import org.coode.parsers.EntityFinder;
import org.coode.parsers.OWLAxiomType;
import org.coode.parsers.OWLEntityRenderer;
import org.coode.parsers.OWLEntitySymbol;
import org.coode.parsers.OWLType;
import org.coode.parsers.Scope;
import org.coode.parsers.Symbol;
import org.coode.parsers.Type;
import org.coode.parsers.TypeVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityCheckerScope
implements Scope {
    private final DisposableOWLEntityChecker owlEntityChecker;
    private final EntityFinder entityFinder;
    private final OWLEntityRenderer owlEntityRenderer;

    public OWLEntityCheckerScope(DisposableOWLEntityChecker owlEntityChecker, EntityFinder entityFinder, OWLEntityRenderer owlEntityRenderer) {
        if (owlEntityChecker == null) {
            throw new NullPointerException("The entity checker cannot be null");
        }
        if (entityFinder == null) {
            throw new NullPointerException("The entity finder cannot be null");
        }
        if (owlEntityRenderer == null) {
            throw new NullPointerException("The OWL entity renderer cannot be null");
        }
        this.owlEntityChecker = owlEntityChecker;
        this.entityFinder = entityFinder;
        this.owlEntityRenderer = owlEntityRenderer;
    }

    @Override
    public void define(Symbol symbol) {
    }

    @Override
    public Scope getEnclosingScope() {
        return null;
    }

    @Override
    public String getScopeName() {
        return "global";
    }

    @Override
    public Symbol resolve(String name) {
        OWLEntitySymbol toReturn = null;
        OWLClass owlEntity = this.getOWLEntityChecker().getOWLClass(name);
        if (owlEntity != null) {
            toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
        } else {
            owlEntity = this.getOWLEntityChecker().getOWLDataProperty(name);
            if (owlEntity != null) {
                toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
            } else {
                owlEntity = this.getOWLEntityChecker().getOWLObjectProperty(name);
                if (owlEntity != null) {
                    toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                } else {
                    owlEntity = this.getOWLEntityChecker().getOWLIndividual(name);
                    if (owlEntity != null) {
                        toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                    } else {
                        owlEntity = this.getOWLEntityChecker().getOWLDatatype(name);
                        if (owlEntity != null) {
                            toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                        } else {
                            owlEntity = this.getOWLEntityChecker().getOWLAnnotationProperty(name);
                            if (owlEntity != null) {
                                toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                            }
                        }
                    }
                }
            }
        }
        return toReturn;
    }

    @Override
    public Set<Symbol> match(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("The initial prefix cannot be null");
        }
        HashSet<Symbol> toReturn = new HashSet<Symbol>();
        Set<OWLEntity> entities = this.getEntityFinder().getEntities(prefix);
        for (OWLEntity owlEntity : entities) {
            toReturn.add(new OWLEntitySymbol(this.getOWLEntityRenderer().render(owlEntity), owlEntity));
        }
        return toReturn;
    }

    public DisposableOWLEntityChecker getOWLEntityChecker() {
        return this.owlEntityChecker;
    }

    public EntityFinder getEntityFinder() {
        return this.entityFinder;
    }

    public OWLEntityRenderer getOWLEntityRenderer() {
        return this.owlEntityRenderer;
    }

    @Override
    public Set<Symbol> getAllSymbols() {
        Set<OWLEntity> entities = this.getEntityFinder().getEntities("");
        HashSet<Symbol> toReturn = new HashSet<Symbol>(entities.size());
        for (OWLEntity owlEntity : entities) {
            toReturn.add(new OWLEntitySymbol(this.getOWLEntityRenderer().render(owlEntity), owlEntity));
        }
        return toReturn;
    }

    @Override
    public Set<Symbol> getAllSymbols(Type type) {
        Set<OWLEntity> entities = type.accept(new TypeVisitorEx<Set<OWLEntity>>(){

            @Override
            public Set<OWLEntity> visitOWLAxiomType(OWLAxiomType owlAxiomType) {
                return Collections.emptySet();
            }

            @Override
            public Set<OWLEntity> visitNonOWLType(Type type) {
                return Collections.emptySet();
            }

            @Override
            public Set<OWLEntity> visitOWLType(OWLType owlType) {
                HashSet<OWLEntity> toReturn = new HashSet<OWLEntity>();
                switch (owlType) {
                    case OWL_CLASS: {
                        toReturn.addAll(OWLEntityCheckerScope.this.getEntityFinder().getMatchingOWLClasses("*"));
                        break;
                    }
                    case OWL_DATA_PROPERTY: {
                        toReturn.addAll(OWLEntityCheckerScope.this.getEntityFinder().getMatchingOWLDataProperties("*"));
                        break;
                    }
                    case OWL_OBJECT_PROPERTY: {
                        toReturn.addAll(OWLEntityCheckerScope.this.getEntityFinder().getMatchingOWLObjectProperties("*"));
                        break;
                    }
                    case OWL_INDIVIDUAL: {
                        toReturn.addAll(OWLEntityCheckerScope.this.getEntityFinder().getMatchingOWLIndividuals("*"));
                        break;
                    }
                }
                return toReturn;
            }
        });
        HashSet<Symbol> toReturn = new HashSet<Symbol>(entities.size());
        for (OWLEntity owlEntity : entities) {
            toReturn.add(new OWLEntitySymbol(this.getOWLEntityRenderer().render(owlEntity), owlEntity));
        }
        return toReturn;
    }

    @Override
    public void dispose() {
        this.getOWLEntityChecker().dispose();
    }
}

