/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CachingBidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;
import org.semanticweb.owlapi.util.ReferencedEntitySetProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidirectionalShortFormProviderAdapter
extends CachingBidirectionalShortFormProvider {
    private ShortFormProvider shortFormProvider;
    private Set<OWLOntology> ontologies;
    private OWLOntologyManager man;
    private OWLOntologyLoaderListener loaderListener = new OWLOntologyLoaderListener(){

        public void finishedLoadingOntology(OWLOntologyLoaderListener.LoadingFinishedEvent event) {
            BidirectionalShortFormProviderAdapter.this.ontologies.clear();
            BidirectionalShortFormProviderAdapter.this.ontologies.addAll(BidirectionalShortFormProviderAdapter.this.man.getOntologies());
            BidirectionalShortFormProviderAdapter.this.rebuild((OWLEntitySetProvider)new ReferencedEntitySetProvider(BidirectionalShortFormProviderAdapter.this.ontologies));
        }

        public void startedLoadingOntology(OWLOntologyLoaderListener.LoadingStartedEvent event) {
        }
    };
    private OWLOntologyChangeListener changeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            BidirectionalShortFormProviderAdapter.this.handleChanges(changes);
        }
    };

    public BidirectionalShortFormProviderAdapter(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public BidirectionalShortFormProviderAdapter(OWLOntologyManager man, Set<OWLOntology> ontologies, ShortFormProvider shortFormProvider) {
        this.man = man;
        this.ontologies = ontologies;
        this.shortFormProvider = shortFormProvider;
        this.man = man;
        this.man.addOntologyChangeListener(this.changeListener);
        this.rebuild((OWLEntitySetProvider)new ReferencedEntitySetProvider(ontologies));
        this.addWellKnownEntities(man);
        man.addOntologyLoaderListener(this.loaderListener);
    }

    private void addWellKnownEntities(OWLOntologyManager man) {
        OWLDataFactory dataFactory = man.getOWLDataFactory();
        this.add((OWLEntity)dataFactory.getOWLThing());
        this.add((OWLEntity)dataFactory.getOWLNothing());
        this.add((OWLEntity)dataFactory.getTopDatatype());
        this.add((OWLEntity)dataFactory.getOWLTopObjectProperty());
        this.add((OWLEntity)dataFactory.getOWLTopDataProperty());
        for (OWL2Datatype datatype : EnumSet.allOf(OWL2Datatype.class)) {
            this.add((OWLEntity)dataFactory.getOWLDatatype(datatype.getIRI()));
        }
    }

    protected String generateShortForm(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    public void dispose() {
        if (this.man != null) {
            this.man.removeOntologyChangeListener(this.changeListener);
            this.man.removeOntologyLoaderListener(this.loaderListener);
        }
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet<OWLEntity> processed = new HashSet<OWLEntity>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
            if (oWLOntologyChange instanceof AddAxiom) {
                AddAxiom addAx = (AddAxiom)oWLOntologyChange;
                for (OWLEntity ent : addAx.getEntities()) {
                    if (processed.contains(ent)) continue;
                    processed.add(ent);
                    this.add(ent);
                }
                continue;
            }
            if (!(oWLOntologyChange instanceof RemoveAxiom)) continue;
            RemoveAxiom remAx = (RemoveAxiom)oWLOntologyChange;
            for (OWLEntity ent : remAx.getEntities()) {
                if (processed.contains(ent)) continue;
                processed.add(ent);
                boolean stillRef = false;
                for (OWLOntology ont : this.ontologies) {
                    if (!ont.containsEntityInSignature(ent)) continue;
                    stillRef = true;
                    break;
                }
                if (stillRef) continue;
                this.remove(ent);
            }
        }
    }
}

