/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.unmarshallers.AbstractUnmarshaller;
import org.sonar.wsclient.unmarshallers.JsonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUnmarshaller
extends AbstractUnmarshaller<Resource> {
    @Override
    protected Resource parse(JSONObject json) {
        Resource resource = new Resource();
        this.parseResourceFields(json, resource);
        this.parseMeasures(json, resource);
        return resource;
    }

    private void parseResourceFields(JSONObject json, Resource resource) {
        resource.setId(JsonUtils.getInteger((Map)json, "id")).setKey(JsonUtils.getString((Map)json, "key")).setName(JsonUtils.getString((Map)json, "name")).setLongName(JsonUtils.getString((Map)json, "lname")).setScope(JsonUtils.getString((Map)json, "scope")).setQualifier(JsonUtils.getString((Map)json, "qualifier")).setLanguage(JsonUtils.getString((Map)json, "lang")).setDescription(JsonUtils.getString((Map)json, "description")).setVersion(JsonUtils.getString((Map)json, "version"));
    }

    private void parseMeasures(JSONObject json, Resource resource) {
        JSONArray measuresJson = (JSONArray)json.get((Object)"msr");
        if (measuresJson != null) {
            resource.setMeasures(this.parseMeasures(measuresJson));
        }
    }

    private List<Measure> parseMeasures(JSONArray measuresJson) {
        ArrayList<Measure> projectMeasures = new ArrayList<Measure>();
        int len = measuresJson.size();
        for (int i = 0; i < len; ++i) {
            JSONObject measureJson = (JSONObject)measuresJson.get(i);
            if (measureJson == null) continue;
            Measure measure = this.parseMeasure(measureJson);
            projectMeasures.add(measure);
        }
        return projectMeasures;
    }

    private Measure parseMeasure(JSONObject json) {
        Measure measure = new Measure();
        measure.setMetricKey(JsonUtils.getString((Map)json, "key")).setMetricName(JsonUtils.getString((Map)json, "name")).setValue(JsonUtils.getDouble((Map)json, "val")).setFormattedValue(JsonUtils.getString((Map)json, "frmt_val")).setTrend(JsonUtils.getInteger((Map)json, "trend")).setVar(JsonUtils.getInteger((Map)json, "var")).setData(JsonUtils.getString((Map)json, "data")).setRuleKey(JsonUtils.getString((Map)json, "rule_key")).setRuleName(JsonUtils.getString((Map)json, "rule_name")).setRuleCategory(JsonUtils.getString((Map)json, "rule_category")).setRulePriority(JsonUtils.getString((Map)json, "rule_priority"));
        return measure;
    }
}

