/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static String getString(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public static Integer getInteger(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return ((Long)value).intValue();
        }
        return null;
    }

    public static Boolean getBoolean(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return (Boolean)value;
        }
        return null;
    }

    public static Long getLong(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return (Long)value;
        }
        return null;
    }

    public static Double getDouble(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return (Double)value;
        }
        return null;
    }

    public static Date getDateTime(Map obj, String field) {
        return JsonUtils.parseDate(obj, field, "yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public static Date getDate(Map obj, String field) {
        return JsonUtils.parseDate(obj, field, "yyyy-MM-dd");
    }

    private static Date parseDate(Map obj, String field, String format) {
        String value = JsonUtils.getString(obj, field);
        if (value != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                return dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

