/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.Violation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationQuery
extends Query<Violation> {
    public static final String BASE_URL = "/api/violations";
    private String[] scopes;
    private String[] qualifiers;
    private String[] ruleKeys;
    private String[] categories;
    private String[] priorities;
    private int depth = 0;
    private String resourceKeyOrId;

    public ViolationQuery(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public ViolationQuery setScopes(String ... scopes) {
        this.scopes = scopes;
        return this;
    }

    public String[] getQualifiers() {
        return this.qualifiers;
    }

    public ViolationQuery setQualifiers(String ... qualifiers) {
        this.qualifiers = qualifiers;
        return this;
    }

    public String[] getRuleKeys() {
        return this.ruleKeys;
    }

    public ViolationQuery setRuleKeys(String ... ruleKeys) {
        this.ruleKeys = ruleKeys;
        return this;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public ViolationQuery setCategories(String ... categories) {
        this.categories = categories;
        return this;
    }

    public String[] getPriorities() {
        return this.priorities;
    }

    public ViolationQuery setPriorities(String ... priorities) {
        this.priorities = priorities;
        return this;
    }

    public int getDepth() {
        return this.depth;
    }

    public ViolationQuery setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append("?resource=").append(this.resourceKeyOrId).append("&");
        if (this.depth != 0) {
            url.append("depth").append(this.depth).append("&");
        }
        this.append(url, "scopes", this.scopes);
        this.append(url, "qualifiers", this.qualifiers);
        this.append(url, "rules", this.ruleKeys);
        this.append(url, "categories", this.categories);
        this.append(url, "priorities", this.priorities);
        return url.toString();
    }

    private void append(StringBuilder url, String paramKey, Object[] paramValues) {
        if (paramValues != null && paramValues.length > 0) {
            url.append(paramKey).append('=');
            for (int index = 0; index < paramValues.length; ++index) {
                if (index > 0) {
                    url.append(',');
                }
                url.append(paramValues[index]);
            }
            url.append('&');
        }
    }

    @Override
    public Class<Violation> getModelClass() {
        return Violation.class;
    }

    public static ViolationQuery createForResource(Resource resource) {
        return new ViolationQuery(resource.getId().toString());
    }

    public static ViolationQuery createForResource(String resourceIdOrKey) {
        return new ViolationQuery(resourceIdOrKey);
    }
}

