/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceQuery
extends Query<Source> {
    public static final String BASE_URL = "/api/sources";
    private String resourceKeyOrId;
    private int from = 0;
    private int to = 0;
    private boolean highlightedSyntax = false;

    public SourceQuery(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public String getResourceKeyOrId() {
        return this.resourceKeyOrId;
    }

    public SourceQuery setResourceKeyOrId(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
        return this;
    }

    public int getFrom() {
        return this.from;
    }

    public SourceQuery setFromLineToLine(int from, int excludedTo) {
        this.from = from;
        this.to = excludedTo;
        return this;
    }

    public SourceQuery setLinesFromLine(int from, int length) {
        this.from = from;
        this.to = from + length;
        return this;
    }

    public int getTo() {
        return this.to;
    }

    public boolean isHighlightedSyntax() {
        return this.highlightedSyntax;
    }

    public SourceQuery setHighlightedSyntax(boolean b) {
        this.highlightedSyntax = b;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append("?resource=").append(this.resourceKeyOrId).append("&");
        if (this.from > 0 && this.to > 0) {
            url.append("from=").append(this.from).append("&to=").append(this.to).append("&");
        }
        if (this.highlightedSyntax) {
            url.append("color=true&");
        }
        return url.toString();
    }

    @Override
    public Class<Source> getModelClass() {
        return Source.class;
    }

    public static SourceQuery create(String resourceKeyOrId) {
        return new SourceQuery(resourceKeyOrId);
    }

    public static SourceQuery createWithHighlightedSyntax(String resourceKeyOrId) {
        return new SourceQuery(resourceKeyOrId).setHighlightedSyntax(true);
    }
}

