/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.Collections;
import java.util.List;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
extends Model {
    public static final String SCOPE_SET = "PRJ";
    public static final String SCOPE_SPACE = "DIR";
    public static final String SCOPE_ENTITY = "FIL";
    public static final String QUALIFIER_VIEW = "VW";
    public static final String QUALIFIER_SUBVIEW = "SVW";
    public static final String QUALIFIER_LIB = "LIB";
    public static final String QUALIFIER_PROJECT = "TRK";
    public static final String QUALIFIER_MODULE = "BRC";
    public static final String QUALIFIER_PACKAGE = "PAC";
    public static final String QUALIFIER_DIRECTORY = "DIR";
    public static final String QUALIFIER_FILE = "FIL";
    public static final String QUALIFIER_CLASS = "CLA";
    public static final String QUALIFIER_UNIT_TEST_CLASS = "UTS";
    public static final String LANGUAGE_JAVA = "java";
    private Integer id;
    private String key;
    private String name;
    private String longName;
    private String scope;
    private String qualifier;
    private String language;
    private String version;
    private Integer copy;
    private String description;
    private List<Measure> measures;

    public Integer getId() {
        return this.id;
    }

    public Resource setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Resource setKey(String key) {
        this.key = key;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Resource setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getName(boolean longFormatIfDefined) {
        if (longFormatIfDefined && this.longName != null && !"".equals(this.longName)) {
            return this.longName;
        }
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public Resource setLongName(String longName) {
        this.longName = longName;
        return this;
    }

    public Resource setName(String s) {
        this.name = s;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public Resource setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Resource setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Resource setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Resource setVersion(String version) {
        this.version = version;
        return this;
    }

    public Integer getCopy() {
        return this.copy;
    }

    public Resource setCopy(Integer copy) {
        this.copy = copy;
        return this;
    }

    public List<Measure> getMeasures() {
        if (this.measures == null) {
            return Collections.emptyList();
        }
        return this.measures;
    }

    public Measure getMeasure(String metricKey) {
        for (Measure measure : this.getMeasures()) {
            if (!metricKey.equals(measure.getMetricKey())) continue;
            return measure;
        }
        return null;
    }

    public Double getMeasureValue(String metricKey) {
        Measure measure = this.getMeasure(metricKey);
        if (measure != null) {
            return measure.getValue();
        }
        return null;
    }

    public Integer getMeasureIntValue(String metricKey) {
        Double d = this.getMeasureValue(metricKey);
        if (d != null) {
            return d.intValue();
        }
        return null;
    }

    public String getMeasureFormattedValue(String metricKey, String defaultValue) {
        Measure measure = this.getMeasure(metricKey);
        if (measure != null) {
            return measure.getFormattedValue(defaultValue);
        }
        return defaultValue;
    }

    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
    }

    public String toString() {
        return "[id=" + this.id + ",key=" + this.key + "]";
    }
}

