/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sonar.wsclient.services.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measure
extends Model {
    private String metricKey;
    private String metricName;
    private Double value;
    private String formattedValue;
    private String data;
    private Integer trend;
    private Integer var;
    private String ruleKey;
    private String ruleName;
    private String ruleCategory;
    private String rulePriority;

    public String getMetricKey() {
        return this.metricKey;
    }

    public Measure setMetricKey(String metricKey) {
        this.metricKey = metricKey;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Measure setMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public Double getValue() {
        return this.value;
    }

    public Integer getIntValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.intValue();
    }

    public Measure setValue(Double value) {
        this.value = value;
        return this;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public String getFormattedValue(String defaultValue) {
        if (this.formattedValue == null) {
            return defaultValue;
        }
        return this.formattedValue;
    }

    public Measure setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getDataAsMap() {
        return this.getDataAsMap(",");
    }

    public Map<String, String> getDataAsMap(String separator) {
        String[] parts;
        if (this.data == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String part : parts = this.data.split(separator)) {
            String[] kv = part.split("=");
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public Measure setData(String data) {
        this.data = data;
        return this;
    }

    public Integer getTrend() {
        return this.trend;
    }

    public Measure setTrend(Integer trend) {
        this.trend = trend;
        return this;
    }

    public Integer getVar() {
        return this.var;
    }

    public Measure setVar(Integer var) {
        this.var = var;
        return this;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public Measure setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Measure setRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    public String getRuleCategory() {
        return this.ruleCategory;
    }

    public Measure setRuleCategory(String ruleCategory) {
        this.ruleCategory = ruleCategory;
        return this;
    }

    public String getRulePriority() {
        return this.rulePriority;
    }

    public Measure setRulePriority(String rulePriority) {
        this.rulePriority = rulePriority;
        return this;
    }
}

