/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Dependency;
import org.sonar.wsclient.services.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyQuery
extends Query<Dependency> {
    public static final String BASE_URL = "/api/dependencies";
    private String resourceIdOrKey = null;
    private String direction = null;
    private String parentId = null;
    private String id = null;
    public static final String INCOMING_DIRECTION = "in";
    public static final String OUTGOING_DIRECTION = "out";

    public String getResourceIdOrKey() {
        return this.resourceIdOrKey;
    }

    public DependencyQuery setResourceIdOrKey(String resourceIdOrKey) {
        this.resourceIdOrKey = resourceIdOrKey;
        return this;
    }

    public DependencyQuery setResourceId(long resourceId) {
        this.resourceIdOrKey = String.valueOf(resourceId);
        return this;
    }

    public String getDirection() {
        return this.direction;
    }

    public DependencyQuery setDirection(String direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        if (this.resourceIdOrKey != null) {
            url.append("resource=").append(this.resourceIdOrKey).append('&');
        }
        if (this.direction != null) {
            url.append("dir=").append(this.direction).append('&');
        }
        if (this.parentId != null) {
            url.append("parent=").append(this.parentId).append('&');
        }
        if (this.id != null) {
            url.append("id=").append(this.id).append('&');
        }
        return url.toString();
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getId() {
        return this.id;
    }

    public DependencyQuery setId(String id) {
        this.id = id;
        return this;
    }

    public DependencyQuery setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Override
    public Class<Dependency> getModelClass() {
        return Dependency.class;
    }

    public static DependencyQuery createForIncomingDependencies(String resourceIdOrKey) {
        DependencyQuery query = new DependencyQuery();
        query.setResourceIdOrKey(resourceIdOrKey);
        query.setDirection(INCOMING_DIRECTION);
        return query;
    }

    public static DependencyQuery createForOutgoingDependencies(String resourceIdOrKey) {
        DependencyQuery query = new DependencyQuery();
        query.setResourceIdOrKey(resourceIdOrKey);
        query.setDirection(OUTGOING_DIRECTION);
        return query;
    }

    public static DependencyQuery createForResource(String resourceIdOrKey) {
        DependencyQuery query = new DependencyQuery();
        query.setResourceIdOrKey(resourceIdOrKey);
        return query;
    }

    public static DependencyQuery createForResource(long resourceId) {
        DependencyQuery query = new DependencyQuery();
        query.setResourceId(resourceId);
        return query;
    }

    public static DependencyQuery createForSubDependencies(String dependencyId) {
        DependencyQuery query = new DependencyQuery();
        query.setParentId(dependencyId);
        return query;
    }

    public static DependencyQuery createForId(String id) {
        DependencyQuery query = new DependencyQuery();
        query.setId(id);
        return query;
    }
}

