/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.indexer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceCodeIndexer;
import org.sonar.squid.api.SourceCodeSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquidIndex
implements SourceCodeIndexer,
SourceCodeSearchEngine {
    private Map<String, SourceCode> index = new TreeMap<String, SourceCode>();

    @Override
    public Collection<SourceCode> search(Query ... query) {
        HashSet<SourceCode> result = new HashSet<SourceCode>();
        for (SourceCode unit : this.index.values()) {
            if (!this.isSquidUnitMatchQueries(unit, query)) continue;
            result.add(unit);
        }
        return result;
    }

    private boolean isSquidUnitMatchQueries(SourceCode unit, Query ... queries) {
        for (Query query : queries) {
            boolean match = query.match(unit);
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public SourceCode search(String key) {
        return this.index.get(key);
    }

    @Override
    public void index(SourceCode sourceCode) {
        sourceCode.setSourceCodeIndexer(this);
        this.index.put(sourceCode.getKey(), sourceCode);
    }
}

