/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.measures.Formula;
import org.sonar.api.measures.FormulaContext;
import org.sonar.api.measures.FormulaData;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AverageFormula
implements Formula {
    private Metric mainMetric;
    private Metric byMetric;

    AverageFormula(Metric mainMetric, Metric byMetric) {
        this.mainMetric = mainMetric;
        this.byMetric = byMetric;
    }

    public static AverageFormula create(Metric main, Metric by) {
        return new AverageFormula(main, by);
    }

    @Override
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(this.mainMetric, this.byMetric);
    }

    @Override
    public Measure calculate(FormulaData data, FormulaContext context) {
        if (!this.shouldDecorateResource(data, context)) {
            return null;
        }
        Measure result = ResourceUtils.isFile(context.getResource()) ? this.calculateForFile(data, context) : this.calculateOnChildren(data, context);
        return result;
    }

    private Measure calculateOnChildren(FormulaData data, FormulaContext context) {
        Measure result = null;
        double totalByMeasure = 0.0;
        double totalMainMeasure = 0.0;
        boolean hasApplicableChildren = false;
        for (FormulaData childrenData : data.getChildren()) {
            Double childrenByMeasure = MeasureUtils.getValue(childrenData.getMeasure(this.byMetric), null);
            Double childrenMainMeasure = MeasureUtils.getValue(childrenData.getMeasure(this.mainMetric), null);
            if (childrenMainMeasure == null || childrenByMeasure == null || !(childrenByMeasure > 0.0)) continue;
            totalByMeasure += childrenByMeasure.doubleValue();
            totalMainMeasure += childrenMainMeasure.doubleValue();
            hasApplicableChildren = true;
        }
        if (hasApplicableChildren) {
            result = new Measure(context.getTargetMetric(), totalMainMeasure / totalByMeasure);
        }
        return result;
    }

    private Measure calculateForFile(FormulaData data, FormulaContext context) {
        Measure result = null;
        Double byMeasure = MeasureUtils.getValue(data.getMeasure(this.byMetric), null);
        Double mainMeasure = MeasureUtils.getValue(data.getMeasure(this.mainMetric), null);
        if (mainMeasure != null && byMeasure != null && byMeasure > 0.0) {
            result = new Measure(context.getTargetMetric(), mainMeasure / byMeasure);
        }
        return result;
    }

    private boolean shouldDecorateResource(FormulaData data, FormulaContext context) {
        return !MeasureUtils.hasValue(data.getMeasure(context.getTargetMetric()));
    }
}

