/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.KeyValue;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyValueFormat {
    public static final String PAIR_SEPARATOR = ";";
    public static final String FIELD_SEPARATOR = "=";

    private KeyValueFormat() {
    }

    public static StringConverter newStringConverter() {
        return StringConverter.INSTANCE;
    }

    public static ToStringConverter newToStringConverter() {
        return ToStringConverter.INSTANCE;
    }

    public static IntegerConverter newIntegerConverter() {
        return IntegerConverter.INSTANCE;
    }

    public static PriorityConverter newPriorityConverter() {
        return PriorityConverter.INSTANCE;
    }

    public static DoubleConverter newDoubleConverter() {
        return DoubleConverter.INSTANCE;
    }

    public static DateConverter newDateConverter() {
        return new DateConverter("yyyy-MM-dd");
    }

    public static DateConverter newDateTimeConverter() {
        return new DateConverter("yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public static DateConverter newDateConverter(String format) {
        return new DateConverter(format);
    }

    public static <K, V> Map<K, V> parse(String data, Converter<K> keyConverter, Converter<V> valueConverter) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (data != null) {
            String[] pairs;
            for (String pair : pairs = StringUtils.split((String)data, (String)PAIR_SEPARATOR)) {
                String[] keyValue = StringUtils.split((String)pair, (String)FIELD_SEPARATOR);
                String key = keyValue[0];
                String value = keyValue.length == 2 ? keyValue[1] : "";
                map.put(keyConverter.parse(key), valueConverter.parse(value));
            }
        }
        return map;
    }

    public static Map parse(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newStringConverter(), KeyValueFormat.newStringConverter());
    }

    public static Map<String, Integer> parseStringInt(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newStringConverter(), KeyValueFormat.newIntegerConverter());
    }

    public static Map<String, Double> parseStringDouble(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newStringConverter(), KeyValueFormat.newDoubleConverter());
    }

    public static Map<Integer, String> parseIntString(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newStringConverter());
    }

    public static Map<Integer, Double> parseIntDouble(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDoubleConverter());
    }

    public static Map<Integer, Date> parseIntDate(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateConverter());
    }

    public static Map<Integer, Integer> parseIntInt(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newIntegerConverter());
    }

    public static Map<Integer, Date> parseIntDateTime(String data) {
        return KeyValueFormat.parse(data, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateTimeConverter());
    }

    public static <K> Multiset<K> parseMultiset(String data, Converter<K> keyConverter) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        if (data != null) {
            String[] pairs;
            for (String pair : pairs = StringUtils.split((String)data, (String)PAIR_SEPARATOR)) {
                String[] keyValue = StringUtils.split((String)pair, (String)FIELD_SEPARATOR);
                String key = keyValue[0];
                String value = keyValue.length == 2 ? keyValue[1] : "0";
                multiset.add(keyConverter.parse(key), new IntegerConverter().parse(value).intValue());
            }
        }
        return multiset;
    }

    public static Multiset<Integer> parseIntegerMultiset(String data) {
        return KeyValueFormat.parseMultiset(data, KeyValueFormat.newIntegerConverter());
    }

    public static Multiset<String> parseMultiset(String data) {
        return KeyValueFormat.parseMultiset(data, KeyValueFormat.newStringConverter());
    }

    @Deprecated
    public static <KEY, VALUE> Map<KEY, VALUE> parse(String data, Transformer<KEY, VALUE> transformer) {
        Map rawData = KeyValueFormat.parse(data);
        HashMap<KEY, VALUE> map = new HashMap<KEY, VALUE>();
        for (Map.Entry entry : rawData.entrySet()) {
            KeyValue<KEY, VALUE> keyVal = transformer.transform((String)entry.getKey(), (String)entry.getValue());
            if (keyVal == null) continue;
            map.put(keyVal.getKey(), keyVal.getValue());
        }
        return map;
    }

    private static <K, V> String formatEntries(Collection<Map.Entry<K, V>> entries, Converter<K> keyConverter, Converter<V> valueConverter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<K, V> entry : entries) {
            if (!first) {
                sb.append(PAIR_SEPARATOR);
            }
            sb.append(keyConverter.format(entry.getKey()));
            sb.append(FIELD_SEPARATOR);
            if (entry.getValue() != null) {
                sb.append(valueConverter.format(entry.getValue()));
            }
            first = false;
        }
        return sb.toString();
    }

    private static <K> String formatEntries(Set<Multiset.Entry<K>> entries, Converter<K> keyConverter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Multiset.Entry<K> entry : entries) {
            if (!first) {
                sb.append(PAIR_SEPARATOR);
            }
            sb.append(keyConverter.format(entry.getElement()));
            sb.append(FIELD_SEPARATOR);
            sb.append(new IntegerConverter().format(entry.getCount()));
            first = false;
        }
        return sb.toString();
    }

    public static <K, V> String format(Map<K, V> map, Converter<K> keyConverter, Converter<V> valueConverter) {
        return KeyValueFormat.formatEntries(map.entrySet(), keyConverter, valueConverter);
    }

    public static String format(Map map) {
        return KeyValueFormat.format(map, KeyValueFormat.newToStringConverter(), KeyValueFormat.newToStringConverter());
    }

    public static String formatIntString(Map<Integer, String> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newStringConverter());
    }

    public static String formatIntDouble(Map<Integer, Double> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDoubleConverter());
    }

    public static String formatIntDate(Map<Integer, Date> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateConverter());
    }

    public static String formatIntDateTime(Map<Integer, Date> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newIntegerConverter(), KeyValueFormat.newDateTimeConverter());
    }

    public static String formatStringInt(Map<String, Integer> map) {
        return KeyValueFormat.format(map, KeyValueFormat.newStringConverter(), KeyValueFormat.newIntegerConverter());
    }

    public static <K, V> String format(Multimap<K, V> map, Converter<K> keyConverter, Converter<V> valueConverter) {
        return KeyValueFormat.formatEntries(map.entries(), keyConverter, valueConverter);
    }

    public static <K> String format(Multiset<K> multiset, Converter<K> keyConverter) {
        return KeyValueFormat.formatEntries(multiset.entrySet(), keyConverter);
    }

    public static String format(Multiset multiset) {
        return KeyValueFormat.formatEntries(multiset.entrySet(), KeyValueFormat.newToStringConverter());
    }

    @Deprecated
    public static String format(Bag bag) {
        return KeyValueFormat.format(bag, 0);
    }

    @Deprecated
    public static String format(Bag bag, int var) {
        StringBuilder sb = new StringBuilder();
        if (bag != null) {
            boolean first = true;
            for (Object obj : bag.uniqueSet()) {
                if (!first) {
                    sb.append(PAIR_SEPARATOR);
                }
                sb.append(obj.toString());
                sb.append(FIELD_SEPARATOR);
                sb.append(bag.getCount(obj) + var);
                first = false;
            }
        }
        return sb.toString();
    }

    private static Double toDouble(String value) {
        return StringUtils.isBlank((String)value) ? null : Double.valueOf(NumberUtils.toDouble((String)value));
    }

    private static Integer toInteger(String value) {
        return StringUtils.isBlank((String)value) ? null : Integer.valueOf(NumberUtils.toInt((String)value));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class RulePriorityNumbersPairTransformer
    implements Transformer<RulePriority, Integer> {
        @Override
        public KeyValue<RulePriority, Integer> transform(String key, String value) {
            try {
                if (StringUtils.isBlank((String)value)) {
                    value = "0";
                }
                return new KeyValue<RulePriority, Integer>(RulePriority.valueOf(key.toUpperCase()), Integer.parseInt(value));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(RulePriorityNumbersPairTransformer.class).warn("Property " + key + " has invalid value: " + value, (Throwable)e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class IntegerNumbersPairTransformer
    implements Transformer<Integer, Integer> {
        @Override
        public KeyValue<Integer, Integer> transform(String key, String value) {
            return new KeyValue<Integer, Integer>(KeyValueFormat.toInteger(key), KeyValueFormat.toInteger(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class DoubleNumbersPairTransformer
    implements Transformer<Double, Double> {
        @Override
        public KeyValue<Double, Double> transform(String key, String value) {
            return new KeyValue<Double, Double>(KeyValueFormat.toDouble(key), KeyValueFormat.toDouble(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class StringNumberPairTransformer
    implements Transformer<String, Double> {
        @Override
        public KeyValue<String, Double> transform(String key, String value) {
            return new KeyValue<String, Double>(key, KeyValueFormat.toDouble(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface Transformer<KEY, VALUE> {
        public KeyValue<KEY, VALUE> transform(String var1, String var2);
    }

    @Deprecated
    public static class DateTimeConverter
    extends DateConverter {
        public DateTimeConverter() {
            super("yyyy-MM-dd'T'HH:mm:ssZ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateConverter
    extends Converter<Date> {
        private SimpleDateFormat dateFormat;

        @Deprecated
        public DateConverter() {
            this("yyyy-MM-dd");
        }

        private DateConverter(String format) {
            this.dateFormat = new SimpleDateFormat(format);
        }

        @Override
        String format(Date d) {
            return d == null ? "" : this.dateFormat.format(d);
        }

        @Override
        Date parse(String s) {
            try {
                return StringUtils.isBlank((String)s) ? null : this.dateFormat.parse(s);
            }
            catch (ParseException e) {
                throw new SonarException("Not a date with format: " + this.dateFormat.toPattern(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoubleConverter
    extends Converter<Double> {
        private static final DoubleConverter INSTANCE = new DoubleConverter();

        private DoubleConverter() {
        }

        @Override
        String format(Double d) {
            return d == null ? "" : String.valueOf(d);
        }

        @Override
        Double parse(String s) {
            return StringUtils.isBlank((String)s) ? null : Double.valueOf(NumberUtils.toDouble((String)s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PriorityConverter
    extends Converter<RulePriority> {
        private static final PriorityConverter INSTANCE = new PriorityConverter();

        private PriorityConverter() {
        }

        @Override
        String format(RulePriority s) {
            return s == null ? "" : s.toString();
        }

        @Override
        RulePriority parse(String s) {
            return StringUtils.isBlank((String)s) ? null : RulePriority.valueOf(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntegerConverter
    extends Converter<Integer> {
        private static final IntegerConverter INSTANCE = new IntegerConverter();

        private IntegerConverter() {
        }

        @Override
        String format(Integer s) {
            return s == null ? "" : String.valueOf(s);
        }

        @Override
        Integer parse(String s) {
            return StringUtils.isBlank((String)s) ? null : Integer.valueOf(NumberUtils.toInt((String)s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ToStringConverter
    extends Converter<Object> {
        private static final ToStringConverter INSTANCE = new ToStringConverter();

        private ToStringConverter() {
        }

        @Override
        String format(Object o) {
            return o.toString();
        }

        @Override
        String parse(String s) {
            throw new IllegalStateException("Can not parse with ToStringConverter: " + s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringConverter
    extends Converter<String> {
        private static final StringConverter INSTANCE = new StringConverter();

        private StringConverter() {
        }

        @Override
        String format(String s) {
            return s;
        }

        @Override
        String parse(String s) {
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Converter<TYPE> {
        abstract String format(TYPE var1);

        abstract TYPE parse(String var1);
    }
}

