/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.qualitymodel.Characteristic;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MeasuresFilters {
    private MeasuresFilters() {
    }

    public static MeasuresFilter<Collection<Measure>> all() {
        return new MeasuresFilter<Collection<Measure>>(){

            @Override
            public Collection<Measure> filter(Collection<Measure> measures) {
                return measures;
            }
        };
    }

    public static MeasuresFilter<Measure> metric(Metric metric) {
        return MeasuresFilters.metric(metric.getKey());
    }

    public static MeasuresFilter<Measure> metric(final String metricKey) {
        return new MetricFilter<Measure>(metricKey){

            @Override
            public Measure filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                for (Measure measure : measures) {
                    if (!measure.getClass().equals(Measure.class) || !measure.getMetricKey().equals(metricKey) || measure.getCharacteristic() != null) continue;
                    return measure;
                }
                return null;
            }
        };
    }

    public static MeasuresFilter<Measure> characteristic(final Metric metric, final Characteristic characteristic) {
        return new MetricFilter<Measure>(metric){

            @Override
            public Measure filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                for (Measure measure : measures) {
                    if (!measure.getClass().equals(Measure.class) || !measure.getMetric().equals(metric) || measure.getCharacteristic() == null || !measure.getCharacteristic().equals(characteristic)) continue;
                    return measure;
                }
                return null;
            }
        };
    }

    public static MeasuresFilter<Measure> measure(final Measure measure) {
        return new MeasuresFilter<Measure>(){

            @Override
            public Measure filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                for (Measure m : measures) {
                    if (!m.equals(measure)) continue;
                    return m;
                }
                return null;
            }
        };
    }

    public static MeasuresFilter<RuleMeasure> rulePriority(Metric metric, RulePriority priority) {
        return new RulePriorityFilter(metric, priority);
    }

    @Deprecated
    public static MeasuresFilter<RuleMeasure> ruleCategory(Metric metric, Integer category) {
        return new RuleCategoryFilter(metric, category);
    }

    public static MeasuresFilter<RuleMeasure> rule(Metric metric, Rule rule) {
        return new RuleFilter(metric, rule);
    }

    @Deprecated
    public static MeasuresFilter<Collection<RuleMeasure>> ruleCategories(Metric metric) {
        return new MetricFilter<Collection<RuleMeasure>>(metric){

            @Override
            public Collection<RuleMeasure> filter(Collection<Measure> measures) {
                return Collections.emptyList();
            }
        };
    }

    public static MeasuresFilter<Collection<RuleMeasure>> rules(final Metric metric) {
        return new MetricFilter<Collection<RuleMeasure>>(metric){

            private boolean apply(Measure measure) {
                return measure instanceof RuleMeasure && metric.equals(measure.getMetric()) && ((RuleMeasure)measure).getRule() != null;
            }

            @Override
            public Collection<RuleMeasure> filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                ArrayList<RuleMeasure> result = new ArrayList<RuleMeasure>();
                for (Measure measure : measures) {
                    if (!this.apply(measure)) continue;
                    result.add((RuleMeasure)measure);
                }
                return result;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuleFilter
    extends AbstractRuleMeasureFilter<RuleMeasure> {
        private Rule rule;

        protected RuleFilter(Metric metric, Rule rule) {
            super(metric);
            this.rule = rule;
        }

        @Override
        boolean doApply(RuleMeasure measure) {
            return measure.getRule() != null && this.rule.equals(measure.getRule());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private static class RuleCategoryFilter
    extends AbstractRuleMeasureFilter<RuleMeasure> {
        protected RuleCategoryFilter(Metric metric, Integer categ) {
            super(metric);
        }

        @Override
        boolean doApply(RuleMeasure measure) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RulePriorityFilter
    extends AbstractRuleMeasureFilter<RuleMeasure> {
        private RulePriority priority;

        protected RulePriorityFilter(Metric metric, RulePriority priority) {
            super(metric);
            this.priority = priority;
        }

        @Override
        boolean doApply(RuleMeasure measure) {
            return measure.getRule() == null && this.priority.equals((Object)measure.getRulePriority());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractRuleMeasureFilter<M>
    extends MetricFilter<M> {
        protected AbstractRuleMeasureFilter(Metric metric) {
            super(metric);
        }

        private boolean apply(Measure measure) {
            return measure instanceof RuleMeasure && this.filterOnMetricKey().equals(measure.getMetricKey()) && this.doApply((RuleMeasure)measure);
        }

        abstract boolean doApply(RuleMeasure var1);

        @Override
        public M filter(Collection<Measure> measures) {
            if (measures == null) {
                return null;
            }
            for (Measure measure : measures) {
                if (!this.apply(measure)) continue;
                return (M)measure;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MetricFilter<M>
    implements MeasuresFilter<M> {
        private final String metricKey;

        protected MetricFilter(Metric metric) {
            this.metricKey = metric.getKey();
        }

        protected MetricFilter(String metricKey) {
            this.metricKey = metricKey;
        }

        public String filterOnMetricKey() {
            return this.metricKey;
        }
    }
}

