/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.Batch;
import org.sonar.batch.MavenProjectConverter;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.core.config.Logback;
import org.sonar.maven.Maven2PluginExecutor;

public final class SonarMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private LifecycleExecutor lifecycleExecutor;
    private PluginManager pluginManager;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder projectBuilder;
    private RuntimeInformation runtimeInformation;
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.configureLogback();
        this.executeBatch();
    }

    private void executeBatch() throws MojoExecutionException {
        ProjectDefinition def = MavenProjectConverter.convert((List)this.session.getSortedProjects(), (MavenProject)this.project);
        ProjectReactor reactor = new ProjectReactor(def);
        Batch batch = new Batch(reactor, new Object[]{this.session, this.getLog(), this.lifecycleExecutor, this.pluginManager, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder, this.projectBuilder, this.getEnvironmentInformation(), Maven2PluginExecutor.class});
        batch.execute();
    }

    private EnvironmentInformation getEnvironmentInformation() {
        String mavenVersion = this.runtimeInformation.getApplicationVersion().toString();
        return new EnvironmentInformation("Maven", mavenVersion);
    }

    private void configureLogback() {
        boolean debugMode = this.verbose || this.getLog().isDebugEnabled();
        System.setProperty("ROOT_LOGGER_LEVEL", debugMode ? "DEBUG" : "INFO");
        Logback.configure((String)"/org/sonar/maven/logback.xml");
    }
}

