/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.api;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Method;
import org.sonar.api.resources.Resource;
import org.sonar.java.api.JavaClass;

public final class JavaMethod
extends Method {
    public static final String QUALIFIER = "MET";
    public static final int UNKNOWN_LINE = -1;
    private static final String CLASS_SEPARATOR = "#";
    private String signature;
    private String className;
    private int fromLine;
    private int toLine;
    private boolean isAccessor = false;

    private JavaMethod(String className, String signature) {
        super(JavaMethod.toKey(className, signature), QUALIFIER, (Language)Java.INSTANCE);
        this.className = className;
        this.signature = signature;
    }

    private JavaMethod(String className, String signature, int fromLine, int toLine, boolean isAccessor) {
        this(className, signature);
        this.fromLine = fromLine;
        this.toLine = toLine;
        this.isAccessor = isAccessor;
    }

    public int getFromLine() {
        return this.fromLine;
    }

    public int getToLine() {
        return this.toLine;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isAccessor() {
        return this.isAccessor;
    }

    public String getName() {
        return this.signature;
    }

    public String getLongName() {
        return this.getKey();
    }

    public String getDescription() {
        return null;
    }

    public Resource getParent() {
        return null;
    }

    public String toString() {
        return this.getKey();
    }

    public static JavaMethod createRef(String key) {
        String[] parts = JavaMethod.splitClassAndMethodFromKey(key);
        return new JavaMethod(parts[0], parts[1]);
    }

    private static String[] splitClassAndMethodFromKey(String key) {
        String[] parts = StringUtils.split((String)key, (String)CLASS_SEPARATOR);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Java method does not respect the format: org.foo.Bar#methodName(LString;)V. Got: " + key);
        }
        return parts;
    }

    public static JavaMethod createRef(JavaClass javaClass, String signature) {
        return new JavaMethod(javaClass.getName(), signature);
    }

    static String toKey(JavaClass javaClass, String signature) {
        return JavaMethod.toKey(javaClass.getName(), signature);
    }

    static String toKey(String className, String signature) {
        return className + CLASS_SEPARATOR + signature;
    }

    public static class Builder {
        private String className;
        private String signature;
        private int fromLine = -1;
        private int toLine = -1;
        private boolean isAccessor = false;

        public Builder setKey(String key) {
            String[] parts = JavaMethod.splitClassAndMethodFromKey(key);
            this.className = parts[0];
            this.signature = parts[1];
            return this;
        }

        public Builder setClass(String className) {
            this.className = className;
            return this;
        }

        public Builder setClass(JavaClass javaClass) {
            this.className = javaClass.getName();
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder setFromLine(int fromLine) {
            this.fromLine = Math.max(-1, fromLine);
            return this;
        }

        public Builder setToLine(int toLine) {
            this.toLine = Math.max(-1, toLine);
            return this;
        }

        public Builder setAccessor(boolean accessor) {
            this.isAccessor = accessor;
            return this;
        }

        public JavaMethod create() {
            return new JavaMethod(this.className, this.signature, this.fromLine, this.toLine, this.isAccessor);
        }
    }
}

