/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.statement.matcher;

import java.util.List;
import org.sonar.duplications.statement.matcher.TokenMatcher;
import org.sonar.duplications.token.Token;
import org.sonar.duplications.token.TokenQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeTokenMatcher
extends TokenMatcher {
    private final String lToken;
    private final String rToken;

    public BridgeTokenMatcher(String lToken, String rToken) {
        if (lToken == null || rToken == null) {
            throw new IllegalArgumentException();
        }
        this.lToken = lToken;
        this.rToken = rToken;
    }

    @Override
    public boolean matchToken(TokenQueue tokenQueue, List<Token> matchedTokenList) {
        if (!tokenQueue.isNextTokenValue(this.lToken)) {
            return false;
        }
        int stack = 0;
        while (tokenQueue.peek() != null) {
            Token token = tokenQueue.poll();
            if (this.lToken.equals(token.getValue())) {
                ++stack;
            } else if (this.rToken.equals(token.getValue())) {
                --stack;
            }
            matchedTokenList.add(token);
            if (stack != 0) continue;
            return true;
        }
        return false;
    }
}

