/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.duplications.index.ClonePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneGroup {
    private final ClonePart originPart;
    private final int cloneLength;
    private final List<ClonePart> parts;
    private int hash;

    public CloneGroup(int cloneLength, ClonePart origin, List<ClonePart> parts) {
        this.cloneLength = cloneLength;
        this.originPart = origin;
        this.parts = ImmutableList.copyOf(parts);
    }

    public ClonePart getOriginPart() {
        return this.originPart;
    }

    public int getCloneUnitLength() {
        return this.cloneLength;
    }

    public List<ClonePart> getCloneParts() {
        return this.parts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ClonePart part : this.parts) {
            builder.append(part).append(" - ");
        }
        builder.append(this.cloneLength);
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CloneGroup)) {
            return false;
        }
        CloneGroup another = (CloneGroup)object;
        if (another.cloneLength != this.cloneLength || this.parts.size() != another.parts.size()) {
            return false;
        }
        if (!this.originPart.equals(another.originPart)) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            result &= another.parts.get(i).equals(this.parts.get(i));
        }
        return result;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.cloneLength != 0) {
            for (ClonePart part : this.parts) {
                h = 31 * h + part.hashCode();
            }
            h = 31 * h + this.originPart.hashCode();
            this.hash = h = 31 * h + this.cloneLength;
        }
        return h;
    }
}

