/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.api.utils.SonarException;
import org.sonar.core.persistence.Database;
import org.sonar.jpa.session.AbstractDatabaseConnector;
import org.sonar.jpa.session.CustomHibernateConnectionProvider;

public class DefaultDatabaseConnector
extends AbstractDatabaseConnector {
    public DefaultDatabaseConnector(Database database) {
        super(database);
    }

    public void start() {
        this.createDatasource();
        super.start();
    }

    private void createDatasource() {
        try {
            CustomHibernateConnectionProvider.setDatasourceForConfig(this.database.getDataSource());
        }
        catch (Exception e) {
            throw new SonarException("Fail to connect to database", (Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.database != null && this.database.getDataSource() != null ? this.database.getDataSource().getConnection() : null;
    }
}

