/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.DatabaseVersion;
import org.sonar.core.persistence.dialect.Dialect;
import org.sonar.jpa.session.DatabaseConnector;

public abstract class AbstractDatabaseConnector
implements DatabaseConnector {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDatabaseConnector.class);
    protected Database database;
    private EntityManagerFactory factory = null;

    protected AbstractDatabaseConnector(Database database) {
        this.database = database;
    }

    public void start() {
        LOG.info("Initializing Hibernate");
        this.factory = this.createEntityManagerFactory();
    }

    public void stop() {
        if (this.factory != null && this.factory.isOpen()) {
            this.factory.close();
            this.factory = null;
        }
        this.database = null;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.factory;
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        Properties props = this.database.getHibernateProperties();
        this.logHibernateSettings(props);
        return Persistence.createEntityManagerFactory((String)"sonar", (Map)props);
    }

    private void logHibernateSettings(Properties props) {
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                LOG.debug(entry.getKey() + ": " + entry.getValue());
            }
        }
    }

    public EntityManager createEntityManager() {
        return this.factory.createEntityManager();
    }

    public final int getDatabaseVersion() {
        throw new UnsupportedOperationException("Moved to " + DatabaseVersion.class.getCanonicalName());
    }

    public final Dialect getDialect() {
        return this.database.getDialect();
    }
}

