/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.workflow;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.workflow.MutableReview;
import org.sonar.api.workflow.Review;
import org.sonar.api.workflow.WorkflowContext;
import org.sonar.api.workflow.condition.Condition;
import org.sonar.api.workflow.function.Function;
import org.sonar.api.workflow.internal.DefaultReview;
import org.sonar.api.workflow.internal.DefaultWorkflow;
import org.sonar.api.workflow.internal.DefaultWorkflowContext;
import org.sonar.api.workflow.screen.Screen;
import org.sonar.core.workflow.ImmutableReview;
import org.sonar.core.workflow.ReviewStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowEngine
implements ServerComponent {
    private final DefaultWorkflow workflow;
    private final ReviewStore store;
    private final Settings settings;

    public WorkflowEngine(DefaultWorkflow workflow, ReviewStore store, Settings settings) {
        this.workflow = workflow;
        this.store = store;
        this.settings = settings;
    }

    public ListMultimap<Long, Screen> listAvailableScreens(DefaultReview[] reviews, DefaultWorkflowContext context, boolean verifyConditions) {
        ArrayListMultimap result = ArrayListMultimap.create();
        this.completeProjectSettings(context);
        for (Map.Entry entry : this.workflow.getScreensByCommand().entrySet()) {
            String commandKey = (String)entry.getKey();
            if (verifyConditions && !this.verifyConditionsQuietly(null, (WorkflowContext)context, this.workflow.getContextConditions(commandKey))) continue;
            for (DefaultReview review : reviews) {
                if (verifyConditions && !this.verifyConditionsQuietly((Review)review, (WorkflowContext)context, this.workflow.getReviewConditions(commandKey))) continue;
                result.put((Object)review.getViolationId(), entry.getValue());
            }
        }
        return result;
    }

    public List<Screen> listAvailableScreens(Review review, DefaultWorkflowContext context, boolean verifyConditions) {
        ArrayList result = Lists.newArrayList();
        this.completeProjectSettings(context);
        for (Map.Entry entry : this.workflow.getScreensByCommand().entrySet()) {
            String commandKey = (String)entry.getKey();
            if (verifyConditions && !this.verifyConditionsQuietly(review, (WorkflowContext)context, this.workflow.getConditions(commandKey))) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public Screen getScreen(String commandKey) {
        return this.workflow.getScreen(commandKey);
    }

    public void execute(String commandKey, DefaultReview review, DefaultWorkflowContext context, Map<String, String> parameters) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commandKey) ? 1 : 0) != 0, (Object)"Missing command");
        Preconditions.checkArgument((boolean)this.workflow.hasCommand(commandKey), (Object)("Unknown command: " + commandKey));
        this.completeProjectSettings(context);
        this.verifyConditions((Review)review, (WorkflowContext)context, this.workflow.getConditions(commandKey));
        ImmutableMap immutableParameters = ImmutableMap.copyOf(parameters);
        ImmutableReview initialReview = new ImmutableReview(review);
        for (Function function : this.workflow.getFunctions(commandKey)) {
            function.doExecute((MutableReview)review, (Review)initialReview, (WorkflowContext)context, (Map)immutableParameters);
        }
        this.store.store(review);
    }

    private boolean verifyConditionsQuietly(@Nullable Review review, WorkflowContext context, List<Condition> conditions) {
        for (Condition condition : conditions) {
            if (condition.doVerify(review, context)) continue;
            return false;
        }
        return true;
    }

    private void verifyConditions(@Nullable Review review, WorkflowContext context, List<Condition> conditions) {
        for (Condition condition : conditions) {
            if (condition.doVerify(review, context)) continue;
            throw new IllegalStateException("Condition is not respected: " + condition.toString());
        }
    }

    private void completeProjectSettings(DefaultWorkflowContext context) {
        Settings projectSettings = new Settings(this.settings);
        List propertyKeys = this.workflow.getProjectPropertyKeys();
        this.store.completeProjectSettings(context.getProjectId(), projectSettings, propertyKeys);
        context.setSettings(projectSettings);
    }
}

