/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.workflow;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.workflow.Comment;
import org.sonar.api.workflow.internal.DefaultReview;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.properties.PropertiesMapper;
import org.sonar.core.properties.PropertyDto;
import org.sonar.core.review.ReviewCommentDto;
import org.sonar.core.review.ReviewCommentMapper;
import org.sonar.core.review.ReviewDto;
import org.sonar.core.review.ReviewMapper;
import org.sonar.core.workflow.ReviewStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewDatabaseStore
implements ReviewStore,
ServerComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ReviewDatabaseStore.class);
    private MyBatis mybatis;

    public ReviewDatabaseStore(MyBatis mb) {
        this.mybatis = mb;
    }

    @Override
    public void store(DefaultReview review) {
        this.store(review, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void store(DefaultReview review, Date now) {
        if (review.getReviewId() == null) {
            LOG.error("Review has no id. Violation id is: " + review.getViolationId());
            return;
        }
        SqlSession session = this.mybatis.openSession();
        ReviewMapper mapper = (ReviewMapper)session.getMapper(ReviewMapper.class);
        ReviewCommentMapper commentMapper = (ReviewCommentMapper)session.getMapper(ReviewCommentMapper.class);
        try {
            ReviewDto dto = mapper.findById(review.getReviewId());
            dto.setResolution(review.getResolution());
            dto.setStatus(review.getStatus());
            dto.setData(KeyValueFormat.format((Map)review.getProperties()));
            dto.setUpdatedAt(now);
            mapper.update(dto);
            for (Comment comment : review.getNewComments()) {
                ReviewCommentDto commentDto = new ReviewCommentDto();
                commentDto.setReviewId(dto.getId());
                commentDto.setText(comment.getMarkdownText());
                commentDto.setCreatedAt(now);
                commentDto.setUpdatedAt(now);
                commentDto.setUserId(comment.getUserId());
                commentMapper.insert(commentDto);
            }
            session.commit();
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeProjectSettings(Long projectId, Settings settings, List<String> propertyKeys) {
        if (propertyKeys.isEmpty()) {
            return;
        }
        SqlSession session = this.mybatis.openSession();
        PropertiesMapper mapper = (PropertiesMapper)session.getMapper(PropertiesMapper.class);
        try {
            List<PropertyDto> dtos = mapper.selectSetOfResourceProperties(projectId, propertyKeys);
            for (PropertyDto dto : dtos) {
                settings.setProperty(dto.getKey(), dto.getValue());
            }
        }
        finally {
            MyBatis.closeQuietly(session);
        }
    }
}

