/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.workflow;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.api.workflow.Review;
import org.sonar.api.workflow.internal.DefaultReview;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableReview
implements Review {
    private final Long violationId;
    private final Long reviewId;
    private final String ruleRepositoryKey;
    private final String ruleKey;
    private final String ruleName;
    private final Long line;
    private final boolean switchedOff;
    private final boolean manual;
    private final String message;
    private final String status;
    private final String resolution;
    private final String severity;
    private final Map<String, String> properties;

    public ImmutableReview(DefaultReview review) {
        this.line = review.getLine();
        this.manual = review.isManual();
        this.message = review.getMessage();
        this.properties = ImmutableMap.copyOf((Map)review.getProperties());
        this.resolution = review.getResolution();
        this.reviewId = review.getReviewId();
        this.ruleKey = review.getRuleKey();
        this.ruleRepositoryKey = review.getRuleRepositoryKey();
        this.ruleName = review.getRuleName();
        this.severity = review.getSeverity();
        this.status = review.getStatus();
        this.switchedOff = review.isSwitchedOff();
        this.violationId = review.getViolationId();
    }

    public Long getViolationId() {
        return this.violationId;
    }

    public Long getReviewId() {
        return this.reviewId;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleRepositoryKey() {
        return this.ruleRepositoryKey;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public Long getLine() {
        return this.line;
    }

    public boolean isSwitchedOff() {
        return this.switchedOff;
    }

    public boolean isManual() {
        return this.manual;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

