/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.review;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.core.review.ReviewDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReviewPredicates {
    private ReviewPredicates() {
    }

    public static Predicate<ReviewDto> status(String ... statuses) {
        return new StatusPredicate(statuses);
    }

    public static Predicate<ReviewDto> resolution(String ... resolutions) {
        return new ResolutionPredicate(resolutions);
    }

    public static Predicate<ReviewDto> manualViolation() {
        return ManualViolationPredicate.INSTANCE;
    }

    public static Predicate<ReviewDto> manualSeverity() {
        return ManualSeverityPredicate.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ManualSeverityPredicate
    implements Predicate<ReviewDto> {
        private static final ManualSeverityPredicate INSTANCE = new ManualSeverityPredicate();

        private ManualSeverityPredicate() {
        }

        public boolean apply(@Nullable ReviewDto review) {
            return review != null && review.isManualSeverity();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ManualViolationPredicate
    implements Predicate<ReviewDto> {
        private static final ManualViolationPredicate INSTANCE = new ManualViolationPredicate();

        private ManualViolationPredicate() {
        }

        public boolean apply(@Nullable ReviewDto review) {
            return review != null && review.isManualViolation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResolutionPredicate
    implements Predicate<ReviewDto> {
        private String[] resolutions;

        private ResolutionPredicate(String ... resolutions) {
            this.resolutions = resolutions;
        }

        public boolean apply(@Nullable ReviewDto review) {
            return review != null && ArrayUtils.contains((Object[])this.resolutions, (Object)review.getResolution());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StatusPredicate
    implements Predicate<ReviewDto> {
        private String[] statuses;

        private StatusPredicate(String ... statuses) {
            this.statuses = statuses;
        }

        public boolean apply(@Nullable ReviewDto review) {
            return review != null && ArrayUtils.contains((Object[])this.statuses, (Object)review.getStatus());
        }
    }
}

